#ifndef __PNX8550_BLT_H__
#define __PNX8550_BLT_H__


#define PNX_SUPPORTED_DRAWINGFLAGS      (DSDRAW_BLEND)

#define PNX_SUPPORTED_DRAWINGFUNCTIONS  (DFXL_FILLRECTANGLE)

#define PNX_SUPPORTED_BLITTINGFLAGS     (DSBLIT_SRC_COLORKEY       |  \
                                         /*DSBLIT_DST_COLORKEY       | */ \
                                         DSBLIT_BLEND_ALPHACHANNEL |  \
                                         DSBLIT_BLEND_COLORALPHA   |  \
                                         DSBLIT_COLORIZE           |  \
                                         DSBLIT_SRC_PREMULTCOLOR   |  \
                                         DSBLIT_SRC_PREMULTIPLY)

#define PNX_SUPPORTED_BLITTINGFUNCTIONS (DFXL_BLIT)


DFBResult pnxEngineSync( void *drv, void *dev );

void pnxEngineReset( void *drv, void *dev );

void pnxEmitCommands( void *drv, void *dev );

void pnxCheckState( void *drv, void *dev,
                    CardState *state, DFBAccelerationMask accel );

void pnxSetState( void *drv, void *dev,
                  GraphicsDeviceFuncs *funcs, CardState *state, DFBAccelerationMask accel );

bool pnxFillRectangle( void *drv, void *dev, DFBRectangle *rect );
bool pnxBlit( void *drv, void *dev, DFBRectangle *rect, int x, int y );
bool pnxBlitYUV( void *drv, void *dev, DFBRectangle *rect, int x, int y );
bool pnxBlitBlend( void *drv, void *dev, DFBRectangle *rect, int x, int y );

#endif
