/*
   (c) Copyright 2000-2002  convergence integrated media GmbH.
   (c) Copyright 2002-2004  convergence GmbH.

   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Hundt <andi@fischlustig.de>,
              Sven Neumann <neo@directfb.org> and
              Ville Syrjl <syrjala@sci.fi>.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __CETVFB__CETVFB_H__
#define __CETVFB__CETVFB_H__

#include <fusion/call.h>
#include <fusion/lock.h>
#include <fusion/shm/pool.h>

#include "callbacks.h"

typedef struct {
     int                    magic;

     int                    layerId;

     unsigned long          minWindowWidth;
     unsigned long          minWindowHeight;
     unsigned long          maxLayerWindowWidth;
     unsigned long          maxLayerWindowHeight;

     CoreSurface            *surface;
     unsigned long          format;         /* tmPixRgbFmt_t */
     unsigned long          format_class;   /* tmPixFmtCls_t */

     bool                   srcColorKeyEnabled;
     DFBColorKey            srcColorKey;

     bool                   set_buffer;
     bool                   unhide_layer;
} CETVFBLayerData;



typedef struct {
     unsigned long          FinalDisplayWidth;
     unsigned long          FinalDisplayHeight;
     unsigned long          IntermediateWidth;
     unsigned long          IntermediateHeight;
} CETVFBDisplayData;


typedef struct {
     FusionSkirmish       lock;
     FusionCall           call;

     FusionSHMPoolShared *shmpool;

     /* we have 3 ranges for shared memory mapping. */
     CETVFBMemArea uncached;
     CETVFBMemArea cached;
     CETVFBMemArea bis; /* read-only */

    void* (*shmAcquire) ( unsigned long resource_id, int size );                /* retval: correct value or 0 */
    int   (*shmRelease) ( unsigned long resource_id, int size, void* address ); /* retval: Dfb_True or Dfb_False */

     CETVFBDisplayData   displayData;

     CoreSurfacePool     *tmml_surface_pool;

} DFBCETVFB;


typedef enum {
     CETVFB_SET_REGION,
     CETVFB_UPDATE_SCREEN,
     CETVFB_SET_PALETTE,
     CETVFB_REMOVE_REGION,
     CETVFB_TMML_ALLOCATE,
     CETVFB_TMML_DEALLOCATE,
     CETVFB_SET_NAT_MOTION_WDW,
     CETVFB_SET_LEVEL,
     CETVFB_GET_LEVEL
} DFBCETVFBCall;


extern DFBCETVFB          *dfb_cetvfb;
extern CoreDFB            *dfb_cetvfb_core;
extern FusionWorld        *dfb_cetvfb_world;

#endif

