/// Filename: drawregs.h   - Drawing Engine driver for pnx8550 sdk
// Description: This file contains defines for accessing "drawing engine" registers
// Author: Denis Oliver Kropp

#ifndef __DRAWREGS_H__
#define __DRAWREGS_H__

#include <pnx8550_misc.h>

/* Registers */

typedef volatile struct {
     __u32     SrcAddrBase;
     __u32     DstAddrBase;
     __u32     Psize;
     __u32     SrcLinear;
     __u32     DstLinear;
     __u32     SrcStride;
     __u32     DstStride;
     __u32     CCColor;
     __u32     SurfAlpha;
     __u32     HAlphaColor;
     __u32     BltCtl;
     __u32     SrcXY;
     __u32     DstXY;
     __u32     BltSize;
     __u32     DstXY2;
     __u32     VecConst;
     __u32     VecCount;
     __u32     TransMask;

     __u32     reserved[108];

     __u32     MonoPatFColor;
     __u32     MonoPatBColor;

     __u32     reserved2[128];

     __u32     EngineStatus;
     __u32     PanicControl;
     __u32     EngineConfig;
     __u32     HostFIFOStatus;
} PNXBLTRegs;

#define PNXBLT_BLEND_ANY  0x00300000

#endif

