// Filename: pnx8550_misc.h   - Misc PNX8550 definitions, declarations etc.
// Author: Denis Oliver Kropp

#ifndef __PNX8550_MISC_H__
#define __PNX8550_MISC_H__


typedef enum {
     false = 0,
     true  = !false
} bool;


/*
 * Offset of register aperture.
 */
#define PNX8550_MMIO_BASE	0xBBE00000

#define MMIO(x)     *(volatile unsigned long *)(PNX8550_MMIO_BASE + (x))
#define DUMP(x)     printk( KERN_DEBUG "%-36s 0x%08lx\n", #x, MMIO(x) )

//#define PNX8550_FB_START        0x03800000
//#define PNX8550_FB_SIZE         0x007F0000

#define PNX8550_MMIO_BLT_START  (0x1BE00000 + 0x04F400)
#define PNX8550_MMIO_BLT_SIZE   (0xC00)


#endif

