#include <directfb.h>


int
main( int argc, char *argv[] )
{
     DFBResult              ret;
     IDirectFB             *dfb;
     IDirectFBSurface      *surface;
     DFBSurfaceDescription  desc;

     ret = DirectFBInit( &argc, &argv );
     if (ret)
          return ret;

     ret = DirectFBCreate( &dfb );
     if (ret)
          return ret;

     desc.flags       = DSDESC_WIDTH | DSDESC_HEIGHT | DSDESC_PIXELFORMAT | DSDESC_CAPS | DSDESC_RESOURCE_ID;
     desc.width       = 400;
     desc.height      = 400;
     desc.pixelformat = DSPF_RGB16;
     desc.caps        = DSCAPS_VIDEOONLY;
     desc.resource_id = 666;

     ret = dfb->CreateSurface( dfb, &desc, &surface );
     if (ret)
          DirectFBError( "Could not create surface!\n", ret );
     else {
          surface->Clear( surface, 0, 0, 0, 0 );
          surface->Release( surface );
     }

     dfb->Release( dfb );

     return 0;
}

