/*-
 * Copyright (c) 2009  Atheros Communications Inc
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef _HIF_USB_INTERNAL_H
#define _HIF_USB_INTERNAL_H
#include <linux/types.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include "hif.h"
#include <linux/skbuff.h>
#include <linux/usb.h>


#define RX_URB_BUF_ALLOC_TIMER          100

#define HIF_USB_PIPE_COMMAND            4 /* 0 */
#define HIF_USB_PIPE_INTERRUPT          3 /* 1 */
#define HIF_USB_PIPE_TX                 1 /* 2 */
#define HIF_USB_PIPE_RX                 2 /* 3 */

#define HIF_USB_MAX_RXPIPES             2
#define HIF_USB_MAX_TXPIPES             4

#ifdef HIF_USB_ENABLE_STREAM_MODE
#define ZM_USB_TX_STREAM_MODE           1
#define ZM_USB_STREAM_MODE              1
#else
#define ZM_USB_TX_STREAM_MODE           0
#define ZM_USB_STREAM_MODE              0
#endif

#ifdef HIF_USB_ENABLE_STREAM_MODE
#define ZM_MAX_RX_BUFFER_SIZE           (8192*2)
#else
#define ZM_MAX_RX_BUFFER_SIZE           4096
#endif

#if ZM_USB_TX_STREAM_MODE == 1
#define ZM_MAX_TX_AGGREGATE_NUM         10
#define ZM_USB_TX_BUF_SIZE              1600//8096
#define ZM_MAX_TX_URB_NUM               2
#else
#define ZM_USB_TX_BUF_SIZE              2048
#define ZM_MAX_TX_URB_NUM               8
#endif
#define ZM_USB_REG_MAX_BUF_SIZE         512
#define ZM_MAX_RX_URB_NUM               16

#ifdef ATH_WMM_SCHEDULE
#define ZM_MAX_TX_BUF_NUM               32
#else
#define ZM_MAX_TX_BUF_NUM               128
#endif

#define ZM_MAX_USB_URB_FAIL_COUNT       1

#define MAX_CMD_URB                     4 
              
#define urb_t                       struct urb

/* USB Endpoint definition */
#define USB_WLAN_TX_PIPE                1
#define USB_WLAN_RX_PIPE                2
#define USB_REG_IN_PIPE                 3
#define USB_REG_OUT_PIPE                4
#ifndef DISABLE_USB_MPHP
#define USB_WLAN_HP_TX_PIPE             5
#define USB_WLAN_MP_TX_PIPE             6
#endif

#define FIRMWARE_DOWNLOAD               0x30
#define FIRMWARE_DOWNLOAD_COMP          0x31
#define FIRMWARE_CONFIRM                0x32
#define HOST_COMMAND_RESERVED_1         0x33
#define HOST_COMMAND_RESERVED_2         0x34

#define HOST_FLASH_READ                 0x35
#define HOST_FLASH_READ_COMP            0x36

#define HOST_UPDATE_LED_STATS	        0x37
/**
 * XXX: This should pulled from firmware
 */
#define ZM_FIRMWARE_WLAN_ADDR		    0x501000
#define ZM_FIRMWARE_TEXT_ADDR_K2		0x903000 
#define ZM_FIRMWARE_TEXT_ADDR_MAGPIE		0x906000 

struct _hif_device_usb;

typedef void (*ath_usb_unload)(void);

typedef struct _UsbCmdUrbContext {
    uint8_t                 use;
    urb_t                   *RegOutUrb;
    struct sk_buff *        buf;
    struct _hif_device_usb  *macp;    
} UsbCmdUrbContext;

typedef struct UsbTxQ
{
    struct sk_buff *        buf;
} UsbTxQ_t;

typedef struct _UsbTxUrbContext {
    uint8_t                 index;
    uint8_t                 inUse;
    struct _hif_device_usb  *macp;
    struct sk_buff          *buf;
    urb_t                   *WlanTxDataUrb;
#ifdef HIF_USB_ENABLE_STREAM_MODE
#if ZM_USB_TX_STREAM_MODE == 1
   uint8_t                  txUsbBuf[ZM_USB_TX_BUF_SIZE];
#endif
#endif
} UsbTxUrbContext;

typedef struct _hif_usb_tx_pipe {
    //uint8_t               txUsbBuf[ZM_MAX_TX_URB_NUM][ZM_USB_TX_BUF_SIZE];
    //urb_t                 *WlanTxDataUrb[ZM_MAX_TX_URB_NUM];
    uint8_t               TxPipeNum;
    UsbTxQ_t              UsbTxBufQ[ZM_MAX_TX_BUF_NUM];
    uint16_t              TxBufHead;
    uint16_t              TxBufTail;
    uint16_t              TxBufCnt;
    uint16_t              TxUrbHead;
    uint16_t              TxUrbTail;
    uint16_t              TxUrbCnt;
    UsbTxUrbContext       TxUrbCtx[ZM_MAX_TX_URB_NUM];
    usb_complete_t        TxUrbCompleteCb;
#ifdef HIF_USB_ENABLE_STREAM_MODE
#if ZM_USB_TX_STREAM_MODE == 1
    uint8_t               txbuf0[1024*16];
    uint8_t               txbuf1[1024*16];
#endif
#endif

} HIFUSBTxPipe;

typedef struct _UsbRxUrbContext {
    uint8_t                 inUse;
    uint8_t                 failcnt;
    struct _hif_device_usb  *macp;
    struct sk_buff          *buf;
    urb_t                   *WlanRxDataUrb;
} UsbRxUrbContext;

typedef struct _hif_device_usb {
    void                    *handle;
    completion_callbacks_t  Callbacks;
    spinlock_t              cs_lock;
	
    struct usb_device       *udev;
    struct usb_interface    *interface;
    struct sk_buff *        regUsbReadBuf;
    UsbRxUrbContext         RxUrbCtx[ZM_MAX_RX_URB_NUM];
    urb_t                   *RegInUrb;
    int                     RegInFailCnt;
    HIFUSBTxPipe            TxPipe;
#ifndef DISABLE_USB_MPHP
    HIFUSBTxPipe            HPTxPipe;
    HIFUSBTxPipe            MPTxPipe;
#endif
    
    UsbCmdUrbContext        CmdUrbCtxs[MAX_CMD_URB];
    spinlock_t              CmdUrbLock;
#ifdef HIF_USB_ENABLE_STREAM_MODE
    struct sk_buff          *remain_buf ;
    struct timer_list       tm_txagg;
#endif
    struct timer_list       tm_rxbuf_alloc;
    uint8_t                 tm_rxbuf_act;
    uint8_t                 surpriseRemoved;
} HIF_DEVICE_USB;


#define hif_usb_assert(_cond)    ({     \
        int __ret = !(_cond);                  \
        if (__ret) {                  \
            dump_stack();               \
            panic("Asserting %s:%d for condition = !%s\n",   \
                __FUNCTION__, __LINE__, #_cond);  \
        }                               \
        __ret;                            \
})

extern int zfLnxAllocAllUrbs(HIF_DEVICE_USB *macp);
extern void zfLnxUnlinkAllUrbs(HIF_DEVICE_USB *macp);
extern void zfLnxFreeAllUrbs(HIF_DEVICE_USB *macp);
extern uint32_t zfLnxSubmitRegInUrb(HIF_DEVICE_USB *macp);
extern int32_t zfLnxUsbSubmitBulkUrb(urb_t *urb, struct usb_device *usb, 
                uint16_t epnum, uint16_t direction, uint8_t *transfer_buffer, 
                int buffer_length, usb_complete_t complete, void *context);
extern uint16_t zfLnxGetFreeTxBuffer(HIF_DEVICE_USB *macp, HIFUSBTxPipe *pipe);


#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)) || \
    (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,19))
extern void zfLnxUsbRegOut_callback(urb_t *urb);
#else
extern void zfLnxUsbRegOut_callback(urb_t *urb, struct pt_regs *regs);
#endif

extern void zfLnxInitUsbTxQ(HIF_DEVICE_USB *macp);
extern void zfLnxInitUsbRxQ(HIF_DEVICE_USB *macp);
extern uint32_t zfLnxPutUsbRxBuffer(HIF_DEVICE_USB *macp, struct sk_buff *buf);

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)) || \
    (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,19))
extern void zfLnxUsbDataIn_callback(urb_t *urb);
#else
extern void zfLnxUsbDataIn_callback(urb_t *urb, struct pt_regs *regs);
#endif

extern uint32_t zfLnxUsbIn(HIF_DEVICE_USB *macp, UsbRxUrbContext *RxUrbCtx);
extern uint32_t zfLnxUsbOut(HIF_DEVICE_USB *macp, struct sk_buff *buf, 
                HIFUSBTxPipe *pipe);

extern int32_t zfLnxUsbSubmitControl(HIF_DEVICE_USB *macp, uint8_t req, 
                uint16_t value, uint16_t index, void *data, uint32_t size);

extern UsbCmdUrbContext* zfLnxAllocCmdUrbCtx(HIF_DEVICE_USB *macp);
extern uint32_t zfLnxUsbSubmitIntUrb(urb_t *urb, struct usb_device *usb,
                uint16_t epnum, uint16_t direction, void* buf, 
                int buffer_length, usb_complete_t complete, void *context, 
                uint32_t interval);
extern void zfLnxFreeUsbTxBuffer(HIF_DEVICE_USB *macp, HIFUSBTxPipe *pipe);

#endif
