/*
 * (C) Copyright 2008
 * Stuart Wood, Lab X Technologies <stuart.wood@labxtechnologies.com>
 *
 * (C) Copyright 2004
 * Jian Zhang, Texas Instruments, jzhang@ti.com.

 * (C) Copyright 2000-2006
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * (C) Copyright 2001 Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Andreas Heppel <aheppel@sysgo.de>

 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/* #define DEBUG */

#undef DEBUG
#undef MYDEBUG

#include <common.h>

#if defined(CONFIG_ENV_IS_IN_NAND) /* Environment is in Nand Flash */

#include <command.h>
#include <environment.h>
#include <linux/stddef.h>
#include <linux/ctype.h>
#include <malloc.h>
#include <asm/byteorder.h>
#include <jffs2/jffs2.h>
#include <linux/mtd/compat.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/nand.h>
#include <nand.h>

#include <asm/io.h>
#include <asm/errno.h>


#if defined(CONFIG_SECURE_BOOT) && defined(CONFIG_AUTH_ENV_BIN)
#include "../tdf256/auth.h"
#endif


#if defined(CONFIG_CMD_ENV) && defined(CONFIG_CMD_NAND)
#define CMD_SAVEENV
#elif defined(CONFIG_ENV_OFFSET_REDUND)
#error Cannot use CONFIG_ENV_OFFSET_REDUND without CONFIG_CMD_ENV & CONFIG_CMD_NAND
#endif

#if defined(CONFIG_ENV_SIZE_REDUND) && (CONFIG_ENV_SIZE_REDUND != CONFIG_ENV_SIZE)
#error CONFIG_ENV_SIZE_REDUND should be the same as CONFIG_ENV_SIZE
#endif

#ifdef CONFIG_INFERNO
#error CONFIG_INFERNO not supported yet
#endif

#ifndef CONFIG_ENV_RANGE
#define CONFIG_ENV_RANGE	CONFIG_ENV_SIZE
#endif

extern unsigned int  read_part_offset(int partno);

int nand_legacy_rw (struct nand_chip* nand, int cmd,
	    size_t start, size_t len,
	    size_t * retlen, u_char * buf);
extern nand_info_t nand_info[];

/* references to names in env_common.c */
extern uchar default_environment[];
extern int default_environment_size;

char * env_name_spec = "NAND";


#ifdef ENV_IS_EMBEDDED
extern uchar environment[];
env_t *env_ptr = (env_t *)(&environment[0]);
#else /* ! ENV_IS_EMBEDDED */
env_t *env_ptr = 0;
#endif /* ENV_IS_EMBEDDED */


/* local functions */
#if !defined(ENV_IS_EMBEDDED) && !defined(CONFIG_ENV_OFFSET_REDUND)
static void use_default(void);
#endif

extern unsigned int  read_part_offset(int partno);
static int env_auth(unsigned char * buf);

#ifdef CONFIG_ENV_OFFSET_REDUND
#define CONFIG_ENV_STATIC	0
#define CONFIG_ENV_DYN1		1
#define CONFIG_ENV_DYN2		2

char *dynenv_tokens[CONFIG_MAX_ENVVARS];
char allowed_vars[CONFIG_SIZE_ALLOWED_VARS];
static char *pdynvar = NULL;

static unsigned char env_static_buffer[CONFIG_ENV_SIZE];
static unsigned char env_dyn1_buffer[CONFIG_ENV_SIZE];
static unsigned char env_dyn2_buffer[CONFIG_ENV_SIZE];
env_t *env_static;

static ulong env_get_offset_for(int type);
static void merge_env(env_t* env_a, env_t* env_b);
#endif

#ifdef CONFIG_ENV_IS_IN_NAND
/* this is the nand device that we will be using */
static	ulong 			env_get_offset(void); 
#endif 

DECLARE_GLOBAL_DATA_PTR;

uchar env_get_char_spec (int index)
{
	return ( *((uchar *)(gd->env_addr + index)) );
}


/* this is called before nand_init()
 * so we can't read Nand to validate env data.
 * Mark it OK for now. env_relocate() in env_common.c
 * will call our relocate function which does the real
 * validation.
 *
 * When using a NAND boot image (like sequoia_nand), the environment
 * can be embedded or attached to the U-Boot image in NAND flash. This way
 * the SPL loads not only the U-Boot image from NAND but also the
 * environment.
 */
int env_init(void)
{
#if defined(ENV_IS_EMBEDDED)
	size_t total;
	int crc1_ok = 0, crc2_ok = 0;
	env_t *tmp_env1, *tmp_env2;

	total = CONFIG_ENV_SIZE;

	tmp_env1 = env_ptr;
	tmp_env2 = (env_t *)((ulong)env_ptr + CONFIG_ENV_SIZE);

	crc1_ok = (crc32(0, tmp_env1->data, ENV_SIZE) == tmp_env1->crc);
	crc2_ok = (crc32(0, tmp_env2->data, ENV_SIZE) == tmp_env2->crc);

	if (!crc1_ok && !crc2_ok)
		gd->env_valid = 0;
	else if(crc1_ok && !crc2_ok)
		gd->env_valid = 1;
	else if(!crc1_ok && crc2_ok)
		gd->env_valid = 2;
	else {
		/* both ok - check serial */
		if(tmp_env1->flags == 255 && tmp_env2->flags == 0)
			gd->env_valid = 2;
		else if(tmp_env2->flags == 255 && tmp_env1->flags == 0)
			gd->env_valid = 1;
		else if(tmp_env1->flags > tmp_env2->flags)
			gd->env_valid = 1;
		else if(tmp_env2->flags > tmp_env1->flags)
			gd->env_valid = 2;
		else /* flags are equal - almost impossible */
			gd->env_valid = 1;
	}

	if (gd->env_valid == 1)
		env_ptr = tmp_env1;
	else if (gd->env_valid == 2)
		env_ptr = tmp_env2;
#else /* ENV_IS_EMBEDDED */
	gd->env_addr  = (ulong)&default_environment[0];
	gd->env_valid = 1;
#endif /* ENV_IS_EMBEDDED */

	mydebug("gd->env_valid=%d\n", gd->env_valid);
	
	return (0);
}

#ifdef CMD_SAVEENV
/*
 * The legacy NAND code saved the environment in the first NAND device i.e.,
 * nand_dev_desc + 0. This is also the behaviour using the new NAND code.
 */
int writeenv(size_t offset, u_char *buf)
{
	size_t end = offset + CONFIG_ENV_RANGE;
	size_t amount_saved = 0;
	size_t blocksize, len;

	u_char *char_ptr;

	blocksize = nand_info[0].erasesize;
	len = min(blocksize, CONFIG_ENV_SIZE);

	while (amount_saved < CONFIG_ENV_SIZE && offset < end) {
		if (nand_block_isbad(&nand_info[0], offset)) {
			offset += blocksize;
		} else {
			char_ptr = &buf[amount_saved];
			if (nand_write(&nand_info[0], offset, &len,
					char_ptr))
				return 1;
			offset += blocksize;
			amount_saved += len;
		}
	}
	if (amount_saved != CONFIG_ENV_SIZE)
		return 1;

	return 0;
}
#ifdef CONFIG_ENV_OFFSET_REDUND

static int saveto(int redundant) 
{
	int env;
	int ret;
	nand_erase_options_t nand_erase_options;

	env = (redundant ? CONFIG_ENV_DYN2 : CONFIG_ENV_DYN1);

	nand_erase_options.length = ROUND_UP(CONFIG_ENV_SIZE, nand_info[0].erasesize);
	nand_erase_options.quiet = 0;
	nand_erase_options.jffs2 = 0;
	nand_erase_options.scrub = 0;
	nand_erase_options.offset = env_get_offset_for(env);

	if (redundant) {
		puts ("Erasing redundant Nand...\n");
	} else {
		puts ("Erasing Nand...\n");
	}
	
	if (nand_erase_opts(&nand_info[0], &nand_erase_options))
		return 1;

	if (redundant) {
		puts ("Writing to redundant Nand... ");
	} else {
		puts ("Writing to Nand... ");
	}
	
	mydebug("env_ptr=%x\n", env_ptr);
	ret = writeenv(nand_erase_options.offset, (u_char *) env_ptr);
	
	return ret;
}


int saveenv(void)
{
	size_t total;
	int ret = 0;
	int redundant_first = 1;
	nand_erase_options_t nand_erase_options;

	//env_ptr->flags++;
	total = CONFIG_ENV_SIZE;

	nand_erase_options.length = ROUND_UP(CONFIG_ENV_SIZE, nand_info[0].erasesize);
	nand_erase_options.quiet = 0;
	nand_erase_options.jffs2 = 0;
	nand_erase_options.scrub = 0;

	if (CONFIG_ENV_RANGE < CONFIG_ENV_SIZE)
		return 1;

	redundant_first = (gd->env_valid == 1);

	// First inactive section
	ret = saveto(redundant_first);
	if (ret) {
		puts("FAILED!\n");
			return 1;
	}

	mydebug("gd->env_valid = %d\n", gd->env_valid);
	gd->env_valid = (gd->env_valid == 2 ? 1 : 2);

	// First active section
	ret = saveto(!redundant_first);		
	if (ret) {
		puts("FAILED!\n");
		return 1;
	}

	puts ("done\n");
	gd->env_valid = (gd->env_valid == 2 ? 1 : 2);
	mydebug("Quit: gd->env_valid = %d\n", gd->env_valid);
	
	return ret;
}
#else /* ! CONFIG_ENV_OFFSET_REDUND */
int saveenv(void)
{
	size_t total;
	int ret = 0;
	nand_erase_options_t nand_erase_options;

	//nand_erase_options.length = CONFIG_ENV_RANGE;
	nand_erase_options.length = ROUND_UP(CONFIG_ENV_SIZE, nand_info[0].erasesize);
	nand_erase_options.quiet = 0;
	nand_erase_options.jffs2 = 0;
	nand_erase_options.scrub = 0;
	//nand_erase_options.offset = CONFIG_ENV_OFFSET;
	nand_erase_options.offset = env_get_offset();

	if (CONFIG_ENV_RANGE < CONFIG_ENV_SIZE)
		return 1;
	puts ("Erasing Nand...\n");
	if (nand_erase_opts(&nand_info[0], &nand_erase_options))
		return 1;

	puts ("Writing to Nand... ");
	total = CONFIG_ENV_SIZE;
		if (writeenv(env_get_offset(), (u_char *) env_ptr)) {
		puts("FAILED!\n");
		return 1;
	}

	puts ("done\n");
	return ret;
}
#endif /* CONFIG_ENV_OFFSET_REDUND */
#endif /* CMD_SAVEENV */

int readenv (size_t offset, u_char * buf)
{
	size_t end = offset + CONFIG_ENV_RANGE;
	size_t amount_loaded = 0;
	size_t blocksize, len;
	int retval;

	u_char *char_ptr;

	blocksize = nand_info[0].erasesize;
	len = min(blocksize, CONFIG_ENV_SIZE);

	while (amount_loaded < CONFIG_ENV_SIZE && offset < end) {
		if (nand_block_isbad(&nand_info[0], offset)) {
			offset += blocksize;
		} else {
			char_ptr = &buf[amount_loaded];
			retval = nand_read(&nand_info[0], offset, &len, char_ptr);
			if ((retval) && (retval != -EUCLEAN)) 
				return 1;
			offset += blocksize;
			amount_loaded += len;
		}
	}
	if (amount_loaded != CONFIG_ENV_SIZE)
		return 1;

	return 0;
}

#ifdef CONFIG_ENV_OFFSET_REDUND
void env_relocate_spec (void)
{
#if !defined(ENV_IS_EMBEDDED)
	int crc1_ok = 0, crc2_ok = 0, crc_static_ok = 0;
	env_t *tmp_env1, *tmp_env2;
	ulong env_offs_dyn1, env_offs_dyn2, env_offs_static;

	mydebug("CONFIG_ENV_SIZE=%x\n", CONFIG_ENV_SIZE);

 	tmp_env1   = (env_t *) env_dyn1_buffer;;
 	tmp_env2   = (env_t *) env_dyn2_buffer;;
 	env_static = (env_t *) env_static_buffer;

	env_offs_dyn1  = env_get_offset_for(CONFIG_ENV_DYN1);
	env_offs_dyn2  = env_get_offset_for(CONFIG_ENV_DYN2);
	env_offs_static = env_get_offset_for(CONFIG_ENV_STATIC);
	mydebug("env_offs_static@%x env_offs_dyn1@%x env_offs_dyn2@%x\n", 
		env_offs_static, env_offs_dyn1, env_offs_dyn2);

	if (readenv(env_offs_dyn1, (u_char *)tmp_env1))
		puts("No Valid Environment Area Found\n");
	if (readenv(env_offs_dyn2, (u_char *)tmp_env2))
		puts("No Valid Reundant Environment Area Found\n");
	if (readenv(env_offs_static, (u_char *)env_static)){ 
		puts("ERROR: No Valid Static Environment Area Found\n");
		puts("\tPlease reset the set.\n");
		for (;;) ;
	}
	else {
		env_auth((u_char *)env_static);
	}

	//mydebug("tmp_env1@%x, tmp_env2@%x, tmp_static@%x\n", tmp_env1, tmp_env2, tmp_env_static);
	{
		unsigned long c1, c2, c3;
		c1 = crc32(0, tmp_env1->data, CONFIG_ENV_SIZE);
		c2 = crc32(0, tmp_env2->data, CONFIG_ENV_SIZE);
		c3 = crc32(0, env_static->data, CONFIG_ENV_SIZE);

	crc1_ok = (crc32(0, tmp_env1->data, ENV_SIZE) == tmp_env1->crc);
	crc2_ok = (crc32(0, tmp_env2->data, ENV_SIZE) == tmp_env2->crc);
		crc_static_ok = (crc32(0, env_static->data, ENV_SIZE) == env_static->crc);
		mydebug("c1=%x c2=%x c3=%x\n", c1, c2, c3); 
	}
	//mydebug("tmp_env1->crc=%x tmp_env2->crc=%x crc1_ok=%d, crc2_ok=%d, crc_static_ok=%d\n", 
	//	tmp_env1->crc, tmp_env2->crc, crc1_ok, crc2_ok, crc_static_ok);

	if (!crc_static_ok) {
		puts("### Warning: Static environment variables are corrupted.\n");
		env_static->data[0] = 0;
		env_static->data[1] = 0;
	}

	
	if(!crc1_ok && !crc2_ok) {
		// In this case, either both dyn1 & dyn2 are empty or they are corrupted.
		//return use_default();
		gd->env_valid = 0;
	}
	else if(crc1_ok && !crc2_ok)
	{
		gd->env_valid = 1;
	}
	else if(!crc1_ok && crc2_ok)
	{
		gd->env_valid = 2;
	}
	else {
		/* both ok - check serial */
			gd->env_valid = 1;
	}

	//free(env_ptr);
	if(gd->env_valid == 1) {
		merge_env(tmp_env1, env_static);
	} else if (gd->env_valid == 2) {
		merge_env(tmp_env2, env_static);
	} // else {}: no merge if no valid vars in dyn1 & dyn2
	
	env_ptr = env_static;

#endif /* ! ENV_IS_EMBEDDED */

	if(gd->env_valid == 1) {
		printf("Env:   NAND @ 0x%08lx\n", env_offs_dyn1);
	} else if (gd->env_valid == 2) { 
		printf("Env:   NAND @ 0x%08lx\n", env_offs_dyn2);
	} else {
		printf("Env:   NAND @ 0x%08lx\n", env_offs_dyn1);
		gd->env_valid = 1;
	}

	mydebug("gd->env_valid=%d\n", gd->env_valid);
}
#else /* ! CONFIG_ENV_OFFSET_REDUND */
/*
 * The legacy NAND code saved the environment in the first NAND device i.e.,
 * nand_dev_desc + 0. This is also the behaviour using the new NAND code.
 */
void env_relocate_spec (void)
{
#if !defined(ENV_IS_EMBEDDED) && defined(CONFIG_ENV_IS_IN_NAND)
	int ret;
	ulong offs = env_get_offset();

	ret = readenv(offs, (u_char *) env_ptr);

	if (ret)
		return use_default();

	if (crc32(0, env_ptr->data, ENV_SIZE) != env_ptr->crc)
		return use_default();
	/* use the just read env from nand as environment */
	//env_ptr = nand_env_ptr;
	printf("Env:   NAND @ 0x%08lx\n", offs);

#endif /* ! ENV_IS_EMBEDDED */
}
#endif /* CONFIG_ENV_OFFSET_REDUND */

#ifdef CONFIG_ENV_OFFSET_REDUND
int is_dyn_var(char *item)
{
	int chg_ok = 0;

	if (strcmp(dynenv_tokens[0], "<all>") == 0) {
		chg_ok = 1;
	} else {
		int i=0;		
		while (dynenv_tokens[i]) {
			if (strcmp(dynenv_tokens[i], item) == 0) {
				// found it
				chg_ok = 1;
				break;
			}

			i++;
		}
	}

	return chg_ok;
}


/* Parse the dynamic env var list from *from. 
 * Input:
 *    from: the orginal list as from getenv().
 *    pdynvar: copy of from, with multiple space removed.
 * Output: 
 *    dynenv_tokens: a pointer array, each point to a dyn var. 
 */
static int parse_dynvar_list(char *pdynvar, char *from) 
{
	char *p, *cp;
	int i, len, k;

	p = from;
	len = strlen(p) + 1; //including '\0'
	
	// Replace \t with space; remove extra spaces....;
	i = 0; 
	k = 0;
	while (i<(len - 1)) {
		// replace first occurrence of tab, return char with space		
		if ( isspace(p[i]) ) {
			if (k>0) {
				pdynvar[k] = ' ';
				//mydebug("==>pdynvar[%d]=%c\n", k, pdynvar[k]);
				k++;
			}
			
			i++;
			// skip subsequence space, tab, return chars		
			while ( isspace(p[i]) ) {
				//mydebug("i=%d skip 0x%02x\n", i, p[i]);
				i++;
			}
		} else {
			pdynvar[k] = p[i];
			//mydebug("==>pdynvar[%d]=%c\n", k, pdynvar[k]);
			k++;
			i++;
		}
	}
	pdynvar[k] = 0;
	
	// Remove the trailing "space"
	//len = strlen(pdynvar) - 1;
	len = k - 1;
	while ( isspace(pdynvar[len]) ) { 
		len--;
	}
	pdynvar[len+1] = 0x0;	
	//mydebug("pdynvar@%x, size:%d, *%s*\n", pdynvar, strlen(pdynvar) + 1, pdynvar); 

	i = 0;
	cp = pdynvar;
	while (*cp) {
		dynenv_tokens[i++] = cp;

		// Find the next space
		cp = strpbrk(cp, " ");
		*cp = 0;
		cp ++;
	}
	dynenv_tokens[i] = NULL;

	i = 0;
	while (dynenv_tokens[i] != NULL) {
		mydebug("dynenv_tokens[%d]=*%s*\n", i, dynenv_tokens[i]);
		i++;
	}

	return i;
}

#if 0
static void show_dynvars(void) 
{
	int i = 0;

	mydebug("dynenv_tokens@%x\n", dynenv_tokens);
	while (dynenv_tokens[i] != NULL) {
		mydebug("dynenv_tokens[%d]=*%s*\n", i, dynenv_tokens[i]);
		i++;
	}
}
#endif

static void merge_env(env_t* env_a, env_t* env_b) {
	//ulong	env_addr_sav = gd->env_addr;
	//env_t*	env_ptr_sav = env_ptr;
	int	i;
	int	nxt;
	char *p;
	
	/* to be able to simply use setenv() we need to set gd->env_addr to 
	 * the 'destination' environment */
	gd->env_addr = (ulong)env_b->data;
	p = getenv("__DYNAMIC_VARS");

	pdynvar = allowed_vars;
	parse_dynvar_list(pdynvar, p);

	/* iterate env_a */
	for (i = 0; env_a->data[i] != '\0'; i = nxt + 1) {
		char*	item;
		char*	val;

		item = val = (char*)&env_a->data[i];

		/* pre-find next item.. */
		for (nxt = i; env_a->data[nxt] != '\0'; ++nxt) {
			if ( (item==val)  &&  (env_a->data[nxt] == '=') ) {
				val = (char*)&env_a->data[nxt];
				*val++ = '\0';	
			}
			
			if (nxt >= CONFIG_ENV_SIZE)
				goto MERGE_ENV_DONE;
		}

		if (item != val) {
			debug("--->env_a['%s']='%s'\n", item, val);

			if (is_dyn_var(item)) {
				/* use default setenv command to put env_a env item into env_b */
				env_ptr = env_b;
				gd->env_addr = (ulong)env_b->data;
				setenv(item, val);
			} else {
				debug("Warning: does not allow to change %s to %s\n", item, val);
			}
		}
	}

MERGE_ENV_DONE:
	/* destroy the embedded environment so that we dont process it twice
	 * or process an environment that is stale.. we dont like stale milk,
	 * same goes for environments :-) */
	env_a->crc = ~0;
	//dcache_flush_range(env_a, CFG_ENV_SIZE);

	/* restore the saved env_addr */
	//env_ptr = env_ptr_sav;
	//gd->env_addr = env_addr_sav;

	//free(pdynvar);
	myinfo("merge done!\n");
}

#endif

#if !defined(ENV_IS_EMBEDDED) && !defined(CONFIG_ENV_OFFSET_REDUND)
static void use_default()
{
	puts ("*** Warning - bad CRC or NAND, using default environment\n\n");
	set_default_env();
}
#endif /* !defined(ENV_IS_EMBEDDED)*/

#ifdef CONFIG_ENV_IS_IN_NAND
extern int nand_curr_device;

#ifdef CONFIG_ENV_OFFSET_REDUND

// Return the first good block starting from "offset".
static ulong get_block(loff_t offset) 
{
	loff_t offs = offset;
	nand_info_t *nand = &(nand_info[0]);

	while (nand->block_isbad(nand, offs)) {
		offs = offs + nand->erasesize;
	}  

	return offs;
}

static ulong env_get_offset_for(int type)
{
	ulong offs;
	int   nandsize;
		
	nandsize = nand_info[0].size;	

	switch (type) {
		case CONFIG_ENV_STATIC:
			// located at 4th good block
			offs = get_block(0);
			offs = get_block(offs + nand_info[0].erasesize);
			offs = get_block(offs + nand_info[0].erasesize);
			offs = get_block(offs + nand_info[0].erasesize);
			break;

		case CONFIG_ENV_DYN1:
			// 1th good block in the dyn env var partition
			offs = env_get_offset();
			offs = get_block(offs);
			break;
	
		case CONFIG_ENV_DYN2:		
			// 1th good block in the dyn env var partition
			offs = env_get_offset();
			offs += nand_info[0].erasesize;
			offs = get_block(offs);
			break;
		
	} 

	return offs;
}
#endif /* CONFIG_ENV_OFFSET_REDUND */

/* 	Return nand offset for env bin. */ 
static ulong env_get_offset(void)
{
#ifndef CONFIG_ENV_OFFSET
	// Get env offset from partition table
	static int 	   firsttime = 1;
	static ulong  env_offset = 0;  // offset for the environment partition

	if (firsttime) {	
		// The environment partition is the 2nd partion
		env_offset = read_part_offset(1);
		mydebug("env_offset=%x\n", env_offset);
		firsttime = 0;
	}	

	return env_offset;

#else
	/*	Env offset is hard-coded. 
	 *	Only implemented for 128MB nand flash.
	 */
	ulong offs;
	int   nandsize;

	nandsize = nand_info[0].size;	
	switch (nandsize) {
		case 0x08000000: /* 128MB */
			offs = 0x00120000;
			break;

		case 0x10000000: /* 256MB */
	                offs = 0x00120000;
                        break;
	
		case 0x20000000: /* 512MB */
			offs = 0x00120000;
			break;

		case 0x01000000: /* 16MB */
		case 0x02000000: /* 32MB */
		case 0x04000000: /* 64MB */
		case 0x40000000: /* 1GB */
		default:
			printf("Warning: unsupported nand!....\n");
			offs = 0x00120000;
			break;
	}

	return offs;
#endif

}


// Authenticate static env vars
static int env_auth(unsigned char *buf)
{
#ifdef CONFIG_AUTH_ENV_BIN
	int ret = 0;;

	//puts("..Authenticating environment variables.....");
	tmbtAuth_Dispatch(buf, CONFIG_ENV_SIZE - CONFIG_SIG_SIZE, AUTH_SHA_COMPLETE, 1);	
	ret = tmbtAuth_Compare( (unsigned long *)&(buf[CONFIG_ENV_SIZE - CONFIG_SIG_SIZE]) );	
	if (ret != 0) 	{	
		puts ("\n\n### Warning: Authenticating env bin fails!!!\n");		
		// Don't stop, just make it empty. 
		// In the development environment, it would stop with u-boot command line mode;
		// In the production environment, the set would handup later on; a reset
		// will be required.
		memset(buf, 0, 0x10);
		ret = 1;
	} else {
		//puts("suceeds.\n");
		ret = 0;
	}

	// clean up signature	
	memset(&(buf[CONFIG_ENV_SIZE - CONFIG_SIG_SIZE]), 0, CONFIG_SIG_SIZE);
#else
	// Just clean up signature	
	memset(&(buf[CONFIG_ENV_SIZE - CONFIG_SIG_SIZE]), 0, CONFIG_SIG_SIZE);
	ret = 0;
#endif

	return ret;
}

#endif /* CONFIG_ENV_IS_IN_NAND */

#endif
