/*
 * Most of this source has been derived from the Linux USB
 * project:
 *   (c) 1999-2002 Matthew Dharm (mdharm-usb@one-eyed-alien.net)
 *   (c) 2000 David L. Brown, Jr. (usb-storage@davidb.org)
 *   (c) 1999 Michael Gee (michael@linuxspecific.com)
 *   (c) 2000 Yggdrasil Computing, Inc.
 *
 * Adapted for U-Boot:
 *   (C) Copyright 2009 Hedwin Koning (hedwin.koning@gmail.com)
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 */

#include <common.h>
#include <command.h>

#if defined(CONFIG_CMD_NET) && defined(CONFIG_USB_NETWORK) 

#undef USB_NET_DEBUG

#ifdef	USB_NET_DEBUG
#define USB_NET_PRINTF(fmt, args...)	printf("[%s@%d]" fmt, __FUNCTION__, __LINE__ , ##args)
#else
#define USB_NET_PRINTF(fmt,args...)
#endif

#include <usb.h>
#include <net.h>
#include <linux/mii.h>
#include <miiphy.h>

#include "usb.h"            /* `struct urb_priv_t' */
#include "usb_net.h"


/* our administration */
extern struct pegasus   g_usb_eth;  	/* could be an array */
extern struct pegasus*  g_p_usb_eth;    /* use this pegasus device */

/* eth administration */
extern struct eth_device   g_eth_dev;  /* use this stuff to feed `eth.c' */

int usb_network_probe(struct usb_device *dev, unsigned int ifnum);
int usb_eth_init(bd_t *bis);

static int g_usb_net_total_devs = 0;    /* number of highest available usb device */

/* scan usb device tree for usb eth device(s) */
int usb_net_scan(int mode) {
    int                 ret = 0;
	unsigned char 		i;

    unsigned int        usb_dev_index;
    struct usb_device*  dev;
    struct eth_device*  p_eth_dev;
    pegasus_t*          p_pegasus;

    /* initialize these first.. */
    g_usb_net_total_devs = 0;
    p_eth_dev = &g_eth_dev;
    p_pegasus = &g_usb_eth;

    if (1 == mode)
        printf("       scanning bus for network devices... ");

    usb_disable_asynch(1);  /* asynch transfer not allowed */

	for(i=0;i<USB_MAX_DEVICE;i++) {
		dev = usb_get_dev_index(i); /* get device */

		if (dev == NULL)
			break; /* no more devices avaiable */

		if (usb_network_probe(dev, 0)) {
			/* Ok found an USB ethernet device, lets check it out */
        	if (0 > (ret = pegasus_probe(dev, p_eth_dev, 0, p_pegasus))) {
            	printf("error %d probing usb-eth device", ret);
            	continue;
        	}
		}
	
        if (0 < ret) {
            ++g_usb_net_total_devs; /* pegasus device counter */
            ++p_pegasus;        /* pegasus device info */
        }
    }

    usb_disable_asynch(0);  /* asynch transfer allowed */

    if (1 == mode)
        printf("%d Network Device(s) found\n", g_usb_net_total_devs);

    if (0 < g_usb_net_total_devs)
        ret = g_usb_net_total_devs;

    return (ret);
}

/* Probe to see if a new device is actually a communications device */
int usb_network_probe(struct usb_device *dev, unsigned int ifnum)
{
	struct usb_interface_descriptor *iface;
	int i;
	unsigned int flags = 0;

	int protocol = 0;
	int subclass = 0;

	/* let's examine the device now */
	iface = &dev->config.if_desc[ifnum];

	/* this is the place to patch some network devices */
	USB_NET_PRINTF("iVendor %X iProduct %X (%x)\n", 
                        dev->descriptor.idVendor,
			dev->descriptor.idProduct,
                        dev->descriptor.bDeviceClass);

	if (dev->descriptor.bDeviceClass != USB_CLASS_COMM &&
	    dev->descriptor.bDeviceClass != USB_CLASS_PER_INTERFACE &&
	    dev->descriptor.bDeviceClass != USB_CLASS_VENDOR_SPEC) {
		/* if it's not a communication device, we go no further */
		return 0;
	}

	/* At this point, we know we've got a live one */
	USB_NET_PRINTF("\n\nUSB Communication device detected\n");

	return 1;
}

int usb_eth_init(bd_t *bis) 
{
	return pegasus_initialize(bis);
}
#endif  /* (CONFIG_CMD_NET) */
