/*
 * Device driver for NAND flash connected IP_2070 EFM.
 *
 * Copyright (C) 2008 NXP B.V.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Revision history
 * Version    Date          Remarks		
 * 0.0.1		20080318		Draft-Initial version
 */

#include <common.h>
#include <watchdog.h>
#include <linux/err.h>
#include <linux/mtd/compat.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/nand.h>
#include <linux/mtd/nand_ecc.h>

#include <asm/io.h>
#include <asm/errno.h>

/* Fix me: To be taken from glb.h */
#define   PNX8XXX_EFM_BASE            (MMIO_BASE + 0x0002B000)
#define 	NX_NAND_AHB_BUF 						(0x00000000) 						/* DMAC Flow conttrol */

/* Max Data buffer size */
#define NX_NAND_BLK_SIZE          (512)

/* Max OOB buffer size */
#define NX_NAND_MAX_OOB_SIZE      (128)

/* Maximum AHB buffer size */
#define NX_NAND_AHB_BUF_MAX_SIZE  (NX_NAND_BLK_SIZE+NX_NAND_MAX_OOB_SIZE)

/* IP_2017 Register offsets */
#define CMD_ADDR_FIFO_OFFSET          (0x000) /**< EFMC Nand Flash Command / Address FIFO register */
#define PAGE_RW_OFFSET                (0x004) /**< EFMC Nand Flash Page Read/Write register */
#define NAND_STATUS_OFFSET            (0x008) /** Nand Flash Status registers */
#define DMA_CTRL_OFFSET               (0x00C) /** DMA Control Register */
#define EBI_CTRL_OFFSET               (0x010) /**<  EBI Pin-Sharing Control Register*/
#define AHB_LATENCY_OFFSET            (0x014) /**< AX/AHB Latency Register */
#define APB_LATENCY_OFFSET            (0x018) /**<  APB Latency Register*/
#define APB_ERROR_GEN_OFFSET          (0x01C) /**<  APB Error Register */
#define AES_KEY1_OFFSET               (0x020) /**< AES Key Register(1st 32bit) */
#define AES_KEY2_OFFSET               (0x024) /**< AES Key Register(2nd 32bit) */
#define AES_KEY3_OFFSET               (0x028) /**< AES Key Register (3rd 32bit) */
#define AES_KEY4_OFFSET               (0x02C) /**< AES Key Register (4th 32bit) */
#define AES_IV1_OFFSET                (0x030) /**<  AES Initial Value Register (1st 32bit)*/
#define AES_IV2_OFFSET                (0x034) /**< AES Initial Value Register (2nd32bit) */
#define AES_IV3_OFFSET                (0x038) /**< AES Initial Value Register (3rd 32bit) */
#define AES_IV4_OFFSET                (0x03C) /**< AES Initial Value Register (4th 32bit) */
#define AES_STATUS_OFFSET             (0x040) /**< AES Status Register */
#define SINGLE_READ_OFFSET            (0x044) /**<  Nand Flash SInge Read Register*/
#define SINGLE_WRITE_OFFSET           (0x048) /**< Nand Flash SInge Write Register */
#define DEV_TYPE0_OFFSET              (0x04C) /**<  Nand Flash Device Type Register for CEn[n]*/
#define DEV_TYPE0_DIFF                (0x00C) /**  */
#define DEV_TIMING0_OFFSET            (0x050) /**<Nand Flash Device Timing Register #0 for CEn[n]  */
#define DEV_TIMING0_DIFF              (0x00C) /**  */
#define DEV_TIMING1_OFFSET            (0x054) /**< Nand Flash Device Timing Register #1 for CEn[n] */
#define DEV_TIMING1_DIFF              (0x00C) /**  */
#define MOD_CONFIG_OFFSET             (0xFD4) /**< Module Configuration Register */
#define INT_CLR_ENABLE_OFFSET         (0xFD8) /** Interrupt Clear Enable Register */
#define INT_SET_ENABLE_OFFSET         (0xFDC) /** Interrupt Set Enable Register */
#define INT_STATUS_OFFSET             (0xFE0) /** Interrupt Status Register */
#define INT_ENABLE_OFFSET             (0xFE4) /** Interrupt Enable Register */
#define INT_CLR_STATUS_OFFSET         (0xFE8) /** Interrupt Clear Status Set Register */
#define INT_SET_STATUS_OFFSET         (0xFEC) /** Interrupt Set Status Set Register */
#define SWRESET_OFFSET                (0xFF0) /**< Software reset register */
#define POWER_DOWN_OFFSET             (0xFF4) /**< Power down register */
#define EXT_MODID_OFFSET              (0xFF8) /**< Dynamic memory write recovery time register */
#define MODID_OFFSET                  (0xFFC) /**< Dynamic memory write recovery time register */

/* Module Config Register bits */
#define MOD_CONFIG_AES_MSK            (0x00000020)

/* Device Type Register bits */
#define DEV_TYPE0_CEN_DONT_MSK   			(0x00000004)
#define DEV_TYPE0_DATA_WIDTH_MSK 			(0x00000003)
#define DEV_TYPE0_PAGE_SIZE_MASK      (0x00000070)
#define DEV_TYPE0_PAGE_SIZE_POS				(4)

/* NAND Status register bits */
#define	NAND_STATUS_RB_DEV0           (0x00000001)

/* Cmd FIFO bit information */
#define CMD_FIFO_CE_POS    						(19)
#define CMD_FIFO_CE_MSK								(0x00000003)
#define CMD_FIFO_CYCLE_POS    				(16)
#define CMD_FIFO_CYCLE_MSK    				(0x00000003)
#define CMD_FIFO_LAST_POS    					(18)
#define CMD_FIFO_LAST_MSK	   					(0x00000001)
#define CMD_FIFO_IO_POS								(0)
#define CMD_FIFO_IO_MSK								(0x0000FFFF)

/* Interrupt Register bits */
#define NX_NAND_INT_READY_START   (20)
#define NX_NAND_INT_ALL           (0x00FFFFFFFF)
#define NX_NAND_INT_OOB_READ      (1<<0)
#define NX_NAND_INT_OOB_WRITE     (1<<1)
#define NX_NAND_INT_BLK_READ      (1<<2)
#define NX_NAND_INT_BLK_WRITE     (1<<3)
#define NX_NAND_INT_ENC           (1<<4)
#define NX_NAND_INT_DEC           (1<<5)
#define NX_NAND_INT_DEC_0_ERR     (1<<6)
#define NX_NAND_INT_DEC_1_ERR     (1<<7)
#define NX_NAND_INT_DEC_2_ERR     (1<<8)
#define NX_NAND_INT_DEC_3_ERR     (1<<9)
#define NX_NAND_INT_DEC_4_ERR     (1<<10)
#define NX_NAND_INT_DEC_5_ERR     (1<<11)
#define NX_NAND_INT_DEC_UNCOR     (1<<12)
#define NX_NAND_INT_AES_DEC       (1<<13)
#define NX_NAND_INT_SEQ_READ      (1<<14)
#define NX_NAND_INT_SEQ_WRITE     (1<<15)
#define NX_NAND_INT_BUSY1         (1<<16)
#define NX_NAND_INT_BUSY2         (1<<17)
#define NX_NAND_INT_BUSY3         (1<<18)
#define NX_NAND_INT_BUSY4         (1<<19)
#define NX_NAND_INT_READY1        (1<<20)
#define NX_NAND_INT_READY2        (1<<21)
#define NX_NAND_INT_READY3        (1<<22)
#define NX_NAND_INT_READY4        (1<<23)

/* DMA control register bits */
#define DMA_CTRL_PER_2_MEM        (0x1)
#define DMA_CTRL_MEM_2_PER        (0x2)

/*  Page Operation register bits */
#define PAGE_RW_OOB_MSK           (0x00000010)
#define PAGE_RW_ECC_MSK           (0x00000004)
#define PAGE_RW_AES_MSK           (0x00000008)
#define PAGE_RW_PAGE_WRITE_MSK    (0x00000002)
#define PAGE_RW_PAGE_READ_MSK     (0x00000001)

#define NX_NAND_SP_ADDR_MASK      (0x000000FF)
/**
* NAND control structure
*/
struct nx_nand_ctrl {
	struct mtd_info       *mtd;          /* MTD information structure */
  uint8_t               *dmabuf;    	/* DMA buffer */
	uint8_t								*dmabuf_unalgn; /* Unaligned buffer */
  int                   slotid;     	/* current chip number */
  int                   cur_col;    	/* Current column address */
  int                   cur_page;   	/* Current page address */
  int                   cur_cmd;   		/* Current page address */
  int                   lb_chip;   	  /* Large Block chip flag */
  void __iomem          *ctrl_base; 	/* Controller base address */
  int                   aes;        	/* AES decryption support */
  uint32_t              aes_key[4]; 	/* AES 128 bit key */
	uint32_t              aes_val[4]; 	/* AES initial 128 bit value */
  int		                num_blks;   	/* # of 512 bytes blocks per page */ 
  int		                blk_index;  	/* Block index */
  int                   *ecc_status;	/* ECC status array */
  int                   offset;				/* Offset in inetrnal driver buffer */
	int 									cedontcare;		/* CE dont care support */
};
