#include <common.h>
#include <ubi_uboot.h>
#include <command.h>
#include <part.h>
#include <asm/io.h>

static unsigned long ubiblock_read(int dev, unsigned long start,
				    unsigned long blkcnt, void *buffer);

static block_dev_desc_t ubi_dev = { 0 };

struct ubi_device *ubiblock_ubi;
struct ubi_volume *ubiblock_vol;

block_dev_desc_t *ubi_get_dev(int dev)
{
	/* The first time through this, the ubi_dev object is
	   not yet initialized. In that case, fill it in. */
	if (ubi_dev.blksz == 0) {
		ubi_dev.if_type = IF_TYPE_UNKNOWN;
		ubi_dev.dev = 0;
		ubi_dev.part_type = PART_TYPE_UNKNOWN;
		ubi_dev.type = DEV_TYPE_HARDDISK;
		ubi_dev.blksz = 512;
		ubi_dev.removable = 1;
		ubi_dev.block_read = ubiblock_read;
		ubiblock_ubi = ubi_get_device (dev);
		ubiblock_vol = ubiblock_ubi->volumes[0];

		init_part(&ubi_dev);

	}

	return &ubi_dev;
}	

static unsigned long ubiblock_read(int dev, unsigned long start,
				    unsigned long blkcnt, void *buffer)
{
	int err = 0, lnum, offs, total_read, len;

	//printk (KERN_ALERT "ubiblock_read start: %d, blkcnt: %d\n", start, blkcnt);

	start = start * 512;
	len = blkcnt * ubi_dev.blksz;

	lnum = start / ubiblock_vol->usable_leb_size;
	offs = start % ubiblock_vol->usable_leb_size;
	total_read = len;
	while (total_read) {
		size_t to_read = ubiblock_vol->usable_leb_size - offs;

		if (to_read > total_read) {
			to_read = total_read;
		}

		err = ubi_eba_read_leb (ubiblock_ubi, ubiblock_vol, lnum, 
				  buffer, offs, to_read, 0);

		if (err) {
			break;
		}

		lnum ++; offs = 0; 
		total_read -= to_read; buffer += to_read;
	}

	return blkcnt;
}
