/*
 *  NXP PNX8XXX i2c_ip3203.h
 *
 *  Copyright (C) 2006 Koninklijke Philips Electronics N.V.
 *  Vincent van der Locht, vincent.van.der.locht@philips.com
 *
 *  This program is free software; you can redistribute	 it and/or modify it
 *  under  the terms of	 the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the	License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED	  ``AS	IS'' AND   ANY	EXPRESS OR IMPLIED
 *  WARRANTIES,	  INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO	EVENT  SHALL   THE AUTHOR  BE	 LIABLE FOR ANY	  DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED	  TO, PROCUREMENT OF  SUBSTITUTE GOODS	OR SERVICES; LOSS OF
 *  USE, DATA,	OR PROFITS; OR	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN	 CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "glb.h"

#define IP3203_SLAVE_ADDR              0x60
#define IP3203_TIMEOUT                 20000

#define MMIO_IP3203_UNIT0              PNX8XXX_I2C0_BASE_VIRT

/* Local Macros for IP3203 */
#define IP3203_CONTROL                 ( (volatile unsigned int *)(MMIO_IP3203_UNIT0 + 0x00000000) )
#define IP3203_STATUS                  ( (volatile unsigned int *)(MMIO_IP3203_UNIT0 + 0x00000004) )
#define IP3203_DAT                     ( (volatile unsigned int *)(MMIO_IP3203_UNIT0 + 0x00000008) )
#define IP3203_HSBIR                   ( (volatile unsigned int *)(MMIO_IP3203_UNIT0 + 0x00000010) )
#define IP3203_FSBIR                   ( (volatile unsigned int *)(MMIO_IP3203_UNIT0 + 0x00000014) )
#define IP3203_INT_STATUS              ( (volatile unsigned int *)(MMIO_IP3203_UNIT0 + 0x00000FE0) )
#define IP3203_INT_EN                  ( (volatile unsigned int *)(MMIO_IP3203_UNIT0 + 0x00000FE4) )
#define IP3203_INT_CLR                 ( (volatile unsigned int *)(MMIO_IP3203_UNIT0 + 0x00000FE8) )
#define IP3203_POWERDOWN               ( (volatile unsigned int *)(MMIO_IP3203_UNIT0 + 0x00000FF4) )

#define IP3203_FSBIR_BITRATE_POS       (0)
#define IP3203_FSBIR_BITRATE_MASK      (0x0000007f)
#define IP3203_AA                      (0x04) /* Bit in the register CONTROL    */
#define IP3203_STO                     (0x10) /* Bit in the register CONTROL    */
#define IP3203_STA                     (0x20) /* Bit in the register CONTROL    */
#define IP3203_INTBIT                  (0x01) /* Bit in the register INT_STATUS */
#define IP3203_EN                      (0x40) /* Bit in the register CONTROL    */

#define WAIT_IP3203INT()               do{ int t = IP3203_TIMEOUT;                            \
                                           while(!(*IP3203_INT_STATUS & IP3203_INTBIT)        \
                                                  && (t-->0)){}                               \
                                         }while(0)

void pnx8xxx_ip3203_init(void);
int pnx8xxx_ip3203_write(char* i2c_message, int message_len);

