#ifndef __LIPP_6300ETH_COMMON_H__
#define __LIPP_6300ETH_COMMON_H__

#include <config.h> /* PHY & ethernet driver related macros are defined here */

#define MAC_BASE_ADDRESS ((MMIO_BASE+0x38000))

/* Speed of the ethernet link */
#define ETH_LINK_SPEED (LX_SPEED_100)

/* Mode of the ethernet link */
#define ETH_LINK_MODE (LX_MODE_FULL_DUPLEX)
  
/* Macro to enable/disable autonegotiation */
#define ETH_AUTO_NEGOTIATION (LX_AUTONEG_ENABLE)

#define GMAC_PRINT 1
#define ENABLE_CACHE 1
#if (GMAC_PRINT == 1)
#define GMAC_DBG(args...)	printf("\nlipp6300eth: " args)
#define GMAC_DBGOUT(fmt,args...) printf(fmt ,##args)
#else
#define GMAC_DBG(args...)
#define GMAC_DBGOUT()
#endif


#define __LIPP_6300ETH__ /* Defined inside PHY code */

/* Macros for PHY driver */
#define mdelay(n)   udelay((n)*1000)

#endif /* __LIPP_6300ETH_COMMON_H__ */


/* Usage instructions

;For choosing smsc 8700 ethernet phy, run the below config & compile

make tv55x_smsc8700_config
make 

;For choosing National semiconductor PHY DP83848 PHY, run the below config 

make tv55x_dp83848_config
make 

;For choosing smsc 8710 ethernet phy, run the below config & compile
make tv55x_smsc8710_config
make 

*/

