/*
 * Copyright (c) 1999-2003 Petko Manolov (petkan@users.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#include <common.h>
#include <command.h>

#ifdef CONFIG_CMD_NET

#include <usb.h>
#include <net.h>
#include <linux/mii.h>
#include <miiphy.h>

//#include "usb_ehci.h"			/* `struct urb_priv_t' */
#include "usb_net.h"
#include "pegasus.h"

/* these are usb endpoints for urb transfer */
#define	PEGASUS_CTRL_ENDPOINT		(0)
#define	PEGASUS_BULK_IN_ENDPOINT	(1)
#define	PEGASUS_BULK_OUT_ENDPOINT	(2)
#define	PEGASUS_INTR_IN_ENDPOINT	(3)

/* these timeouts are in fact dummies _but_ the usb layer interprets them nonetheless! */
#define	PEGASUS_CTRL_URB_TIMEOUT	(1)
#define	PEGASUS_BULK_URB_TIMEOUT	(1)

/* move these defines to a headerfile somewhere,
 * "far.. far away.." */
#define MCS_RD_BMREQ				(0xc0)
#define MCS_WR_BMREQ				(0x40)
#define MCS_RD_BREQ					(0x0e)
#define MCS_WR_BREQ					(0x0d)

#define DEVICE_REV_B				(0x0100)
#define DEVICE_REV_C				(0x0200)

/* mii defines */
#define	MII_DATA_REGISTER_LO		(HIF_REG_11)
#define	MII_DATA_REGISTER_HI		(HIF_REG_12)
#define	MII_OPCODE_REGISTER			(HIF_REG_13)
#define	MII_CONTROL_REGISTER		(HIF_REG_14)

#define	MII_COMMAND_WRITE			(0x01)
#define	MII_COMMAND_READ			(0x02)

#define	MII_CONTROL_READY			(1 << 6)
#define	MII_CONTROL_PENDING			(1 << 7)

#define	MII_PHY_CONTROL_REG			(0)
#define	MII_CONTROL_RESET			(1 << 15)
#define	MII_CONTROL_LOOPBACK		(1 << 14)
#define	MII_CONTROL_10				(0 << 13) | (0 << 6)
#define	MII_CONTROL_100				(0 << 13) | (1 << 6)
#define	MII_CONTROL_ANG_EN			(1 << 12)
#define	MII_CONTROL_POWERDOWN		(1 << 11)
#define	MII_CONTROL_ISOLATE			(1 << 10)
#define	MII_CONTROL_ANG_RESTART		(1 << 9)
#define	MII_CONTROL_FULL_DUPLEX		(1 << 8)
#define	MII_CONTROL_HALF_DUPLEX		(0 << 8)
#define	MII_CONTROL_COLLISION_TEST	(1 << 7)
#define	MII_CONTROL_RESERVED		(1 << 5) | (1 << 4) | (1 << 3) | (1 << 2) | (1 << 1) | (1 << 0)

#define	MII_PHY_STATUS_REG			(1)
#define	MII_STATUS_ANG_COMPLETE		(1 << 5)

/* timeout for restarting ang */
#define	ANG_RETRY					(100)	/* poll completion this many times */
#define	ANG_RETRY_DELAY				(10)	/* wait this many milliseconds between each poll */

/* err, info, dbg, TRACE defines */
#undef	DEBUG
#undef	SHOW_INFO
#undef	SHOW_DBG
#undef	SHOW_TRACE

/* some handy macros for printing errors, tracing function calls
 * showing info.. */
#ifdef	DEBUG
	#define err(format, arg...) 					\
		do {							\
			printf(						\
				"ERROR: %s;%s(%d): " format "\n",	\
                                __FILE__, __FUNCTION__, __LINE__,       \
                                ## arg);                                \
                } while (0)
#else   /* ! DEBUG */
        #define err(format, arg...) printf("ERROR: " format "\n", ## arg)
#endif  /* DEBUG */

#ifdef SHOW_INFO
	#ifdef DEBUG
		#define info(format, arg...) 					\
			do {							\
				printf(						\
					"INFO: %s;%s(%d): " format "\n", 	\
					__FILE__, __FUNCTION__, __LINE__, 	\
					## arg);				\
			} while (0)
	#else	/* ! DEBUG */
		#define info(format, arg...) 			\
			do {					\
				printf(				\
					"INFO: " format "\n", 	\
					## arg);		\
			} while (0)
	#endif	/* DEBUG */
#else	/* ! SHOW_INFO */
	#define info(format, arg...) do {} while(0)
#endif /* SHOW_INFO */

#ifdef	SHOW_TRACE
	#ifdef	DEBUG
		#define	trace(format, arg...)					\
			do {							\
				printf(						\
					"TRACE: %s;%s(%d): " format "\n", 	\
					__FILE__, __FUNCTION__, __LINE__, 	\
					## arg);				\
			} while (0)
	#else	/* ! DEBUG */
		#define trace(format, arg...) 			\
			do {					\
				printf(				\
					"TRACE: " format "\n", 	\
					## arg);		\
			} while (0)
	#endif	/* DEBUG */
#else	/* ! SHOW_TRACE */
	#define trace(format, arg...) do {} while(0)
#endif	/* SHOW_TRACE */

#define	PER_USB_ETH_STATUS_LEN		(8)
#define	RX_USB_ETH_RX_PACKET_LEN	(64)
#define	RX_ETH_PACKET_LEN		(1518)

#define	RX_ENABLED	(1 << 0)
#define	TX_ENABLED	(1 << 1)

/* our administration */
extern struct pegasus	g_usb_eth;	/* could be an array */

//typedef enum per_state {
//	per_not_submitted = 0,
//	per_resubmit = 1,
//	per_stop = 2
//} per_state_t;

/* periodically updated with usb eth status */
//volatile unsigned int	g_per_usb_eth_status[PER_USB_ETH_STATUS_LEN] __attribute((aligned(CONFIG_SYS_CACHELINE_SIZE)));
//volatile per_state_t	g_per_usb_eth_state;

/* intermediate usb eth packet storage */
//volatile unsigned char	g_rx_usb_eth_packet[RX_USB_ETH_RX_PACKET_LEN] __attribute((aligned(CONFIG_SYS_CACHELINE_SIZE)));

/* eth packet is built here */
//volatile unsigned char	g_rx_eth_packet[RX_ETH_PACKET_LEN] __attribute((aligned(CONFIG_SYS_CACHELINE_SIZE)));
//volatile int		g_rx_eth_packet_offs;
//volatile char		g_rx_eth_packet_available;

// #define	USB_ETH_DEV_MAX	(1)

//static int g_usb_net_total_devs = 0;	/* number of highest available usb device */


/* forward declarations */
int mcs7830_read_register(pegasus_t* pegasus, __u16 indx, __u16 size, void* data);
int mcs7830_write_register(pegasus_t* pegasus, __u16 indx, __u16 size, __u8* data);

#if     defined (SHOW_INFO)
static void maybe_print_receiver_status(char rcv_status);
#endif  /* defined (SHOW_INFO) */


int
mcs7830_read_register(
	pegasus_t*	pegasus,
	__u16		indx,
	__u16		size,
	void*		data) {

	int	ret;
	int	wValue = 0x0000;
	int	wIndex = indx;
	int	wLength = size;

	trace("pegasus=0x%p, indx=%d, size=%d, data=0x%p",
		(void*)pegasus, indx, size, (void*)data);

	/* u-boot usb implementation does not support urbs like linux does,
	 * so use the u-boot usb stack for submitting control messages */
	ret = usb_control_msg(
		pegasus->usb,
		usb_rcvctrlpipe(
			pegasus->usb,
			PEGASUS_CTRL_ENDPOINT),
		MCS_RD_BREQ,
		MCS_RD_BMREQ,
		wValue,
		wIndex,
		data,
		wLength,
		PEGASUS_CTRL_URB_TIMEOUT);
	if (wLength != ret)
		trace("only %d of %d bytes sent", ret, size);
	trace("ret=%d", ret);
	return (0 > ret ? ret : 0);
}


int
mcs7830_write_register(
	pegasus_t*	pegasus,
	__u16		indx,
	__u16		size,
	__u8*		data) {

	int	ret;
	int	wValue = 0x0000;
	int	wIndex = indx;
	int	wLength = size;

	trace("pegasus=0x%p, indx=%d, size=%d, data=0x%p",
		(void*)pegasus, indx, size, (void*)data);

	/* u-boot usb implementation does not support urbs like linux does,
	 * so use the u-boot usb stack for submitting control messages */
	ret = usb_control_msg(
		pegasus->usb,
		usb_sndctrlpipe(
			pegasus->usb,
			PEGASUS_CTRL_ENDPOINT),
		MCS_WR_BREQ,
		MCS_WR_BMREQ,
		wValue,
		wIndex,
		data,
		wLength,
		PEGASUS_CTRL_URB_TIMEOUT);
	if (wLength != ret)
		err("only %d of %d bytes sent", ret, size);
	trace("ret=%d", ret);
	return (0 > ret ? ret : 0);
}

int
mcs7830_miiphy_read(
	char *devname,
	unsigned char addr,
	unsigned char reg,
	unsigned short *value) {

#if	(FIXME)
	int	ret;
	char	mii_opcode;
	char	mii_control;
	char	mii_data_lo;
	char	mii_data_hi;
	int	retry;
#endif	/* FIXME */

	trace("%s; addr=0x%02x, reg=0x%02x\n", addr, reg);

	if (addr != FARADAY_PHY_ADDRESS)
		return (-1);

	return ReadPhyRegisterPassive(
		&g_usb_eth,
		reg,
		(__u16*)value);

#if	(FIXME)
	mii_opcode = MII_COMMAND_READ | (addr & 0x1f);
	ret = mcs7830_write_register(
		&g_usb_eth,	/* not very tidy is it? */
		MII_OPCODE_REGISTER,
		sizeof(mii_opcode),
		(void*)&mii_opcode);
	if (0 > ret)
		err("error %d writing mii opcode 0x%02x", ret, mii_opcode);

	mii_control = MII_CONTROL_PENDING | (reg & 0x1f);
	ret = mcs7830_write_register(
		&g_usb_eth,	/* not very tidy is it? */
		MII_CONTROL_REGISTER,
		sizeof(mii_control),
		(void*)&mii_control);
	if (0 > ret)
		err("error %d writing mii control 0x%02x", ret, mii_control);

	for (retry = 10; 0 > retry; --retry) {
		ret = mcs7830_read_register(
			&g_usb_eth,	/* not very tidy is it? */
			MII_CONTROL_REGISTER,
			sizeof(mii_control),
			(void*)&mii_control);
		if (mii_control & MII_CONTROL_READY)
			break;
	}
	if (0 == retry)
		err("error %d, mii retry count expired");

	ret = mcs7830_read_register(
		&g_usb_eth,	/* not very tidy is it? */
		MII_DATA_REGISTER_LO,
		sizeof(mii_data_lo),
		(void*)&mii_data_lo);
	if (0 > ret)
		err("error %d reading mii data lo nibble", ret);

	ret = mcs7830_read_register(
		&g_usb_eth,	/* not very tidy is it? */
		MII_DATA_REGISTER_HI,
		sizeof(mii_data_hi),
		(void*)&mii_data_hi);
	if (0 > ret)
		err("error %d reading mii data hi nibble", ret);

	*value = mii_data_lo | (mii_data_hi << 8);
	return (ret);
#endif	/* FIXME */
}

int
mcs7830_miiphy_write(
	char *devname,
	unsigned char addr,
	unsigned char reg,
	unsigned short value) {

#if	(FIXME)
	int	ret;
	char	mii_opcode;
	char	mii_control;
	char	mii_data_lo;
	char	mii_data_hi;
	int	retry;
#endif	/* FIXME */

	trace("addr=0x%02x, reg=0x%02x, value=0x%04x\n", addr, reg, value);

	if (addr != FARADAY_PHY_ADDRESS)
		return (-1);

	return WritePhyRegisterPassive(
		&g_usb_eth,
		reg,
		(__u16*)&value);

#if	(FIXME)
	mii_data_lo = value & 0x00ff;
	mii_data_hi = value >> 8;

	ret = mcs7830_write_register(
		&g_usb_eth,	/* not very tidy is it? */
		MII_DATA_REGISTER_LO,
		sizeof(mii_data_lo),
		(void*)&mii_data_lo);
	if (0 > ret)
		err("error %d writing mii data lo nibble", ret);

	ret = mcs7830_write_register(
		&g_usb_eth,	/* not very tidy is it? */
		MII_DATA_REGISTER_HI,
		sizeof(mii_data_hi),
		(void*)&mii_data_hi);
	if (0 > ret)
		err("error %d writing mii data hi nibble", ret);

	mii_opcode = MII_COMMAND_WRITE | (addr & 0x1f);
	ret = mcs7830_write_register(
		&g_usb_eth,	/* not very tidy is it? */
		MII_OPCODE_REGISTER,
		sizeof(mii_opcode),
		(void*)&mii_opcode);
	if (0 > ret)
		err("error %d writing mii opcode 0x%02x", ret, mii_opcode);

	mii_control = MII_CONTROL_PENDING | (reg & 0x1f);
	ret = mcs7830_write_register(
		&g_usb_eth,	/* not very tidy is it? */
		MII_CONTROL_REGISTER,
		sizeof(mii_control),
		(void*)&mii_control);
	if (0 > ret)
		err("error %d writing mii control 0x%02x", ret, mii_control);

	for (retry = 10; 0 > retry; --retry) {
		ret = mcs7830_read_register(
			&g_usb_eth,	/* not very tidy is it? */
			MII_CONTROL_REGISTER,
			sizeof(mii_control),
			(void*)&mii_control);
		if (mii_control & MII_CONTROL_READY)
			break;
	}
	if (0 == retry)
		err("error %d, mii retry count expired");

	return (ret);
#endif	/* FIXME */
}

#endif  /* (CONFIG_COMMANDS & CFG_CMD_NET) &&
	 * defined(CONFIG_PEGASUS) &&
	 * defined(CONFIG_USB_OHCI_NEW) */
