/*
 * Copyright (c) 1999-2003 Petko Manolov - Petkan (petkan@users.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 */


#ifndef	PEGASUS_DEV

#define	PEGASUS_II			0x80000000
#define	HAS_HOME_PNA		0x40000000

#define	EPROM_WRITE			0x01
#define	EPROM_READ			0x02
#define	EPROM_DONE			0x04
#define	EPROM_WR_ENABLE		0x10
#define	EPROM_LOAD			0x20

#define	PHY_DONE			0x80
#define	PHY_READ			0x40
#define	PHY_WRITE			0x20
#define	DEFAULT_GPIO_RESET	0x24
#define	LINKSYS_GPIO_RESET	0x24
#define	DEFAULT_GPIO_SET	0x26

#define	PEGASUS_PRESENT		0x00000001
#define	PEGASUS_RUNNING		0x00000002
#define	PEGASUS_TX_BUSY		0x00000004
#define	PEGASUS_RX_BUSY		0x00000008
#define	CTRL_URB_RUNNING	0x00000010
#define	CTRL_URB_SLEEP		0x00000020
#define	PEGASUS_UNPLUG		0x00000040
#define	PEGASUS_RX_URB_FAIL	0x00000080
#define	ETH_REGS_CHANGE		0x40000000
#define	ETH_REGS_CHANGED	0x80000000

#define	RX_MULTICAST		2
#define	RX_PROMISCUOUS		4

#define	REG_TIMEOUT			(HZ)
#define	PEGASUS_TX_TIMEOUT	(HZ*10)

#define	TX_UNDERRUN			0x80
#define	EXCESSIVE_COL		0x40
#define	LATE_COL			0x20
#define	NO_CARRIER			0x10
#define	LOSS_CARRIER		0x08
#define	JABBER_TIMEOUT		0x04

#define	LINK_STATUS			0x01

#define	PEGASUS_REQT_READ	0xc0
#define	PEGASUS_REQT_WRITE	0x40
#define	PEGASUS_REQ_GET_REGS	0xf0
#define	PEGASUS_REQ_SET_REGS	0xf1
#define	PEGASUS_REQ_SET_REG	PEGASUS_REQ_SET_REGS

enum pegasus_registers {
	EthCtrl0 = 0,
	EthCtrl1 = 1,
	EthCtrl2 = 2,
	EthID = 0x10,
	Reg1d = 0x1d,
	EpromOffset = 0x20,
	EpromData = 0x21,	/* 0x21 low, 0x22 high byte */
	EpromCtrl = 0x23,
	PhyAddr = 0x25,
	PhyData = 0x26, 	/* 0x26 low, 0x27 high byte */
	PhyCtrl = 0x28,
	UsbStst = 0x2a,
	EthTxStat0 = 0x2b,
	EthTxStat1 = 0x2c,
	EthRxStat = 0x2d,
	WakeupControl = 0x78,
	Reg7b = 0x7b,
	Gpio0 = 0x7e,
	Gpio1 = 0x7f,
	Reg81 = 0x81,
};

/* taken from `include/linux/mod_devicetable.h', linux 2.6.10 */
#define USB_DEVICE_ID_MATCH_VENDOR		0x0001
#define USB_DEVICE_ID_MATCH_PRODUCT		0x0002
/* taken from `include/linux/usb.h', linux 2.6.10 */
#define USB_DEVICE_ID_MATCH_DEVICE		(USB_DEVICE_ID_MATCH_VENDOR | USB_DEVICE_ID_MATCH_PRODUCT)

#if	(CODE_GLORIFICATION)
typedef enum mcs7830_hif_reg {
	hif_reg_01 = 0x00,
	hif_reg_02 = 0x01,
	hif_reg_03 = 0x02,
	hif_reg_04 = 0x03,
	hif_reg_05 = 0x04,
	hif_reg_06 = 0x05,
	hif_reg_07 = 0x06,
	hif_reg_08 = 0x07,
	hif_reg_09 = 0x08,
	hif_reg_10 = 0x09,
	hif_reg_11 = 0x0a,
	hif_reg_12 = 0x0b,
	hif_reg_13 = 0x0c,
	hif_reg_14 = 0x0d,
	hif_reg_15 = 0x0e,
	hif_reg_16 = 0x0f,
	hif_reg_17 = 0x10,
	hif_reg_18 = 0x11,
	hif_reg_19 = 0x12,
	hif_reg_20 = 0x13,
	hif_reg_21 = 0x14,
	hif_reg_22 = 0x15,
	hif_reg_23 = 0x16,
	hif_reg_24 = 0x17
} mcs7830_regs_t;

typedef enum mcs7830_hif_reg_15_flags {
	
} mcs7830_hif_reg_15_flags_t;
#endif	/* CODE_GLORIFICATION */

#define	HIF_REG_01	((__u16)(0x00))
#define	HIF_REG_02	((__u16)(0x01))
#define	HIF_REG_03	((__u16)(0x02))
#define	HIF_REG_04	((__u16)(0x03))
#define	HIF_REG_05	((__u16)(0x04))
#define	HIF_REG_06	((__u16)(0x05))
#define	HIF_REG_07	((__u16)(0x06))
#define	HIF_REG_08	((__u16)(0x07))
#define	HIF_REG_09	((__u16)(0x08))
#define	HIF_REG_10	((__u16)(0x09))
#define	HIF_REG_11	((__u16)(0x0A))
#define	HIF_REG_12	((__u16)(0x0B))
#define	HIF_REG_13	((__u16)(0x0C))
#define	HIF_REG_14	((__u16)(0x0D))
#define	HIF_REG_15	((__u16)(0x0E))
#define	HIF_REG_16	((__u16)(0x0F))
#define	HIF_REG_17	((__u16)(0x10))
#define	HIF_REG_18	((__u16)(0x11))
#define	HIF_REG_19	((__u16)(0x12))
#define	HIF_REG_20	((__u16)(0x13))
#define	HIF_REG_21	((__u16)(0x14))
#define	HIF_REG_22	((__u16)(0x15))
#define	HIF_REG_23	((__u16)(0x16))
#define	HIF_REG_24	((__u16)(0x17))

#define	FARADAY_PHY_ADDRESS	(0x01)
#define	READ_OPCODE		(0x40)
#define	WRITE_OPCODE		(0x20)

#define	HIF_REG_14_PEND_FLAG_BIT	(0x80)
#define	HIF_REG_14_READY_FLAG_BIT	(0x40)

#define	HIF_REG_15_PROMISCIOUS		(0x01)
#define	HIF_REG_15_ALLMULTICAST		(0x02)
#define	HIF_REG_15_SLEEPMODE		(0x04)
#define	HIF_REG_15_TXENABLE		(0x08)
#define	HIF_REG_15_RXENABLE		(0x10)
#define	HIF_REG_15_FULLDUPLEX_ENABLE	(0x20)
#define	HIF_REG_15_SPEED100		(0x40)
#define	HIF_REG_15_CFG			(0x80)

#define	PHY_CONTROL_REG_INDEX		(00)
#define	PHY_STATUS_REG_INDEX		(01)
#define	PHY_IDENTIFICATION1_REG_INDEX	(02)
#define	PHY_IDENTIFICATION2_REG_INDEX	(03)
#define	PHY_AUTONEGADVT_REG_INDEX	(04)
#define	PHY_AUTONEGLINK_REG_INDEX	(05)
#define	PHY_AUTONEGEXP_REG_INDEX	(06)
#define	PHY_MIRROR_REG_INDEX		(16)
#define	PHY_INTERRUPTENABLE_REG_INDEX	(17)
#define	PHY_INTERRUPTSTATUS_REG_INDEX	(18)
#define	PHY_CONFIG_REG_INDEX		(19)
#define	PHY_CHIPSTATUS_REG_INDEX	(20)

#define	PHY_AUTONEGADVT_FdxPause	(0x0400)
#define	PHY_AUTONEGADVT_100T4		(0x0200)
#define	PHY_AUTONEGADVT_Fdx100TX	(0x0100)
#define	PHY_AUTONEGADVT_100TX		(0x0080)
#define	PHY_AUTONEGADVT_10TFdx		(0x0040)
#define	PHY_AUTONEGADVT_10T		(0x0020)
#define	PHY_AUTONEGADVT_ieee802_3	(0x0001)

#define	PHY_CONTROL_LOOPBACK		(0x4000)
#define	PHY_CONTROL_SPEED100		(0x2000)
#define	PHY_CONTROL_AUTONEG_ENABLE	(0x1000)
#define	PHY_CONTROL_RESTART_AUTONEG	(0x0200)
#define	PHY_CONTROL_FULLDUPLEX		(0x0100)
#define	PHY_CONTROL_SPEED10		(0x0000)
#define	PHY_CONTROL_HALFDUPLEX		(0x0000)

#define	PTR_FPGA_VERSION		(0)
#define	PTR_PAUSE_THRESHOLD		(0)

#define	ETHERNET_ADDRESS_LENGTH	(6)




#else	/* PEGASUS_DEV */


#endif	/* PEGASUS_DEV */
