/*
 * (C) Copyright 2008, Excito Elektronik i Sk=E5ne AB
 *
 * Author: Tor Krill tor@excito.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <pci.h>
#include <usb.h>
//#include <mpc83xx.h>
#include <asm/io.h>
#include <asm/bitops.h>
#include <asm/addrspace.h>

#include "usb_ehci.h"
#include "usb_ehci_fsl.h"
#include "usb_ehci_core.h"

/*
 * Create the appropriate control structures to manage
 * a new EHCI host controller.
 *
 * Excerpts from linux ehci fsl driver.
 */
 
static volatile int test = 100;
static volatile int *ptest = &test;

int ehci_hcd_init(void)
{
	//volatile immap_t *im = (immap_t *)CONFIG_SYS_IMMR;
	uint32_t addr, temp;
	uint32_t reg;
	uint32_t i;
	uint32_t j;

	//addr = (uint32_t)&(im->usb[0]);
	hccr = (struct ehci_hccr *)(CONFIG_SYS_USB_EHCI_REGS_BASE + 0x100);
	hcor = (struct ehci_hcor *)((uint32_t) hccr + HC_LENGTH(ehci_readl(&hccr->cr_capbase)));

	printf("hcor: %p\n", hcor);

	i = ehci_readl(&hcor->or_usbcmd);
	i = i & 0xfffffffc;
	/* stop USB transactions */
	ehci_writel (&hcor->or_usbcmd, i);
	j = 100;
	while (!(ehci_readl(&hcor->or_usbsts) & STS_HALT) && j) {
		j--;
		udelay (100);
	}
	if (j) {
		/* USB ctrl halted, now perform reset command */
		ehci_writel(&hcor->or_usbcmd, i | CMD_RESET);
		while ((ehci_readl(&hcor->or_usbcmd) & CMD_RESET) && j) {
			j--;
			udelay (100);
		}
		if (!j) {
			puts("USB controller stays in reset\n");
		}
	}

#define PNX8XXX_USB_IP9028_USB_MODE_HOST        0x00000003
#define PNX8XXX_USB_IP9028_USB_MODE_OFFSET      0x1A8

	/* put USB OTG block into HOST mode */
	ehci_writel((CONFIG_SYS_USB_EHCI_REGS_BASE + PNX8XXX_USB_IP9028_USB_MODE_OFFSET), PNX8XXX_USB_IP9028_USB_MODE_HOST);

	return 0;
}

/*
 * Destroy the appropriate control structures corresponding
 * the the EHCI host controller.
 */
int ehci_hcd_stop(void)
{
	return 0;
}
