/*
 * (C) Copyright 2003
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 * (C) Copyright 2006
 * NXP Semiconductors,
 * Robert Delien robert.delien@nxp.com, Hans Zuidam hans.zuidam@nxp.com
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * This file contains the configuration parameters for the NXP
 * TV52x, which is a TV520 series based platform
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#define CONFIG_TV52X
//#define DEBUG

#include <pnx8550_glb.h>

/* PNX853x have a 4KEc MIPS32 core */
#define CONFIG_MIPS32                   /* MIPS32 CPU core */

/* 
 *  Specify whether or not u-boot needs to relocate 
 */
#define  CONFIG_SKIP_RELOCATE_UBOOT

/* 
 *  Allow the allocatable memory to be located anyware in memory not 
 *  just below the u-boot text base
 */
//#define CONFIG_SYS_MALLOC_BASE      0x88000000
//128MB - 4MB 
//#define CONFIG_SYS_MALLOC_BASE      (0x88000000 - 0x400000)

#define CONFIG_SYS_MTD_PARTITION_EXTERNAL

/*-----------------------------------------------------------------------
 * Timing related configuration
 */
#define CONFIG_SYS_MIPS_TIMER_FREQ  360000000
#define CONFIG_SYS_HZ               1000
#define CONFIG_CP0_COUNT_RATE       (CONFIG_SYS_MIPS_TIMER_FREQ/2)   /* Half the CPU core frequency */
/* TSU clock */
#define CONFIG_TSU_CLOCK            13500000    /* 13.5Mhz */

/*-----------------------------------------------------------------------
 * Default environment variables
 */
#define CONFIG_BOOTCOMMAND          ""
#define CONFIG_BOOTDELAY            5               /* autoboot after 5 seconds */
#define CONFIG_BAUDRATE             115200
#define CONFIG_BOOTFILE             /vmlinux        /* File to boot */
#define CONFIG_SYS_LOAD_ADDR        0x82000000      /* SDRAM address to load files to */


#define CONFIG_TIMESTAMP        /* Print image info with timestamp */
#undef  CONFIG_BOOTARGS

#define CONFIG_EXTRA_ENV_SETTINGS                   \
    "addmisc=setenv bootargs $(bootargs) "              \
        "console=ttyS0,$(baudrate) "                \
        "panic=1\0"                     \
    ""


/* Pre default no features are enabaled */
#undef  CONFIG_CMD_ASKENV       /* ask for env variable         */
#undef  CONFIG_CMD_AUTOSCRIPT   /* Autoscript Support           */
#undef  CONFIG_CMD_BDI          /* bdinfo                       */
#undef  CONFIG_CMD_BEDBUG       /* Include BedBug Debugger      */
#undef  CONFIG_CMD_BMP          /* BMP support                  */
#undef  CONFIG_CMD_BOOTD        /* bootd                        */
#undef  CONFIG_CMD_BSP          /* Board Specific functions     */
#undef  CONFIG_CMD_CACHE	    /* icache, dcache		        */
#undef  CONFIG_CMD_CDP          /* Cisco Discovery Protocol     */
#undef  CONFIG_CMD_CONSOLE      /* coninfo                      */
#undef  CONFIG_CMD_DATE		    /* support for RTC, date/time...*/
#undef  CONFIG_CMD_DHCP         /* DHCP Support                 */
#undef  CONFIG_CMD_DIAG         /* Diagnostics                  */
#undef  CONFIG_CMD_DISPLAY      /* Display support              */
#undef  CONFIG_CMD_DOC          /* Disk-On-Chip Support         */
#undef  CONFIG_CMD_DTT          /* Digital Therm and Thermostat */
#undef  CONFIG_CMD_ECHO         /* echo arguments               */
#undef  CONFIG_CMD_EEPROM       /* EEPROM read/write support    */
#undef  CONFIG_CMD_ELF          /* ELF (VxWorks) load/boot cmd  */
#undef  CONFIG_CMD_ENV          /* saveenv                      */
#undef  CONFIG_CMD_EXT2         /* EXT2 Support                 */
#undef  CONFIG_CMD_FAT          /* FAT support                  */
#undef  CONFIG_CMD_FDC          /* Floppy Disk Support          */
#undef  CONFIG_CMD_FDOS         /* Floppy DOS support           */
#undef  CONFIG_CMD_FLASH        /* flinfo, erase, protect       */
#undef  CONFIG_CMD_FPGA         /* FPGA configuration Support   */
#undef  CONFIG_CMD_HWFLOW       /* RTS/CTS hw flow control      */
#undef  CONFIG_CMD_I2C          /* I2C serial bus support       */
#undef  CONFIG_CMD_IDE          /* IDE harddisk support         */
#undef  CONFIG_CMD_IMI          /* iminfo                       */
#undef  CONFIG_CMD_IMLS         /* List all found images        */
#undef  CONFIG_CMD_IMMAP        /* IMMR dump support            */
#undef  CONFIG_CMD_IRQ          /* irqinfo                      */
#undef  CONFIG_CMD_ITEST        /* Integer (and string) test    */
#undef  CONFIG_CMD_JFFS2        /* JFFS2 Support                */
#undef  CONFIG_CMD_KGDB         /* kgdb                         */
#undef  CONFIG_CMD_LOADB        /* loadb                        */
#undef  CONFIG_CMD_LOADS        /* loads                        */
#undef  CONFIG_CMD_MEMORY       /* md mm nm mw cp cmp crc base loop mtest */
#undef  CONFIG_CMD_MFSL         /* FSL support for Microblaze   */
#undef  CONFIG_CMD_MII          /* MII support                  */
#undef  CONFIG_CMD_MISC         /* Misc functions like sleep etc*/
#undef  CONFIG_CMD_MMC          /* MMC support                  */
#undef  CONFIG_CMD_MTDPARTS     /* Partition support            */
#undef  CONFIG_CMD_NAND         /* NAND support                 */
#undef  CONFIG_CMD_NET          /* bootp, tftpboot, rarpboot    */
#undef  CONFIG_CMD_NFS          /* NFS support                  */
#undef  CONFIG_CMD_ONENAND      /* OneNAND support              */
#undef  CONFIG_CMD_PCI          /* pciinfo                      */
#undef  CONFIG_CMD_PCMCIA       /* PCMCIA support               */
#undef  CONFIG_CMD_PING         /* ping support                 */
#undef  CONFIG_CMD_PORTIO       /* Port I/O                     */
#undef  CONFIG_CMD_REGINFO      /* Register dump                */
#undef  CONFIG_CMD_REISER       /* Reiserfs support             */
#undef  CONFIG_CMD_RUN          /* run command in env variable  */
#undef  CONFIG_CMD_SARI         /* Simple arithmetic operations */
#undef  CONFIG_CMD_SAVES        /* save S record dump           */
#undef  CONFIG_CMD_SCSI         /* SCSI Support                 */
#undef  CONFIG_CMD_SDRAM        /* SDRAM DIMM SPD info printout */
#undef  CONFIG_CMD_SETGETDCR    /* DCR support on 4xx           */
#undef  CONFIG_CMD_SNTP         /* SNTP support                 */
#undef  CONFIG_CMD_SPI          /* SPI utility                  */
#undef  CONFIG_CMD_TERMINAL     /* built-in Serial Terminal     */
#undef  CONFIG_CMD_UNIVERSE     /* Tundra Universe Support      */
#undef  CONFIG_CMD_UBI          /* UBI support                  */
#undef  CONFIG_CMD_UBIFS        /* UBI support                  */
#undef  CONFIG_CMD_USB          /* USB Support                  */
#undef  CONFIG_CMD_VFD          /* VFD support (TRAB)           */
#undef  CONFIG_CMD_XIMG         /* Load part of Multi Image     */
#undef  CONFIG_CMD_AT91_SPIMUX  /* AT91 MMC/SPI Mux Support     */

/*
 * Define the commands supported
 */
#if defined(CONFIG_TV52X_SMALL)
    #define CONFIG_CMD_ECHO         /* echo arguments               */
    #define CONFIG_CMD_ENV          /* saveenv                      */
    #define CONFIG_CMD_FAT          /* FAT support                  */
    #define CONFIG_CMD_I2C          /* I2C serial bus support       */
    #define CONFIG_CMD_MEMORY       /* md mm nm mw cp cmp crc base loop mtest */
    #define CONFIG_CMD_MISC         /* Misc functions like sleep etc*/
    #define CONFIG_CMD_MTDPARTS     /* Partition support            */
    #define CONFIG_CMD_NAND         /* NAND support                 */
    #define CONFIG_CMD_PCI          /* pciinfo                      */
    #define CONFIG_CMD_PORTIO       /* Port I/O                     */
    #define CONFIG_CMD_RUN          /* run command in env variable  */
    #define CONFIG_CMD_SARI         /* Simple arithmetic operations */
    #define CONFIG_CMD_UBI          /* UBI support                  */
#else
    #define CONFIG_CMD_AUTOSCRIPT   /* Autoscript Support           */
    #define CONFIG_CMD_DHCP         /* DHCP Support                 */
    #define CONFIG_CMD_ECHO         /* echo arguments               */
    #define CONFIG_CMD_ENV          /* saveenv                      */
    #define CONFIG_CMD_FAT          /* FAT support                  */
    #define CONFIG_CMD_I2C          /* I2C serial bus support       */
    #define CONFIG_CMD_JFFS2        /* JFFS2 Support                */
    #define CONFIG_CMD_LOADB        /* loadb                        */
    #define CONFIG_CMD_MEMORY       /* md mm nm mw cp cmp crc base loop mtest */
    #define CONFIG_CMD_MII          /* MII support                  */
    #define CONFIG_CMD_MISC         /* Misc functions like sleep etc*/
    #define CONFIG_CMD_MTDPARTS     /* Partition support            */
    #define CONFIG_CMD_NAND         /* NAND support                 */
    #define CONFIG_CMD_NET          /* bootp, tftpboot, rarpboot    */
    #define CONFIG_CMD_NFS          /* NFS support                  */
    #define CONFIG_CMD_PCI          /* pciinfo                      */
    #define CONFIG_CMD_PING         /* ping support                 */
    #define CONFIG_CMD_PORTIO       /* Port I/O                     */
    #define CONFIG_CMD_RUN          /* run command in env variable  */
    #define CONFIG_CMD_SARI         /* Simple arithmetic operations */
    #define CONFIG_CMD_UBI          /* UBI support                  */
    #undef  CONFIG_CMD_UBIFS        /* UBI support                  */
    #define CONFIG_CMD_USB          /* USB Support                  */
#endif

/*-----------------------------------------------------------------------
 * FAT filesystem support
 */

#define CONFIG_SUPPORT_VFAT

#define CONFIG_SYS_SCSI_MAX_SCSI_ID 4
#define CONFIG_SYS_SCSI_MAX_LUN     4


/*-----------------------------------------------------------------------
 * 
 * Ethernet suppotr
 *  Natsemi support
 *  USB ethernet dongle
 */
#ifdef CONFIG_CMD_NET

#define CONFIG_NATSEMI
/* needed for `eth_*' functions */
#define CONFIG_NET_MULTI
#define CONFIG_PEGASUS
#undef  CONFIG_MII
#define CONFIG_BOOTP_SUBNETMASK
#define CONFIG_BOOTP_GATEWAY
#define CONFIG_BOOTP_DNS

#endif
/*-----------------------------------------------------------------------
 * NOR flash configuration
 */
#define CONFIG_SYS_NO_FLASH
#undef  CONFIG_CRAMFS       /* No CRAM FS support although JFFS2 support */


/*-----------------------------------------------------------------------
 * NAND flash configuration
 */

#define CONFIG_SYS_FLASH_BASE           0        

#undef  CONFIG_NAND_LEGACY
#define CONFIG_NAND
#define CONFIG_NAND_NXP_IPA051
#define CONFIG_SYS_MAX_NAND_DEVICE      5       /* Max number of NAND devices       */

#define CONFIG_SYS_NAND_QUIET           1

/* 
 * Note: NAND_BASE refers to the xio profiles, in board_nand_init the correct base 
 *values are retreived from the xio profiles
 */
#define CONFIG_SYS_NAND_BASE            0x814, 0x818, 0x81C, 0x834, 0x838
#define CONFIG_MTD_NAND_VERIFY_WRITE
#define NAND_MAX_FLOORS                 1
#define NAND_MAX_CHIPS                  1
#define NAND_ChipID_UNKNOWN             0x00
#define SECTORSIZE                      512

#ifdef CONFIG_CMD_UBIFS
#define CONFIG_SYS_64BIT_VSPRINTF
#define CONFIG_LZO
#endif

#define CONFIG_MTD_UBI_DEBUG
#define CONFIG_MTD_UBI_DEBUG_MSG
#define CONFIG_MTD_UBI_DEBUG_MSG_IO

#ifdef CONFIG_CMD_UBI
#define CONFIG_MTD_PARTITIONS
#define CONFIG_RBTREE
#define CONFIG_DOS_PARTITION
#else
#undef  CONFIG_MTD_PARTITIONS
#undef  CONFIG_RBTREE
#endif

/* JFFS2 support */
#ifdef CONFIG_CMD_MTDPARTS
#define CONFIG_JFFS2_CMDLINE            1
#define CONFIG_JFFS2_DEV                "nand0"
#define CONFIG_JFFS2_NAND
#define MTDIDS_DEFAULT                  "nand0=sys"
#define MTDPARTS_DEFAULT                "mtdparts=sys:11232k@176k(bootfs);sys:4000k@11408k(rootfs)"
#endif

/*-----------------------------------------------------------------------
 * Miscellaneous configurable options
 */
#if !defined(CONFIG_TV52X_SMALL)
#define CONFIG_SYS_LONGHELP                         /* undef to save memory      */
#endif

#if defined(CONFIG_TV52X_SMALL)
#undef  CONFIG_AUTO_COMPLETE
#undef  CONFIG_MEM_CONSOLE
#endif

#define CONFIG_SYS_PROMPT               "TV543 # "  /* Monitor Command Prompt    */
#define CONFIG_SYS_CBSIZE               256         /* Console I/O Buffer Size   */
#define CONFIG_SYS_PBSIZE               (CONFIG_SYS_CBSIZE + sizeof(CONFIG_SYS_PROMPT) + 16)    /* Print Buffer Size */
#define CONFIG_SYS_MAXARGS              16          /* max number of command args*/

#define CONFIG_SYS_MALLOC_LEN           (512*1024)

#define CONFIG_SYS_BOOTPARAMS_LEN       (8*1024)

/* during mmio scan, invalid module ids could be encountered */
#define CFG_MMIO_WARN_INV_MODID_COUNT           /* ..just count and warn user */
#define CFG_MMIO_WARN_INV_MODID_RANGES          /* ..just display range and warn user */


#if !defined(CONFIG_TV52X_SMALL)
/* Upgrader configuration */
#define CONFIG_TV52X_UPGRADE
#define CONFIG_BOOTDELAY_UPGRADER 0
#endif

/*-----------------------------------------------------------------------
 * Memory Map
 */
#include <asm/addrspace.h>
#define CONFIG_SYS_INIT_SP_OFFSET       0x000D0000  /* Put initial stack at 512kiB  */
#define CONFIG_SYS_SDRAM_BASE           KSEG0ADDR(SDRAM_BASE)   /* Cached alias     */
#define CFG_SDRAM_MAX                   SDRAM_MAX       /* 128MiB       */

#define CONFIG_SYS_MEMTEST_START        (CONFIG_SYS_SDRAM_BASE)
#define CONFIG_SYS_MEMTEST_END          ((CONFIG_SYS_SDRAM_BASE)+(CONFIG_SYS_INIT_SP_OFFSET))

/*-----------------------------------------------------------------------
 * Serial port configuration
 */
#define CFG_IP0107_UART                             /* Has an IP0107 on SoC     */
#define CFG_IP0107_CLOCK                3692300     /* 3.6923 MHz           */
#ifndef CFG_CONSOLE_PORT
#define CFG_CONSOLE_PORT                IP0107_2    /* Use UART 2 for console   */
#endif
#define CONFIG_SYS_BAUDRATE_TABLE       { 50, 75, 110, 134.5, 150, 300, 600, 1200, 2400, \
                                        4800, 9600, 19200, 38400, 57600, 115200, 230400 }

/*-----------------------------------------------------------------------
 * Console configuration
 */
#define CONFIG_SYS_HUSH_PARSER                  /* Enable HUSH shell parser */
#define CONFIG_SYS_PROMPT_HUSH_PS2      "> "        /* Configure HUSH sec. prompt   */
#define CONFIG_CMDLINE_EDITING              /* Enable command line editing  */


/* The following #defines are needed to get flash environment right */
#define CONFIG_SYS_MONITOR_BASE     TEXT_BASE
#define CFG_MONITOR_LEN         (192 << 10) /* No more than 192KiB */


/*-----------------------------------------------------------------------
 * Environment configuration
 */
#if defined(CONFIG_CMD_NAND)
#undef  CONFIG_ENV_IS_NOWHERE
#define CONFIG_ENV_IS_IN_NAND
#define CONFIG_ENV_OFFSET       0x0003C000  /* Address of Environment Sector*/
#else
#define CONFIG_ENV_IS_NOWHERE
#endif
#define CONFIG_ENV_SIZE         0x00004000  /* Size of Environment Sector   */

/*-----------------------------------------------------------------------
 * Cache Configuration
 */
#define CONFIG_SYS_DCACHE_SIZE      16384
#define CONFIG_SYS_ICACHE_SIZE      16384
#define CONFIG_SYS_CACHELINE_SIZE   32

/*-----------------------------------------------------------------------
 * PCI Configuration
 */
#if !defined(CONFIG_TV52X_SMALL)
#define CONFIG_PCI
#undef  CONFIG_PCI_PNP
#endif
#define CONFIG_NXP_PCIXIO_IPA051 /*HZ*/

/*-----------------------------------------------------------------------
 * XIO Configuration
 */
#define CONFIG_XIO /*HZ*/


/*-----------------------------------------------------------------------
 * USB Configuration
 */
#if !defined(CONFIG_TV52X_SMALL)
// ip90.. is not a PCI device
#define CONFIG_EHCI_HCD_INIT_AFTER_RESET
#define CONFIG_USB_EHCI
#define CONFIG_USB_EHCI_NXP
#define CONFIG_SYS_USB_EHCI_MAX_ROOT_PORTS  8
#define CONFIG_SYS_IMMR             IP9028
#define CONFIG_SYS_USB_EHCI_REGS_BASE       IP9028
#define CONFIG_EHCI_DCACHE

#undef  CONFIG_PCI_OHCI
#undef  CONFIG_USB_OHCI_NEW
#define CONFIG_SYS_USB_OHCI_REGS_BASE       IP9028

#define LITTLEENDIAN                1

#define CFG_DEVICE_DEREGISTER
#define CFG_USB_EVENT_POLL
#define CONFIG_SYS_USB_OHCI_SLOT_NAME       "ohci_pci"
#define CONFIG_SYS_USB_OHCI_MAX_ROOT_PORTS  8

/* process single td's on done queue or process all td's from urb (up to
 * max number of defined td's) in the done queue at once */
#undef CFG_USB_OHCI_DQ_SINGLE_TD_PROCESSING

#define CONFIG_USB_STORAGE
#define CONFIG_DOS_PARTITION

#define CONFIG_USB_NETWORK

#endif


/*-----------------------------------------------------------------------
 * I2C Configuration
 */
#define CONFIG_NXP_I2C
#undef  CONFIG_NXP_I2C_IP0105
#define CONFIG_NXP_I2C_IP3203
#undef  CONFIG_HARD_I2C
#define CONFIG_SYS_I2C_SPEED            (150000)    /* 150kHz */
#define CONFIG_SYS_I2C_SLAVE            0
#define CONFIG_I2C_CMD_TREE
#define CONFIG_I2C_MULTI_BUS

#define CONFIG_SYS_I2C_EEPROM_ADDR_LEN      1
#define CFG_I2C_MULTI_EEPROMS


/*-----------------------------------------------------------------------
 * Stand-by processor Configuration
 */
#undef  CONFIG_MISC_INIT_R
#define CONFIG_STANDBY_SLAVE_BUS    0x03
#define CONFIG_STANDBY_SLAVE_ADDR   0x30

/*-----------------------------------------------------------------------
 * Secure boot configuration
 */
#define CONFIG_SECURE_BOOT
#ifdef CONFIG_SECURE_BOOT
#define CONFIG_USE_FAT_FS
#undef  CONFIG_USB_SHOW_PROGRESS
#else
#define CONFIG_USB_SHOW_PROGRESS
#endif

/* 
  * Misc
  */
 #define CONFIG_NUM_OF_SCRATCH_REGS     8

#endif  /* __CONFIG_H */
