#ifndef	_TM328X_H
#define	_TM328X_H


/*
 * Register offsets in TM32 MMIO space
 */
#define OFFS_TM32_MEM_EVENTS		0x000C
#define OFFS_TM32_DC_LOCK_CTL		0x0010
#define OFFS_TM32_DC_LOCK_ADDR		0x0014
#define OFFS_TM32_DC_LOCK_SIZE		0x0018
#define	OFFS_TM32_DC_PARAMS		0x001C
#define	OFFS_TM32_IC_PARAMS		0x0020

#define	OFFS_TM32_CTL			0x0030

#define	OFFS_TM32_DRAM_LO		0x0034
#define	OFFS_TM32_DRAM_HI		0x0038
#define	OFFS_TM32_DRAM_CLIMIT		0x003C
#define	OFFS_TM32_APERT1_LO		0x0040
#define	OFFS_TM32_APERT1_HI		0x0044

#define	OFFS_TM32_START_ADDR		0x0048
#define	OFFS_TM32_PC			0x004C
#define OFFS_TM32_RSE_CAUSE		0x0050
#define OFFS_TM32_RSE_PC		0x0054

#if defined(CONFIG_CPU_TM3271)
#define OFFS_TM32_RSE_OBSERVE0		0x0060
#define OFFS_TM32_RSE_OBSERVE1		0x0064
#define OFFS_TM32_RSE_OBSERVE2		0x0068
#define OFFS_TM32_RSE_OBSERVE3		0x006C
#define OFFS_TM32_RSE_OBSERVE4		0x0070
#define OFFS_TM32_RSE_OBSERVE5		0x0074
#define OFFS_TM32_RSE_OBSERVE6		0x0078
#define OFFS_TM32_RSE_OBSERVE7		0x007C
#endif /* CONFIG_CPU_TM3271 */

#define OFFS_TM32_POWER_DOWN		0x0108

#define OFFS_TM32_IC_LRU_UPDATE		0x0220
#define OFFS_TM32_IC_LOCK_CTL		0x0210
#define OFFS_TM32_IC_LOCK_ADDR		0x0214
#define OFFS_TM32_IC_LOCK_SIZE		0x0218

#define	OFFS_TM32_PF0_START_ADDR	0x0400
#define	OFFS_TM32_PF0_END_ADDR		0x0404
#define	OFFS_TM32_PF0_CTL		0x0408
#define	OFFS_TM32_PF1_START_ADDR	0x0410
#define	OFFS_TM32_PF1_END_ADDR		0x0414
#define	OFFS_TM32_PF1_CTL		0x0418
#define	OFFS_TM32_PF2_START_ADDR	0x0420
#define	OFFS_TM32_PF2_END_ADDR		0x0424
#define	OFFS_TM32_PF2_CTL		0x0428
#define	OFFS_TM32_PF3_START_ADDR	0x0430
#define	OFFS_TM32_PF3_END_ADDR		0x0434
#define	OFFS_TM32_PF3_CTL		0x0438

#define OFFS_TM32_SEM			0x0500

#define	OFFS_TM32_EXECVEC		0x0800
#define	OFFS_TM32_ISETTING0		0x0810
#define	OFFS_TM32_ISETTING1		0x0814
#define	OFFS_TM32_ISETTING2		0x0818
#define	OFFS_TM32_ISETTING3		0x081C
#define	OFFS_TM32_IPENDING		0x0820
#define	OFFS_TM32_ICLEAR		0x0824
#define	OFFS_TM32_IMASK			0x0828
#define	OFFS_TM32_IPOLARITY		0x082C
#define	OFFS_TM32_INTVEC		0x0880

/* generic register offsets for timer modules */
#define	OFFS_TM32_TIMER_TMODULUS	0x0000
#define	OFFS_TM32_TIMER_TVALUE		0x0004
#define	OFFS_TM32_TIMER_TCTL		0x0008
/* mmio offsets for timer module registers */
#if defined(CONFIG_CPU_TM3270)
/*module offsets */
#define	OFFS_TM32_TIMER1		0x0c00
#define	OFFS_TM32_TIMER2		0x0c20
#define	OFFS_TM32_TIMER3		0x0c40
#define	OFFS_TM32_SYSTIMER		0x0c60
/* register offsets */
#define	OFFS_TM32_TIMER1_TMODULUS	0x0C00
#define	OFFS_TM32_TIMER1_TVALUE		0x0C04
#define	OFFS_TM32_TIMER1_TCTL		0x0C08
#define	OFFS_TM32_TIMER2_TMODULUS	0x0C20
#define	OFFS_TM32_TIMER2_TVALUE		0x0C24
#define	OFFS_TM32_TIMER2_TCTL		0x0C28
#define	OFFS_TM32_TIMER3_TMODULUS	0x0C40
#define	OFFS_TM32_TIMER3_TVALUE		0x0C44
#define	OFFS_TM32_TIMER3_TCTL		0x0C48
#define	OFFS_TM32_SYSTIMER_TMODULUS	0x0C60
#define	OFFS_TM32_SYSTIMER_TVALUE	0x0C64
#define	OFFS_TM32_SYSTIMER_TCTL		0x0C68
#elif defined(CONFIG_CPU_TM3271)
/* module offsets */
#define	OFFS_TM32_SYSTIMER		0x0c00
#define	OFFS_TM32_TIMER1		0x0c20
#define	OFFS_TM32_TIMER2		0x0c40
#define	OFFS_TM32_TIMER3		0x0c60
/* register offsets */
#define	OFFS_TM32_SYSTIMER_TMODULUS	0x0C00
#define	OFFS_TM32_SYSTIMER_TVALUE	0x0C04
#define	OFFS_TM32_SYSTIMER_TCTL		0x0C08
#define	OFFS_TM32_TIMER1_TMODULUS	0x0C20
#define	OFFS_TM32_TIMER1_TVALUE		0x0C24
#define	OFFS_TM32_TIMER1_TCTL		0x0C28
#define	OFFS_TM32_TIMER2_TMODULUS	0x0C40
#define	OFFS_TM32_TIMER2_TVALUE		0x0C44
#define	OFFS_TM32_TIMER2_TCTL		0x0C48
#define	OFFS_TM32_TIMER3_TMODULUS	0x0C60
#define	OFFS_TM32_TIMER3_TVALUE		0x0C64
#define	OFFS_TM32_TIMER3_TCTL		0x0C68
#endif

#define OFFS_TM32_MOD_ID		0x0FFC

#define OFFS_TM32_BICTL			0x1000
#define OFFS_TM32_BINSTLOW		0x1004
#define OFFS_TM32_BINSTHIGH		0x1008
#define OFFS_TM32_BDCTL			0x1020
#define OFFS_TM32_BDATAALOW		0x1030
#define OFFS_TM32_BDATAAHIGH		0x1034
#define OFFS_TM32_BDATAVAL		0x1038
#define OFFS_TM32_BDATAMASK		0x103C

#define OFFS_TM32_JMP_TGT_PC0		0x1040
#define OFFS_TM32_JMP_TGT_PC1		0x1044
#define OFFS_TM32_JMP_TGT_PC2		0x1048
#define OFFS_TM32_JMP_TGT_PC3		0x104C

#if defined(CONFIG_CPU_TM3270)
#define OFFS_TM32_RSE_OBSERVE		0x1060
#endif


/*
 * Bitfields and such in the registers above
 */
#define	TM32_CTL__ACTION__MASK(V)		(((V) & 0x3) << 30)
#define	TM32_CTL__ACTION__NONE			0x0
#define	TM32_CTL__ACTION__RESET			0x1
#define	TM32_CTL__ACTION__START			0x2
#define	TM32_CTL__ACTION__RESERVED		0x3

#define	TM32_CTL__JMP_TGT_ENABLE		(1 << 15)

#define	TM32_START_ADDR__MASK(V)		((V) & ~(0x40 - 1))

#define TM32_INTNO_INTREQ0			(1 << 0)
#define TM32_INTNO_INTREQ1			(1 << 1)
#define TM32_INTNO_INTREQ2			(1 << 2)
#define TM32_INTNO_INTREQ3			(1 << 3)
#if defined(CONFIG_CPU_TM3270)
#define TM32_INTNO_INTREQ4			(1 << 4)
#define TM32_INTNO_TIMER1			(1 << 5)
#define TM32_INTNO_TIMER2			(1 << 6)
#define TM32_INTNO_TIMER3			(1 << 7)
#define TM32_INTNO_SYSTIMER			(1 << 8)
#elif defined(CONFIG_CPU_TM3271)
#define TM32_INTNO_SYSTIMER			(1 << 4)
#define TM32_INTNO_TIMER1			(1 << 5)
#define TM32_INTNO_TIMER2			(1 << 6)
#define TM32_INTNO_TIMER3			(1 << 7)
#define TM32_INTNO_INTREQ8			(1 << 8)
#endif
#define TM32_INTNO_INTREQ9			(1 << 9)
#define TM32_INTNO_INTREQ10			(1 << 10)
#define TM32_INTNO_INTREQ11			(1 << 11)
#define TM32_INTNO_INTREQ12			(1 << 12)
#define TM32_INTNO_INTREQ13			(1 << 13)
#define TM32_INTNO_INTREQ14			(1 << 14)
#define TM32_INTNO_INTREQ15			(1 << 15)
#define TM32_INTNO_INTREQ16			(1 << 16)
#define TM32_INTNO_INTREQ17			(1 << 17)
#define TM32_INTNO_INTREQ18			(1 << 18)
#define TM32_INTNO_INTREQ19			(1 << 19)
#define TM32_INTNO_INTREQ20			(1 << 20)
#define TM32_INTNO_INTREQ21			(1 << 21)
#define TM32_INTNO_INTREQ22			(1 << 22)
#define TM32_INTNO_INTREQ23			(1 << 23)
#define TM32_INTNO_INTREQ24			(1 << 24)
#define TM32_INTNO_INTREQ25			(1 << 25)
#define TM32_INTNO_INTREQ26			(1 << 26)
#define TM32_INTNO_INTREQ27			(1 << 27)
#define TM32_INTNO_INTREQ28			(1 << 28)
#define TM32_INTNO_INTREQ29			(1 << 29)
#define TM32_INTNO_INTREQ30			(1 << 30)
#define TM32_INTNO_INTREQ31			(1 << 31)


#define TM32_TIMER_x_TCTL__PRESCALE(V)		(((V) & 0xF) << 16)
#define TM32_TIMER_x_TCTL__SOURCE		(0xF << 8)
#define TM32_TIMER_x_TCTL__SOURCE_CLOCK		( 0 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_PRESCALE	( 1 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_EXT7		( 2 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_DATABRK	( 3 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_INSTBRK	( 4 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_CACHE1	( 5 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_CACHE2	( 6 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_CACHE3	( 7 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_CACHE4	( 8 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_EXT0		( 9 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_EXT1		(10 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_EXT2		(11 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_EXT3		(12 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_EXT4		(13 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_EXT5		(14 << 8)
#define TM32_TIMER_x_TCTL__SOURCE_EXT6		(15 << 8)
#define TM32_TIMER_x_TCTL__RUN			(0x1 << 0)
#define TM32_TIMER_x_TCTL__STOP			(0x0 << 0)


#define	TM32_DC_PARAMS__BLOCKSIZE(V)		(((V) & (0x3FF << 16)) >> 16)
#define TM32_DC_PARAMS__ASSOCIATIVITY(V)	(((V) & (0x1F  << 11)) >> 11)
#define TM32_DC_PARAMS__NUMBER_OF_SETS(V)	((V) & 0x3FF)

/* bit fileds for TM32_BDCTL databreakpoint control register */
#define	TM32_DBCTL__DVC				( 1 << 16)
#define	TM32_DBCTL__DAC				( 1 << 8)
#define	TM32_DBCTL__BS				( 1 << 3)
#define	TM32_DBCTL__BL				( 1 << 2)
#define	TM32_DBCTL__DC__NONE			(0x0 << 0)
#define	TM32_DBCTL__DC__ADDR			(0x1 << 0)
#define	TM32_DBCTL__DC__VALUE			(0x2 << 0)
#define	TM32_DBCTL__DC__ADDR_VALUE		(0x3 << 0)

/* interrupt source assignment for tm3270 */
#define	TM32_ISOURCE__INTREQ0	0x00
#define	TM32_ISOURCE__INTREQ1	0x01
#define	TM32_ISOURCE__INTREQ2	0x02
#define	TM32_ISOURCE__INTREQ3	0x03

#if 0
#if defined(CONFIG_CPU_TM3270)
/* tm3270 specific interrupt sources */
#define	TM32_ISOURCE__INTREQ4	0x04
#define	TM32_ISOURCE__TIMER1	0x05
#define	TM32_ISOURCE__TIMER2	0x06
#define	TM32_ISOURCE__TIMER3	0x07
#define	TM32_ISOURCE__SYSTIMER	0x08

#elif defined (CONFIG_CPU_TM3271)
/* tm3271 specific interrupt sources */
#define	TM32_ISOURCE__SYSTIMER	0x04
#define	TM32_ISOURCE__TIMER1	0x05
#define	TM32_ISOURCE__TIMER2	0x06
#define	TM32_ISOURCE__TIMER3	0x07
#define	TM32_ISOURCE__INTREQ8	0x08

#else
/* should not get here! */
#error No CPU defined
#endif	/* CONFIG_CPU_TM3270 */
#endif

#define	TM32_ISOURCE__INTREQ9	0x09
#define	TM32_ISOURCE__INTREQ10	0x0a
#define	TM32_ISOURCE__INTREQ11	0x0b
#define	TM32_ISOURCE__INTREQ12	0x0c
#define	TM32_ISOURCE__INTREQ13	0x0d
#define	TM32_ISOURCE__INTREQ14	0x0e
#define	TM32_ISOURCE__INTREQ15	0x0f
#define	TM32_ISOURCE__INTREQ16	0x10
#define	TM32_ISOURCE__INTREQ17	0x11
#define	TM32_ISOURCE__INTREQ18	0x12
#define	TM32_ISOURCE__INTREQ19	0x13
#define	TM32_ISOURCE__INTREQ20	0x14
#define	TM32_ISOURCE__INTREQ21	0x15
#define	TM32_ISOURCE__INTREQ22	0x16
#define	TM32_ISOURCE__INTREQ23	0x17
#define	TM32_ISOURCE__INTREQ24	0x18
#define	TM32_ISOURCE__INTREQ25	0x19
#define	TM32_ISOURCE__INTREQ26	0x1a
#define	TM32_ISOURCE__INTREQ27	0x1b
#define	TM32_ISOURCE__INTREQ28	0x1c
#define	TM32_ISOURCE__INTREQ29	0x1d
#define	TM32_ISOURCE__INTREQ30	0x1e
#define	TM32_ISOURCE__INTREQ31	0x1f

#endif	/* _TM328X_H */
