//-----------------------------------------------------------------------------
//
//  Copyright 2002 Philips Semiconductors Limited
//
//  Philips Semiconductors - Millbrook Industrial Estate
//  Southampton - SO15 0DJ - UK
//
//  All rights are reserved. Reproduction in whole or part is prohibited
//  without the written prior consent of the copyright owner.
//
//  Company Confidential
//
//  Filename: mont.h
//  Project: Centaurus2 / Tamperproof
//
//  Rev		Date		Author		Comments
//  -------------------------------------------------------------------
//  001		05/12/2002	A.Badey		Original version for Centaurus2
//
//  Additionnal information:
//  This code is based on the mont.h code by Bruce Murray. Refer to this code
//  for more information on the revisions made.
//
//  Function:
//  This module is the header module for mont.o1.c.
//
//----------------------------------------------------------------------------- 

#ifndef  _MONTGOMERY_H
#define  _MONTGOMERY_H

//------------------
// INCLUDE FILES
//------------------

#include "bn.h"
//--------------------
// EXPORTED TYPEDEFS
//--------------------

// Structure containg derived constants which depend on the modulus

typedef struct
{
   Bignum_t     global_p;           /* Copy of modulus - silly name as it is not now global */
   Bignum_t     Omura_corr;         /* Correction for Bignum_t overflow i.e. R-p            */
   Bignum_t     InputBlock;         /* montgomery format version of the input value         */
   unsigned int Mod_dash;           /* m'                                                   */
   unsigned int R_power;            /* R_power = n as in R =2^n                             */
   int          Modulus_Digits;     /* Number of base 2^32 digits (ULONG) in Modulus        */
}
MONTGOMERY_CONSTS;


//--------------------
// EXPORTED DATA
//--------------------

//--------------------
// STATIC DATA
//--------------------

//--------------------
// FUNCTION PROTOTYPES
//--------------------

unsigned int MnInvModTwoToTheThirtyTwo (unsigned int x);

// MnConvToMont(converted, number, derived constants)
// -> Converts a number into Mont. space
void MnConvToMont( Bignum_t *, Bignum_t *, MONTGOMERY_CONSTS *);

// MnMontMul(answer, multiplier, multiplicand, derived constants)
// -> Multiplies two numbers together in Montgomery space
void MnMontMul( Bignum_t *, Bignum_t *, Bignum_t *, MONTGOMERY_CONSTS *);

// rsa_decode(outputblock, inputblock, modulus,exponent)
// ->This function performs the encryption of inputblock as specified by
//   the RSA algorithm.
int rsa_decode_256( Bignum_t *, Bignum_t *, Bignum_t *, Bignum_t *, Bignum_t *);

#endif // _MONTGOMERY_H      Do not add anything below this line


