/*
 *  Copyright(C) 2002 Koninklijke Philips Electronics N.V.,
 *  All Rights Reserved.
 *  This  source code and any compilation or derivative thereof is the
 *  proprietary information of Koninklijke Philips Electronics N.V.
 *  and is confidential in nature.
 *  Under no circumstances is this software to be exposed to or placed
 *  under an Open Source License of any type without the expressed
 *  written permission of Koninklijke Philips Electronics N.V.      
 *                                                                  
 *############################################################
 */
/*!
 *     \file          tmbtAuthTdfLoader.h
 *
 *     \brief         -
 *
 */
/*----------------------------------------------------------*
 *
 *     %version:       2 %
 *     %date_created:  Fri Oct 17 16:34:47 2008 %
 *     %date_modified: Tue Apr 22 17:23:36 2008 %
 *     %derived_by:    uttamnk %
 *
 *
 *############################################################
 */

#ifndef TMBT_AUTHTDFLOADER_H
#define TMBT_AUTHTDFLOADER_H

/*
#ifndef lint
static char    *_DEJ_2_tmbtTdfLoader_h = "@(#) %filespec: tmbtAuthTdfLoader.h,2 %  (%full_filespec: tmbtAuthTdfLoader.h,2:header:bl39#1 %)";
#endif
*/

/*============================================================================*
 * Standard include files:
 *============================================================================*/

#if 0
#include <tmNxCompId.h>                 /* DVP system wide component IDs */
#endif

/*============================================================================*
 * Project include files:
 *============================================================================*/

#ifdef __cplusplus
extern "C"
{
#endif

/*============================================================================*
 * Types and defines:
 *============================================================================*/

#if !defined(CID_TDFLOADER)
#define CID_TDFLOADER                                               (CID_RESERVED - 1)
#endif

#define TM_ERR_TDFLOADER_BASE                                       (CID_TDFLOADER | CID_LAYER_NONE)
#define TM_ERR_TDFLOADER_COMP                                       (TM_ERR_TDFLOADER_BASE | TM_ERR_COMP_UNIQUE_START)

#define TMDL_ERR_TDF_INVALID_FORMAT                                 (TM_ERR_TDFLOADER_BASE + 16)
#define TMDL_ERR_TDF_TDF_VERSION_UNKNOWN                            (TM_ERR_TDFLOADER_BASE + 17)
#define TMDL_ERR_TDF_CPU_TYPE_UNKNOWN                               (TM_ERR_TDFLOADER_BASE + 18)
#define TMDL_ERR_TDF_FILE_TYPE_UNKNOWN                              (TM_ERR_TDFLOADER_BASE + 19)
#define TMDL_ERR_TDF_NOT_EXECUTABLE                                 (TM_ERR_TDFLOADER_BASE + 20)
#define TMDL_ERR_TDF_CRC_INCORRECT                                  (TM_ERR_TDFLOADER_BASE + 21)
#define TMDL_ERR_TDF_COMPRESSION_UNKNOWN                            (TM_ERR_TDFLOADER_BASE + 22)
#define TMDL_ERR_TDF_CHECK_UNKNOWN                                  (TM_ERR_TDFLOADER_BASE + 23)
#define TMDL_ERR_TDF_AUTH_UNKNOWN                                   (TM_ERR_TDFLOADER_BASE + 24)
#define TMDL_ERR_TDF_AUTH_ERR                                       (TM_ERR_TDFLOADER_BASE + 25)
#define TMDL_ERR_TDF_INVALID_FILE	                                (TM_ERR_TDFLOADER_BASE + 26)

#define PADDINGSIZE(offset,blocksize) (((blocksize) - ((offset) % (blocksize))) % (blocksize))

enum TdfVersion_e

{
    TDF_VERSION_3                       = 3,
    TDF_VERSION_2                       = 2,
    TDF_VERSION_1                       = 1,
    TDF_VERSION_UNKNOWN                 = 0,
};

typedef enum TdfVersion_e TdfVersion_t;


// file type

#define TDF_FILE_TYPE_MASK              0x0000FFFF
enum TdfFileType_e
{
    TDF_FILE_TYPE_TEXT =                0x00000001,
    TDF_FILE_TYPE_DATA =                0x00000002,
    TDF_FILE_TYPE_TEXT_AND_DATA =       0x00000003,
    TDF_FILE_TYPE_UNKNOWN =             0,
};

#define TDF_FILE_TYPE_NAME_SIZE         8
typedef struct _TdfFileType_t
{
    enum TdfFileType_e  Type;
    char                Name [TDF_FILE_TYPE_NAME_SIZE];
} TdfFileType_t, *pTdfFileType_t;


// check type

#define TDF_FILE_CHECK_MASK             0x000F0000
//#define TDF_FILE_AUTH_MASK                0x0FF00000

enum TdfCheck_e
{
    //TDF_FILE_AUTH_SHA1RSA  =          0x00100000,
    //TDF_FILE_AUTH_UNKNOWN  =            TDF_FILE_AUTH_MASK,
    TDF_FILE_CHECK_CRC16   =            0x00000000,
    TDF_FILE_CHECK_ADLER32 =            0x00010000,
    TDF_FILE_CHECK_UNKNOWN =            0x000F0000,
};

#define TDF_FILE_CHECK_NAME_SIZE  8
typedef struct _TdfCheck_t
{
    enum TdfCheck_e         Check;
    char                    Name [TDF_FILE_CHECK_NAME_SIZE];
} TdfCheck_t, *pTdfCheck_t;


// compression type

#define TDF_FILE_COMPRESSION_MASK       0xF0000000
enum TdfCompression_e
{
    TDF_FILE_COMPRESSION_NONE =         0x00000000,
    TDF_FILE_COMPRESSION_ZLIB =         0x80000000,
    TDF_FILE_COMPRESSION_UNKNOWN =      0xF0000000,
};

#define TDF_FILE_COMPRESSION_NAME_SIZE  8
typedef struct _TdfCompression_t
{
    enum TdfCompression_e   Compression;
    char                    Name [TDF_FILE_COMPRESSION_NAME_SIZE];
} TdfCompression_t, *pTdfCompression_t;


// cpu type

enum TdfCpuType_e
{
    TDF_CPU_TYPE_MIPS_PR4450            = 1,
    TDF_CPU_TYPE_TM_1500                = 2,
    TDF_CPU_TYPE_UNKNOWN                = 0,
};

#define TDF_CPU_TYPE_NAME_SIZE          8
typedef struct _TdfCpuType_t
{
    enum TdfCpuType_e   Type;
    char                Name [TDF_CPU_TYPE_NAME_SIZE];
    
} TdfCpuType_t, *pTdfCpuType_t;


// tdf header

#define TDF_HEADER_MAGIC                0x4644547F
#define TDF_SEQUENCE_SIZE               20

typedef struct _Adpair_t
{
    unsigned long addr;
    unsigned long data;
}Adpair_t;

typedef struct _Sequence_t
{
    unsigned long Ncmds;
    Adpair_t pair[TDF_SEQUENCE_SIZE];
} Sequence_t;


typedef struct _TdfHeader_t             // filled by UPG maker - 
{
    unsigned long       Magic;          // fixed TDF_HEADER_MAGIC
    unsigned long       HeaderSize;     // size_of(TdfHeader_t)
    TdfVersion_t        TdfVersion;     // 0x01
    enum TdfCpuType_e   CpuType;        // from elf
    enum TdfFileType_e  FileType;       // from upg cfg file
    unsigned long       ContentSize;    // from elf
    unsigned long       ContentCrc;     // calc from file (optional)
    void                *pVAddress;     // from elf
    void                *pPAddress;     // from elf
    void                (*pEntry) (int);// from elf
    unsigned long       Attributes;     // for time being 0x00
    Sequence_t          StartSequence;  // from upg cfg file
    Sequence_t          StopSequence;   // from upg cfg file
} TdfHeader_t, *pTdfHeader_t;

#define TDF_PL_PLAIN            0x00000000UL
#define TDF_PL_COMPRESS_ZLIB    0x00000001UL
#define TDF_PL_COMPRESS_LZRW    0x00000002UL
#define TDF_PL_COMPRESS_LZO    	0x00000003UL

#define TDF_PL_SIGNING_SHA1     0x00000100UL
#define TDF_PL_SIGNING_SHA256   0x00000200UL

typedef struct _TdfPayloadHeader
{
    unsigned long       payloadType;
    unsigned long       payloadSize;
} TdfPayloadHeader_t, *pTdfPayloadHeader_t;


//YW: todo: change to the same structure as in TDF tool v3
typedef struct _TdfSignedPayload
{
    unsigned char       padding[PADDINGSIZE(sizeof(TdfHeader_t)+sizeof(TdfPayloadHeader_t),64)];
    //unsigned char       rsa[128];
    unsigned char       rsa[256];
} TdfSignedPayload_t;

typedef struct _TdfStorage
{
    TdfHeader_t         hdr;
    TdfPayloadHeader_t  pl_new;
    unsigned char       padding[PADDINGSIZE(sizeof(TdfHeader_t)+sizeof(TdfPayloadHeader_t),64)];
    TdfPayloadHeader_t  pl_old;
} TdfStorage_t, *pTdfStorage_t;
    

/*============================================================================*
 * Exported functions:
 *============================================================================*/

unsigned int tmbtAuthTdfLoader_Load(char* fname, void *startaddr);
unsigned int tmbtAuthTdfLoader_HeaderValidate(void *pth);
 
#ifdef __cplusplus
}
#endif
 
#endif
