/*
   (c) Copyright 2000-2002  convergence integrated media GmbH.
   (c) Copyright 2002-2004  convergence GmbH.

   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Hundt <andi@fischlustig.de>,
              Sven Neumann <neo@directfb.org> and
              Ville Syrjl <syrjala@sci.fi>.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __CETVFB__CETVFB_H__
#define __CETVFB__CETVFB_H__

#include <fusion/call.h>
#include <fusion/lock.h>
#include <fusion/shm/pool.h>

//#include <tmMmlTypes.h>

//#include <tmIVmix.h>
//#include <tmIVmixColorKey.h>
//#include <tmIVmixGfxLayer.h>
//#include <tmIVmixVidLayer.h>
//#include <tmIPlfInstGfx.h>
//#include <tmIPlfInstMem.h>

//#include <pnx8550_mem.h>


#define CETVFB_VIDEOMEM_BASE ( 0x2000000   ) //JPJ
#define CETVFB_VIDEOMEM_SIZE ( 8*1024*1024 ) //JPJ


typedef struct {
     int                    magic;

//   tmIVmix               *pIVmix;
//   tmIVmixLayer          *pILayer;
//   tmIVmixGfxLayer       *pIGfxLayer;
//   tmIVmixColorKey       *pIColorKey;

     int                    layerId;

     unsigned long          minWindowWidth;
     unsigned long          minWindowHeight;
     unsigned long          maxLayerWindowWidth;
     unsigned long          maxLayerWindowHeight;

     CoreSurface            *surface;
	 unsigned long          format;			/* tmPixRgbFmt_t */
	 unsigned long          format_class;	/* tmPixFmtCls_t */

//   bool                   scaling;
//   int                    scale_size;
//   int                    scale_pitch;
//   tmRect_t               scale_rect;
//   int                    scale_width;
//   int                    scale_height;
//   tmPixRgbFmt_t          scale_format;
//   tmPixFmtCls_t          scale_format_class;

     bool                   set_buffer;
} CETVFBLayerData;

typedef struct {
     unsigned long         *pILayer;		/* to be removed !!! */
     unsigned long         *pIVidLayer;		/* to be removed !!! */

     unsigned long         minWindowWidth;
     unsigned long         minWindowHeight;
     unsigned long         maxLayerWindowWidth;
     unsigned long         maxLayerWindowHeight;
} CETVFBVideoLayerData;

typedef struct {
     FusionSkirmish       lock;
     FusionCall           call;

     FusionSHMPoolShared *shmpool;

     unsigned long       memSize;   // memory space size
     unsigned long       memPhys;
     void                *memVirt;

//   int                  scale_buffer;

     CETVFBVideoLayerData   *videoLayerData;

//   pthread_mutex_t      mbsLock;
//   pthread_cond_t       mbsCond;
//   bool                 mbsBusy;
} DFBCETVFB;


typedef enum {
     CETVFB_SET_REGION,
     CETVFB_UPDATE_SCREEN,
     CETVFB_SET_PALETTE,
//   CETVFB_VIDEO_SET_REGION
     CETVFB_REMOVE_REGION,
} DFBCETVFBCall;


extern DFBCETVFB          *dfb_cetvfb;
extern CoreDFB            *dfb_cetvfb_core;
extern FusionWorld        *dfb_cetvfb_world;

	// temporary solution
//extern tmIVmix       *dfb_pIVmix1;
//extern tmIVmix       *dfb_pIVmix2;
//extern tmIPlfInstGfx *dfb_pIPlfInstGfx;

#endif

