#include <stdio.h>
#include <unistd.h>

#include <fusion/fusion.h>
#include <fusion/lock.h>


int
main( int argc, char *argv[] )
{
     DirectResult         ret;
     FusionWorld         *world;
     FusionSkirmish       skirmish;

     ret = fusion_enter( -1, 23, FER_MASTER, &world );
     if (ret)
          return ret;

     ret = fusion_skirmish_init( &skirmish, "Lock Test", world );
     if (ret)
          return ret;

     fusion_skirmish_prevail( &skirmish );

     printf( "Skirmish prevailed...\n" );
     sleep( 20 );
     printf( "...dismissing Skirmish...\n" );
     sleep( 1 );

     fusion_skirmish_dismiss( &skirmish );

     printf( "...Skirmish dismissed.\n" );
     sleep( 20 );

     fusion_skirmish_destroy( &skirmish );
     fusion_exit( world, false );

     return -1;
}

