/**********************************************************************************************************************/
/*** 16 bit RGB 565 scalers *******************************************************************************************/
/**********************************************************************************************************************/

#define FUNC_NAME(UPDOWN) stretch_hvx_rgb16_ ## UPDOWN
#define SHIFT_R5          5
#define SHIFT_R6          6
#define X_F81F            0xf81f
#define X_07E0            0x07e0

#include "stretch_up_down_16.h"

#undef FUNC_NAME
#undef SHIFT_R5
#undef SHIFT_R6
#undef X_F81F
#undef X_07E0

/**********************************************************************************************************************/
/*** 16 bit ARGB 4444 scalers *****************************************************************************************/
/**********************************************************************************************************************/

#define FUNC_NAME(UPDOWN) stretch_hvx_argb4444_ ## UPDOWN
#define SHIFT_R5          4
#define SHIFT_R6          4
#define X_F81F            0x0f0f
#define X_07E0            0xf0f0
#define HAS_ALPHA

#include "stretch_up_down_16.h"

#undef HAS_ALPHA
#undef FUNC_NAME
#undef SHIFT_R5
#undef SHIFT_R6
#undef X_F81F
#undef X_07E0

/**********************************************************************************************************************/
/*** 16 bit RGB 444 scalers *******************************************************************************************/
/**********************************************************************************************************************/

#define FUNC_NAME(UPDOWN) stretch_hvx_rgb444_ ## UPDOWN
#define SHIFT_R5          4
#define SHIFT_R6          4
#define X_F81F            0x0f0f
#define X_07E0            0x00f0

#include "stretch_up_down_16.h"

#undef FUNC_NAME
#undef SHIFT_R5
#undef SHIFT_R6
#undef X_F81F
#undef X_07E0

/**********************************************************************************************************************/
/*** 32 bit ARGB 8888 scalers *****************************************************************************************/
/**********************************************************************************************************************/

#define SHIFT_R8          8
#define SHIFT_L8          8
#define X_00FF00FF        0x00ff00ff
#define X_FF00FF00        0xff00ff00

#define FUNC_NAME(UPDOWN) stretch_hvx_argb_ ## UPDOWN

#include "stretch_up_down_32.h"

#undef FUNC_NAME

/**********************************************************************************************************************/

#define FUNC_NAME(UPDOWN) stretch_hvx_argb_ ## UPDOWN ## _indexed

#include "stretch_up_down_32_indexed.h"

#undef FUNC_NAME

#undef SHIFT_R8
#undef SHIFT_L8
#undef X_00FF00FF
#undef X_FF00FF00

/**********************************************************************************************************************/
/*** 32 bit RGB 888 scalers *******************************************************************************************/
/**********************************************************************************************************************/

#define SHIFT_R8          8
#define SHIFT_L8          8
#define X_00FF00FF        0x00ff00ff
#define X_FF00FF00        0x0000ff00

#define FUNC_NAME(UPDOWN) stretch_hvx_rgb32_ ## UPDOWN

#include "stretch_up_down_32.h"

#undef FUNC_NAME

/**********************************************************************************************************************/

#define FUNC_NAME(UPDOWN) stretch_hvx_rgb32_ ## UPDOWN ## _indexed

#include "stretch_up_down_32_indexed.h"

#undef FUNC_NAME

#undef SHIFT_R8
#undef SHIFT_L8
#undef X_00FF00FF
#undef X_FF00FF00

/**********************************************************************************************************************/
/*** 16 bit YUV 422 scalers *******************************************************************************************/
/**********************************************************************************************************************/

#define FUNC_NAME(UPDOWN) stretch_hvx_nv16_ ## UPDOWN

#include "stretch_up_down_8.h"

#undef FUNC_NAME

/**********************************************************************************************************************/

#define FUNC_NAME(UPDOWN) stretch_hvx_nv16_uv_ ## UPDOWN

#include "stretch_up_down_88.h"

#undef FUNC_NAME

/**********************************************************************************************************************/
/**********************************************************************************************************************/

typedef void (*StretchHVx)( void       *dst,
                            int         dpitch,
                            const void *src,
                            int         spitch,
                            int         width,
                            int         height,
                            int         dst_width,
                            int         dst_height,
                            DFBRegion  *clip );

static StretchHVx stretch_hvx_down[DFB_NUM_PIXELFORMATS] = {
     NULL,                         /* DSPF_ARGB1555 */
     stretch_hvx_rgb16_down,       /* DSPF_RGB16 */
     NULL,                         /* DSPF_RGB24 */
     stretch_hvx_rgb32_down,       /* DSPF_RGB32 */
     stretch_hvx_argb_down,        /* DSPF_ARGB */
     NULL,                         /* DSPF_A8 */
     NULL,                         /* DSPF_YUY2 */
     NULL,                         /* DSPF_RGB332 */
     NULL,                         /* DSPF_UYVY */
     NULL,                         /* DSPF_I420 */
     NULL,                         /* DSPF_YV12 */
     NULL,                         /* DSPF_LUT8 */
     NULL,                         /* DSPF_ALUT44 */
     NULL,                         /* DSPF_AiRGB */
     NULL,                         /* DSPF_A1 */
     NULL,                         /* DSPF_NV12 */
     stretch_hvx_nv16_down,        /* DSPF_NV16 */
     NULL,                         /* DSPF_ARGB2554 */
     stretch_hvx_argb4444_down,    /* DSPF_ARGB4444 */
     NULL,                         /* DSPF_NV21 */
     NULL,                         /* DSPF_AYUV */
     NULL,                         /* DSPF_A4 */
     NULL,                         /* DSPF_ARGB1666 */
     NULL,                         /* DSPF_ARGB6666 */
     NULL,                         /* DSPF_RGB18 */
     NULL,                         /* DSPF_LUT2 */
     stretch_hvx_rgb444_down,      /* DSPF_RGB444 */
     NULL,                         /* DSPF_RGB555 */
};

static StretchHVx stretch_hvx_up[DFB_NUM_PIXELFORMATS] = {
     NULL,                         /* DSPF_ARGB1555 */
     stretch_hvx_rgb16_up,         /* DSPF_RGB16 */
     NULL,                         /* DSPF_RGB24 */
     stretch_hvx_rgb32_up,         /* DSPF_RGB32 */
     stretch_hvx_argb_up,          /* DSPF_ARGB */
     NULL,                         /* DSPF_A8 */
     NULL,                         /* DSPF_YUY2 */
     NULL,                         /* DSPF_RGB332 */
     NULL,                         /* DSPF_UYVY */
     NULL,                         /* DSPF_I420 */
     NULL,                         /* DSPF_YV12 */
     NULL,                         /* DSPF_LUT8 */
     NULL,                         /* DSPF_ALUT44 */
     NULL,                         /* DSPF_AiRGB */
     NULL,                         /* DSPF_A1 */
     NULL,                         /* DSPF_NV12 */
     stretch_hvx_nv16_up,          /* DSPF_NV16 */
     NULL,                         /* DSPF_ARGB2554 */
     stretch_hvx_argb4444_up,      /* DSPF_ARGB4444 */
     NULL,                         /* DSPF_NV21 */
     NULL,                         /* DSPF_AYUV */
     NULL,                         /* DSPF_A4 */
     NULL,                         /* DSPF_ARGB1666 */
     NULL,                         /* DSPF_ARGB6666 */
     NULL,                         /* DSPF_RGB18 */
     NULL,                         /* DSPF_LUT2 */
     stretch_hvx_rgb444_up,        /* DSPF_RGB444 */
     NULL,                         /* DSPF_RGB555 */
};

/**********************************************************************************************************************/
/**********************************************************************************************************************/

typedef void (*StretchHVxIndexed)( void       *dst,
                                   int         dpitch,
                                   const void *src,
                                   int         spitch,
                                   int         width,
                                   int         height,
                                   int         dst_width,
                                   int         dst_height,
                                   DFBRegion  *clip,
                                   const u32  *colors );

static StretchHVxIndexed stretch_hvx_down_indexed[DFB_NUM_PIXELFORMATS] = {
     NULL,                              /* DSPF_ARGB1555 */
     NULL,                              /* DSPF_RGB16 */
     NULL,                              /* DSPF_RGB24 */
     stretch_hvx_rgb32_down_indexed,    /* DSPF_RGB32 */
     stretch_hvx_argb_down_indexed,     /* DSPF_ARGB */
     NULL,                              /* DSPF_A8 */
     NULL,                              /* DSPF_YUY2 */
     NULL,                              /* DSPF_RGB332 */
     NULL,                              /* DSPF_UYVY */
     NULL,                              /* DSPF_I420 */
     NULL,                              /* DSPF_YV12 */
     NULL,                              /* DSPF_LUT8 */
     NULL,                              /* DSPF_ALUT44 */
     NULL,                              /* DSPF_AiRGB */
     NULL,                              /* DSPF_A1 */
     NULL,                              /* DSPF_NV12 */
     NULL,                              /* DSPF_NV16 */
     NULL,                              /* DSPF_ARGB2554 */
     NULL,                              /* DSPF_ARGB4444 */
     NULL,                              /* DSPF_NV21 */
     NULL,                              /* DSPF_AYUV */
     NULL,                              /* DSPF_A4 */
     NULL,                              /* DSPF_ARGB1666 */
     NULL,                              /* DSPF_ARGB6666 */
     NULL,                              /* DSPF_RGB18 */
     NULL,                              /* DSPF_LUT2 */
     NULL,                              /* DSPF_RGB444 */
     NULL,                              /* DSPF_RGB555 */
};

static StretchHVxIndexed stretch_hvx_up_indexed[DFB_NUM_PIXELFORMATS] = {
     NULL,                         /* DSPF_ARGB1555 */
     NULL,                         /* DSPF_RGB16 */
     NULL,                         /* DSPF_RGB24 */
     stretch_hvx_rgb32_up_indexed, /* DSPF_RGB32 */
     stretch_hvx_argb_up_indexed,  /* DSPF_ARGB */
     NULL,                         /* DSPF_A8 */
     NULL,                         /* DSPF_YUY2 */
     NULL,                         /* DSPF_RGB332 */
     NULL,                         /* DSPF_UYVY */
     NULL,                         /* DSPF_I420 */
     NULL,                         /* DSPF_YV12 */
     NULL,                         /* DSPF_LUT8 */
     NULL,                         /* DSPF_ALUT44 */
     NULL,                         /* DSPF_AiRGB */
     NULL,                         /* DSPF_A1 */
     NULL,                         /* DSPF_NV12 */
     NULL,                         /* DSPF_NV16 */
     NULL,                         /* DSPF_ARGB2554 */
     NULL,                         /* DSPF_ARGB4444 */
     NULL,                         /* DSPF_NV21 */
     NULL,                         /* DSPF_AYUV */
     NULL,                         /* DSPF_A4 */
     NULL,                         /* DSPF_ARGB1666 */
     NULL,                         /* DSPF_ARGB6666 */
     NULL,                         /* DSPF_RGB18 */
     NULL,                         /* DSPF_LUT2 */
     NULL,                         /* DSPF_RGB444 */
     NULL,                         /* DSPF_RGB555 */
};

/**********************************************************************************************************************/

void gStretchBlit( CardState *state, DFBRectangle *srect, DFBRectangle *drect )
{
     GenefxState  *gfxs  = state->gfxs;
     DFBRectangle  orect = *drect;

     int fx, fy;
     int ix, iy;
     int h;

     D_ASSERT( gfxs != NULL );

     CHECK_PIPELINE();

     if (state->render_options & (DSRO_SMOOTH_UPSCALE | DSRO_SMOOTH_DOWNSCALE) &&
         srect->x == 0 && srect->y == 0 && !state->blittingflags)
     {
          if (gfxs->src_format == gfxs->dst_format) {
               StretchHVx stretch = NULL;

               if (srect->w <= drect->w || srect->h <= drect->h) {
                    if ((state->render_options & DSRO_SMOOTH_UPSCALE) &&
                        (DFB_PIXELFORMAT_INDEX(gfxs->dst_format) < D_ARRAY_SIZE(stretch_hvx_up)))
                         stretch = stretch_hvx_up[DFB_PIXELFORMAT_INDEX(gfxs->dst_format)];
               }
               else {
                    if ((state->render_options & DSRO_SMOOTH_DOWNSCALE) &&
                        (DFB_PIXELFORMAT_INDEX(gfxs->dst_format) < D_ARRAY_SIZE(stretch_hvx_down)))
                         stretch = stretch_hvx_down[DFB_PIXELFORMAT_INDEX(gfxs->dst_format)];
               }

               if (stretch) {
                    DFBRegion clip = state->clip;

                    if (!dfb_region_rectangle_intersect( &clip, drect ))
                         return;

                    dfb_region_translate( &clip, - drect->x, - drect->y );

                    stretch( gfxs->dst_org[0] + drect->y * gfxs->dst_pitch
                             + DFB_BYTES_PER_LINE( gfxs->dst_format, drect->x ),
                             gfxs->dst_pitch, gfxs->src_org[0], gfxs->src_pitch,
                             srect->w, srect->h, drect->w, drect->h, &clip );

                    switch (gfxs->dst_format) {
                         case DSPF_NV16:
                              clip.x1 /= 2;
                              clip.x2 /= 2;
                              if (srect->w < drect->w || srect->h < drect->h) {
                                   stretch_hvx_nv16_uv_up( gfxs->dst_org[1] + drect->y * gfxs->dst_pitch
                                                           + DFB_BYTES_PER_LINE( gfxs->dst_format, drect->x&~1 ),
                                                           gfxs->dst_pitch, gfxs->src_org[1], gfxs->src_pitch,
                                                           srect->w/2, srect->h, drect->w/2, drect->h, &clip );
                              }
                              else {
                                   stretch_hvx_nv16_uv_down( gfxs->dst_org[1] + drect->y * gfxs->dst_pitch
                                                             + DFB_BYTES_PER_LINE( gfxs->dst_format, drect->x&~1 ),
                                                             gfxs->dst_pitch, gfxs->src_org[1], gfxs->src_pitch,
                                                             srect->w/2, srect->h, drect->w/2, drect->h, &clip );
                              }
                              break;

                         default:
                              break;
                    }

                    return;
               }
          }
          else if (gfxs->src_format == DSPF_LUT8) {
               StretchHVxIndexed stretch_indexed = NULL;

               if (srect->w < drect->w || srect->h < drect->h) {
                    if ((state->render_options & DSRO_SMOOTH_UPSCALE) &&
                        (DFB_PIXELFORMAT_INDEX(gfxs->dst_format) < D_ARRAY_SIZE(stretch_hvx_up_indexed)))
                         stretch_indexed = stretch_hvx_up_indexed[DFB_PIXELFORMAT_INDEX(gfxs->dst_format)];
               }
               else {
                    if ((state->render_options & DSRO_SMOOTH_DOWNSCALE) &&
                        (DFB_PIXELFORMAT_INDEX(gfxs->dst_format) < D_ARRAY_SIZE(stretch_hvx_down_indexed)))
                         stretch_indexed = stretch_hvx_down_indexed[DFB_PIXELFORMAT_INDEX(gfxs->dst_format)];
               }

               if (stretch_indexed) {
                    int             i;
                    u32             colors[256];
                    const DFBColor *entries = gfxs->Blut->entries;
                    DFBRegion       clip    = state->clip;

                    if (!dfb_region_rectangle_intersect( &clip, drect ))
                         return;

                    dfb_region_translate( &clip, - drect->x, - drect->y );

                    for (i=0; i<gfxs->Blut->num_entries; i++)
                         colors[i] = PIXEL_ARGB( entries[i].a, entries[i].r, entries[i].g, entries[i].b );

                    stretch_indexed( gfxs->dst_org[0] + drect->y * gfxs->dst_pitch
                                     + DFB_BYTES_PER_LINE( gfxs->dst_format, drect->x ),
                                     gfxs->dst_pitch, gfxs->src_org[0], gfxs->src_pitch,
                                     srect->w, srect->h, drect->w, drect->h, &clip, colors );

                    return;
               }
          }
     }

     /* Clip destination rectangle. */
     if (!dfb_rectangle_intersect_by_region( drect, &state->clip ))
          return;

     /* Calculate fractions. */
     fx = (srect->w << 16) / orect.w;
     fy = (srect->h << 16) / orect.h;

     /* Calculate horizontal phase and offset. */
     ix = fx * (drect->x - orect.x);
     srect->x += ix >> 16;
     ix &= 0xFFFF;

     /* Calculate vertical phase and offset. */
     iy = fy * (drect->y - orect.y);
     srect->y += iy >> 16;
     iy &= 0xFFFF;

     /* Adjust source size. */
     srect->w = ((drect->w * fx + ix) + 0xFFFF) >> 16;
     srect->h = ((drect->h * fy + iy) + 0xFFFF) >> 16;

     D_ASSERT( srect->x + srect->w <= state->source->config.size.w );
     D_ASSERT( srect->y + srect->h <= state->source->config.size.h );
     D_ASSERT( drect->x + drect->w <= state->clip.x2 + 1 );
     D_ASSERT( drect->y + drect->h <= state->clip.y2 + 1 );


     if (!ABacc_prepare( gfxs, MAX( srect->w, drect->w ) ))
          return;


     switch (gfxs->src_format) {
          case DSPF_A4:
          case DSPF_YUY2:
          case DSPF_UYVY:
               srect->x &= ~1;
               break;
          default:
               break;
     }

     switch (gfxs->dst_format) {
          case DSPF_A4:
          case DSPF_YUY2:
          case DSPF_UYVY:
               drect->x &= ~1;
               break;
          default:
               break;
     }

     gfxs->Slen   = srect->w;
     gfxs->Dlen   = drect->w;
     gfxs->length = gfxs->Dlen;
     gfxs->SperD  = fx;
     gfxs->Xphase = ix;

     h = drect->h;

     Aop_xy( gfxs, drect->x, drect->y );
     Bop_xy( gfxs, srect->x, srect->y );

     while (h--) {
          RUN_PIPELINE();

          Aop_next( gfxs );

          iy += fy;

          while (iy > 0xFFFF) {
               iy -= 0x10000;
               Bop_next( gfxs );
          }
     }
}

