/* (C) Copyright 2004 Atheros Communications, Inc.
 * All rights reserved.
 * File Name: led.cpp
 * Description: PBC LED control functions
 */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include "led.h"
    
enum led_status {OFF=0, YELLOW,GREEN,RED};
    
static int  g_pbc_stat = LED_OFF; ;

void led_display (int pbc_status)
{
     g_pbc_stat = pbc_status;
}

static void led_ctrl(int led_color)
{
    switch(led_color){
        case YELLOW:
             system("exec echo 2 >/proc/ar531x/gpio/tricolor_led");
             break;
        case GREEN:
             system("exec echo 1 >/proc/ar531x/gpio/tricolor_led");
             break;
        case RED:
             system("exec echo 3 >/proc/ar531x/gpio/tricolor_led");
             break;
        case OFF:
             system("exec echo 0 >/proc/ar531x/gpio/tricolor_led");
             break;
    }
}
    
void * led_loop(void *p_data)
{
    int led_color = OFF;
    int overlap_counter=0;
    
    for(;;){
        switch (g_pbc_stat) {
             case LED_INPROGRESS:
                  if(led_color){
                     led_ctrl(OFF);
                     led_color = OFF;
                     usleep(100);
                  }else{
                     led_ctrl(YELLOW);
                     led_color=YELLOW;
                     usleep(200);
                  }
                  break;
             case LED_ERROR:
                  if(led_color){
                     led_ctrl(OFF);
                     led_color = OFF;
                     usleep(100);
                  }else{
                     led_ctrl(RED);
                     led_color=RED;
                     usleep(100);
                  }
                  break;
             case LED_OVERLAP:
                  overlap_counter++;
                  if((overlap_counter >10) && (overlap_counter <=15)){
                    led_ctrl(OFF);
                    if (overlap_counter ==15)
                        overlap_counter = 0;
                    break;
                  }
                  if(led_color){
                     led_ctrl(OFF);
                     led_color = OFF;
                     usleep(100);
                  }else{
                     led_ctrl(RED);
                     led_ctrl(OFF);
                     led_color=RED;
                     usleep(100);
                  }

                  break;
             case LED_SUCCESS:
                  led_ctrl(GREEN);
                  usleep(300);
                  break;
        
             case LED_OFF:
             default:
                  led_ctrl(OFF);
                  break;
       }
    }
}




