/*
 *	Fusion Kernel Module
 *
 *	(c) Copyright 2002-2003  Convergence GmbH
 *
 *      Written by Denis Oliver Kropp <dok@directfb.org>
 *
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 */
 
#ifndef __FUSIONEE_H__
#define __FUSIONEE_H__

#include <linux/poll.h>
#include <linux/fusion.h>

#include "fusiondev.h"
#include "types.h"

/* module init/cleanup */

int  fusionee_init   (FusionDev *dev);
void fusionee_deinit (FusionDev *dev);


/* internal functions */

int fusionee_new           (FusionDev         *dev,
                            bool               force_slave,
                            Fusionee         **ret_fusionee);

int fusionee_enter         (FusionDev         *dev,
                            FusionEnter       *enter,
                            Fusionee          *fusionee);

int fusionee_fork          (FusionDev         *dev,
                            FusionFork        *fork,
                            Fusionee          *fusionee);

int fusionee_send_message  (FusionDev         *dev,
                            Fusionee          *fusionee,
                            FusionID           recipient,
                            FusionMessageType  msg_type,
                            int                msg_id,
                            int                msg_channel,
                            int                msg_size,
                            const void        *msg_data,
                            MessageCallback    callback,
                            void              *callback_ctx,
                            int                callback_param);

int fusionee_get_messages  (FusionDev         *dev,
                            Fusionee          *fusionee,
                            void              *buf,
                            int                buf_size,
                            bool               block);

unsigned
int fusionee_poll          (FusionDev         *dev,
                            Fusionee          *fusionee,
                            struct file       *file,
                            poll_table        *wait);

int fusionee_kill          (FusionDev         *dev,
                            Fusionee          *fusionee,
                            FusionID           target,
                            int                signal,
                            int                timeout_ms);

void fusionee_destroy      (FusionDev         *dev,
                            Fusionee          *fusionee);

FusionID fusionee_id( const Fusionee *fusionee );

#endif
