#ifndef __CETVFB__CALLBACKS_H__
#define __CETVFB__CALLBACKS_H__


#define dfb_True	(1)
#define dfb_False	(0)


//** define the constants **//

    // Color Key Types 
#define Dfb_KeySrcColorKey				0
#define Dfb_KeyDstColorKey				1
	// Pixel Format Classes
#define Dfb_PixFmtClassYuv				0
#define Dfb_PixFmtClassRgb				1
#define Dfb_PixFmtClassClut				2
   // Pixel Format types for PixFmtClassClut
#define Dfb_PixFmtRgbClut1bpp			10
#define Dfb_PixFmtRgbClut2bpp			11
#define Dfb_PixFmtRgbClut4bpp			12
#define Dfb_PixFmtRgbClut8bpp			13
#define Dfb_PixFmtArgbClut1bpp			14
#define Dfb_PixFmtArgbClut2bpp			15
#define Dfb_PixFmtArgbClut4bpp			16
#define Dfb_PixFmtArgbClut8bpp			17
#define Dfb_PixFmtYuvClut1bpp			18
#define Dfb_PixFmtYuvClut2bpp			19
#define Dfb_PixFmtYuvClut4bpp			20
#define Dfb_PixFmtYuvClut8bpp			21
#define Dfb_PixFmtAyuvClut1bpp			22
#define Dfb_PixFmtAyuvClut2bpp			23
#define Dfb_PixFmtAyuvClut4bpp			24
#define Dfb_PixFmtAyuvClut8bpp			25
     // Pixel Format Types for PixFmtClassRgb
#define Dfb_PixFmtXrgb1555				30
#define Dfb_PixFmtArgb1555				31
#define Dfb_PixFmtXrgb4444				32
#define Dfb_PixFmtArgb4444				33
#define Dfb_PixFmtRgb565				34
#define Dfb_PixFmtXrgb8888				35
#define Dfb_PixFmtArgb8888				36
    // Pixel Format types for PixFmtClassYuv
#define Dfb_PixFmtUyvy					40
#define Dfb_PixFmtYuy2					41
#define Dfb_PixFmtVyuy					42

//** define the function list structure **//
typedef struct {
	void (*GetOutputProperties)(		unsigned long *pwidth, unsigned long *pheight, unsigned long *pfieldrate, int /*bool*/ *pprogressive );
	unsigned long (*GetSuppNrKeys)(		int gfxlayer );
	void (*SetKey)(						int gfxlayer, unsigned long keynr, unsigned long keytype, unsigned long lowercolor, unsigned long uppercolor);
	void (*EnableKey)(					int gfxlayer, unsigned long keynr, int /*bool*/ enable );
//  bool (*SetBuffer)(		    int gfxlayer, unsigned long width, unsigned long height, unsigned long stride, int src_ul_x, int src_ul_y, int src_lr_x, int src_lr_y, unsigned long  fmtclass, unsigned long  fmttype, void *pbuf );
    int /*bool*/ (*SetBuffer)(			int gfxlayer, unsigned long width, unsigned long height, unsigned long stride, unsigned long  fmtclass, unsigned long  fmttype, void *pbuf );
    void (*SetClut)(				    int gfxlayer, unsigned long nrentries, unsigned long *clut );
	void (*GetMinWindowSize)(			int gfxlayer, unsigned long *pwidth, unsigned long *pheight );
	void (*GetMaxLayerWindowSize)(		int gfxlayer, unsigned long *pwidth, unsigned long *pheight );
	void (*SetLayerWindow)(				int gfxlayer, int ul_x, int ul_y, int lr_x, int lr_y );
	void (*SetDstWindow)(				int gfxlayer, int ul_x, int ul_y, int lr_x, int lr_y );
	void (*SetSrcWindow)(				int gfxlayer, int ul_x, int ul_y, int lr_x, int lr_y);
	void (*SetScaleMode) (				int gfxlayer, unsigned long mode );
	void (*HideLayer)(					int gfxlayer, int /*bool*/ hide );
	void (*ActivateNewWindowSettings) ( int gfxlayer, int /*bool*/ sync, unsigned long millisec );
	void (* SetGraphicLayerMode) (		int gfxlayer, unsigned long layermode );
	void * (*GetVideoMemory) (void);
	void (*AcceleratedCopy)(			unsigned long SrcAddr, unsigned long DstAddr, int ul_x, int ul_y, int lr_x, int lr_y, int dst_x, int dst_y );
} CETVFBCallBackTable;



// Prototypes //

void DFB_RegisterCetvCallBackTable( CETVFBCallBackTable cetvfbfct );

void DFB_RegisterVideoMemStart( unsigned int memstart );


#endif
