/*
   (c) Copyright 2000-2002  convergence integrated media GmbH.
   (c) Copyright 2002-2004  convergence GmbH.

   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Hundt <andi@fischlustig.de>,
              Sven Neumann <neo@directfb.org> and
              Ville Syrjl <syrjala@sci.fi>.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <config.h>

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fcntl.h>
#include <sys/mman.h>

#include <directfb.h>

#include <fusion/arena.h>
#include <fusion/shmalloc.h>

#include <core/core.h>
#include <core/coredefs.h>
#include <core/coretypes.h>
#include <core/layers.h>
#include <core/palette.h>
#include <core/surfaces.h>
#include <core/system.h>

#include <gfx/convert.h>

#include <misc/conf.h>

#include <direct/messages.h>


#include "cetvfb.h"
#include "primary.h"
//#include "video.h"
#include "callbacks.h"

#include <core/core_system.h>


DFB_CORE_SYSTEM( cetvfb )

D_DEBUG_DOMAIN( CETVFB_System, "CETVFB/System", "Core System CETVFB" );

/**********************************************************************************************************************/

DFBCETVFB          *dfb_cetvfb        = NULL;
CoreDFB            *dfb_cetvfb_core   = NULL;
FusionWorld        *dfb_cetvfb_world  = NULL;


static unsigned int VideoMemStart = 0;


/**********************************************************************************************************************/

static DFBResult
CETVFB_Init( bool master )
{
     DFBResult rval = DFB_OK;
//	 bool ret = false;
     static int  fd = -1;


     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     setpgid( 0, 0 );

     if (master) {
//        D_ASSERT( dfb_pIVmix1 != NULL );
//        D_ASSERT( dfb_pIPlfInstGfx != NULL );

          /* Create and allocate the whole system memory space */
//		  ret = mix_CreateMemoryPool( &dfb_cetvfb->memPhys, &dfb_cetvfb->memVirt, &dfb_cetvfb->memSize );
//		  if (!ret) return DFB_INIT;

		 /* memory is created and allocated by platform already !! (will be a callback in the future !! */
		  dfb_cetvfb->memVirt = (void*)VideoMemStart;
		  dfb_cetvfb->memPhys = VideoMemStart;	/* the tmmalloc() returns physical and virtual memories that area aligned !! */
		  dfb_cetvfb->memSize = CETVFB_VIDEOMEM_SIZE;
		  printf("\nMemory intialization : master\n");

//        D_DEBUG_AT( CETVFB_System, "  -> memspace handle 0x%08x\n", (unsigned int) dfb_cetvfb->memHandle );
     }
	 else
	 {
		if (fd < 0) {
		    fd = open( "/dev/mem", O_RDWR );
		    if (fd < 0) {
			       D_PERROR( "System/CETVFB: Couldn't open /dev/mem!\n" );
		        return DFB_INIT;
			}
		}

	    dfb_cetvfb->memVirt = mmap( 0, dfb_cetvfb->memSize, PROT_READ | PROT_WRITE, MAP_SHARED, fd, dfb_cetvfb->memPhys );
	
     }

     if (rval) {
          D_ERROR( "System/CETVFB: Error '%u' mapping physical to virtual!\n", rval );
          return rval;
     }


     D_DEBUG_AT( CETVFB_System, "  -> physical 0x%08x\n", (unsigned int) dfb_cetvfb->memPhys );
     D_DEBUG_AT( CETVFB_System, "  -> virtual  0x%08x\n", (unsigned int) dfb_cetvfb->memVirt );
	 D_DEBUG_AT( CETVFB_System, "  -> size     0x%08x\n", (unsigned int) dfb_cetvfb->memSize );

//     D_ASSERT( dfb_cetvfb->memPhys != 0 );
     D_ASSERT( dfb_cetvfb->memVirt != NULL );

     return DFB_OK;
}

static void
CETVFB_Exit()
{
    /* TODO: destroy memspace */
}

static FusionCallHandlerResult
dfb_cetvfb_call_handler( int   caller,
                      int   call_arg, 
                      void *call_ptr,
                      void         *ctx,
                      unsigned int  serial,
                      int          *ret_val )
{
     switch (call_arg) {
          case CETVFB_SET_REGION:
               *ret_val = dfb_cetvfb_set_region_handler( call_ptr );
               break;

          case CETVFB_UPDATE_SCREEN:
               *ret_val = dfb_cetvfb_update_screen_handler( call_ptr );
               break;

          case CETVFB_SET_PALETTE:
               *ret_val = dfb_cetvfb_set_palette_handler( call_ptr );
               break;

//          case CETVFB_VIDEO_SET_REGION:
//               return dfb_cetvfb_video_set_region_handler( call_ptr );

          case CETVFB_REMOVE_REGION:
               *ret_val = dfb_cetvfb_remove_region_handler( call_ptr );
               break;

          default:
               D_BUG( "unknown call" );
               *ret_val = DFB_BUG;
               break;
     }

     return FCHR_RETURN;
}

/**********************************************************************************************************************/

static void
system_get_info( CoreSystemInfo *info )
{
     info->type = CORE_ANY;
     info->caps = CSCAPS_ACCELERATION;

     snprintf( info->name, DFB_CORE_SYSTEM_INFO_NAME_LENGTH, "CETVFB" );
}

static DFBResult
system_initialize( CoreDFB *core, void **data )
{
     DFBResult            ret;
     CoreScreen          *screen;
     FusionWorld         *world;
     FusionSHMPoolShared *pool;

     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     D_ASSERT( dfb_cetvfb == NULL );

     world = dfb_core_world( core );
     pool  = dfb_core_shmpool( core );

     dfb_cetvfb = (DFBCETVFB*) SHCALLOC( pool, 1, sizeof(DFBCETVFB) );
     if (!dfb_cetvfb) {
          D_ERROR( "DirectFB/CETVFB: Couldn't allocate shared memory!\n" );
          return DFB_NOSYSTEMMEMORY;
     }

     dfb_cetvfb->shmpool = pool;
     dfb_cetvfb_core     = core;
     dfb_cetvfb_world    = world;

     ret = CETVFB_Init( true );
     if (ret) {
          SHFREE( pool, dfb_cetvfb );
          return ret;
     }

     fusion_skirmish_init( &dfb_cetvfb->lock, "CETVFB System", world );
     fusion_call_init( &dfb_cetvfb->call, dfb_cetvfb_call_handler, NULL, world );

	 /* register screen functions */
	 screen = dfb_screens_register( NULL, NULL, &cetvfbPrimaryScreenFuncs );

	 /* register layer functions for the 3 layers */
     dfb_layers_register( screen, (void*) 0, &cetvfbPrimaryLayerFuncs );
     dfb_layers_register( screen, (void*) 1, &cetvfbPrimaryLayerFuncs );
	 dfb_layers_register( screen, (void*) 2, &cetvfbPrimaryLayerFuncs );


     fusion_arena_add_shared_field( dfb_core_arena( core ), "CETVFB", dfb_cetvfb );

     *data = dfb_cetvfb;

     return DFB_OK;
}

static DFBResult
system_join( CoreDFB *core, void **data )
{
     void       *ret;
     CoreScreen *screen;

     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     D_ASSERT( dfb_cetvfb == NULL );

     fusion_arena_get_shared_field( dfb_core_arena( core ), "CETVFB", &ret );

     dfb_cetvfb       = ret;
     dfb_cetvfb_core  = core;
     dfb_cetvfb_world = dfb_core_world( core );

     if (CETVFB_Init( false ))
          return DFB_INIT;

	 /* register screen functions */
     screen = dfb_screens_register( NULL, NULL, &cetvfbPrimaryScreenFuncs );

	 /* register layer functions for the 3 layers */
     dfb_layers_register( screen, (void*) 0, &cetvfbPrimaryLayerFuncs );
     dfb_layers_register( screen, (void*) 1, &cetvfbPrimaryLayerFuncs );
	 dfb_layers_register( screen, (void*) 2, &cetvfbPrimaryLayerFuncs );
//     dfb_layers_register( screen, NULL, &cetvfbPrimaryLayerFuncs );

     *data = dfb_cetvfb;

     return DFB_OK;
}

static DFBResult
system_shutdown( bool emergency )
{
     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     D_ASSERT( dfb_cetvfb != NULL );

     fusion_call_destroy( &dfb_cetvfb->call );

     fusion_skirmish_prevail( &dfb_cetvfb->lock );

     CETVFB_Exit();

     fusion_skirmish_destroy( &dfb_cetvfb->lock );

     SHFREE( dfb_cetvfb->shmpool, dfb_cetvfb );

     dfb_cetvfb       = NULL;
     dfb_cetvfb_core  = NULL;
     dfb_cetvfb_world = NULL;

     return DFB_OK;
}

static DFBResult
system_leave( bool emergency )
{
     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     D_ASSERT( dfb_cetvfb != NULL );

     dfb_cetvfb       = NULL;
     dfb_cetvfb_core  = NULL;
     dfb_cetvfb_world = NULL;

     return DFB_OK;
}

static DFBResult
system_suspend()
{
     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     return DFB_UNIMPLEMENTED;
}

static DFBResult
system_resume()
{
     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     return DFB_UNIMPLEMENTED;
}

static volatile void *
system_map_mmio( unsigned int    offset,
                 int             length )
{
     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     return NULL;
}

static void
system_unmap_mmio( volatile void  *addr,
                   int             length )
{
     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );
}

static int
system_get_accelerator()
{
     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     return 0;
}

static VideoMode *
system_get_modes()
{
     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     return NULL;
}

static VideoMode *
system_get_current_mode()
{
     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     return NULL;
}

static DFBResult
system_thread_init()
{
     D_DEBUG_AT( CETVFB_System, "%s()\n", __FUNCTION__ );

     return DFB_OK;
}

static bool
system_input_filter( CoreInputDevice *device,
                     DFBInputEvent   *event )
{
     return false;
}

static unsigned long
system_video_memory_physical( unsigned int offset )
{
//	printf("\nsystem_video_memory_physical : 0x%08lx\n",offset);
     return dfb_cetvfb->memPhys + offset;
}

static void *
system_video_memory_virtual( unsigned int offset )
{
//     printf("\nsystem_video_memory_virtual : 0x%08lx\n",offset);
     return dfb_cetvfb->memVirt + offset;
}

static unsigned int
system_videoram_length()
{
     return dfb_cetvfb->memSize;
}

static unsigned long
system_aux_memory_physical( unsigned int offset )
{
     return 0;
}

static void *
system_aux_memory_virtual( unsigned int offset )
{
     return NULL;
}

static unsigned int
system_auxram_length()
{
     return 0;
}

static void
system_get_busid( int *ret_bus, int *ret_dev, int *ret_func )
{
}

static void
system_get_deviceid( unsigned int *ret_vendor_id,
                     unsigned int *ret_device_id )
{
}


void DFB_RegisterVideoMemStart( unsigned int memstart )
{
	VideoMemStart = memstart;
}

