/*
   (c) Copyright 2000-2002  convergence integrated media GmbH.
   (c) Copyright 2002-2004  convergence GmbH.

   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Hundt <andi@fischlustig.de>,
              Sven Neumann <neo@directfb.org> and
              Ville Syrjl <syrjala@sci.fi>.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __JAG__JAG_H__
#define __JAG__JAG_H__

#include <fusion/call.h>
#include <fusion/lock.h>
#include <fusion/shm/pool.h>

#include <tmMmlTypes.h>

#include <tmIVmix.h>
#include <tmIVmixColorKey.h>
#include <tmIVmixGfxLayer.h>
#include <tmIVmixVidLayer.h>
#include <tmIPlfInstGfx.h>
#include <tmIPlfInstMem.h>

#include <pnx8550_mem.h>


#define JAG_SYSTEM_GFXMEM_ADDR     PNX8550_GFXMEM_ADDR
#define JAG_SYSTEM_GFXMEM_SIZE     PNX8550_GFXMEM_SIZE


typedef struct {
     int                    magic;

     tmIVmix               *pIVmix;
     tmIVmixLayer          *pILayer;
     tmIVmixGfxLayer       *pIGfxLayer;
     tmIVmixColorKey       *pIColorKey;

     bool                   first;

     UInt32                 minWindowWidth;
     UInt32                 minWindowHeight;
     UInt32                 maxLayerWindowWidth;
     UInt32                 maxLayerWindowHeight;

     CoreSurface           *surface;
     tmPixRgbFmt_t          format;
     tmPixFmtCls_t          format_class;

     bool                   scaling;
     int                    scale_size;
     int                    scale_pitch;
     tmRect_t               scale_rect;
     int                    scale_width;
     int                    scale_height;
     tmPixRgbFmt_t          scale_format;
     tmPixFmtCls_t          scale_format_class;

     bool                   set_buffer;
} JAGLayerData;

typedef struct {
     tmIVmixLayer          *pILayer;
     tmIVmixVidLayer       *pIVidLayer;

     UInt32                 minWindowWidth;
     UInt32                 minWindowHeight;
     UInt32                 maxLayerWindowWidth;
     UInt32                 maxLayerWindowHeight;
} JAGVideoLayerData;

typedef struct {
     FusionSkirmish       lock;
     FusionCall           call;

     FusionSHMPoolShared *shmpool;

     tmmlMmspHandle_t     memHandle;   // handle to memory space
     tmmlPhysAddr_t       memPhys;
     void                *memVirt;

     int                  scale_buffer;
     int                  scale_buffer2;

     JAGVideoLayerData   *videoLayerData;

     pthread_mutex_t      mbsLock;
     pthread_cond_t       mbsCond;
     bool                 mbsBusy;

     CoreSurfacePool     *tmml_surface_pool;
} DFBJAG;


typedef enum {
     JAG_SET_REGION,
     JAG_UPDATE_SCREEN,
     JAG_SET_PALETTE,
     JAG_VIDEO_SET_REGION,
     JAG_REMOVE_REGION,
     JAG_TMML_ALLOCATE,
     JAG_TMML_DEALLOCATE,
} DFBJAGCall;


extern DFBJAG             *dfb_jag;
extern CoreDFB            *dfb_jag_core;
extern FusionWorld        *dfb_jag_world;

// temporary solution
extern tmIVmix       *dfb_pIVmix1;
extern tmIVmix       *dfb_pIVmix2;
extern tmIPlfInstGfx *dfb_pIPlfInstGfx;


#endif

