/*
   (c) Copyright 2000-2002  convergence integrated media GmbH.
   (c) Copyright 2002-2004  convergence GmbH.

   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Hundt <andi@fischlustig.de>,
              Sven Neumann <neo@directfb.org> and
              Ville Syrjl <syrjala@sci.fi>.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __JAG__PRIMARY_H__
#define __JAG__PRIMARY_H__

#include "jag.h"


#include <core/layers.h>
#include <core/screens.h>

extern ScreenFuncs       jagPrimaryScreenFuncs;
extern DisplayLayerFuncs jagPrimaryLayerFuncs;


typedef struct {
     JAGLayerData               *layerData;
     CoreLayerRegionConfig       config;
     CoreLayerRegionConfigFlags  updated;
     CoreSurface                *surface;
     CorePalette                *palette;
} JAGSetRegionData;

typedef struct {
     JAGLayerData               *layerData;
     DFBRegion                   region;
     CoreSurfaceBufferLock      *lock;
} JAGUpdateScreenData;

typedef struct {
     JAGLayerData               *layerData;
     CorePalette                *palette;
} JAGSetPaletteData;


DFBResult dfb_jag_set_region_handler   ( JAGSetRegionData    *data );

DFBResult dfb_jag_update_screen_handler( JAGUpdateScreenData *data );

DFBResult dfb_jag_set_palette_handler  ( JAGSetPaletteData   *data );

DFBResult dfb_jag_remove_region_handler( JAGLayerData        *data );

#endif

