#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <time.h>
#include <sys/time.h>


#define ARRAY_SIZE(array)        ((int)(sizeof(array) / sizeof((array)[0])))

/**********************************************************************************************************************/

static long long
clock_get_micros()
{
     struct timeval tv;

     gettimeofday( &tv, NULL );

     return (long long)tv.tv_sec * 1000000LL + (long long)tv.tv_usec;
}

/**********************************************************************************************************************/

typedef struct {
     const char *name;
     void      (*bench)(unsigned int n);
} BenchMethod;

static void
loop_counter(unsigned int n)
{
     volatile unsigned int i;

     for (i = 0; i < n; i++);
}

static void
branch_tree(unsigned int n)
{
     while (n > 0) {
          if (n & 1) {
               if (n & 2) {
                    if (n & 4)
                         n -= 2;
                    else
                         n -= 1;
               }
               else
                    n -= 1;
          }
          else
               n -= 1;
     }
}

static void
multi_multiply(unsigned int n)
{
     volatile unsigned int i, m = n;

     for (i = 0; i < n; i++) {
          m *= m * i;
     }
}

static void
cache_test(unsigned int n)
{
     volatile char buffer[0x400000];

     while (n--)
          buffer[n & 0x3fffff] = buffer[(n & 0x3fffff) ^ 0x3fffff];
}

static BenchMethod methods[] = {
     { "loop counter", loop_counter},
     { "branch tree", branch_tree},
     { "multi multiply", multi_multiply},
     { "cache test", cache_test}
};

/**********************************************************************************************************************/

int
main (int argc, char *argv[])
{
     int i;

     for (i=0; i<ARRAY_SIZE(methods); i++) {
          long long    t1, t2;
          BenchMethod *method = &methods[i];

          printf( "Benchmarking '%s'...  ", method->name ); fflush( stdout );

          sync();

          usleep( 300000 );


          t1 = clock_get_micros();

          method->bench( 1000000000U );

          t2 = clock_get_micros();

          printf( "%5llu Kloops/sec\n", 1000000000ULL / (t2 - t1) );
     }

     return 0;
}
