/*-
 * Copyright (c) 2009  Atheros Communications Inc
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/usb.h>

 
#define VENDOR_ATHR             0x0CF3  //Atheros
#define PRODUCT_AR7010          0x7010  
#define PRODUCT_AR7011          0x7011  
#define PRODUCT_AR9271          0x9271

#define VENDOR_PHILIPS 0x0471 //Philips
#define PRODUCT_TV550 0x209e

typedef void (*ath_usb_unload)(void);

static void unload_usb(void);
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0))
static void *zfLnxProbe(struct usb_device *dev, unsigned int ifnum,
                        const struct usb_device_id *id);
static void zfLnxDisconnect(struct usb_device *dev, void *ptr);
#else
static int zfLnxProbe(struct usb_interface *interface,
                      const struct usb_device_id *id);
static void zfLnxDisconnect(struct usb_interface *interface);
#endif

extern void HIF_USBDeviceInserted(struct usb_interface *interface, ath_usb_unload unload,unsigned short product_id);
extern void HIF_USBDeviceDetached(struct usb_interface *interface, uint8_t surpriseRemoved);

static const char driver_name[] = "MAGPIE";
static struct usb_interface *g_magpie_usb_ifc = NULL;

/* table of devices that work with this driver */
static struct usb_device_id magpie_ids [] = {
    { USB_DEVICE(VENDOR_ATHR, PRODUCT_AR7010) },
    { USB_DEVICE(VENDOR_ATHR, PRODUCT_AR7011) },
    { USB_DEVICE(VENDOR_ATHR, PRODUCT_AR9271) },
    { USB_DEVICE(VENDOR_PHILIPS, PRODUCT_TV550 ) }, 
    { }                 /* Terminating entry */
};

MODULE_DEVICE_TABLE(usb, magpie_ids);

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0))
static void *zfLnxProbe(struct usb_device *dev, unsigned int ifnum,
                        const struct usb_device_id *id)
{
struct usb_interface *interface = &dev->actconfig->interface[ifnum];
#else
static int zfLnxProbe(struct usb_interface *interface,
                      const struct usb_device_id *id)
{
    struct usb_device *dev = interface_to_usbdev(interface);
#endif

    unsigned short vendor_id, product_id;
    int result = 0;

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0))
    usb_get_dev(dev);
#endif    

    vendor_id = dev->descriptor.idVendor;
    product_id = dev->descriptor.idProduct;

#if 1   
    printk(KERN_NOTICE "vendor_id = %04x\n", vendor_id);
    printk(KERN_NOTICE "product_id = %04x\n", product_id);

    if (dev->speed == USB_SPEED_HIGH)
      printk(KERN_NOTICE "USB 2.0 Host\n");
    else
      printk(KERN_NOTICE "USB 1.1 Host\n");  
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0))
    if (usb_set_configuration(dev, dev->config[0].bConfigurationValue))
    {
      printk(KERN_ERR "usb_set_configuration() failed\n");
      result = -EIO;
      goto fail;
    }
#endif

    HIF_USBDeviceInserted(interface, unload_usb,product_id);

#if 0 
    if (!(macp = kmalloc(sizeof(struct usbdrv_private), GFP_KERNEL)))
    {
      printk(KERN_ERR "out of memory allocating device structure\n");
      result = -ENOMEM;
      goto fail;
    }

    /* Zero the memory */
    memset(macp, 0, sizeof(struct usbdrv_private));
#endif
                          
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0))
    usb_inc_dev_use(dev);
#endif
  
    g_magpie_usb_ifc = interface;  
    goto done;

//fail3:
    //zfLnxFreeAllUrbs(macp);
//fail2:
    //free_netdev(net);  //kernel 2.6
//fail1:
    //kfree(macp);

//fail:
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0))
    usb_put_dev(dev);
#endif
    //macp = NULL;

done:    
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0))
    return macp;
#else
    return result;
#endif  
  }

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0))
static void zfLnxDisconnect(struct usb_device *dev, void *ptr)
#else
static void zfLnxDisconnect(struct usb_interface *interface)
#endif
{
#if 0
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0))
    struct usbdrv_private *macp = (struct usbdrv_private *) usb_get_intfdata(interface);
#else
    struct usbdrv_private *macp = (struct usbdrv_private *)ptr;
#endif  
#endif

    printk("zfLnxDisconnect\n");
                          
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0))    
    usb_dec_dev_use(dev);
#else
    usb_put_dev(interface_to_usbdev(interface));
#endif

    //zfLnxClearStructs(macp->device);
    if ( g_magpie_usb_ifc != NULL ) {
        g_magpie_usb_ifc = NULL;
        HIF_USBDeviceDetached(interface, 1);
    }   
}
  
static struct usb_driver magpie_usb_driver = {
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0))
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,15))
  .owner        = THIS_MODULE,
#endif
#endif
  .name         = driver_name,
  .probe        = zfLnxProbe,
  .disconnect   = zfLnxDisconnect,
  .id_table     = magpie_ids,
};

void unload_usb()
{    
    if ( g_magpie_usb_ifc != NULL ) {
        HIF_USBDeviceDetached(g_magpie_usb_ifc, 0);
        g_magpie_usb_ifc = NULL;
    }

    usb_deregister(&magpie_usb_driver);  
}

int ath_usb_module_init(void)
{       
    usb_register(&magpie_usb_driver);
    
    return 0;
}

void
ath_usb_module_exit(void) 
{
    printk("exit ath usb called\n");
    
    g_magpie_usb_ifc = NULL;
    //usb_deregister(&magpie_usb_driver);    
}
module_init(ath_usb_module_init);
module_exit(ath_usb_module_exit);
MODULE_LICENSE("GPL");



