#include <config.h>

#include <errno.h>
#include <unistd.h>

#include <direct/build.h>
#include <direct/system.h>

#if HAVE_ASM_PAGE_H
#include <asm/page.h>
#endif

#ifndef PAGE_SIZE
#define PAGE_SIZE   sysconf( _SC_PAGESIZE )
#endif





#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include <linux/fb.h>

#include <asm/page.h>

#include <sys/mman.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <malloc.h>
#include <errno.h>

#include <directfb.h>

#include <direct/debug.h>
#include <direct/messages.h>

#include <core/gfxcard.h>


#include <core/graphics_driver.h>

DFB_GRAPHICS_DRIVER( pnx8550 )

/* FIXME: make independent from system again */
//#include <jag/jag.h>


#include "pnx8550.h"
#include "pnx8550_blt.h"


/* to align the pointer to the (next) page boundary */
//#define PAGE_SIZE 100
#define PAGE_MASK (~(PAGE_SIZE - 1))



#define PAGE_ALIGN(addr)	(((addr) + PAGE_SIZE - 1) & PAGE_MASK)

/**************************************************************************************************/

static int
driver_probe( CoreGraphicsDevice *device )
{
	 if (!access( "/dev/pnxdraw", O_RDWR ))
	      return 1;

     return 0;
}

static void
driver_get_info( CoreGraphicsDevice *device,
                 GraphicsDriverInfo *info )
{
     /* fill driver info structure */
     snprintf( info->name,
               DFB_GRAPHICS_DRIVER_INFO_NAME_LENGTH,
               "Philips PNX8550 Driver" );

     snprintf( info->vendor,
               DFB_GRAPHICS_DRIVER_INFO_VENDOR_LENGTH,
               "Denis Oliver Kropp" );

     info->version.major = 0;
     info->version.minor = 5;

     info->driver_data_size = sizeof (PNXDriverData);
     info->device_data_size = sizeof (PNXDeviceData);
}

static DFBResult
driver_init_driver( CoreGraphicsDevice  *device,
                    GraphicsDeviceFuncs *funcs,
                    void                *driver_data,
                    void                *device_data,
                    CoreDFB             *core )
{
     PNXDriverData *pdrv = driver_data;

     /* Open Drawing Engine device. */
     pdrv->draw_fd = direct_try_open( "/dev/pnxdraw", "/dev/misc/pnxdraw", O_RDWR, true );
     if (pdrv->draw_fd < 0)
          return DFB_INIT;

     /* Map shared area of device. */
     pdrv->draw_shared = mmap( NULL, PAGE_ALIGN(sizeof(PNXDrawSharedArea)),
                               PROT_READ | PROT_WRITE,
                               MAP_SHARED, pdrv->draw_fd, 0 );
     if (pdrv->draw_shared == MAP_FAILED) {
          D_PERROR( "PNX8550/Driver: Could not map Drawing Engine device!\n" );
          close( pdrv->draw_fd );
          return DFB_INIT;
     }

     /* Initialize function table. */
     funcs->EngineSync    = pnxEngineSync;
     funcs->EngineReset   = pnxEngineReset;
     funcs->EmitCommands  = pnxEmitCommands;
     funcs->CheckState    = pnxCheckState;
     funcs->SetState      = pnxSetState;
     funcs->FillRectangle = pnxFillRectangle;
     funcs->Blit          = pnxBlit;

     return DFB_OK;
}

static DFBResult
driver_init_device( CoreGraphicsDevice *device,
                    GraphicsDeviceInfo *device_info,
                    void               *driver_data,
                    void               *device_data )
{
     PNXDriverData *pdrv = driver_data;
     PNXDeviceData *pdev = device_data;

     /* fill device info */
     snprintf( device_info->name,   DFB_GRAPHICS_DEVICE_INFO_NAME_LENGTH,   "PNX8550" );
     snprintf( device_info->vendor, DFB_GRAPHICS_DEVICE_INFO_VENDOR_LENGTH, "Philips" );

     /* device limitations */
     device_info->limits.surface_byteoffset_alignment = 16;
     device_info->limits.surface_bytepitch_alignment  = 16;

     /* device capabilities */
     device_info->caps.flags    = 0;
     device_info->caps.accel    = PNX_SUPPORTED_DRAWINGFUNCTIONS |
                                  PNX_SUPPORTED_BLITTINGFUNCTIONS;
     device_info->caps.drawing  = PNX_SUPPORTED_DRAWINGFLAGS;
     device_info->caps.blitting = PNX_SUPPORTED_BLITTINGFLAGS;

     /* Allocate working buffer for workaround. */
     pdev->tmp_offset = 0; // FIXME  dfb_gfxcard_reserve_memory( device, 16 * 4096 );
     if (pdev->tmp_offset < 0) {
          D_ERROR( "PNX8543/Driver: Could not reserve working buffer (%dk)!\n", 16 * 4096 );
          return DFB_INIT;
     }

     pdev->tmp_phys = pdrv->draw_shared->phys + 4096; // FIXME  dfb_gfxcard_memory_physical( device, pdev->tmp_offset );

     pnxEngineReset( pdrv, pdev );

     return DFB_OK;
}

static void
driver_close_device( CoreGraphicsDevice *device,
                     void               *driver_data,
                     void               *device_data )
{
}

static void
driver_close_driver( CoreGraphicsDevice *device,
                     void               *driver_data )
{
     PNXDriverData *pdrv = driver_data;

     /* Unmap shared area. */
     munmap( (void*) pdrv->draw_shared, PAGE_ALIGN(sizeof(PNXDrawSharedArea)) );

     /* Close Drawing Engine device. */
     close( pdrv->draw_fd );
}

