#ifndef __PNX8550_H__
#define __PNX8550_H__

#include "pnxdraw.h"

#include <linux/fb.h>

#ifndef FB_ACCEL_PHILIPS_PNX8550
#define FB_ACCEL_PHILIPS_PNX8550 8550
#endif


#define PNXBLT_ENGINESTATUS_DEBUSY  0x00000100

#define PNXBLT_HOSTFIFOSTATUS       0x0000003F


#define PNXBLT_PSIZE_8BPP           0x00000008
#define PNXBLT_PSIZE_16BPP          0x00000010
#define PNXBLT_PSIZE_32BPP          0x00000020

#define PNXBLT_PSIZE_RGB565         0x00000000
#define PNXBLT_PSIZE_ARGB4444       0x00000100
#define PNXBLT_PSIZE_ARGB8888       0x00000000

#define PNXBLT_BLTCTL_SP            0x00001000
#define PNXBLT_BLTCTL_KEY_DST       0x00020000
#define PNXBLT_BLTCTL_KEY_SRC       0x00050000
#define PNXBLT_BLTCTL_BLEND_NORMAL  0x00100000
#define PNXBLT_BLTCTL_BLEND_PREMULT 0x00200000
#define PNXBLT_BLTCTL_BLEND_OPAQUE  0x00300000
#define PNXBLT_BLTCTL_UPDATE_DST_A  0x00400000
#define PNXBLT_BLTCTL_BLEND_BLACK   0x00800000


typedef volatile struct {
     __u32     SrcAddrBase;
     __u32     DstAddrBase;
     __u32     Psize;
     __u32     SrcLinear;
     __u32     DstLinear;
     __u32     SrcStride;
     __u32     DstStride;
     __u32     CCColor;
     __u32     SurfAlpha;
     __u32     HAlphaColor;
     __u32     BltCtl;
     __u32     SrcXY;
     __u32     DstXY;
     __u32     BltSize;
     __u32     DstXY2;
     __u32     VecConst;
     __u32     VecCount;
     __u32     TransMask;

     __u32     reserved[108];

     __u32     MonoPatFColor;
     __u32     MonoPatBColor;

     __u32     reserved2[128];

     __u32     EngineStatus;
     __u32     PanicControl;
     __u32     EngineConfig;
     __u32     HostFIFOStatus;
} PNXBLTRegs;


typedef struct {
     /* state validation */
     int            v_flags;

     /* prepared register values */
     __u32          SurfAlpha;
     __u32          HAlphaColor;
     __u32          MonoPatFColor;

     /* cached values */
     DFBSurfaceDrawingFlags  drawingflags;
     DFBSurfaceBlittingFlags blittingflags;

     DFBSurfaceBlendFunction src_blend;
     DFBSurfacePixelFormat   src_format;

     int                     tmp_offset;
     unsigned long           tmp_phys;

     int                     dest_pitch;
     unsigned long           dest_phys;

     int                     src_pitch;
     unsigned long           src_phys;

     unsigned long           src_key;
     unsigned long           src_mask;
} PNXDeviceData;

typedef struct {
     int                draw_fd;
     PNXDrawSharedArea *draw_shared;
} PNXDriverData;


#endif
