/*
  (Information filled in by ChangeSynergy:)
            %name: callbacks.h %
         %version: brg45mgr#9RR5 %
   %date_modified: Thu Apr 07 10:23:21 2011 %
      %derived_by: devcetv %
*/

#ifndef __CETVFB__CALLBACKS_H__
#define __CETVFB__CALLBACKS_H__

#define Dfb_True	(1)
#define Dfb_False	(0)

//** define the constants **//

    // Color Key Types 
#define Dfb_KeySrcColorKey              1
#define Dfb_KeyDstColorKey              2
	// Pixel Format Classes
#define Dfb_PixFmtClassYuv				0
#define Dfb_PixFmtClassRgb				1
#define Dfb_PixFmtClassClut				2
   // Pixel Format types for PixFmtClassClut
#define Dfb_PixFmtRgbClut1bpp			10
#define Dfb_PixFmtRgbClut2bpp			11
#define Dfb_PixFmtRgbClut4bpp			12
#define Dfb_PixFmtRgbClut8bpp			13
#define Dfb_PixFmtArgbClut1bpp			14
#define Dfb_PixFmtArgbClut2bpp			15
#define Dfb_PixFmtArgbClut4bpp			16
#define Dfb_PixFmtArgbClut8bpp			17
#define Dfb_PixFmtYuvClut1bpp			18
#define Dfb_PixFmtYuvClut2bpp			19
#define Dfb_PixFmtYuvClut4bpp			20
#define Dfb_PixFmtYuvClut8bpp			21
#define Dfb_PixFmtAyuvClut1bpp			22
#define Dfb_PixFmtAyuvClut2bpp			23
#define Dfb_PixFmtAyuvClut4bpp			24
#define Dfb_PixFmtAyuvClut8bpp			25
     // Pixel Format Types for PixFmtClassRgb
#define Dfb_PixFmtXrgb1555				30
#define Dfb_PixFmtArgb1555				31
#define Dfb_PixFmtXrgb4444				32
#define Dfb_PixFmtArgb4444				33
#define Dfb_PixFmtRgb565				34
#define Dfb_PixFmtXrgb8888				35
#define Dfb_PixFmtArgb8888				36
    // Pixel Format types for PixFmtClassYuv
#define Dfb_PixFmtUyvy					40
#define Dfb_PixFmtYuy2					41
#define Dfb_PixFmtVyuy					42
#define Dfb_PixFmtYuv420                                43

typedef struct _CETVFBMemArea {
    void         *start;
    unsigned int  length;
} CETVFBMemArea;

//** define the function list structure **//
typedef struct {
    void (*GetOutputProperties) ( unsigned long *pwidth, unsigned long *pheight, unsigned long *pfieldrate, int /*bool*/ *pprogressive );
    unsigned long (*GetSuppNrKeys)      ( int gfxlayer );
    void (*SetKey)                      ( int gfxlayer, unsigned long keynr, unsigned long keytype, unsigned long lowercolor, unsigned long uppercolor);
    void (*EnableKey)                   ( int gfxlayer, unsigned long keynr, int enable );
    int  (*SetBuffer)                   ( int gfxlayer, unsigned long width, unsigned long height, unsigned long stride, unsigned long  fmtclass, unsigned long  fmttype, void *pbuf );
    void (*SetClut)                     ( int gfxlayer, unsigned long nrentries, unsigned long *clut );
    void (*GetMinWindowSize)            ( int gfxlayer, unsigned long *pwidth, unsigned long *pheight );
    void (*GetMaxLayerWindowSize)       ( int gfxlayer, unsigned long *pwidth, unsigned long *pheight );
    void (*SetLayerWindow)              ( int gfxlayer, int ul_x, int ul_y, int lr_x, int lr_y );
    void (*SetDstWindow)                ( int gfxlayer, int ul_x, int ul_y, int lr_x, int lr_y );
    void (*SetSrcWindow)                ( int gfxlayer, int ul_x, int ul_y, int lr_x, int lr_y);
    void (*SetScaleMode)                ( int gfxlayer, unsigned long mode );
    void (*HideLayer)                   ( int gfxlayer, int hide );
    void (*ActivateNewWindowSettings)   ( int gfxlayer, int sync, unsigned long millisec );
    void (*SetGraphicLayerMode)         ( int gfxlayer, unsigned long layermode );
    void (*AcceleratedCopy)( unsigned long SrcAddr, unsigned long DstAddr, int ul_x, int ul_y, int lr_x, int lr_y, int dst_x, int dst_y );

    /* we need to know how large and where the system shared (aka video) memory is, to do the 'mmap' */
    void (*GetSharedMemoryLocation) ( CETVFBMemArea* uncached, CETVFBMemArea* cached, CETVFBMemArea* bis );

    /* callbacks for surface memory storage (physical addresses inside system shared memory)
     * resource_id is either: an ID provided by the window creator (e.g. tv),
     *                        a layer ID provided by the system module. this is 2000,2001 or 2002.
     * This will be used by PRODUCT and TEST CODE.
     * For Acquire, server code is the same for both.
     * For Release, PRODUCT will need resource_id and size again to Release.
     * For Release, TEST CODE will have an invalid resource_id -> address is used for call to Free.
     * In both cases, resource_id and size is used to recognize whether it's PRODUCT or TEST CODE.
     * (in principle, the offset of the address could be used to determine this and the resource_id but
     *  that's a bit of a kludge)
     */
    void* (*MemoryAcquire) ( unsigned long resource_id, int size );                /* retval: correct value or 0 */
    int   (*MemoryRelease) ( unsigned long resource_id, int size, void* address ); /* retval: Dfb_True or Dfb_False */

    void  (*SetNatMotionWindow) ( int gfxlayer, int ul_x, int ul_y, int lr_x, int lr_y, int enable );
    
    int  (*SetLevel) ( int gfxlayer, int level );
    int  (*GetLevel) ( int gfxlayer, int *ret_level );

} CETVFBCallBackTable;



// Prototypes //

void Dfb_RegisterCetvCallBackTable( CETVFBCallBackTable cetvfbfct );

#endif
