/*
   (c) Copyright 2000-2002  convergence integrated media GmbH.
   (c) Copyright 2002-2004  convergence GmbH.

   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Hundt <andi@fischlustig.de>,
              Sven Neumann <neo@directfb.org> and
              Ville Syrjl <syrjala@sci.fi>.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __CETVFB__PRIMARY_H__
#define __CETVFB__PRIMARY_H__

#include "cetvfb.h"
#include "callbacks.h"

#include <core/layers.h>
#include <core/screens.h>

extern ScreenFuncs       cetvfbPrimaryScreenFuncs;
extern DisplayLayerFuncs cetvfbPrimaryLayerFuncs;


typedef struct {
     CETVFBLayerData            *layerData;
     CoreLayerRegionConfig       config;
     CoreLayerRegionConfigFlags  updated;
     CoreSurface                *surface;
     CorePalette                *palette;
} CETVFBSetRegionData;

typedef struct {
     CETVFBLayerData            *layerData;
     DFBRegion                   region;
     CoreSurfaceBufferLock      *lock;
} CETVFBUpdateScreenData;

typedef struct {
     CETVFBLayerData            *layerData;
     CorePalette                *palette;
} CETVFBSetPaletteData;

typedef struct
{
    int gfxlayer;
    int ul_x;
    int ul_y;
    int lr_x;
    int lr_y;
    bool enable;
} CETVFBNatMotionWdwData;

typedef struct {
     CETVFBLayerData            *layerData;
     int                         level;
} CETVFBSetGetLevelData;

DFBResult dfb_cetvfb_set_region_handler   ( CETVFBSetRegionData    *data );

DFBResult dfb_cetvfb_update_screen_handler( CETVFBUpdateScreenData *data );

DFBResult dfb_cetvfb_set_palette_handler  ( CETVFBSetPaletteData   *data );

DFBResult dfb_cetvfb_remove_region_handler( CETVFBLayerData        *data );

DFBResult dfb_cetvfb_set_nat_motion_handler( CETVFBNatMotionWdwData *data );

DFBResult dfb_cetvfb_set_level_handler     ( CETVFBSetGetLevelData *data );

DFBResult dfb_cetvfb_get_level_handler     ( CETVFBSetGetLevelData *data );

/* this is used 'internally' in the system module,
 * to pass the pointers to other components (such as cetvfb.c or cetvfb_surfacepool.c) */
CETVFBCallBackTable dfb_cetvfb_get_callbacks( );

#endif

