/// Filename: pnxdraw.h   - Drawing Engine driver for pnx8550 sdk
// Description: This file contains defines accessing "pnxdraw" driver
// Author: Denis Oliver Kropp

#ifndef __PNXDRAW_H__
#define __PNXDRAW_H__


#define PNXDRAW_HEADER_SETUP_DESTINATION     0x01
#define PNXDRAW_HEADER_SETUP_SOURCE          0x02
#define PNXDRAW_HEADER_SETUP_KEY             0x03
#define PNXDRAW_HEADER_EXECUTE_FILL          0x11
#define PNXDRAW_HEADER_EXECUTE_BLIT          0x12
#define PNXDRAW_HEADER_EXECUTE_BLIT_BLEND    0x13


typedef volatile struct {
     u32                    header;

     u32                    addr;
     u32                    stride;

     u32                    psize;
} PNXDrawSetupDestination;


typedef volatile struct {
     u32                    header;

     u32                    addr;
     u32                    stride;
} PNXDrawSetupSource;


typedef volatile struct {
     u32                    header;

     u32                    cccolor;
     u32                    transmask;
} PNXDrawSetupKey;


typedef volatile struct {
     u32                    header;

     u32                    bltctl;
     u32                    color;

     u32                    xy;
     u32                    size;
} PNXDrawExecuteFill;


typedef volatile struct {
     u32                    header;

     u32                    bltctl;

     u32                    srcxy;
     u32                    dstxy;
     u32                    size;
} PNXDrawExecuteBlit;


typedef volatile struct {
     u32                    header;

     u32                    bltctl;

     u32                    color;

     u32                    srcxy;
     u32                    dstxy;
     u32                    size;
} PNXDrawExecuteBlitBlend;


typedef volatile union {
     u32                    header;

     PNXDrawSetupDestination  dest;
     PNXDrawSetupSource       source;
     PNXDrawSetupKey          key;

     PNXDrawExecuteFill       fill;
     PNXDrawExecuteBlit       blit;
     PNXDrawExecuteBlitBlend  blit_blend;
} PNXDrawPacket;



#define PNXDRAW_STATE_ACTIVE  0x00000001

#define PNXDRAW_NUM_PACKETS   128
#define PNXDRAW_INDEX_MASK    (PNXDRAW_NUM_PACKETS-1)

typedef volatile struct {
     unsigned long            phys;

     u32                    state;

     struct {
          u32               index;
          u32               age;
     } read;

     struct {
          u32               index;
          u32               age;
     } write;

     PNXDrawPacket            packets[PNXDRAW_NUM_PACKETS];
} PNXDrawSharedArea;



#define PNXDRAW_IOCTL_RESET        _IO ( 'D', 0 )
#define PNXDRAW_IOCTL_CONTINUE     _IO ( 'D', 1 )
#define PNXDRAW_IOCTL_WAITIDLE     _IO ( 'D', 2 )
#define PNXDRAW_IOCTL_WAITDONE     _IOR( 'D', 3, u32 )


#endif

