/// Filename: pnxdraw.h   - Drawing Engine driver for pnx8550 sdk
// Description: This file contains defines accessing "pnxdraw" driver
// Author: Denis Oliver Kropp

#ifndef __PNXDRAW_H__
#define __PNXDRAW_H__


#define PNXDRAW_HEADER_SETUP_DESTINATION     0x01
#define PNXDRAW_HEADER_SETUP_SOURCE          0x02
#define PNXDRAW_HEADER_SETUP_KEY             0x03
#define PNXDRAW_HEADER_EXECUTE_FILL          0x11
#define PNXDRAW_HEADER_EXECUTE_BLIT          0x12
#define PNXDRAW_HEADER_EXECUTE_BLIT_BLEND    0x13


typedef volatile struct {
     __u32                    header;

     __u32                    addr;
     __u32                    stride;

     __u32                    psize;
} PNXDrawSetupDestination;


typedef volatile struct {
     __u32                    header;

     __u32                    addr;
     __u32                    stride;
} PNXDrawSetupSource;


typedef volatile struct {
     __u32                    header;

     __u32                    cccolor;
     __u32                    transmask;
} PNXDrawSetupKey;


typedef volatile struct {
     __u32                    header;

     __u32                    bltctl;
     __u32                    color;

     __u32                    xy;
     __u32                    size;
} PNXDrawExecuteFill;


typedef volatile struct {
     __u32                    header;

     __u32                    bltctl;

     __u32                    srcxy;
     __u32                    dstxy;
     __u32                    size;
} PNXDrawExecuteBlit;


typedef volatile struct {
     __u32                    header;

     __u32                    bltctl;

     __u32                    color;

     __u32                    srcxy;
     __u32                    dstxy;
     __u32                    size;
} PNXDrawExecuteBlitBlend;


typedef volatile union {
     __u32                    header;

     PNXDrawSetupDestination  dest;
     PNXDrawSetupSource       source;
     PNXDrawSetupKey          key;

     PNXDrawExecuteFill       fill;
     PNXDrawExecuteBlit       blit;
     PNXDrawExecuteBlitBlend  blit_blend;
} PNXDrawPacket;



#define PNXDRAW_STATE_ACTIVE  0x00000001

#define PNXDRAW_NUM_PACKETS   128
#define PNXDRAW_INDEX_MASK    (PNXDRAW_NUM_PACKETS-1)

typedef volatile struct {
     unsigned long            phys;

     __u32                    state;

     struct {
          __u32               index;
          __u32               age;
     } read;

     struct {
          __u32               index;
          __u32               age;
     } write;

     PNXDrawPacket            packets[PNXDRAW_NUM_PACKETS];
} PNXDrawSharedArea;



#define PNXDRAW_IOCTL_RESET        _IO ( 'D', 0 )
#define PNXDRAW_IOCTL_CONTINUE     _IO ( 'D', 1 )
#define PNXDRAW_IOCTL_WAITIDLE     _IO ( 'D', 2 )
#define PNXDRAW_IOCTL_WAITDONE     _IOR( 'D', 3, __u32 )


#endif

