#define _XOPEN_SOURCE 500
#include <unistd.h>
#include <stdio.h>

static int cuser, cnice, csystem, cidle, ctotal;
static int puser, pnice, psystem, pidle, ptotal;
static int duser, dnice, dsystem, didle, dtotal;

static int
read_stat()
{
     char  dummy[4];
     FILE *file;

     puser   = cuser;
     pnice   = cnice;
     psystem = csystem;
     pidle   = cidle;
     ptotal  = ctotal;

     file = fopen( "/proc/stat", "r" );
     if (!file) {
          perror( "Could not open '/proc/stat'" );
          return 0;
     }

     if (fscanf( file, "%3s %d %d %d %d", dummy, &cuser, &cnice, &csystem, &cidle ) < 4) {
          fprintf( stderr, "Parsing '/proc/stat' failed!\n" );
          return 0;
     }

     fclose( file );

     ctotal  = cuser + cnice + csystem + cidle;

     duser   = cuser - puser;
     dnice   = cnice - pnice;
     dsystem = csystem - psystem;
     didle   = cidle - pidle;
     dtotal  = ctotal - ptotal;

     return 1;
}

int
main( int argc, char *argv[] )
{
     unsigned int cycle      = 0;
     int          interval   = 1000000;
     char         symbols[4] = { '-', '\\', '|', '/' };

     if (argc > 1) {
          float val;

          if (sscanf( argv[1], "%f", &val ) != 1) {
               fprintf( stderr, "Usage: %s [interval]\n", argv[0] );
               return 0;
          }

          interval = 1000000 * val;
     }

     if (!read_stat())
          return 0;

     usleep( 200000 );

     while (read_stat()) {
          int u = duser * 100 / dtotal;
          int n = dnice * 100 / dtotal;
          int s = dsystem * 100 / dtotal;
          int i = didle * 100 / dtotal;

          printf( "    user %3d%% | nice %3d%% | system %3d%% | idle %3d%%   (%c)\r",
                  u, n, s, i, symbols[cycle++&3] );

          fflush( stdout );

          usleep( interval );
     }

     return 0;
}

