#include <directfb.h>


/**************************************
* Local macros/typedef
**************************************/
#define WIN_W                     720
#define WIN_H                     576
//#define DEFAULT_FNT               "decker.ttf"
//#define DEFAULT_FNT1               "AkhbarOTS_Grey.ttf"
#define DEFAULT_FNT1               "PHLSC4.otp"
#define DEFAULT_FNT2               "PHLSC4.ltt"




#define DFBCHECK(x...)                           \
do {                                             \
  DFBResult err;                                 \
  err = x;                                       \
  if (err != DFB_OK) {                           \
    printf ("Fail!! err!=DFB_OK");               \
    DirectFBError (#x, err);                     \
  }                                              \
} while(0);

/***************************************
* Local data
***************************************/
static IDirectFB             *dfb;


/***************************************
* Local procedures
***************************************/
int main (int argc, char *argv[])
{
	IDirectFBDisplayLayer         *layer;
	DFBWindowDescription          wdesc;
	IDirectFBWindow               *gwindow;
    IDirectFBSurface              *gsurface;
    DFBFontDescription            fontdesc;
    IDirectFBFont                 *font1, *font2;
	char                          fontname[128];
	char                          text1[256];
	char                          text2[256];
    char                          text3[256];
    char                          text4[256];
	int                           tw,th;
    int                           outline_width     = 0x10000*4;
    int                           outline_opacity   = 0x10000;

    DFBColorID                    ids[2]    = {	DCID_PRIMARY, DCID_OUTLINE };
    DFBColor                      colors[2] = {	{ 0xff,    0xFF, 0xFF, 0xFF },
												{ 0xff,    0x40, 0x70, 0xb0 } };

    /* DirectFB init */
	DFBCHECK(DirectFBInit( (void*)&argc, (void*)&argv ));
	DFBCHECK(DirectFBCreate( &dfb ));

	/* Obtain the layer */
	DFBCHECK(dfb->GetDisplayLayer(dfb, DLID_PRIMARY, &layer));

	/* Setup the Graphical window */
	wdesc.flags  = (DFBWindowDescriptionFlags)( DWDESC_POSX | DWDESC_POSY | DWDESC_WIDTH | DWDESC_HEIGHT 
					| DWDESC_OPTIONS | DWDESC_PIXELFORMAT | DWDESC_STACKING);
	wdesc.posx   = 0;
	wdesc.posy   = 0;
	wdesc.width  = WIN_W;
	wdesc.height = WIN_H;
	wdesc.pixelformat = DSPF_RGB16;
	wdesc.stacking  = DWSC_MIDDLE;
	wdesc.options   = DWOP_NONE;
	DFBCHECK(layer->CreateWindow(layer, &wdesc, &gwindow));
	DFBCHECK(gwindow->GetSurface(gwindow, &gsurface));
    DFBCHECK(gsurface->Clear( gsurface, 0x00, 0x00, 0xff, 0xff ));

	/* Create font1 and set text string1*/
    strncpy (fontname, DEFAULT_FNT1, sizeof(fontname) );
//    strncpy (text, "Hello World!", sizeof(text) );
    strncpy (text1, "﻿هذه هي بعض العينات النص العربي.", sizeof(text1) );
    strncpy (text3, "﻿LATINهذه هي بعض العينات النص العربي.", sizeof(text3) );
    strncpy (text4, "هذه هي بعض العينات النص العربي.LATIN", sizeof(text4) );
//	fontdesc.flags       = DFDESC_HEIGHT | DFDESC_ATTRIBUTES;
	fontdesc.flags       = DFDESC_HEIGHT | DFDESC_ATTRIBUTES | DFDESC_ROTATION;
    fontdesc.rotation    = DFB_DEGREES(0); //DFB_DEGREES( 20.0 );
	fontdesc.attributes  = DFFA_NONE;
	fontdesc.height      = 20;
    fontdesc.attributes      |= DFFA_OUTLINED;
    fontdesc.flags           |= DFDESC_OUTLINE_WIDTH | DFDESC_OUTLINE_OPACITY;
    fontdesc.outline_width    = outline_width;
    fontdesc.outline_opacity  = outline_opacity;
	DFBCHECK(dfb->CreateFont(dfb, fontname, &fontdesc, &font1));


	/* Create font2 and set text string2*/
    strncpy (fontname, DEFAULT_FNT2, sizeof(fontname) );
//    strncpy (text, "Hello World!", sizeof(text) );
    strncpy (text2, "﻿هذه هي بعض العينات النص العربي.", sizeof(text2) );
	DFBCHECK(dfb->CreateFont(dfb, fontname, &fontdesc, &font2));
	
	
	/* Set window opacity and request focus */
	DFBCHECK(gwindow->SetOpacity( gwindow, 0xFF ));
    DFBCHECK(gwindow->RequestFocus( gwindow ));

    /* Draw the text 1 */
	DFBCHECK(gsurface->SetFont (gsurface, font1));
	DFBCHECK(font1->GetHeight  (font1, &th));
	DFBCHECK(font1->GetStringWidth  (font1, text1, -1, &tw));
    DFBCHECK(gsurface->SetColor (gsurface, 0xff, 0xff, 0xff,  0xff)); // White
 //   DFBCHECK(gsurface->SetColors (gsurface, ids, colors, 2));
	if ( fontdesc.rotation == DFB_DEGREES( 90.0 ) )
	{
	  DFBCHECK(gsurface->DrawString (gsurface,text1, -1, (WIN_W-th)/2, (WIN_H-th)/2, DSTF_TOPLEFT| DSTF_OUTLINE ));
	}
	else
	{
	  DFBCHECK(gsurface->DrawString (gsurface,text1, -1, (WIN_W-tw)/2, (WIN_H-th)/2, DSTF_TOPLEFT| DSTF_OUTLINE ));
	}
	if ( fontdesc.rotation == DFB_DEGREES( 90.0 ) )
	{
	  DFBCHECK(gsurface->DrawString (gsurface,text3, -1, (WIN_W-th)/2, (WIN_H-th)/2 + 50, DSTF_TOPLEFT| DSTF_OUTLINE ));
	}
	else
	{
	  DFBCHECK(gsurface->DrawString (gsurface,text3, -1, (WIN_W-tw)/2, (WIN_H-th)/2 + 50, DSTF_TOPLEFT| DSTF_OUTLINE ));
	}
    	if ( fontdesc.rotation == DFB_DEGREES( 90.0 ) )
	{
	  DFBCHECK(gsurface->DrawString (gsurface,text4, -1, (WIN_W-th)/2, (WIN_H-th)/2 + 100, DSTF_TOPLEFT| DSTF_OUTLINE ));
	}
	else
	{
	  DFBCHECK(gsurface->DrawString (gsurface,text4, -1, (WIN_W-tw)/2, (WIN_H-th)/2 + 100, DSTF_TOPLEFT| DSTF_OUTLINE ));
	}
	
    /* Draw the text 2*/
	DFBCHECK(gsurface->SetFont (gsurface, font2));
	DFBCHECK(font1->GetHeight  (font2, &th));
	DFBCHECK(font1->GetStringWidth  (font2, text2, -1, &tw));
    DFBCHECK(gsurface->SetColor (gsurface, 0xff, 0xff, 0xff,  0xff)); // White
 //   DFBCHECK(gsurface->SetColors (gsurface, ids, colors, 2));
	if ( fontdesc.rotation == DFB_DEGREES( 90.0 ) )
	{
	  DFBCHECK(gsurface->DrawString (gsurface,text2, -1, (WIN_W-th)/2, (WIN_H-th)/2 + 150, DSTF_TOPLEFT| DSTF_OUTLINE ));
	}
	else
	{
	  DFBCHECK(gsurface->DrawString (gsurface,text2, -1, (WIN_W-tw)/2, (WIN_H-th)/2 + 150, DSTF_TOPLEFT| DSTF_OUTLINE ));
	}
	
	
	
	
	
	
	
	
	
    /* Show it for 5 seconds! */
	DFBCHECK(gsurface->Flip( gsurface, NULL, DSFLIP_NONE ));
    sleep(20);
    while ( 1 )
    {
        sleep(2);
    }

    /* Exit */
	if (dfb)
		DFBCHECK(dfb->Release( dfb ));

    return 1;	
}

