#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>

#include <direct/messages.h>

#define CHK(x) \
     do {                                              \
          if ((x) < 0) {                               \
               D_PERROR( "Failure at '%s'!\n", #x );   \
               return -1;                              \
          }                                            \
     } while (0)

#define OUTER_SIZE   (1024*1024)
#define INNER_SIZE   ( 512*1024)
#define INNER_OFFSET ( 256*1024)

int
main( int argc, char *argv[] )
{
     int  i;
     int  ofd;
//     int  ifd;
     u8  *map;
//     u8  *tmp;

     CHK( ofd = open( "outer.tst", O_CREAT | O_RDWR, 0644 ) );

     map = mmap( NULL, OUTER_SIZE, PROT_READ | PROT_WRITE, MAP_SHARED, ofd, 0 );
     if (map == MAP_FAILED) {
          D_PERROR( "mmap() on outer file failed!\n" );
          return -1;
     }

     CHK( ftruncate( ofd, 1024 * 1024 ) );


/*     CHK( ifd = open( "inner.tst", O_CREAT | O_RDWR, 0644 ) );
     CHK( ftruncate( ifd,  512 * 1024 ) );

     munmap( map + INNER_OFFSET, INNER_SIZE );

     tmp = mmap( map + INNER_OFFSET, INNER_SIZE, PROT_READ | PROT_WRITE, MAP_SHARED, ifd, 0 );
     if (tmp == MAP_FAILED) {
          D_PERROR( "mmap() on inner file failed!\n" );
          return -1;
     }

     close( ifd );
*/

     for (i=0; i<OUTER_SIZE; i++)
          map[i] = 0xff;

//     madvise( map + INNER_OFFSET, INNER_SIZE, MADV_DONTNEED );
//     munlock( map + INNER_OFFSET, INNER_SIZE );
     madvise( map + INNER_OFFSET, INNER_SIZE, 9 );

//     CHK( munmap( tmp, INNER_SIZE ) );
     CHK( munmap( map, OUTER_SIZE ) );


     close( ofd );

     return 0;
}
