/*
 * (C) Copyright 2000-2003
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * Misc boot support
 */
#include <common.h>
#include <command.h>
#include <net.h>
#include <asm/io.h>
#include <linux/string.h>

/* Allow ports to override the default behavior */
__attribute__((weak))
unsigned long do_go_exec (ulong (*entry)(int, char *[]), int argc, char *argv[])
{
	return entry (argc, argv);
}

int do_go (cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	ulong	addr, rc;
	int     rcode = 0;

	if (argc < 2) {
		printf ("Usage:\n%s\n", cmdtp->usage);
		return 1;
	}

	addr = simple_strtoul(argv[1], NULL, 16);

	printf ("## Starting application at 0x%08lX ...\n", addr);

#ifdef CONFIG_TV52X	
{
	uchar *linux_cmdline = NULL;
    uchar *macaddr = NULL;
    unsigned long len,len1,len2;
    uchar new_cmdline[1024];
    
	/*
	 * Hack: Linux on PNX8543 expects the command line to
	 * be passed by a pointer to it in the SCRATCH_6 register.	This is about
	 * as non-standard as you can get.
	 */
	linux_cmdline = (uchar *)getenv("cmdline"); 
	if (linux_cmdline == NULL) {
		// Use default?
		printf(".....No cmdline is passed\n");
        writel(0, (IP0126 + 0x0518));
    } else {
        macaddr = (uchar *)getenv("ethaddr");  
        if(macaddr == NULL) {
	 sprintf( new_cmdline,  "%s", linux_cmdline );
        } else {
            sprintf( new_cmdline, "%s 6300mac=%s", linux_cmdline, macaddr);
        }        
        writel( (unsigned int)new_cmdline, (IP0126 + 0x0518) );
        printf( "to %x, linux_cmdline=%x(%s)\n", (IP0126 + 0x0518), (unsigned int)new_cmdline, new_cmdline);
    }        
}
#endif

	/*
	 * pass address parameter as argv[0] (aka command name),
	 * and all remaining args
	 */
	rc = do_go_exec ((void *)addr, argc - 1, argv + 1);
	if (rc != 0) rcode = 1;

	printf ("## Application terminated, rc = 0x%lX\n", rc);
	return rcode;
}

extern int dsp_stop(int);
extern int dsp_start(int, unsigned int);

int do_dsp_go(
	cmd_tbl_t*	cmdtp,
	int 		flag,
	int 		argc,
	char*		argv[])
{
	int		cpu;
	unsigned int	addr;

	if (argc < 3) {
		printf ("Usage:\n%s\n", cmdtp->usage);
		return 1;
	}

	cpu = simple_strtoul(argv[1], NULL, 10);
	mydebug("cpu=%d\n", cpu);

	addr = simple_strtoul(argv[2], NULL, 16);
	mydebug("start_addr=0x%08x\n", addr);

	/* hand over to the single processor go.. */
	//if (cpu == CFG_CPU)
	//	return (do_go(cmdtp, flag, --argc, &argv[1]));

	mydebug("## Starting application at 0x%08X on cpu %d...\n", addr, cpu);

//#ifdef CFG_CPU_STOP_BEFORE_GO
	/* stop specified cpu */
	if (dsp_stop(cpu)) {
		printf("ERROR: could not stop cpu %d\n", cpu);
		return (~0);
	}
//#endif

	/* set start address on specified cpu and kick it! */
	if (dsp_start(cpu, addr)) {
		printf("ERROR: could not start cpu %d @ 0x%08x\n",
			cpu, addr);
		return (~0);
	}

	return (0);
}

#ifdef CONFIG_STANDBY_SLAVE_ADDR
extern int send_signal(void);

int do_disable_watchdog (cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	send_signal();
}

U_BOOT_CMD(
	diswdog, 1,	0,	do_disable_watchdog,
	"diswdog\t- disable watchdog in standby.\n",
	NULL
);
#endif


/* -------------------------------------------------------------------- */

U_BOOT_CMD(
	go, CONFIG_SYS_MAXARGS, 1,	do_go,
	"go      - start application at address 'addr'\n",
	"addr [arg ...]\n    - start application at address 'addr'\n"
	"      passing 'arg' as arguments\n"
);

extern int do_reset (cmd_tbl_t *cmdtp, int flag, int argc, char *argv[]);

U_BOOT_CMD(
	reset, 1, 0,	do_reset,
	"reset   - Perform RESET of the CPU\n",
	NULL
);

U_BOOT_CMD(
	dspgo, CONFIG_SYS_MAXARGS, 2,	do_dsp_go,
	"dspgo\n"
	"        - start applications on specified start address\n",
	"addr\n"
	"        - start address of cpu, these must be 64 byte aligned\n"
);

