/*
 * (C) Copyright 2000, 2001
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 */

/*
 * Support for additional commands to send signal or information towards
 * standby.
 *
 * #define CONFIG_CMD_SIGNAL_GPIO
 *
 */

#include <common.h>
#include <config.h>
#include <command.h>
#include <i2c.h>


#ifdef CONFIG_CMD_SIGNAL_GPIO
int do_signal (cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	uchar i2cMsgBuf[6] = 
	{ 
		0x00,		// message type and invoke id
		0xe9, 0x03, 	// rpc funcid
		0x02,		// parameter length
		0x00, 0x00, 	// optional parameters
	};
	int	msglen = sizeof(i2cMsgBuf);
	int ret = -1;
	unsigned int signo = -1;

	if (argc != 2) {
		printf("Usage: signal <signo>\n");
		return -1;
	}

	// signo is decimal
	signo = (unsigned int)simple_strtoul(argv[1], 0, 10);
	i2cMsgBuf[4] = (uchar) (signo & 0xFF);
	i2cMsgBuf[5] = (uchar) (signo >> 8);

	{
		int i;
		puts("Sending: ");
		for (i=0; i<msglen; i++) 
			printf("%02x ", i2cMsgBuf[i]);
		puts("\n");
	}
	ret = i2c_write(CONFIG_STANDBY_SLAVE_ADDR, 0, 0, i2cMsgBuf, msglen);
	if (ret) {
		printf("Send signal %d FAILED!\n", signo);
		return 1;
	}

	return ret;
}


int do_setgpio(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	uchar i2cMsgBuf[6] = 
	{ 
		0x00,		// message type and invoke id
		0x04, 0x00, 	// rpc funcid
		0x02,		// parameter length
		0x00, 0x00, 	// optional parameters
	};
	int	msglen = sizeof(i2cMsgBuf);
	int ret = -1;
	unsigned char pin = 0xff;
	unsigned char val = 0xff;
	
	if (argc != 3) {
		printf("Usage: setgpio <pin> <value>\n");
		return -1;
	}

	pin = (unsigned char)simple_strtoul(argv[1], 0, 16);
	val = (unsigned char)simple_strtoul(argv[2], 0, 16);
	mydebug("setgpio <%x> <%x>\n", pin, val);

	switch (val) {
		case 0:
		case 1:
			i2cMsgBuf[4] = pin;
			i2cMsgBuf[5] = val;
	
			{
				int i;
				puts("Sending: ");
				for (i=0; i<msglen; i++) 
					printf("%02x ", i2cMsgBuf[i]);
				puts("\n");
			}

			ret = i2c_write(CONFIG_STANDBY_SLAVE_ADDR, 0, 0, i2cMsgBuf, msglen);
			if (ret) {
				puts("Send setgpio message FAILED!\n");
				return 1;
			}
			break;

		default:
			puts("Value is not correct. Only 0 and 1 are allowed.\n");
			ret = -1;
			break;
	}
	
	return ret;
}


U_BOOT_CMD(
    signal,    CONFIG_SYS_MAXARGS,    1,     do_signal,
    "signal <signo> (decimal)\n",
    "<signo> - send pre-defined signal <signo> (decimal) to sby.\n"
);

U_BOOT_CMD(
    setgpio,    CONFIG_SYS_MAXARGS,    1,     do_setgpio,
    "setgpio <pin>(hex) <value>\n",
    "- set standby gpio pin <pin> to <value>.\n"
    "          <pin> is hex number; <value> can be 0 or 1.\n"
);
#endif
