/* XXX */

#define	DEBUG	0

#include <config.h>

#if defined(CONFIG_CMD_SARI)

#include <common.h>
#include <command.h>
#include <malloc.h>

#define	OP_CMP	0
#define	OP_ADD	1
#define	OP_SUB	2
#define	OP_LT	3
#define	OP_GT	4

#define	VAL_HEX	0
#define	VAL_DEC	1
#define	VAL_STR	2

int
cmd_get_op_type(
	char*	arg)
{
 	if (!strncmp(arg, "scmp", 4))
 		return (OP_CMP);
	if (!strncmp(arg, "sadd", 4))
		return (OP_ADD);
	if (!strncmp(arg, "ssub", 4))
		return (OP_SUB);
// 	if (!strncmp(arg, "slt", 3))
// 		return (OP_LT);
// 	if (!strncmp(arg, "sgt", 3))
// 		return (OP_GT);
	return (-1);
}

int
cmd_get_data_type(
	char*	arg,
	int	default_type)
{
	int len = strlen(arg);

#if DEBUG
	printf("%s: argv[0]=\"%s\"\n", __FUNCTION__, arg);
#endif	/* DEBUG */

	if (len > 2 && arg[len-2] == '.') {
		switch(arg[len-1]) {
		case 'h':
			return VAL_HEX;
		case 'd':
			return VAL_DEC;
 		case 's':
 			return VAL_STR;
		default:
			return -1;
		}
	}
	return default_type;
}


int
do_simple_arithmetic(
	cmd_tbl_t*	cmdtp,
	int		flag,
	int 		argc,
	char*		argv[])
{
	char*		env_res;
	unsigned int	res;
	int		optype;
	int		valtype;
	unsigned long	val1;
	unsigned long	val2;

	val1 = val2 = 0;

	optype = cmd_get_op_type(argv[0]);
	valtype = cmd_get_data_type(argv[0], VAL_STR);
#if DEBUG
	printf("%s: optype=%d, valtype=%d\n", __FUNCTION__, optype, valtype);
#endif	/* DEBUG */

	/* check for valid 'opcode', value type and argument count */
 	if (	(argc < 3) ||
		(optype < 0) ||
		(valtype < 0)) {
		printf ("Usage:\n%s\n", cmdtp->usage);
		return (1);
	}

	switch (valtype) {
	case VAL_HEX:
		val1 = simple_strtoul(argv[1], NULL, 16);
		val2 = simple_strtoul(argv[2], NULL, 16);
		break;
	case VAL_DEC:
		val1 = simple_strtoul(argv[1], NULL, 10);
		val2 = simple_strtoul(argv[2], NULL, 10);
		break;
	case VAL_STR:
		break;
	default:
		printf ("Usage:\n%s\n", cmdtp->usage);
		return (1);
	}

#if DEBUG
	printf("%s: val1=%d, val2=%d\n", __FUNCTION__, val1, val2);
#endif	/* DEBUG */

	switch (optype) {
	case OP_CMP:
		if (valtype == VAL_STR)
			return (strcmp(argv[1], argv[2]) == 0 ? 0 : 1);
		else
			return (val1 == val2 ? 0 : 1);
	case OP_ADD:
		if (valtype == VAL_STR) {
			printf ("Usage:\n%s\n", cmdtp->usage);
			return (1);
		}
		res = val1 + val2;
		break;
	case OP_SUB:
		if (valtype == VAL_STR) {
			printf ("Usage:\n%s\n", cmdtp->usage);
			return (1);
		}
		res = val1 - val2;
		break;
// 	case OP_LT:
// 		return (val1 < val2 ? 0 : 1);
// 	case OP_GT:
// 		return (val1 > val2 ? 0 : 1);
	default:
		printf ("Usage:\n%s\n", cmdtp->usage);
		return (1);
	}

	env_res = (char*)malloc(10 + 1);
	sprintf(env_res, "0x%.8x", res);
	setenv("result", env_res);
	free(env_res);

	return (0);
}

U_BOOT_CMD(
	scmp, 3, 0, do_simple_arithmetic,
	"scmp    - compare stuff\n",
	"[.h, .d, .s] arg1 arg2\n"
	"    - compare two (hexa)decimals or strings\n"
);

U_BOOT_CMD(
	sadd, 3, 0, do_simple_arithmetic,
	"sadd    - simple arithmetic addition\n",
	"[.h, .d] arg1 arg2\n"
	"    - stores arg1+arg2 in ${result}\n"
);

U_BOOT_CMD(
	ssub, 3, 0, do_simple_arithmetic,
	"ssub    - simple arithmetic subtraction\n",
	"[.h, .d] arg1 arg2\n"
	"    - stores arg1-arg2 in ${result}\n"
);

// U_BOOT_CMD(
// 	slt, 3, 0, do_simple_arithmetic,
// 	"slt    - less than..?\n",
// 	"[.h, .d] arg1 arg2\n"
// 	"    - returns arg1<arg2\n"
// );

// U_BOOT_CMD(
// 	sgt, 3, 0, do_simple_arithmetic,
// 	"sgt    - greater than..?\n",
// 	"[.h, .d] arg1 arg2\n"
// 	"    - returns arg1>arg2\n"
// );

#endif	/* CFG_CMD_SARI */
