/*
 * (C) Copyright 2002
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * (C) Copyright 2002
 * Robert Schwebel, Pengutronix, <r.schwebel@pengutronix.de>
 *
 * (C) Copyright 2003
 * Kai-Uwe Bloem, Auerswald GmbH & Co KG, <linux-development@auerswald.de>
 *
 * (C) Copyright 2005
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 *   Added support for reading flash partition table from environment.
 *   Parsing routines are based on driver/mtd/cmdline.c from the linux 2.4
 *   kernel tree.
 *
 *   $Id: cmdlinepart.c,v 1.17 2004/11/26 11:18:47 lavinen Exp $
 *   Copyright 2002 SYSGO Real-Time Solutions GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include <malloc.h>
#include <jffs2/jffs2.h>
#include <linux/list.h>
#include <linux/ctype.h>

#include <config.h>

#ifdef CONFIG_USE_FAT_FS
#include <fat.h>
#include <asm/byteorder.h>
#include <part.h>
#endif

#include "../tdf256/tdfloader_local.h"
#include "../tdf256/tdfloader.h"

extern void tmbtAuth_Start(void);
extern void tmbtAuth_Stop(void);
extern void dsp_wait_auth(void); 

//YW: to align with cmd_fat.c
int do_fs_loadtdf(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	unsigned long     offset;
	block_dev_desc_t *dev_desc=NULL;
	int               dev=0;
	int               part=1;
	char             *ep;
	int               usetm = 0; // use mips by default
	char             *filename = NULL;
	int				  ret;
	
	mydebug("argc=%d\n", argc);
	if (argc < 5) {
		printf ("usage: fsloadtdf <interface> <dev[:part]> <addr> <filename> <tm>\n");
		return 1;
	}
	dev = (int)simple_strtoul (argv[2], &ep, 16);
	dev_desc=get_dev(argv[1],dev);
	if (dev_desc==NULL) {
		puts ("\n** Invalid boot device **\n");
		return 1;
	}
	if (*ep) {
		if (*ep != ':') {
			puts ("\n** Invalid boot device, use `dev[:part]' **\n");
			return 1;
		}
		part = (int)simple_strtoul(++ep, NULL, 16);
	}
	if (fat_register_device(dev_desc,part)!=0) {
		printf ("\n** Unable to use %s %d:%d for fatload **\n",argv[1],dev,part);
		return 1;
	}
	
	offset = simple_strtoul (argv[3], NULL, 16);
	filename = argv[4];

	if (argc == 6) {		
		char *tmopt = NULL;

		tmopt = argv[5];
		if (strcmp(tmopt, "tm") == 0) {
			usetm = 1;
		}
	}	

	if (usetm) {
		tmbtAuth_Start();
	} else {
		// Clear all semaphores and usetm flag
		tmbtAuth_Stop();
	}	

	printf("Authenticating %s", filename);
	ret = tmbtAuthTdfLoader_Load(filename, (void *)offset);
	printf("%s\n", (ret==0) ? "suceeds" : "fails");
	
	if (usetm) {
		tmbtAuth_Stop();
	}

	// Hang up upon error!
	if (ret) {
		puts ("### Authentication fails ### Please RESET the board ###\n");
		for (;;) { }
	}
	return 0;
}

// initialize semaphore so the tmauth will wait for data to come
int do_dsp_wait_auth(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{	
	dsp_wait_auth(); 
	return 0;
}

/*********************************************************************************************/
U_BOOT_CMD(
	loadtdf,	6,	0,	do_fs_loadtdf,
	"loadtdf\t- load and authenticate tdf file.....\n",
	" <interface> <dev> <addr> [ filename ] <tm>\n"
	"    - load and authenticate tdf file from fat fs (for now)\n"
	"      with offset 'off'\n"
);

U_BOOT_CMD(
	dspwait, 1,	0,	do_dsp_wait_auth,
	"dspwait\t- prepare for authentication with dsp\n",
	NULL
);



