/*
*FILE         : splash_display.c
*
*AUTHOUR      : SARAVANAN S
*
*DATE         : 12.10.2009
*
*DISCRIPTION  : Display the splash screen based on the SPLASH DISPLAY ENV  
*               variable.
*
******************************************************************************/
#include <common.h>
#include <command.h>
#include <asm/io.h>
#include <pnx8550_glb.h>
#include <asm-mips/addrspace.h>
#include "config.h"
#include <config.h>
#include <i2c.h>
#include <pci.h>

#include <universe.h>

#include "../tdf256/tdfloader_local.h"
#include "../tdf256/tdfloader.h"
#include "../tdf256/wrapper.h"

#if 0
#include "zlib.h"

#include "bn.h"

#include "tdfloader_local.h"
#include "tdfloader.h"
#include "auth.h"
#endif

#include <asm/io.h>

#define DEBUG 1

#define PRINTF  printf
#define NULL   0L
#ifdef DEBUG
#define DPRINTF printf
#endif
 

/****************************** MACRO DEFINES ********************************/
    
#define SPLASHENV               "SPLASH"

/* SlaveAddress of the Standby processor */

#define UBF_LOAD_ADDR            "UBF_LOAD_ADDR"
#define UBF_LOAD_ADDR_VAL        "0x0f500000"

#define SPLASH_IS_ON             "SPLASH_IS_ON"

#define UBF_WIDTH_POS_IN_HEADER  12
#define UBF_HEIGHT_POS_IN_HEADER 14
#define UBF_HEADER_SIZE          (2*8)      /* 8 bytes */

#define MAX_WIDTH                 960
#define MAX_HEIGHT                540

#define CROP_HEIGHT               64 

#define int32_t     long
#define u_int32_t   unsigned long
#define __u32       unsigned long

#define   MAXLEN               256     /* Maximum string length */
#define   TRUE                 1
#define   FALSE                0


/* States */
#define   CONFIG_LVDS_DONE     0x01
#define   SET_PIN_DONE         0x02
#define   WAIT_EXACT_DONE      0x04
#define   ENABLE_LVDS_DONE     0x08
#define   WAIT_ATLEAST_DONE    0x10

#define   CMD_NONE         0xFF    /* COMMANDS ISSUED BY CEPLF */
#define   MSG_CONFIG_HEADER    99
#define   MSG_CONFIG_LVDS      1
#define   MSG_WAIT_EXACT       10
#define   MSG_SET_PIN          2
#define   MSG_SET_PIN_WITHDELAY 3
#define   MSG_WAIT_ATLEAST     11
#define   MSG_SHOW_SPLASH      20

#define   MSG_ENABLE_LVDS      66
#define   MSG_SET_REGISTER     67
#define   MSG_SEND_I2C         68
#define   MSG_BACKLIGHT        69
#define   MSG_WAIT_I2C         70
#define   MSG_2D_DIMMING       71
#define   MSG_SCALE_FACTOR     72

#define   MEMSIZE              1024*500 

#define PNX8XXXFB_DFPTYPE_FILE			0
#define PNX8XXXFB_DFPTYPE_PHILIPS_1080P		1
#define PNX8XXXFB_DFPTYPE_PHILIPS_768P		2
#define PNX8XXXFB_DFPTYPE_PHILIPS_1080P120	3

#define PNX8XXXFB_MMIO_READ( a ) 		*((volatile unsigned int *)((a))) 
#define PNX8XXXFB_MMIO_WRITE( a, w )		*((volatile unsigned int *)((a))) = (unsigned long)(w)

#define PNX8XXXFB_PALETTE_CNT		        16

#define LVDSTX_SRESRET_OFFSET			0x00177ff0
#define LVDSTX2_SRESRET_OFFSET			0x00114ff0
/* as per Prince */
#define LVDSBUF_FLUSH_OFFSET                    0x0017800C

#define CPIPE_GFX_DECOMP1_CTRL_OFFSET		0x00063B80
#define CPIPE_GFX_DECOMP2_CTRL_OFFSET		0x00063B84
#define CPIPE_GFX_DECOMP3_CTRL_OFFSET		0x00063B88
#define CPIPE_GFX_DECOMP_CTRL_RESET		0x00001000

#define LAYER_STATUS_CTRL_GFX2_OFFSET		0x00147000
#define LAYER_STATUS_CTRL_DISABLE		0x00000000
#define LAYER_STATUS_CTRL_ENABLE		0x00000001

#define LAYER_INITIAL_SIZE_GFX2_OFFSET		0x00147004
#define LAYER_FINAL_SIZE_GFX2_OFFSET		0x00147008

#define RIF_LINE_WIDTH_BAMODE_PK_GFX2_OFFSET	0x0014705C
#define RIF_ADDR_A_PK_GFX2_OFFSET		0x00147064

#define RIF_FORMAT_GFX2_OFFSET			0x00147044
#define RIF_FORMAT_ARGB32			0xa0000018
#define RIF_FORMAT_ARGB4444			0x50000019 
#define RIF_FORMAT_RGB16			0x5000001B
#define RIF_FORMAT_YUY2				0x50000010
#define RIF_FORMAT_UYVY				0x50000011
#define RIF_FORMAT_CLUT8			0x00000003

#define RIF_PITCH_A_PK_GFX2_OFFSET		0x0014706C

#define CLUT_DATA_GFX2_OFFSET			0x00147120
#define CLUT_ADDR_GFX2_OFFSET			0x00147124

#define GS2D_FRAME_GEOMETRY_OUTPUT_GFX2_OFFSET	0x00147368

#define PROGIF_INTERRUPT_CLR_OFFSET		0x00146FE8
#define PROGIF_INTERRUPT_STS_OFFSET		0x00146FE0
#define PROGIF_INTERRUPT_STS_L4_DONE		0x00080000

//#define SPLASH_IMAGE_LOAD_ADDRESS            0x1FE02000
#define SPLASH_IMAGE_LOAD_ADDRESS            0x0F500000
#define SPLASH_SETTINGS_LOAD_ADDRESS         0x0F400000

// Panal frequency
#define PAN_FREQ                             720000

/* LVDS config register offsets */
#define MAX_LVDS_CONFIG_CLOCK_REGS           14
#define MAX_LVDS_CONFIG_CPIPETVPIX_REGS      4    
#define MAX_CONFIG_CPIPETVPROC_REGS          4
#define MAX_CONFIG_CPIPEL2QTV_REGS           26

/* 100/200 Hz panel specific LVDS regs */
#define LVDS_BUF_REGS_SIZE                   17
#define LVDS_BUF_REGS_OFFSET                 18
#define LVDS_TX1_REGS_SIZE                   23
#define LVDS_TX1_REGS_OFFSET                 35
#define LVDS_TX2_REGS_SIZE                   23
#define LVDS_TX2_REGS_OFFSET                 58

/* 2D dimming & scanning registers */
#define TMAPCTV55XPWMDRVREG_CLOCKS 0x00047000
#define TMAPCTV55XPWMDRVREG_CLK_PWM2_CTL (TMAPCTV55XPWMDRVREG_CLOCKS+0x0b48) 

#define TMAPCTV55XPWMDRVREG_GPIO_TSU 0x0014C000
#define TMAPCTV55XPWMDRVREG_GPIO_MASK_AND_IO_DATA (TMAPCTV55XPWMDRVREG_GPIO_TSU+0x0010) 
/* Remark: Not need to read the current register. 
Only set bit 26 to 1 so that only gpio10 is initialized. Otherwise other gpio pins can be triggered as well. */

#define TMAPCTV55XPWMDRVREG_MODE_CTL_0 (TMAPCTV55XPWMDRVREG_GPIO_TSU+0x0000)
/* Remark: Not need to read the current register. 
Only set gpio pin10 by settings bits 20 and 21 to 2 (bit21=1 bit20=0).*/

#define TMAPCTV55XPWMDRVREG_PWM2_CNTVAL (TMAPCTV55XPWMDRVREG_GPIO_TSU+0x0650)
/* Remark: The count val itself in this register must be overwritten by the boost level that comes in via the interface 
(just like with the backlight level the percentage from the interface must be translated to a proper countval by taking 
this percentage of the MAXVAL in the next register). */

#define TMAPCTV55XPWMDRVREG_PWM2_MAXVAL (TMAPCTV55XPWMDRVREG_GPIO_TSU+0x0654) 
#define TMAPCTV55XPWMDRVREG_PWM23_HSCNT (TMAPCTV55XPWMDRVREG_GPIO_TSU+0x0674) 
#define TMAPCTV55XPWMDRVREG_PWM23_UPDREG (TMAPCTV55XPWMDRVREG_GPIO_TSU+0x061C)
#define TMAPCTV55XPWMDRVREG_PWM23_RST (TMAPCTV55XPWMDRVREG_GPIO_TSU+0x0670)

#define TMAPCTV55XPWMDRVREG_GLOBALREG 0x00063000
#define TMAPCTV55XPWMDRVREG_GPIO_MUX_SEL (TMAPCTV55XPWMDRVREG_GLOBALREG+0x0424) 


/****************************** TYPE DEFINES  ********************************/
/* Data type of Display environment configuration */    
typedef union tuDATA
{
    int        iData;            /* Numerical data   */
    char       acData[MAXLEN];   /* Char string      */

}tuDATA;

   
/* Display configuration params */
typedef struct sDISPCONFIG {
    unsigned char ucMsgType ;          /* Message type         */

    unsigned char ucMsgLen  ;          /* Message Length       */

    tuDATA        *puData   ;          /* Disp param Alpha/num */

    struct sDISPCONFIG *psNext;        /* Next config data     */

}tsDISPDATA;

typedef struct
{
	int32_t		offset;
	u_int32_t	value;

} pnx8xxx_reg_t, *ppnx8xxx_reg_t;

typedef const pnx8xxx_reg_t *pcpnx8xxx_reg_t;


struct fb_bitfield {
        __u32 offset;                   /* beginning of bitfield        */
        __u32 length;                   /* length of bitfield           */
        __u32 msb_right;                /* != 0 : Most significant bit is */
                                        /* right */
};

struct fb_var_screeninfo {
        __u32 xres;                     /* visible resolution           */
        __u32 yres;
        __u32 bits_per_pixel;           /* guess what                   */
        struct fb_bitfield red;         /* bitfield in fb mem if true color, */
        struct fb_bitfield green;       /* else only length is significant */
        struct fb_bitfield blue;
        struct fb_bitfield transp;      /* transparency                 */
        __u32 nonstd;                   /* != 0 Non standard pixel format */
};

typedef struct pnx8xxx_ovlsetup
{
	int32_t		pmem;
	u_int32_t	mode;
	u_int32_t	w;
	u_int32_t	h;

} pnx8xxx_ovlsetup_t, *ppnx8xxx_ovlsetup_t;

typedef const pnx8xxx_ovlsetup_t *pcpnx8xxx_ovlsetup_t;

typedef struct pnx8xxx_par
{
	u_int32_t					vmmio;
	u_int32_t					vmem;
	u_int32_t					pmem;
	u_int32_t					stridemul;
	u_int32_t					pseudo_palette[PNX8XXXFB_PALETTE_CNT];
	int32_t						dfp_type;
	ppnx8xxx_reg_t				dfp_regs;
	ppnx8xxx_ovlsetup_t			ovl;
	struct fb_var_screeninfo	*varsinfo;

} pnx8xxx_par_t, *ppnx8xxx_par_t;

/***************************************************************************/
/*          GLOBAL VARIABLES                                                */
/***************************************************************************/
/* State machine for different states of splash app */
static char status = 0;

/* Offset and memory management components for string handling */
char DELIM = ',' ;
static int  iOffset=0;
static int  iEnvIdx=0;

/* Memory managment for string/Environment table handling */ 
static int  iAvailable = MEMSIZE ; 
static char cMemory[MEMSIZE];
static unsigned char ucFirstNode = TRUE ;

/* To measure the delay time and lampon enabled */
ulong ulStartTime;
ulong guiTime=0.0;
static unsigned char ucLamponEnabled = FALSE ;

/* Global Display environment table */
static   tsDISPDATA *gpsDispData = NULL ; 

/* Global 855 configuration */
struct pnx8xxx_par par;

/* To control backlight level */
ulong ulBackLtMaxVal   = 0xC00AFC80 ;
ulong ulBackLtCountVal = 0xC00AFC80 ;

/* To calculate scale factor */
unsigned int  screen_width  = 1920   ;
unsigned int  screen_height = 1080   ;

/* To control "splash" and "lampon" commands */
static unsigned char ucSetPinWithDelay = FALSE ;
    
//1920,
//1080,
//    960,
//    540,
#ifdef ARGB
// ARGB
static struct fb_var_screeninfo gtmvipLmFb_ScreenInf =
{
    960,
    540,
    16,
    { 24, 8, 0 },
    { 16, 8, 0 },
    {  8, 8, 0 },
    {  0, 8, 0 },
};
#else  // RGB565
static struct fb_var_screeninfo gtmvipLmFb_ScreenInf =
{
    960,
    540,
    16,
    { 24, 8, 0 },
    { 16, 6, 0 },
    {  8, 8, 0 },
    {  0, 8, 0 },
};
#endif

static pnx8xxx_reg_t	cpipel2k8[] =
{
	{ 0x00147010, 0x0000002c }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/LAYER_START_GFX2_1            0
	{ 0x00147020, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CROP_CTRL_GFX2_1              1 
	{ 0x00147024, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CROP_WIN_START_GFX2_1         2 
	{ 0x00147028, 0x02d00238 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CROP_WIN_SIZE_GFX2_1          3
	{ 0x00147030, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/LCU_BOUNDARY_GFX2_1           4
	{ 0x00147034, 0x00000006 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/LCU_CTRL_GFX2_1               5
	{ 0x00147038, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/LCU_FIRST_PIXEL_GFX2_1        6
	{ 0x00147040, 0x0868002c }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_FIRST_PIXEL_GFX2_1        7
	{ 0x00147048, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_VARIABLE_FORMAT_GFX2_1    8
	{ 0x0014704c, 0x00000028 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_DUMMY_CNT_GFX2_1          9 
	{ 0x00147050, 0xff000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_PKEY_CTRL_GFX2_1          10 
	{ 0x00147054, 0x10500015 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_START_FETCH_GFX2_1        11
	{ 0x00147058, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_INS_GFX2_1                12
	{ 0x00147060, 0x0000ffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_LINE_INC_PK_GFX2_1        13
	{ 0x00147068, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_ADDR_B_PK_GFX2_1          14
	{ 0x00147070, 0x00001e00 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_PITCH_B_PK_GFX2_1         15
	{ 0x00147074, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_LINE_WIDTH_BAMODE_SP_GFX2_1  16
	{ 0x00147078, 0x0000ffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_LINE_INC_SP_GFX2_1        17
	{ 0x0014707c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_ADDR_A_SP_GFX2_1          18
	{ 0x00147080, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_ADDR_B_SP_GFX2_1          19
	{ 0x00147084, 0x00001e00 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_PITCH_SP_GFX2_1           20
	{ 0x00147088, 0x00000008 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/UDTH_CTRL_GFX2_1              21
	{ 0x00147120, 0x9503c428 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CLUT_DATA_GFX2_1              22
	{ 0x00147140, 0x00ffffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_MASK_1_GFX2_1            23
	{ 0x00147144, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_1_UPP_GFX2_1         24
	{ 0x00147148, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_1_LOW_GFX2_1         25
	{ 0x0014714c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_REPLACE_1_GFX2_1         26
	{ 0x00147150, 0x00ffffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_MASK_2_GFX2_1            27
	{ 0x00147154, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_2_UPP_GFX2_1         28
	{ 0x00147158, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_2_LOW_GFX2_1         29
	{ 0x0014715c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_REPLACE_2_GFX2_1         30
	{ 0x00147160, 0x00ffffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_MASK_3_GFX2_1            31
	{ 0x00147164, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_3_UPP_GFX2_1         32
	{ 0x00147168, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_3_LOW_GFX2_1         33
	{ 0x0014716c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_REPLACE_3_GFX2_1         34
	{ 0x00147170, 0x00ffffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_MASK_4_GFX2_1            35
	{ 0x00147174, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_4_UPP_GFX2_1         36
	{ 0x00147178, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_4_LOW_GFX2_1         37
	{ 0x0014717c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_REPLACE_4_GFX2_1         38
	{ 0x00147180, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_ROPS_1_GFX2_1            39
	{ 0x00147184, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_ROPS_2_GFX2_1            40
	{ 0x00147290, 0x00000016 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_CTRL_GFX2_1              41
	{ 0x00147294, 0x08000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_MATRIX_COEFFS_1_GFX2_1   42
	{ 0x00147298, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_MATRIX_COEFFS_2_GFX2_1   43
	{ 0x0014729c, 0x08000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_MATRIX_COEFFS_3_GFX2_1   44
	{ 0x001472a0, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_MATRIX_COEFFS_4_GFX2_1   45
	{ 0x001472a4, 0x08000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_MATRIX_COEFFS_5_GFX2_1   46
	{ 0x001472a8, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_OFFSET_UPP_GFX2_1        47
	{ 0x001472ac, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_OFFSET_MID_GFX2_1        48
	{ 0x001472b0, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_OFFSET_LOW_GFX2_1        49
	{ 0x001472c0, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_BACKGROUND_COLOR_GFX2_1   50
	{ 0x001472c4, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_SOLID_COLOR_GFX2_1        51
	{ 0x001472c8, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_CKEY_MASK_ROP_GFX2_1      52
	{ 0x001472cc, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_PIXEL_CTRL_ROP_GFX2_1     53
	{ 0x001472d0, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_ALPHA_BLEND_PASS_GFX2_1   54
	{ 0x001472d4, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_ALPHA_PASS_GFX2_1         55
	{ 0x001472d8, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_ALPHA_CTRL_GFX2_1         56
	{ 0x001472dc, 0x00236058 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_BORDER_START_GFX2_1       57
	{ 0x001472e0, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_BORDER_SIZE_GFX2_1        58
	{ 0x001472e4, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_HEIGHT_WIDTH_GFX2_1       59
	{ 0x001472e8, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_BORDER_COLOR_GFX2_1       60
	{ 0x001472ec, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_CURTAIN_COLOR_GFX2_1      61
	{ 0x00147360, 0x00200000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_GLB_CTRL_0_GFX2_1        62
	{ 0x00147364, 0x00000055 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_FILTER_KERNEL_GFX2_1     63
	{ 0x0014736c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_FRAME_GEOMETRY_INPUT_GFX2_1  64
	{ 0x00147370, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_H_INITIAL_SET_GFX2_1     65
	{ 0x00147374, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_V_INITIAL_SET_GFX2_1     66
	{ 0x00147378, 0x00020000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_H_ZONE_0_SCALE_GFX2_1  // WXGA   67
	{ 0x0014737c, 0x00020000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_V_ZONE_0_SCALE_GFX2_1  // WXGA   68

	{ 0x00147cac, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GNSH_GAMMA_CTRL_OL_1         69
	{ 0x00147cb0, 0x00000004 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GNSH_NSH_CTRL_OL_1           70
	{ 0x00147cb4, 0x00000007 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GNSH_UNSIGN_ENABLE_OL_1      71

	{ -1        , 0x00000000 }
};

pnx8xxx_reg_t  gClockLvdsCpipe[] = 
{
    /* Clocks, size=14*/
	{0x00047440, 0x00000003}, /*0*/
	{0x00047444, 0x00000003}, /*1*/
	{0x00047448, 0x00000003}, /*2*/
	{0x00047484, 0x00000003}, /*3*/
	{0x00047470, 0x00000003}, /*4*/
// 	{0x00047474, 0x00000003}, /*5*/
  	{0x00047474, 0x00000002}, /*5*/
	{0x00047478, 0x00000003}, /*6*/
//  	{0x0004747c, 0x00000003}, /*7*/
  	{0x0004747c, 0x00000002}, /*7*/
//  	{0x00047480, 0x00000003}, /*8*/
  	{0x00047480, 0x00000002}, /*8*/
	{0x000474c0, 0x00000003}, /*9*/
	{0x000474c4, 0x00000003}, /*10*/
	{0x000474cc, 0x00000003}, /*11*/
	{0x000474d0, 0x00000003}, /*12*/
	{0x00047A40, 0x00000003}, /*13*/

	/* cpipetvpix_pll, size=4 */
//	{0x000470ac, 0x0d34199d}, /*14*/
	{0x000470ac, 0x0b3e0d8d}, /*14*/
//	{0x000470b0, 0x10e8c408}, /*15*/
	{0x000470b0, 0x10e88400}, /*15*/
//	{0x000470b8, 0x4018c888}, /*16*/
	{0x000470b8, 0x602d7bc8}, /*16*/
//	{0x000470b4, 0x00000002}, /*17*/
	{0x000470b4, 0x00000001}, /*17*/
	
	/* lvdsbuf, size=17*/
	{0x00178004, 0x00000010}, /*18*/
	{0x00178008, 0x00000100}, /*19*/
//	{0x0017800c, 0x00e42402}, /*20*/
	{0x0017800c, 0x0}, /*20*/
	{0x00178010, 0x00000018}, /*21*/
	{0x00178014, 0x00000001}, /*22*/
	{0x00178018, 0x00000000}, /*23*/
	{0x0017801c, 0x04040004}, /*24*/
	{0x00178020, 0x04650898}, /*25*/
	{0x00178024, 0x043a0781}, /*26*/
	{0x00178028, 0x002a0117}, /*27*/
	{0x0017802c, 0x0000003e}, /*28*/
	{0x00178030, 0x00010004}, /*29*/
	{0x00178034, 0x01ad0000}, /*30*/
	{0x00178038, 0x00400040}, /*31*/
	{0x0017803c, 0x000000ff}, /*32*/
	{0x00178040, 0x00ff0000}, /*33*/
	{0x00178044, 0x00ffffff}, /*34*/
	
	/* lvdstx1, size=23 */
    {0x00177040, 0x00011e80}, /*35*/	
	{0x00177000, 0x0080a414}, /*36*/
	{0x00177004, 0x00000000}, /*37*/
	{0x00177008, 0x00000000}, /*38*/
	{0x0017700c, 0x00000000}, /*39*/
	{0x00177010, 0x0b0a0908}, /*40*/
	{0x00177014, 0x00000d0c}, /*41*/
	{0x00177018, 0x08080808}, /*42*/
	{0x0017701c, 0x00000808}, /*43*/
	{0x00177020, 0x0b0a0908}, /*44*/
	{0x00177024, 0x00000d0c}, /*45*/
	{0x00177028, 0x08080808}, /*46*/
	{0x0017702c, 0x00000808}, /*47*/
	{0x00177030, 0x07070707}, /*48*/
	{0x00177034, 0x00000007}, /*49*/
	{0x00177038, 0x08080808}, /*50*/
	{0x0017703c, 0x00000008}, /*51*/
	{0x00177044, 0xaf000018}, /*52*/
	{0x00177048, 0x11667c61}, /*53*/
	{0x0017704c, 0x00000004}, /*54*/
	{0x00177050, 0x00000003}, /*55*/
	{0x00177ff0, 0x00040000}, /*56*/
	{0x00177ff4, 0x00000000}, /*57*/

	/* lvdstx2,size=23 */
	{0x00114040, 0x00011e00}, /*58*/
	{0x00114000, 0x0080a414}, /*59*/
	{0x00114004, 0x00000000}, /*60*/
	{0x00114008, 0x00000000}, /*61*/
	{0x0011400c, 0x00000000}, /*62*/
	{0x00114010, 0x03020100}, /*63*/
	{0x00114014, 0x00000504}, /*64*/
	{0x00114018, 0x08080808}, /*65*/
	{0x0011401c, 0x00000808}, /*66*/
	{0x00114020, 0x03020100}, /*67*/
	{0x00114024, 0x00000504}, /*68*/
	{0x00114028, 0x08080808}, /*69*/
	{0x0011402c, 0x00000808}, /*70*/
	{0x00114030, 0x07070707}, /*71*/
	{0x00114034, 0x00000007}, /*72*/
	{0x00114038, 0x08080808}, /*73*/
	{0x0011403c, 0x00000008}, /*74*/
	{0x00114044, 0x8c0000a7}, /*75*/
	{0x00114048, 0x11667c61}, /*76*/
	{0x0011404c, 0x00000004}, /*77*/
	{0x00114050, 0x00000003}, /*78*/
	{0x00114ff0, 0x00040000}, /*79*/
	{0x00114ff4, 0x00000000}, /*80*/
	
	/*cpipel2qtv_stg, size=26*/
	{0x00146000, 0x00000000}, /*81*/
	{0x00146004, 0x2a},       /*82*/
	{0x00146008, 0x00043210}, /*83*/
	{0x0014600c, 0x20080200}, /*84*/
	{0x00146f00, 0x06111200}, /*85*/
	{0x00146040, 0x00000031}, /*86*/
	{0x00146044, 0x089b0465}, /*87*/
	{0x00146048, 0x089b011a}, /*88*/
	{0x0014604c, 0x0465002c}, /*89*/
	{0x00146050, 0x003c0068}, /*90*/
	{0x00146054, 0x00060012}, /*91*/
	{0x00146058, 0x00020002}, /*92*/
	{0x0014605c, 0x00020002}, /*93*/
	{0x00146060, 0x00000000}, /*94*/
	{0x00146064, 0x00000000}, /*95*/
	{0x00146068, 0x00000000}, /*96*/
	{0x0014606c, 0x00000000}, /*97*/
	{0x00146070, 0x00000000}, /*98*/
	{0x00146074, 0x00000000}, /*99*/
	{0x00146078, 0x00000000}, /*100*/
	{0x0014607c, 0x00000000}, /*101*/
	{0x00146080, 0x0465015e}, /*102*/
	{0x00146084, 0x80000007}, /*103*/
	{0x00146090, 0x00000000}, /*104*/
	{0x00147ce0, 0x04070002}, /*105*/
	{0x00147c00, 0x00000001}, /*106*/
	
	/* cpipetvproc_pll, size=4 */
//	{ 0x000470bc, 0x0d34199d },/*107*/
  	{ 0x000470bc, 0xdeadabba },/*107*/
//  	{ 0x000470c0, 0x10e8c408 },/*108*/
  	{ 0x000470c0, 0x52adabba },/*108*/
//  	{ 0x000470c8, 0x40190000 },/*109*/
  	{ 0x000470c8, 0xc02dabba },/*109*/
	{ 0x000470c4, 0x00000002 },/*110*/

        /* To control backlight level */
        { 0x0014C600,  0xC00AFC80},
        { 0x0014C610,  0xC00AFC80},

	{ -1        , 0x00000000 }
};

/* With  Delay : exactly:20 Atleast:500 */
char TESTDATA[] = "99,2,180,2009-03-13 2:07:55 PM Creator Name BEQBRGBRG1DT111,1,96,47440,3,47444,3,47448,3,47484,3,47470,3,47474,2,47478,3,4747c,3,47480,2,474c0,3,474c4,3,474cc,3,474d0,3,47a40,32,470ac,d34199d,470b0,10e8c408,470b8,4018c888,470b4,2,470bc,deadabba,470c0,52adabba,470c8,c02dabba,470c4,2,146000,0,146004,2a,146008,43210,14600c,20080200,146f00,6111200,146040,31,146044,89b0465,146048,89b011a,14604c,465002c,146050,3c0068,146054,60012,146058,20002,14605c,20002,146060,0,146064,0,146068,0,14606c,0,146070,0,146074,0,146078,0,14607c,0,146080,465015e,146084,80000007,146090,0,147ce0,4070002,147c00,1,2,3,7,1,3,10,1,20,66,2,14c010,0,11,1,500,20,2,1,/philips/data/splash.tdf,69,1,63,2,3,ab,1,2";

char adispEnv[] = "99,2,180,2009-03-13 2:07:55 PM Creator Name BEQBRGBRG1DT111,1,96,47440,3,47444,3,47448,3,47484,3,47470,3,47474,2,47478,3,4747c,3,47480,2,474c0,3,474c4,3,474cc,3,474d0,3,47a40,32,470ac,d34199d,470b0,10e8c408,470b8,4018c888,470b4,2,470bc,deadabba,470c0,52adabba,470c8,c02dabba,470c4,2,146000,0,146004,2a,146008,43210,14600c,20080200,146f00,6111200,146040,31,146044,89b0465,146048,89b011a,14604c,465002c,146050,3c0068,146054,60012,146058,20002,14605c,20002,146060,0,146064,0,146068,0,14606c,0,146070,0,146074,0,146078,0,14607c,0,146080,465015e,146084,80000007,146090,0,147ce0,4070002,147c00,1,2,3,7,1,3,10,1,20,66,2,14c010,0,11,1,500,20,2,0,/philips/data/splash.tdf,69,1,32,2,3,ab,1,2";

    
char pcldispEnv[] =  "99,2,181,DISPT_005.000.009.004,1,102,47440,3,47444,5,47448,7,47484,5,47470,13,47474,12,47478,13,4747c,12,47480,12,474c0,53,474c4,3,474cc,53,474d0,53,47a40,deadabba,470ac,b3e0d8d,470b0,10e8c400,470b8,402d7bb3,470b4,1,470bc,deadabba,470c0,deadabba,470c8,deadabba,470c4,deadabba,146000,0,146004,c0,146008,42310,14600c,0,146f00,6111200,146040,31,146044,82f0515,146048,780082f,14604c,50500cc,146050,7d407e7,146054,10004,146058,41b0003,14605c,41b0003,146060,0,146064,0,146068,0,14606c,0,146070,0,146074,0,146078,0,14607c,0,146080,50500cd,146084,2,146090,0,147ce0,7070002,147c00,0,0x0014C600,0xC00AFC80,0x0014C610,0xC00AFC80,0x0017800c,0x00e42402,2,3,120,1,0,10,1,10,66,2,14c010,cff,11,1,200,20,2,0,splashbmp.tdf,69,1,100,3,4,0x22,0,1,10000,3,4,0x20,0,0,10000" ;

//char pcldispEnv[] =  "99,2,181,DISPT_005.000.009.004,1,102,47440,3,47444,5,47448,7,47484,5,47470,13,47474,12,47478,13,4747c,12,47480,12,474c0,53,474c4,3,474cc,53,474d0,53,47a40,deadabba,470ac,b3e0d8d,470b0,10e8c400,470b8,402d7bb3,470b4,1,470bc,deadabba,470c0,deadabba,470c8,deadabba,470c4,deadabba,146000,0,146004,c0,146008,42310,14600c,0,146f00,6111200,146040,31,146044,82f0515,146048,780082f,14604c,50500cc,146050,7d407e7,146054,10004,146058,41b0003,14605c,41b0003,146060,0,146064,0,146068,0,14606c,0,146070,0,146074,0,146078,0,14607c,0,146080,50500cd,146084,2,146090,0,147ce0,7070002,147c00,0,0x0014C600,0xC00AFC80,0x0014C610,0xC00AFC80,0x0017800c,0x00e42402,2,3,120,1,0,10,1,10,66,2,14c010,cff,11,1,200,20,2,0,splashbmp.tdf,69,1,10,2,3,122,1,1" ;

 
static char TdfHeader[ sizeof(TdfHeader_t) 
                     + sizeof(TdfPayloadHeader_t) 
                     + sizeof(TdfSignedPayload_t)
                     + (3 * DCACHE_BYTES_PER_LINE)
                     ];

/******************************************************************************
**         Local  Functions                                                ***
******************************************************************************/
static void splaInitDispConfig( char *filename, unsigned int uiCrop );
static int  splaCheckWaitAtleast(void);
static int  pnx85500fb_poll_mask_set( struct pnx8xxx_par *par, u_int32_t offset, u_int32_t mask );
static int  pnx85500fb_poll_mask_unset( struct pnx8xxx_par *par, u_int32_t offset, u_int32_t mask );

static inline void pnx8xxx_write_regs( u_int32_t base, pcpnx8xxx_reg_t pregs )
{
	u_int32_t	i;
	
	for ( i=0; pregs[i].offset != -1; i++ )
	{
		PNX8XXXFB_MMIO_WRITE( base+pregs[i].offset, pregs[i].value );
	}
}

static inline void pnx8xxx_write_regs_1( u_int32_t base, pcpnx8xxx_reg_t pregs, unsigned int size )
{
	u_int32_t	i;
	
	for ( i=0; i<size; i++ )
	{
		PNX8XXXFB_MMIO_WRITE( base+pregs[i].offset, pregs[i].value );
	}
}


/*-----------------------------------------------------------------------------
// FUNCTION:	pnx85500fb_init_pll
//-----------------------------------------------------------------------------
*/
int
pnx85500fb_init_pll( struct pnx8xxx_par *par, const pnx8xxx_reg_t *pReg )
{
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[0].offset, pReg[0].value );
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[1].offset, pReg[1].value | 0x3 );
	pnx85500fb_poll_mask_unset( par, pReg[3].offset, pReg[3].value );
    
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[1].offset, pReg[1].value | 0x2 );
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[2].offset, 0x80000000 );
	pnx85500fb_poll_mask_set( par, pReg[3].offset, pReg[3].value );
	
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[2].offset, pReg[2].value );
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[1].offset, pReg[1].value & ~0x2 );
	pnx85500fb_poll_mask_set( par, pReg[3].offset, pReg[3].value );

	return 0;
}


/*-----------------------------------------------------------------------------
// FUNCTION:	pnx85500fb_init_layer
//-----------------------------------------------------------------------------
*/
static int
pnx85500fb_init_layer( struct pnx8xxx_par *par, struct fb_var_screeninfo *var )
{	
	u_int32_t 			xy, ckeyMask, fullscr ;


	PNX8XXXFB_MMIO_WRITE( par->vmmio + RIF_ADDR_A_PK_GFX2_OFFSET, par->pmem );

	xy = ( ((var->yres & 0xFFF) << 16) | (var->xres & 0xFFF) );

	// WXGA  fullscr= ( ((0x438 & 0xFFF) << 16) | (0x780 & 0xFFF) );
        fullscr= ( ((screen_height & 0xFFF) << 16) | (screen_width & 0xFFF) );

	PNX8XXXFB_MMIO_WRITE( par->vmmio+LAYER_INITIAL_SIZE_GFX2_OFFSET, xy );
	PNX8XXXFB_MMIO_WRITE( par->vmmio+LAYER_FINAL_SIZE_GFX2_OFFSET, fullscr);
	PNX8XXXFB_MMIO_WRITE( par->vmmio+GS2D_FRAME_GEOMETRY_OUTPUT_GFX2_OFFSET, fullscr);

	switch( var->bits_per_pixel )
	{
		case 8:
			par->stridemul 	= 1;
			ckeyMask		= 0x000000FF;

			PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_FORMAT_GFX2_OFFSET, RIF_FORMAT_CLUT8 );
			PNX8XXXFB_MMIO_WRITE( par->vmmio+CLUT_ADDR_GFX2_OFFSET, 0x2 );
			break;

		case 16:
			par->stridemul 	= 2;
		
			if ( var->green.length == 6 )
			{
				ckeyMask		= 0x0000FFFF;
				PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_FORMAT_GFX2_OFFSET, RIF_FORMAT_RGB16 );
			}
			else
			{
				ckeyMask		= 0x00000FFF;
				PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_FORMAT_GFX2_OFFSET, RIF_FORMAT_ARGB4444 );
			}
			PNX8XXXFB_MMIO_WRITE( par->vmmio+CLUT_ADDR_GFX2_OFFSET, 0x0 );
			break;

		case 32:
		default:
			par->stridemul	= 4;
			ckeyMask		= 0x00FFFFFF;
		
			PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_FORMAT_GFX2_OFFSET, RIF_FORMAT_ARGB32 );
			PNX8XXXFB_MMIO_WRITE( par->vmmio+CLUT_ADDR_GFX2_OFFSET, 0x0 );
			break;
	}
	
	PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_LINE_WIDTH_BAMODE_PK_GFX2_OFFSET, par->stridemul * (var->xres-1) );
	PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_PITCH_A_PK_GFX2_OFFSET, par->stridemul * var->xres );

	return 0;
}


/*-----------------------------------------------------------------------------
// FUNCTION:	pnx85500fb_poll_mask_set
//-----------------------------------------------------------------------------
*/
static int pnx85500fb_poll_mask_set( struct pnx8xxx_par *par, u_int32_t offset, u_int32_t mask )
{
	u_int32_t 		tmp, count = 9999;

        do{
           tmp = PNX8XXXFB_MMIO_READ( par->vmmio + offset );
        }while( ((tmp & mask) != mask) && (--count != 0));
	return 0;
}

/*-----------------------------------------------------------------------------
// FUNCTION:    pnx85500fb_poll_mask_unset
//-----------------------------------------------------------------------------
*/
static int pnx85500fb_poll_mask_unset( struct pnx8xxx_par *par, u_int32_t offset, u_int32_t mask )
{
        u_int32_t               tmp, count = 9999;

        do{
        tmp = PNX8XXXFB_MMIO_READ( par->vmmio + offset );
        }while( ((tmp & mask) == mask) && (--count !=0));
        return 0;
}

/******************************************************************************
**         Global Functions                                                ***
******************************************************************************/

/*-----------------------------------------------------------------------------
// FUNCTION:	pnx85500fb_init_1
//-----------------------------------------------------------------------------
*/
int
pnx85500fb_enableLVDS_lvdscpipe( struct pnx8xxx_par *par )
{
    unsigned int size = 0, tmp = 0;

    PNX8XXXFB_MMIO_WRITE( par->vmmio + LAYER_STATUS_CTRL_GFX2_OFFSET, LAYER_STATUS_CTRL_DISABLE );

    cpipel2k8[67].value = (screen_width  * 0x10000 / par->varsinfo->xres) ;  // Width scale factor
    cpipel2k8[68].value = (screen_height * 0x10000 / par->varsinfo->yres) ;  // Height scale factor
    printf("SCALE FACTOR width=0x%X  height=0x%X\n",cpipel2k8[67].value, cpipel2k8[68].value );

    pnx8xxx_write_regs( par->vmmio, &cpipel2k8[0] ); 	
    pnx85500fb_init_layer( par, par->varsinfo );
/* commented as per Prince 
    PNX8XXXFB_MMIO_WRITE( par->vmmio + LVDSTX_SRESRET_OFFSET, 0x00040001 );
    pnx85500fb_poll_mask_set( par, LVDSTX_SRESRET_OFFSET, 0x1 );
    PNX8XXXFB_MMIO_WRITE( par->vmmio + LVDSTX2_SRESRET_OFFSET, 0x00040001 );
    pnx85500fb_poll_mask_set( par, LVDSTX2_SRESRET_OFFSET, 0x1 );
*/
    /* LVDS TX1 */
    gClockLvdsCpipe[55].value &= ~0x03;
    gClockLvdsCpipe[78].value &= ~0x03;
    PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[35].offset, gClockLvdsCpipe[35].value & 0xfffffff0);
    PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[55].offset, gClockLvdsCpipe[55].value );
    PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[78].offset, gClockLvdsCpipe[78].value );

    size = 23;	
    pnx8xxx_write_regs_1( par->vmmio, &gClockLvdsCpipe[36], size );
   // PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[35].offset, gClockLvdsCpipe[35].value | 0x1);

    /* LVDS TX2 */
    PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[58].offset, gClockLvdsCpipe[58].value & 0xfffffff0);
    size = 23;	
    pnx8xxx_write_regs_1( par->vmmio, &gClockLvdsCpipe[59], size );
   // PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[58].offset, gClockLvdsCpipe[58].value | 0x1);
	
    size = 17;
    pnx8xxx_write_regs_1( par->vmmio, &gClockLvdsCpipe[18], size );
    
    /* ADDed as per Prince */
    gClockLvdsCpipe[55].value |= 0x03;
    gClockLvdsCpipe[78].value |= 0x03;
    PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[35].offset, gClockLvdsCpipe[35].value | 0x1);
    PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[58].offset, gClockLvdsCpipe[58].value | 0x1);
    PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[55].offset, gClockLvdsCpipe[55].value );
    PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[78].offset, gClockLvdsCpipe[78].value );
    
    tmp = PNX8XXXFB_MMIO_READ( par->vmmio + LVDSBUF_FLUSH_OFFSET );

    PNX8XXXFB_MMIO_WRITE( par->vmmio + LVDSBUF_FLUSH_OFFSET, tmp | 0x01 );
    pnx85500fb_poll_mask_set( par, LVDSBUF_FLUSH_OFFSET, 0x1 );
   
    PNX8XXXFB_MMIO_WRITE( par->vmmio + LVDSBUF_FLUSH_OFFSET, tmp & ~0x01 );
    pnx85500fb_poll_mask_set( par, LVDSBUF_FLUSH_OFFSET, 0x1 );
    
    PNX8XXXFB_MMIO_WRITE( par->vmmio + LVDSTX_SRESRET_OFFSET, 0x00040001 );
    pnx85500fb_poll_mask_set( par, LVDSTX_SRESRET_OFFSET, 0x1 );
   
    PNX8XXXFB_MMIO_WRITE( par->vmmio + LVDSTX2_SRESRET_OFFSET, 0x00040001 );
    pnx85500fb_poll_mask_set( par, LVDSTX2_SRESRET_OFFSET, 0x1 );
  
    return 0;
}

int
pnx85500fb_enable_panel( struct pnx8xxx_par *par , int32_t addr, u_int32_t val )
{
    //struct fb_var_screeninfo *var =  par->varsinfo;
    u_int32_t                offset = 0;

    val |=  0x00020000;
    val &= ~0x00000002;
    PNX8XXXFB_MMIO_WRITE( par->vmmio + 0x14c010, val );

 
    PNX8XXXFB_MMIO_WRITE( par->vmmio + PROGIF_INTERRUPT_CLR_OFFSET, 0xFFFFFFFF );
    pnx85500fb_poll_mask_set( par, PROGIF_INTERRUPT_STS_OFFSET, PROGIF_INTERRUPT_STS_L4_DONE );

    PNX8XXXFB_MMIO_WRITE( par->vmmio + RIF_ADDR_A_PK_GFX2_OFFSET, par->pmem + offset );
    PNX8XXXFB_MMIO_WRITE( par->vmmio + LAYER_STATUS_CTRL_GFX2_OFFSET, 0x00000000 );

    PNX8XXXFB_MMIO_WRITE( par->vmmio + CPIPE_GFX_DECOMP2_CTRL_OFFSET, CPIPE_GFX_DECOMP_CTRL_RESET );
    PNX8XXXFB_MMIO_WRITE( par->vmmio + CPIPE_GFX_DECOMP2_CTRL_OFFSET, 0x0 );

    PNX8XXXFB_MMIO_WRITE( par->vmmio + PROGIF_INTERRUPT_CLR_OFFSET, 0xFFFFFFFF );
    PNX8XXXFB_MMIO_WRITE( par->vmmio + LAYER_STATUS_CTRL_GFX2_OFFSET, LAYER_STATUS_CTRL_ENABLE );

    pnx85500fb_poll_mask_set( par, PROGIF_INTERRUPT_STS_OFFSET, PROGIF_INTERRUPT_STS_L4_DONE );

    return 0;
}

/******************************************************************************
** NAME        : splaMalloc
**
** PARAMETERS  : iSize
**
** RETURNS     : pointer to the allocated location
**
** DESCRIPTION : Allocate memory from static area.
**
******************************************************************************/
char *splaMalloc( int iSize )
{
    char *pcCurPos = NULL ;

    if( iAvailable > iSize )
    {
        pcCurPos= cMemory+iOffset ;
        iOffset += iSize;
        iAvailable -= iSize ;
    }

    return pcCurPos; 
}

void sstrcpy( char *dest, char *src )
{
    int idx=0;

    while( (dest[idx] = src[idx]) )
    {
        if( dest[idx++] == '\0' )
           break;
    }
}

char *sstrtok( char *pcCurPos)
{
    static char token[1024];
    int         idx=0;

    //memset(token, 0x00, 1024 ) ;
 
    while( (idx<1024) && (pcCurPos[iEnvIdx]!='\0') && (pcCurPos[iEnvIdx]!=DELIM) )
    { 
        token[idx++]  = pcCurPos[iEnvIdx++] ;
    }

    token[idx] = '\0' ;
    iEnvIdx++; 

    return token; 
}

static int pnx8500Asci2Hex( char str)
{
        int retval = 0;
        switch (str)
        {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
                retval = (int)(str - 0x30);
                break;
        case 'a':
        case 'A':
                retval = (int) 0xA;
                break;
        case 'b':
        case 'B':
                retval = (int) 0xB;
                break;
        case 'c':
        case 'C':
                retval = (int) 0xC;
                break;
        case 'D':
        case 'd':
                retval = (int) 0xD;
                break;
        case 'E':
        case 'e':
                retval = (int) 0xE;
                break;
        case 'f':
        case 'F':
                retval = (int) 0xF;
                break;
        default:
                retval = -1 ;
                break;
        }
        return retval;
}

static int pnx85xxxAtoI( char *str)
{
    int ival=0;
    int idx=0;

    while( str[idx] != '\0')
    {
        ival = ival*10 + pnx8500Asci2Hex( str[idx++] );
    }

    idx++;

    return ival;
}

static int pnx85xxxAtoX( char *str)
{
    int ival=0;
    int idx=0;

    while( str[idx] != '\0')
    {
        ival = ival*16 + pnx8500Asci2Hex( str[idx++] );
    }

    idx++;
    return ival;
}

/******************************************************************************
** NAME        : splaNextDispData
**
** PARAMETERS  : None
**
** RETURNS     : Next display env node
**
** DESCRIPTION : Get the next table entry of splash disp env.
**
******************************************************************************/
tsDISPDATA *splaNextDispData( void )
{
    if( ucFirstNode )
    { 
        ucFirstNode = FALSE ;
    }
    else if( gpsDispData )
    {
        gpsDispData = gpsDispData->psNext;
    }

    return gpsDispData;
}



/******************************************************************************
** NAME        : splaAddDispData
**
** PARAMETERS  : psDispList
**               psDispData
**
** RETURNS     : None
**
** DESCRIPTION : Add new disp param into the list
**
******************************************************************************/
void splaAddDispData( tsDISPDATA *psDispList, tsDISPDATA *psDispData )
{
    tsDISPDATA *psDisp = psDispList;

    while( psDisp->psNext != NULL )
    { 
       psDisp = psDisp->psNext ;
    } 

    psDisp->psNext = psDispData;
}
   

/******************************************************************************
** NAME        : splaNewDispData
**
** PARAMETERS  : None
**
** RETURNS     : Default structure with default values.
**
** DESCRIPTION : Allocate memory for new structure and fill with the default
**               values.
**
******************************************************************************/
tsDISPDATA  *splaNewDispData( void )
{
    tsDISPDATA *psDispData = (tsDISPDATA *) splaMalloc(sizeof(tsDISPDATA) );

    if( !psDispData)
    {
        return NULL ; /* Failed to allocate mem for new data */
    }

    psDispData->ucMsgType= CMD_NONE;
    psDispData->puData   = NULL    ;
    psDispData->psNext   = NULL    ;

    return psDispData;
}

void *ubf_read(void *dest, const long src, size_t count)
{
	volatile uchar *d = (volatile uchar*) dest;
	volatile uchar *s = (volatile uchar*) src;
	while(count--) {
		*d++ = *s++;
		asm volatile("sync");
	}
	return dest;
}


void splaInitDispConfig( char *filename, unsigned int uiCrop )
{
    unsigned long ubfLoadAddr = 0x00 ;
    char     *ubladdr= NULL ;
    __u32 xres = 0 ;   /* width  */
    __u32 yres = 0 ;   /* height */
    __u32 stride =  0 ;   /* stride*/
    char  res[2];

    /* Reset the splash environment */
    status     = 0;
    iOffset    = 0;
    iAvailable = MEMSIZE ; 
    iEnvIdx    = 0;
    ucFirstNode= TRUE ;
    ucLamponEnabled = FALSE ;
    

    /* TDF File header */
    //TdfHeader_t       *ptdfHeader;
    int               count;
    int               bytes;
    void              *fp = NULL;  // for now, just a palce holder
    TdfHeader_t       *pTdfHeader  = (TdfHeader_t*)(((unsigned int)TdfHeader   + ((2 * DCACHE_BYTES_PER_LINE) - 1)) & ~((2*DCACHE_BYTES_PER_LINE) - 1));


    // fat fs is read-only
    fp = fopen(filename, NULL); 
    if (fp==NULL) 
    {
        /* Default UBF load address,  Get UBF file header information */
        ubladdr = getenv( UBF_LOAD_ADDR);
 
#ifdef DEBUG
        DPRINTF("Failed to open TDF file (%s), using address from UBF_LOAD_ADDR env variable\n", filename );
#endif

    }
    else
    {
#ifdef DEBUG
        DPRINTF("TDF file loaded successfully\n");
#endif
        count = sizeof(TdfHeader_t);

        bytes = fread((void *)pTdfHeader, count, 1, fp);
        if (bytes == 0) 
        {
            /* Default UBF load address,  Get UBF file header information */
            ubladdr = getenv( UBF_LOAD_ADDR);
 
#ifdef DEBUG
            DPRINTF("TDF file opened read filed\n");
            DPRINTF("Invalid header in TDF file (%s), using address from UBF_LOAD_ADDR env variable\n", filename );
#endif
        }
        else
        {
            ubfLoadAddr = (unsigned int) pTdfHeader->pVAddress ;
#ifdef DEBUG
            DPRINTF(" UBF Load address 0x%X\n", (unsigned int)ubfLoadAddr );
#endif
        }
    }

    /* Calculate UBF laod address from env variable*/
    if( ubladdr )
    {
        if( ubladdr[1] == 'x' )
        {
            ubfLoadAddr = pnx85xxxAtoX( ubladdr+2 );
        }
        else
        {
            ubfLoadAddr = pnx85xxxAtoX( ubladdr );
        }
    }
      
    /* Calculate the width */ 
    ubf_read (res, ubfLoadAddr+UBF_WIDTH_POS_IN_HEADER , 2 );
    xres = (res[1]  & 0xFF)  ;
    xres = xres<<8 ;
    xres |= (res[0] & 0xFF );

    ubf_read (res, ubfLoadAddr+UBF_HEIGHT_POS_IN_HEADER , 2 );
    yres = (res[1]  & 0xFF );
    yres = yres<<8 ;
    yres |= (res[0] & 0xFF );
    stride = ((xres+1)>>1)<<2;

    if( uiCrop )
    {
        // Crop the image
        yres = yres - (CROP_HEIGHT * 2 ); 
        ubfLoadAddr = ubfLoadAddr + (CROP_HEIGHT * stride )  ;
    }

    if( (xres*yres) <= ( MAX_WIDTH * MAX_HEIGHT *2) )
    {
        gtmvipLmFb_ScreenInf.xres = xres ;
        gtmvipLmFb_ScreenInf.yres = yres ;
    }

    par.dfp_type = PNX8XXXFB_DFPTYPE_PHILIPS_1080P120;
    par.dfp_regs = 0;
    par.varsinfo = (struct fb_var_screeninfo*)&gtmvipLmFb_ScreenInf;

    par.vmmio = MMIO_BASE;//MMIO_BASE_ADDR;
    //par.pmem  = SPLASH_IMAGE_LOAD_ADDRESS;
    par.pmem  = ubfLoadAddr  + UBF_HEADER_SIZE ;

#ifdef DEBUG
    PRINTF("UBF Load addr 0x%X  Width %d  Height %d  stride %d Crop %d ImageAddr 0x%X\n", (unsigned int)ubfLoadAddr, (int)gtmvipLmFb_ScreenInf.xres, (int)gtmvipLmFb_ScreenInf.yres, (int)stride, (int)uiCrop, (unsigned int)par.pmem );
#endif

}

                
/******************************************************************************
** NAME        : splaParseDispEnv
**
** PARAMETERS  : Display enviornment string 
**
** RETURNS     : 0 -> successfully parsed the disp env
**               1 -> Failed to parse the disp env
**
** DESCRIPTION : Parse the input display environment data and extract the
**               data based on the message type.
**
******************************************************************************/
void splaParseDispEnv( char *pcEnvData )
{
    int           retval = 0 ;
    char          *pcToken  ;
    unsigned int  uiMsgData ;
    unsigned int  uiMsgData2;
    unsigned char ucIdx     ;
    unsigned char ucMsgLen  ;
    char          ucMsgType ;
    char          acFile[256] ;
    unsigned int  uiCrop = 0  ;

    tsDISPDATA  *psDispList= NULL ;

    ucSetPinWithDelay = FALSE ;
                                 
    /* First token from the display envrionment string */
    pcToken = sstrtok( pcEnvData );

    /* parse all the messages and append with the display data list */
    while( *pcToken != '\0' && !retval )
    {
        /* Reset the values */
        ucIdx     =  0;
        ucMsgLen  =  0;
        ucMsgType =  CMD_NONE ;

        /* convert the token into message type */
        ucMsgType = pnx85xxxAtoI( pcToken );

        /* Get next token from the display envrionment string */
        pcToken = sstrtok( pcEnvData);
        if( !pcToken )
        {
#ifdef DEBUG
            DPRINTF("Invalid environment string\n");
#endif
            return ;
        }

        /* convert the token into message length */
        ucMsgLen = pnx85xxxAtoI( pcToken );

        if( (ucMsgType != MSG_CONFIG_HEADER) && (ucMsgType != MSG_SHOW_SPLASH)   &&
            (ucMsgType != MSG_SEND_I2C   )   && (ucMsgType != MSG_WAIT_I2C   )   &&
            (ucMsgType != MSG_CONFIG_LVDS)   && (ucMsgType != MSG_ENABLE_LVDS)   &&
            (ucMsgType != MSG_SET_REGISTER)  && (ucMsgType != MSG_SET_PIN)       &&
            (ucMsgType != MSG_BACKLIGHT)     && (ucMsgType != MSG_BACKLIGHT)     &&
            (ucMsgType != MSG_WAIT_EXACT)    && (ucMsgType != MSG_WAIT_ATLEAST)  &&
            (ucMsgType != MSG_SET_PIN_WITHDELAY) &&
            (ucMsgType != MSG_2D_DIMMING) && (ucMsgType != MSG_SCALE_FACTOR ) )
        {
#ifdef DEBUG
            DPRINTF("Unsupported command=%d  msglen=%d\n",ucMsgType, ucMsgLen );
#endif
            /* Get next token from the display envrionment string */

            while( ucIdx < ucMsgLen )
            {
                /* Get Display ID */
                pcToken = sstrtok( pcEnvData);
                if( !pcToken )
                {
#ifdef DEBUG
                    DPRINTF("Invalid environment string\n");
#endif
                }
                ucIdx++;
             }

            /* read the next command */
            pcToken = sstrtok( pcEnvData);
            continue;
        }


        if( pcToken )
        {
            tsDISPDATA  *psDispData= splaNewDispData();

            if( !psDispData )
            {
#ifdef DEBUG
                DPRINTF("Failed to allocate memory for disp data AvailMem %d\n", iAvailable );
#endif
                return ;
            }

            /* Allocate memory for number of data (num/string) */
            psDispData->puData = ( tuDATA *) splaMalloc( sizeof(tuDATA)*ucMsgLen);
            
            if( !(psDispData->puData) )
            {
#ifdef DEBUG
                DPRINTF("Failed to allocate memory for disp data reqSize %d AvailMem %d\n", ucMsgLen , iAvailable );
#endif
                return ;
            }

            psDispData->ucMsgType = ucMsgType;
            psDispData->ucMsgLen  = ucMsgLen;

            switch( ucMsgType )
            {
                case MSG_CONFIG_HEADER:
                case MSG_SHOW_SPLASH  :
                case MSG_SEND_I2C :
                     {
                         /* Get Display ID */
                         pcToken = sstrtok( pcEnvData );
                         if( !pcToken )
                         {
#ifdef DEBUG
                             DPRINTF("Invalid environment string \n");
#endif
                             return ;
                         }
                         uiMsgData = pnx85xxxAtoI( pcToken );

                         /* Get Display description */
                         pcToken = sstrtok(  pcEnvData );
                         if( !pcToken )
                         {
#ifdef DEBUG
                             DPRINTF("Invalid environment string\n");
#endif
                             return ;
                         }

                         /* Update the display env data */
                         psDispData->puData[ucIdx++].iData = uiMsgData ;
                         sstrcpy( psDispData->puData[ucIdx++].acData,pcToken );

                         if( ucMsgType == MSG_SHOW_SPLASH )
                         {
                             sstrcpy(acFile, pcToken );
                             uiCrop = uiMsgData ; 
                         }
                     }
                     break;

                case MSG_WAIT_I2C :
                     {
                         /* Get Expected value */
                         pcToken = sstrtok( pcEnvData );
                         if( !pcToken )
                         {
#ifdef DEBUG
                             DPRINTF("Invalid environment string\n");
#endif
                             return ;
                         }
                         uiMsgData = pnx85xxxAtoI( pcToken );

                         /* Get I2C Msg len */
                         pcToken = sstrtok( pcEnvData );
                         if( !pcToken )
                         {
#ifdef DEBUG
                             DPRINTF("Invalid environment string\n");
#endif
                             return ;
                         }
                         uiMsgData2 = pnx85xxxAtoI( pcToken );

                         /* Get I2c Msg*/
                         pcToken = sstrtok(  pcEnvData );
                         if( !pcToken )
                         {
#ifdef DEBUG
                             DPRINTF("Invalid environment string\n");
#endif
                             return ;
                         }

                         /* Update the display env data */
                         psDispData->puData[ucIdx++].iData = uiMsgData ;
                         psDispData->puData[ucIdx++].iData = uiMsgData2 ;
                         sstrcpy( psDispData->puData[ucIdx++].acData,pcToken );

                     }
                     break;

                case MSG_CONFIG_LVDS  :
                case MSG_ENABLE_LVDS  :
                case MSG_SET_REGISTER :
                case MSG_SET_PIN      :
                     {
                         while( ucIdx < ucMsgLen )
                         {
                             /* Get Display ID */
                             pcToken = sstrtok( pcEnvData);
                             if( !pcToken )
                             {
#ifdef DEBUG
                                 DPRINTF("Invalid environment string\n");
#endif
                                 return ;
                             }
                             uiMsgData = pnx85xxxAtoX( pcToken );

                             /* Update the display env data */
                             psDispData->puData[ucIdx++].iData = uiMsgData ;
                         }
                     }
                     break;

                case MSG_SET_PIN_WITHDELAY :
                     {
                         while( ucIdx < ucMsgLen-1 )
                         {
                             /* Get Display ID */
                             pcToken = sstrtok( pcEnvData);
                             if( !pcToken )
                             {
#ifdef DEBUG
                                 DPRINTF("Invalid environment string\n");
#endif
                                 return ;
                             }
                             uiMsgData = pnx85xxxAtoX( pcToken );

                             /* Update the display env data */
                             psDispData->puData[ucIdx++].iData = uiMsgData ;
                         }
                             
                         pcToken = sstrtok( pcEnvData);
                         uiMsgData = pnx85xxxAtoI( pcToken );

                         /* Update the display env data */
                         psDispData->puData[ucIdx++].iData = uiMsgData ;

                         ucSetPinWithDelay = TRUE ; 
                     }
                     break;

                case MSG_BACKLIGHT    :
                case MSG_WAIT_EXACT   :
                case MSG_WAIT_ATLEAST :
                     {
                         while( ucIdx < ucMsgLen )
                         {
                             /* Get Display ID */
                             pcToken = sstrtok( pcEnvData );
                             if( !pcToken )
                             {
#ifdef DEBUG
                                 DPRINTF("Invalid environment string\n");
#endif
                                 return ;
                             }
                             uiMsgData = pnx85xxxAtoI( pcToken );

                             /* Update the display env data */
                             psDispData->puData[ucIdx++].iData = uiMsgData ;
                         }
                     }
                     break;

                case MSG_2D_DIMMING:
                     {
                         /* 2D dimming value : boost level */
                         pcToken = sstrtok( pcEnvData );
                         if( !pcToken )
                         {
#ifdef DEBUG
                             DPRINTF("Invalid environment string \n");
#endif
                             return ;
                         }

                         /* 2D dimming Boost level */
                         uiMsgData = pnx85xxxAtoI( pcToken );
                         psDispData->puData[ucIdx++].iData = uiMsgData ;

                         /* Register values */
                         while( ucIdx < ucMsgLen )
                         {
                             /* Registers associated with 2D dimming */
                             pcToken = sstrtok( pcEnvData );
                             if( !pcToken )
                             {
#ifdef DEBUG
                                 DPRINTF("Invalid environment string\n");
#endif
                                 return ;
                             }
                             uiMsgData = pnx85xxxAtoX( pcToken );

                             /* Update the display env data */
                             psDispData->puData[ucIdx++].iData = uiMsgData ;
                          }
                     }
	             break;

                case MSG_SCALE_FACTOR :
                     {
                         pcToken = sstrtok( pcEnvData );
                         if( !pcToken )
                         {
#ifdef DEBUG
                             DPRINTF("Invalid environment string \n");
#endif
                             return ;
                         }

                         // PANEL WIDTH SCALING FACTOR 
                         screen_width = pnx85xxxAtoX( pcToken );

                         pcToken = sstrtok( pcEnvData );
                         if( !pcToken )
                         {
#ifdef DEBUG
                             DPRINTF("Invalid environment string \n");
#endif
                             return ;
                         }

                         // PANEL HEIGHT SCALING FACTOR 
                         screen_height = pnx85xxxAtoX( pcToken );
                     }
	             break;

                default           :
                     retval = 1 ;
                     break;
            }

            if( !retval )
            {
                if( psDispList == NULL )
                {
                    psDispList = psDispData ;
                }
                else
                {
                    splaAddDispData( psDispList, psDispData );
                }
            }
        }
        
        /* Get next token from the display envrionment string */
        pcToken = sstrtok( pcEnvData );
    }

    gpsDispData  = psDispList ; 
  
    /* Initialize the global configuration */ 
    splaInitDispConfig( acFile, uiCrop );

}

/******************************************************************************
** NAME        : splaConfigLVDS
**
** PARAMETERS  : Display enviornment table
**
** RETURNS     : None
**
** DESCRIPTION : Configure the LVDS
**
******************************************************************************/
void splaConfigLVDS(  tsDISPDATA *psDispData  )
{
    unsigned char  ucIdx=0;
    unsigned char  pllIdx=0;
    pnx8xxx_reg_t  pllRegVal[4];
    pnx8xxx_reg_t  RegVal;
    unsigned char ucRegOff=0;
    pnx8xxx_reg_t  LVDSRegVal;

    if( !psDispData )
    {
        return ;
    }

#ifdef DEBUG
    DPRINTF("splaConfigLVDS\n"); 
#endif

    /* CLOCKS */
#ifdef DEBUG
    DPRINTF("Write Clocks\n");
#endif
    while( ucIdx < (MAX_LVDS_CONFIG_CLOCK_REGS*2) )
    {
        RegVal.offset = psDispData->puData[ucIdx++].iData ;
        RegVal.value  = psDispData->puData[ucIdx++].iData ;
        PNX8XXXFB_MMIO_WRITE( par.vmmio+RegVal.offset, RegVal.value );
    }

    /* CPIPETVPIX  PLL */
#ifdef DEBUG
    DPRINTF("CPIPETVPIX  PLL \n");
#endif
    pllIdx = 0;
    while( pllIdx < MAX_LVDS_CONFIG_CPIPETVPIX_REGS)
    {
        pllRegVal[pllIdx].offset = psDispData->puData[ucIdx++].iData ;
        pllRegVal[pllIdx].value  = psDispData->puData[ucIdx++].iData ;
        pllIdx++;
    }
    pnx85500fb_init_pll(&par,  pllRegVal );
     
    /* update panel specific LVDS BUF regs */
    ucRegOff = 0 ;
    while( (ucIdx < psDispData->ucMsgLen) && (ucRegOff < LVDS_BUF_REGS_SIZE) )
    {
        LVDSRegVal.offset = psDispData->puData[ucIdx++].iData ;
        LVDSRegVal.value  = psDispData->puData[ucIdx++].iData ;

        gClockLvdsCpipe[LVDS_BUF_REGS_OFFSET + ucRegOff].value   = LVDSRegVal.value ;
                
        printf("LVDS BUF Reg=0x%X  Val=0x%X\n",LVDSRegVal.offset, LVDSRegVal.value);
        ucRegOff++;
    }

    /* update panel specific LVDS TX1 regs */
    ucRegOff = 0 ;
    while( (ucIdx < psDispData->ucMsgLen) && (ucRegOff < LVDS_TX1_REGS_SIZE) )
    {
        LVDSRegVal.offset = psDispData->puData[ucIdx++].iData ;
        LVDSRegVal.value  = psDispData->puData[ucIdx++].iData ;

        gClockLvdsCpipe[LVDS_TX1_REGS_OFFSET + ucRegOff].value   = LVDSRegVal.value ;
                
        printf("LVDS TX1 Reg=0x%X  Val=0x%X\n",LVDSRegVal.offset, LVDSRegVal.value);
        ucRegOff++;
    }

    /* update panel specific LVDS TX2 regs */
    ucRegOff = 0 ;
    while( (ucIdx < psDispData->ucMsgLen) && (ucRegOff < LVDS_TX2_REGS_SIZE) )
    {
        LVDSRegVal.offset = psDispData->puData[ucIdx++].iData ;
        LVDSRegVal.value  = psDispData->puData[ucIdx++].iData ;

        gClockLvdsCpipe[LVDS_TX2_REGS_OFFSET + ucRegOff].value   = LVDSRegVal.value ;
                
        printf("LVDS TX2 Reg=0x%X  Val=0x%X\n",LVDSRegVal.offset, LVDSRegVal.value);
        ucRegOff++;
    }
     


    /* CPIPETVPROC PLL */
#ifdef DEBUG
    DPRINTF("CPIPETVPROC PLL\n");
#endif
    pllIdx = 0;
    while( pllIdx < MAX_CONFIG_CPIPETVPROC_REGS )
    {
        pllRegVal[pllIdx].offset = psDispData->puData[ucIdx++].iData ;
        pllRegVal[pllIdx].value  = psDispData->puData[ucIdx++].iData ;
        pllIdx++;
    }
    pnx85500fb_init_pll( &par, pllRegVal );
     
    /* CPIPE L2QTV STG */
#ifdef DEBUG
    DPRINTF("CPIPE L2QTV STG \n");
#endif
    while( ucIdx < psDispData->ucMsgLen )
    //while( ucIdx < (psDispData->ucMsgLen-2) ) 
    {
        RegVal.offset = psDispData->puData[ucIdx++].iData ;
        RegVal.value  = psDispData->puData[ucIdx++].iData ;
		/*Girish 9Dec2009: To fix the hor offset to zero & vertical offset equal to STG_V_BLANK_O_GLB_1 & 0x000000FF */
		if( RegVal.offset == 0x0014604c )
		{
		   cpipel2k8[0].value = (RegVal.value & 0x000000FF);
		   //printf("Setting the GFX_INIT_LAYER with hor & ver sizes from STG registers: cpipel2k8: %x, 14604c val: %x\n", cpipel2k8[0].value,(RegVal.value & 0x000000FF));
		}

        if( RegVal.offset  == 0x0014C600)
        {
            /* Backlight count val */
            ulBackLtCountVal = RegVal.value ;
            printf("ulBackLtCountVal 0x%x\n", ulBackLtCountVal );
        }
        else if( RegVal.offset == 0x0014C610)
        {
            /* Backlight max val */
            ulBackLtMaxVal = RegVal.value ;
            printf("ulBackLtMaxVal 0x%X\n", ulBackLtMaxVal );
        }
        else if( RegVal.offset == 0x0017800c) /* This register update is moved to EnableLVDS() */
        {
            /* Backlight max val */
            gClockLvdsCpipe[20].value  = RegVal.value ;
            printf("LVDS BUFF CNTRL REG value 0x%X\n", gClockLvdsCpipe[20].value );
        }
        else
        {
            PNX8XXXFB_MMIO_WRITE( par.vmmio+RegVal.offset, RegVal.value );
        }
    }

    // Fxied value for these regs! 
    PNX8XXXFB_MMIO_WRITE( par.vmmio+0x147c00, 1);
    PNX8XXXFB_MMIO_WRITE( par.vmmio+0x47478, 13);
    /* Added to solve PR eh25#15339 */
    PNX8XXXFB_MMIO_WRITE( par.vmmio+0x4747c, 13);

    /* Set the status */
    status |= CONFIG_LVDS_DONE  ;
}

/******************************************************************************
** NAME        : splaEnableLVDS
**
** PARAMETERS  : Display enviornment table  
**
** RETURNS     : None
**
** DESCRIPTION : Enable the LVDS
**
******************************************************************************/
void splaEnableLVDS(  tsDISPDATA *psDispData  )
{
    unsigned char ucIdx=0;

    pnx8xxx_reg_t  RegVal;

    if( !psDispData )
    {
        return ;
    }
 
    RegVal.offset = psDispData->puData[ucIdx++].iData ;
    RegVal.value  = psDispData->puData[ucIdx++].iData ;

    if( status & WAIT_EXACT_DONE )
    {
#ifdef DEBUG
        DPRINTF("splaEnableLVDS  MsgLen =%d\n",psDispData->ucMsgLen  );
#endif

        /* Configrue the lvds and cpipe */
        pnx85500fb_enableLVDS_lvdscpipe( &par );

        /* enable the panel */
        pnx85500fb_enable_panel( &par , RegVal.offset, RegVal.value );
 
        status |= ENABLE_LVDS_DONE ;

#if 0
        /* SPLASH is enabled */
        setenv( SPLASH_IS_ON , "1");
        saveenv();
#endif

    }
}

/******************************************************************************
** NAME        : splaSetPin
**
** PARAMETERS  : Display enviornment table 
**
** RETURNS     : None
**
** DESCRIPTION : Set IO pin using I2C
**
******************************************************************************/
void splaSetPin(   tsDISPDATA *psDispData  )
{
    int           iretval=0;
    unsigned char ucIdx=0;
    unsigned int uiPin= 0  ;
    unsigned int uiVal= 0  ;
    unsigned int uiMode= 0 ;

    unsigned char I2cBuf[8];

    if( !psDispData )
    {
        return ;
    }

    if( status & CONFIG_LVDS_DONE )
    {
        uiPin = psDispData->puData[ucIdx++].iData;
        uiMode= psDispData->puData[ucIdx++].iData;
        uiVal = psDispData->puData[ucIdx++].iData;

        if( uiPin <= 0xFF ) /* i2c command for mips */
        { 
#if 0
            /* Set MIPS Pin value */ 
            writel( uiVal, uiPin );
#endif

#ifdef DEBUG
            DPRINTF("SARA : MIPS SetPin %d  0x%X\n", uiVal, uiPin ) ;
#endif
        } 
        else  /* i2c command for standby processor */
        {
            /* Set Pin Mode */ 
            I2cBuf[0] = 0x00 ;
            I2cBuf[1] = 0x07 ;
            I2cBuf[2] = 0x00 ;
            I2cBuf[3] = 0x03 ;
            I2cBuf[4] = (char) (uiPin & 0xFF);
            I2cBuf[5] = uiMode      ;
            I2cBuf[6] = uiMode>>8   ;
            iretval = i2c_write(CONFIG_STANDBY_SLAVE_ADDR, 0, 0, I2cBuf, 7);  // TEST

#ifdef DEBUG
            DPRINTF("SARA : STANDBY SetPin mode 0x%X 0x%X 0x%X 0x%X 0x%X 0x%X 0x%X\n", I2cBuf[0], I2cBuf[1], I2cBuf[2], I2cBuf[3], I2cBuf[4], I2cBuf[5], I2cBuf[6] );
#endif

            /* Set Pin value */ 
            I2cBuf[0] = 0x00 ;
            I2cBuf[1] = 0x04 ;
            I2cBuf[2] = 0x00 ;
            I2cBuf[3] = 0x02 ;
            I2cBuf[4] = (char) (uiPin & 0xFF);
            I2cBuf[5] = (char) uiVal;
            iretval = i2c_write(CONFIG_STANDBY_SLAVE_ADDR, 0, 0, I2cBuf, 6);  // TEST

#ifdef DEBUG
            DPRINTF("SARA : STANDBY SetPin value 0x%X 0x%X 0x%X 0x%X 0x%X 0x%X\n", I2cBuf[0], I2cBuf[1], I2cBuf[2], I2cBuf[3], I2cBuf[4], I2cBuf[5] );
#endif
        }

        status |= SET_PIN_DONE ;
    }
#ifdef DEBUG
    DPRINTF("splaSetPin  0x%X %d  0x%X \n", uiPin, uiMode, uiVal );
#endif
}

/******************************************************************************
** NAME        : splaSetPinWithDelay
**
** PARAMETERS  : Display enviornment table 
**
** RETURNS     : None
**
** DESCRIPTION : Set standby GPIO pins with delay using I2C
**
******************************************************************************/
void splaSetPinWithDelay (   tsDISPDATA *psDispData  )
{
    int           iretval=0;
    unsigned char ucIdx=0;
    unsigned int uiPin= 0  ;
    unsigned int uiVal= 0  ;
    unsigned int uiTimeout = 0  ;
    unsigned int uiMode= 0 ;

    unsigned char I2cBuf[9];

    if( !psDispData )
    {
        return ;
    }

    if( status & CONFIG_LVDS_DONE )
    {
        uiPin = psDispData->puData[ucIdx++].iData  & 0xFF ;
        uiMode= psDispData->puData[ucIdx++].iData  & 0xFFFF ;
        uiVal = psDispData->puData[ucIdx++].iData  & 0xFF ;
        uiTimeout = psDispData->puData[ucIdx++].iData  & 0xFFFF ;

        DPRINTF("SARA : STANDBY SetPinWithDelay  0x%X 0x%X 0x%X 0x%X\n", uiPin, uiMode, uiVal, uiTimeout );

        /* Set Pin Mode */ 
        I2cBuf[0] = 0x00 ;
        I2cBuf[1] = 0x07 ;
        I2cBuf[2] = 0x00 ;
        I2cBuf[3] = 0x03 ;
        I2cBuf[4] = (char) (uiPin & 0xFF);
        I2cBuf[5] = uiMode      ;
        I2cBuf[6] = uiMode>>8   ;
        iretval = i2c_write(CONFIG_STANDBY_SLAVE_ADDR, 0, 0, I2cBuf, 7);  // TEST


        /* Set Pin value with delay */ 
        I2cBuf[0] = 0x00 ;
        I2cBuf[1] = 0xb4 ;
        I2cBuf[2] = 0x00 ;
        I2cBuf[3] = 0x04 ;
        I2cBuf[4] = (char) (uiPin & 0xFF);
        I2cBuf[5] = (char) uiVal;
        I2cBuf[6] = (char) (uiTimeout & 0xFF) ;
        I2cBuf[7] = (char) (uiTimeout>>8) ;
        iretval = i2c_write(CONFIG_STANDBY_SLAVE_ADDR, 0, 0, I2cBuf, 8);  // TEST

//#ifdef DEBUG
            DPRINTF("SARA : STANDBY SetPinWithDelay value 0x%X 0x%X 0x%X 0x%X 0x%X 0x%X 0x%X 0x%X\n", I2cBuf[0], I2cBuf[1], I2cBuf[2], I2cBuf[3], I2cBuf[4], I2cBuf[5] , I2cBuf[6],  I2cBuf[7] );
//#endif
        }

#ifdef DEBUG
    DPRINTF("splaSetPinWithDelay  0x%X %d  0x%X  %d \n", uiPin, uiMode, uiVal, uiTimeout );
#endif
}

/******************************************************************************
** NAME        : splaWaitExact
**
** PARAMETERS  : Display enviornment table 
**
** RETURNS     : None
**
** DESCRIPTION : Busy loop for a specified time.
**
******************************************************************************/
void splaWaitExact(  tsDISPDATA *psDispData  )
{
    unsigned int uiTime=0;

    if( !psDispData )
    {
        return ;
    }

    if( status & SET_PIN_DONE )
    {
        uiTime =  psDispData->puData[0].iData ;

#ifdef DEBUG
        DPRINTF("splaWaitExact  %d  %d  %d\n", 
            psDispData->ucMsgType,
            psDispData->ucMsgLen, uiTime );
#endif

        udelay( uiTime* 1000 ); // uiTime milliseconds

        status |= WAIT_EXACT_DONE ;
    }

}

/******************************************************************************
** NAME        : splaWaitAtleast
**
** PARAMETERS  : Display enviornment table 
**
** RETURNS     : None
**
** DESCRIPTION : Start the timer to wait atleast T time.
**
******************************************************************************/
void splaWaitAtleast(  tsDISPDATA *psDispData  )
{
    
    if( !psDispData )
    {
        return ;
    }

    if(status & ENABLE_LVDS_DONE )
    {
        guiTime= (ulong) psDispData->puData[0].iData ;

        ulStartTime = get_timer(0);

        // Workaround for get_timer issue 
        set_timeout( guiTime * 1000 );



#ifdef DEBUG
        DPRINTF("splaWaitAtleast  %d  %d  %d\n", 
            (int)psDispData->ucMsgType,
            (int)psDispData->ucMsgLen , (int)guiTime );
#endif
    }
}

/******************************************************************************
** NAME        : splaCheckWaitAtleast 
**
** PARAMETERS  : None
**
** RETURNS     : TRUE  -> Time elapsed
**               FALSE -> Time not elapsed
**
** DESCRIPTION : Check the elapsed time from start of the WaitAtleast timer.
**
******************************************************************************/
int splaCheckWaitAtleast( void )
{
    ulong ulTimeElapsed = 0 ;

    ulTimeElapsed = get_timer( ulStartTime );

#ifdef DEBUG
    DPRINTF(" Elapsed time %d  cmptime %d\n", (int)ulTimeElapsed, (int)guiTime );
#endif

    // Workaround for get_timer issue 
    while (!did_timeout()) 
    { 
        udelay(1000); 
    }

#if 0
    if( ulTimeElapsed >= guiTime )
    { 
        status |= WAIT_ATLEAST_DONE ;
    }
    else
    {
        printf("Timer not expired\m");
    }
#endif
 
    return TRUE ;
}


/******************************************************************************
** NAME        : splaSetRegister
**
** PARAMETERS  : Display enviornment table 
**
** RETURNS     : None
**
** DESCRIPTION : Update the register with new value.
**
******************************************************************************/
void splaSetRegister(  tsDISPDATA *psDispData  )
{
    unsigned char ucIdx=0;
    pnx8xxx_reg_t  RegVal;

    if( !psDispData )
    {
        return ;
    }

#ifdef DEBUG
    DPRINTF("splaSetRegister   %d  %d   ", 
        psDispData->ucMsgType,
        psDispData->ucMsgLen);
#endif

    while( ucIdx < psDispData->ucMsgLen )
    {
        RegVal.offset = psDispData->puData[ucIdx++].iData ;
        RegVal.value  = psDispData->puData[ucIdx++].iData ;
        PNX8XXXFB_MMIO_WRITE( par.vmmio+RegVal.offset, RegVal.value );
    }
}


/******************************************************************************
** NAME        : splaShowSplash
**
** PARAMETERS  : Display enviornment table 
**
** RETURNS     : TRUE -> showsplash success
**               FALSE -> showsplash not yet started 
**
** DESCRIPTION : Display the splash screen.
**
******************************************************************************/
int splaShowSplash(  tsDISPDATA *psDispData  )
{
    if( !psDispData )
    {
       return FALSE;
    }

        /* Parameters of SHOW_SPLASH are used in disp_env parser function to
        set the global configuration : refer the function splaInitDispConfig */
#ifdef DEBUG
        DPRINTF("splaShowSplash %d  %d  %d  %s\n", 
            psDispData->ucMsgType,
            psDispData->ucMsgLen,
            psDispData->puData[0].iData,
            psDispData->puData[1].acData);
#endif
        
    return TRUE ;
}

/******************************************************************************
** NAME        : splaBacklight
**
** PARAMETERS  : Display enviornment table 
**
** RETURNS     : None
**
** DESCRIPTION : Set the bakclight with given params.
**
******************************************************************************/
int splaBacklight(  tsDISPDATA *psDispData )
{
    unsigned int uilevel=0;
    uchar        I2cBuf[7];
    ulong ulCountMask = 0xc0000000 ;

    if( !psDispData )
    {
        return FALSE ;
    }

     uilevel =  psDispData->puData[0].iData ;

#ifdef DEBUG
        DPRINTF("splaBacklight %d  %d  %d\n", 
            psDispData->ucMsgType,
            psDispData->ucMsgLen, uilevel );
#endif


#if 1
    /* controll pin 2.2 of stby processor */
    /* code from Hedwin tmbtMain.c
     * enable LVDS data on standby pin 2.2  =
     * configure pin 2.2 as output pin 
     */
    /* To conrol BackLight level*/
#if 0
    ulcountval = (PAN_FREQ/100) * uilevel ;
    //ulcountval = 0xC0000000 | ulcountval ; 
    PNX8XXXFB_MMIO_WRITE( par.vmmio + 0x0014C600,  ulcountval );
    PNX8XXXFB_MMIO_WRITE( par.vmmio + 0x0014C610,  0xC00AFC80);
#else
    ulCountMask      = (ulBackLtCountVal & 0xC0000000 ) ; // Keep the last two bits unchange
    ulBackLtCountVal =  ulBackLtMaxVal & 0x3fffffff ;    // use only 0-29 bits for brightness calculation
    ulBackLtCountVal = (ulCountMask) | ((ulBackLtCountVal/100) * uilevel) ;

    printf("BackLtCount val 0x%X maxval 0x%X mask 0x%X  uilevel %d\n", ulBackLtCountVal, ulBackLtMaxVal, (ulCountMask), uilevel );

    PNX8XXXFB_MMIO_WRITE( par.vmmio + 0x0014C600,  ulBackLtCountVal);
    PNX8XXXFB_MMIO_WRITE( par.vmmio + 0x0014C610,  ulBackLtMaxVal );
#endif

   if( ucSetPinWithDelay == FALSE )
   {
    // lamp on
    I2cBuf[0] = 0x00; // message type and invoke id (synchro)
    I2cBuf[1] = 0x07; // rpc funcid LO (pinsetmode)
    I2cBuf[2] = 0x00; // rpc funcid HI (pinsetmode)
    I2cBuf[3] = 0x03; // parameter length
    I2cBuf[4] = 0x22; // pin id
    I2cBuf[5] = 0x00; // output mode Open Drain
    I2cBuf[6] = 0x00; // output mode Open Drain
    i2c_write(CONFIG_STANDBY_SLAVE_ADDR, 0, 0,  I2cBuf, 7  );

    /* configure pin 2.2 as low todo check if low or high */
    I2cBuf[0] = 0x00; // message type and invoke id (synchro)
    I2cBuf[1] = 0x04; // rpc funcid LO (pinsetmode)
    I2cBuf[2] = 0x00; // rpc funcid HI (pinsetmode)
    I2cBuf[3] = 0x02; // parameter length
    I2cBuf[4] = 0x22; // pin id
    I2cBuf[5] = 0x01; // lamp on
    i2c_write(CONFIG_STANDBY_SLAVE_ADDR, 0, 0,  I2cBuf, 6  );

    //udelay(800000); // dealy between lcd power on and lampon

    // LCD Power on setmode
    I2cBuf[0] = 0x00; // message type and invoke id (synchro)
    I2cBuf[1] = 0x07; // rpc funcid LO (pinsetmode)
    I2cBuf[2] = 0x00; // rpc funcid HI (pinsetmode)
    I2cBuf[3] = 0x02; // parameter length
    I2cBuf[4] = 0x20; // pin id
    I2cBuf[5] = 0x00; // output mode Open Drain
    i2c_write(CONFIG_STANDBY_SLAVE_ADDR, 0, 0,  I2cBuf, 6  );
   
    // LCD Power on setlatch
    I2cBuf[0] = 0x00; // message type and invoke id (synchro)
    I2cBuf[1] = 0x04; // rpc funcid LO (pinsetmode)
    I2cBuf[2] = 0x00; // rpc funcid HI (pinsetmode)
    I2cBuf[3] = 0x03; // parameter length
    I2cBuf[4] = 0x20; // pin id
    I2cBuf[5] = 0x00 ; //(char) uilevel ; // output mode ?
    I2cBuf[6] = 0x00 ; //(char) uilevel ; // output mode ?
    i2c_write(CONFIG_STANDBY_SLAVE_ADDR, 0, 0,  I2cBuf, 7  );
  }   

#endif

    return TRUE ;
}


/******************************************************************************
** NAME        : splaSet2DDimming
**
** PARAMETERS  : Display enviornment table 
**
** RETURNS     : Status of setting 2Ddimming/scanning.
**
** DESCRIPTION : Set the 2Ddimming with given params.
**
******************************************************************************/
int splaSet2DDimming( tsDISPDATA *psDispData )
{
    unsigned char ucIdx=0;
    pnx8xxx_reg_t  RegVal;
    u_int32_t      tmp;
    unsigned long ulMaxval =0;
    unsigned int   boostLevel = 0;

    if( !psDispData )
    {
        return FALSE ;
    }

    /* 2D dimming boost level */
    boostLevel =  psDispData->puData[ucIdx++].iData ;

#ifdef DEBUG
        DPRINTF("splaSet2DDimming boost Level=%d  Len=%d\n", boostLevel, psDispData->ucMsgLen );
#endif

    while( ucIdx < psDispData->ucMsgLen )
    {
        RegVal.offset = psDispData->puData[ucIdx++].iData ;
        RegVal.value  = psDispData->puData[ucIdx++].iData ;

        switch( RegVal.offset )
        {
            case TMAPCTV55XPWMDRVREG_CLK_PWM2_CTL:

#ifdef DEBUG
                printf("2DDIMMING : TMAPCTV55XPWMDRVREG_CLK_PWM2_CTL 0x%X\n", RegVal.value );
#endif
                PNX8XXXFB_MMIO_WRITE( par.vmmio+RegVal.offset, RegVal.value );
                break;
				
            case TMAPCTV55XPWMDRVREG_GPIO_TSU:
#ifdef DEBUG
                printf("2DDIMMING : TMAPCTV55XPWMDRVREG_GPIO_TSU\n");
#endif
                PNX8XXXFB_MMIO_WRITE( par.vmmio+TMAPCTV55XPWMDRVREG_GPIO_TSU, RegVal.value );

                /*  read the RESET value of the register & set the bit 26 to 1*/
                tmp = PNX8XXXFB_MMIO_READ( par.vmmio + TMAPCTV55XPWMDRVREG_GPIO_MASK_AND_IO_DATA );
                tmp |= 0x04000000;
                PNX8XXXFB_MMIO_WRITE( par.vmmio+TMAPCTV55XPWMDRVREG_GPIO_MASK_AND_IO_DATA, tmp );

                /* read the reset value of the register & set the bit 21 to 1 , bit 20 to 0 */
                tmp = PNX8XXXFB_MMIO_READ( par.vmmio + TMAPCTV55XPWMDRVREG_MODE_CTL_0 );
                tmp |= 0x00200000;
                PNX8XXXFB_MMIO_WRITE( par.vmmio+TMAPCTV55XPWMDRVREG_MODE_CTL_0, tmp );
                break;

            case TMAPCTV55XPWMDRVREG_PWM2_MAXVAL :
#ifdef DEBUG
                printf("2DDIMMING : TMAPCTV55XPWMDRVREG_PWM2_MAXVAL\n");
#endif
                tmp = PNX8XXXFB_MMIO_READ( par.vmmio + TMAPCTV55XPWMDRVREG_PWM2_CNTVAL );
                // Keep the last 2 bits unchanged & RESET all 29bits
                tmp &= 0xC0000000;
 
                // Get the max boost val
                ulMaxval = RegVal.value & 0x3fffffff;

                // Set the count val as percentage of max boostlevel 
                tmp |= ((ulMaxval/100)*boostLevel);
                PNX8XXXFB_MMIO_WRITE( par.vmmio+TMAPCTV55XPWMDRVREG_PWM2_CNTVAL, tmp);

                PNX8XXXFB_MMIO_WRITE( par.vmmio+TMAPCTV55XPWMDRVREG_PWM2_MAXVAL, RegVal.value );
                break;
				
            case TMAPCTV55XPWMDRVREG_PWM23_HSCNT :
#ifdef DEBUG
                printf("2DDIMMING : TMAPCTV55XPWMDRVREG_PWM23_HSCNT  0x%X\n", RegVal.value );
#endif
                PNX8XXXFB_MMIO_WRITE( par.vmmio+TMAPCTV55XPWMDRVREG_PWM23_HSCNT, RegVal.value );				
                break;
				
            case TMAPCTV55XPWMDRVREG_PWM23_UPDREG:
#ifdef DEBUG
                printf("2DDIMMING : TMAPCTV55XPWMDRVREG_PWM23_UPDREG  0x%X\n", RegVal.value );
#endif
                PNX8XXXFB_MMIO_WRITE( par.vmmio+TMAPCTV55XPWMDRVREG_PWM23_UPDREG, RegVal.value );
                break;
				
            case TMAPCTV55XPWMDRVREG_PWM23_RST :
#ifdef DEBUG
                printf("2DDIMMING : TMAPCTV55XPWMDRVREG_PWM23_RST  0x%X\n", RegVal.value );
#endif
                PNX8XXXFB_MMIO_WRITE( par.vmmio+TMAPCTV55XPWMDRVREG_PWM23_RST, RegVal.value );

                tmp = PNX8XXXFB_MMIO_READ( par.vmmio + TMAPCTV55XPWMDRVREG_GPIO_MUX_SEL );
                /* set the bit21 to 1, bit20 to 0 */
                tmp |= 0x00200000;
#ifdef DEBUG
                printf("2DDIMMING : TMAPCTV55XPWMDRVREG_GPIO_MUX_SEL,   0x%X\n", tmp);
#endif
                PNX8XXXFB_MMIO_WRITE( par.vmmio+TMAPCTV55XPWMDRVREG_GPIO_MUX_SEL, tmp );
                break;
				
           default :
                break;
        }
        
    }

    return TRUE ;
}

/******************************************************************************
** NAME        : splaConfigHeader
**
** PARAMETERS  : Display enviornment table 
**
** RETURNS     : None
**
** DESCRIPTION : Display config string header.
**
******************************************************************************/
void splaConfigHeader( tsDISPDATA *psDispData )
{
    if( !psDispData )
    {
        return ;
    }

    PRINTF("splaConfigHeader %d  %d  %d  %s \n", 
        psDispData->ucMsgType,
        psDispData->ucMsgLen,
        psDispData->puData[0].iData,
        psDispData->puData[1].acData);
}

/******************************************************************************
** NAME        : splaSendI2C
**
** PARAMETERS  : None
**
** RETURNS     : None
**
** DESCRIPTION : send the given message to I2C bus
**
******************************************************************************/
void splaSendI2C( tsDISPDATA *psDispData  )
{
    int   iLen ;
    unsigned char  *pcdata;

    int   old_bus;

    if( !psDispData )
    {
        return ;
    }

#ifdef DEBUG
    PRINTF("splaConfigHeader %d  %d  %d  %s \n", 
        psDispData->ucMsgType,
        psDispData->ucMsgLen,
        psDispData->puData[0].iData,
        psDispData->puData[1].acData);
#endif

    iLen   = psDispData->puData[0].iData ;
    pcdata = (unsigned char *)psDispData->puData[1].acData ;

    /* 
    * 1.  first byte =  I2c bus. Possibles values:
    *         0x00: I2C1 bus of the PNX85500
    *         0x10: I2C2 bus of the PNX85500
    *         0x20: I2C3 bus of the PNX85500
    *         0x30: I2C4 bus of the PNX85500
    * 2.second byte = I2C address.
    * 3.Third byte = I2C sub-address. This defines which I2C register we want to change.
    * 4.Following bytes = I2C data. This is the values to write into the register
    */

    /* Get the current i2c bus */
    old_bus = i2c_get_bus_num();

    /* Set the new i2c bus */
    i2c_set_bus_num( pcdata[0] );

    i2c_write( pcdata[1] , pcdata[2] , 2, pcdata+3 , iLen-3  );

    /* Set back the old i2c bus */
    i2c_set_bus_num( old_bus );
}
    
/******************************************************************************
** NAME        : splaWaitI2C
**
** PARAMETERS  : None
**
** RETURNS     : None
**
** DESCRIPTION : Wait until an I2C read action returns a certain value
**
******************************************************************************/
void splaWaitI2C(  tsDISPDATA *psDispData  )
{
    int   iLen  ;
    char  *pcdata;
    unsigned char ucExpectVal =0  ;
    unsigned char byte ;

    int   old_bus;

    if( !psDispData )
    {
        return ;
    }

#ifdef DEBUG
    PRINTF("splaConfigHeader %d  %d  %d  %s \n", 
        psDispData->ucMsgType,
        psDispData->ucMsgLen,
        psDispData->puData[0].iData,
        psDispData->puData[1].acData);
#endif

    ucExpectVal = (unsigned char) psDispData->puData[0].iData ;
    iLen   = psDispData->puData[0].iData ;
    pcdata = psDispData->puData[1].acData ;

    /* 
    * 1.  first byte =  I2c bus. Possibles values:
    *         0x00: I2C1 bus of the PNX85500
    *         0x10: I2C2 bus of the PNX85500
    *         0x20: I2C3 bus of the PNX85500
    *         0x30: I2C4 bus of the PNX85500
    * 2.second byte = I2C address.
    * 3.Third byte = I2C sub-address. This defines which I2C register we want to read.
    */
    /* Get the current i2c bus */
    old_bus = i2c_get_bus_num();

    /* Set the new i2c bus */
    i2c_set_bus_num( pcdata[0] );

    do{
        i2c_read( pcdata[1] , pcdata[2], 1, &byte , 1);
        udelay(1000);
    } while( ucExpectVal != byte );

    /* Set back the old i2c bus */
    i2c_set_bus_num( old_bus );

}

/******************************************************************************
** NAME        : Main
**
** PARAMETERS  : None
**
** RETURNS     : Status of test application.
**
** DESCRIPTION : Sample application to test the DispEnv string parser.
**
******************************************************************************/
int splash_main( void )
{

    ulong start = get_timer(0) ;
    ulong end   ;
    char *pdispEnv ;

    char acDispEnv[] = SPLASHENV ;

    tsDISPDATA *psDispData ;

    /* Default ubf file load address */
    setenv( UBF_LOAD_ADDR , UBF_LOAD_ADDR_VAL );

#if 0
    /* SPLASH is not yet enabled */
    setenv( SPLASH_IS_ON , "0");
//#else
    printf("set SPLASHENV test string\n");
    setenv( SPLASHENV, pcldispEnv );
    saveenv( );
#endif

    pdispEnv = getenv ( acDispEnv );
    splaParseDispEnv( pdispEnv ) ;

    end = get_timer( start );
    //PRINTF("Time taken by DispEnvParser  %d\n", (int) end );

    psDispData = splaNextDispData();
    while( psDispData )
    {
        switch( psDispData->ucMsgType)
        {
            case MSG_CONFIG_HEADER:
                splaConfigHeader( psDispData ) ;
                break;

            case MSG_SHOW_SPLASH  :
                splaShowSplash( psDispData);
                break;

            case MSG_SEND_I2C :
                splaSendI2C( psDispData );
                break;

            case MSG_WAIT_I2C :
                splaWaitI2C( psDispData );
                break;

            case MSG_CONFIG_LVDS  :
                splaConfigLVDS( psDispData );
                break;

            case MSG_ENABLE_LVDS  :
                splaEnableLVDS( psDispData ) ;
                break;

            case MSG_SET_REGISTER :
                splaSetRegister( psDispData );
                break;

            case MSG_SET_PIN      :
                splaSetPin( psDispData ) ;
                break;

            case MSG_SET_PIN_WITHDELAY :
                splaSetPinWithDelay( psDispData ) ;
                break;

            case MSG_BACKLIGHT    :
                if( ucSetPinWithDelay )
                {
                    splaBacklight( psDispData );
                }
                else
                {
                    /* Has to be done in lampon command */
                    ucFirstNode= TRUE ; /* lampon command should start with the current node */
                }
                break;

            case MSG_2D_DIMMING   :
                splaSet2DDimming( psDispData );
                break;

            case MSG_WAIT_EXACT   :
                splaWaitExact( psDispData ) ;
                break;

            case MSG_WAIT_ATLEAST :
                splaWaitAtleast( psDispData ) ;
                break;

            default           :
                break;
        }
   
        if( !ucFirstNode ) 
            psDispData = splaNextDispData();
        else
            break;
    }

    end = get_timer( start );
    //PRINTF("Time taken SplashApp %d\n", (int)end );

    return 0;
}

/******************************************************************************
** NAME        : lampon
**
** PARAMETERS  : None
**
** RETURNS     : Status of test application.
**
** DESCRIPTION : Sample application to test the DispEnv string parser.
**
******************************************************************************/
int lampon( void )
{
    tsDISPDATA *psDispData ;

    PRINTF("start SPLASH Lampon sequence \n");

    if( !splaCheckWaitAtleast() )
    {
        return FALSE ;
    }

    psDispData = splaNextDispData();

    while( psDispData )
    {
        switch( psDispData->ucMsgType)
        {
            case MSG_CONFIG_HEADER:
                splaConfigHeader( psDispData ) ;
                break;

            case MSG_SHOW_SPLASH  :
                splaShowSplash( psDispData);
                break;

            case MSG_SEND_I2C :
                splaSendI2C( psDispData );
                break;

            case MSG_WAIT_I2C :
                splaWaitI2C( psDispData );
                break;

            case MSG_CONFIG_LVDS  :
                splaConfigLVDS( psDispData );
                break;

            case MSG_ENABLE_LVDS  :
                splaEnableLVDS( psDispData ) ;
                break;

            case MSG_SET_REGISTER :
                splaSetRegister( psDispData );
                break;

            case MSG_SET_PIN      :
                splaSetPin( psDispData ) ;
                break;

            case MSG_SET_PIN_WITHDELAY :
                splaSetPinWithDelay( psDispData ) ;
                break;

            case MSG_BACKLIGHT    :
                splaBacklight( psDispData );
                break;

            case MSG_2D_DIMMING   :
                splaSet2DDimming( psDispData );
                break;

            case MSG_WAIT_EXACT   :
                splaWaitExact( psDispData ) ;
                break;

            case MSG_WAIT_ATLEAST :
                splaWaitAtleast( psDispData ) ;
                break;

            default           :
                break;

        }
    
        psDispData = splaNextDispData();
    }

    PRINTF("End SPLASH Lampon sequence \n");

    ucLamponEnabled = TRUE ;

    return TRUE;
}


/******************************************************************************
** NAME        : lampon_enabled
**
** PARAMETERS  : None
**
** RETURNS     : TRUE : lampon enabled .
**               False: lampon not enabled .
**
** DESCRIPTION : To check lampon is enabled or not.
**
******************************************************************************/
int lampon_enabled( void )
{
#ifdef DEBUG
    PRINTF("Lampon Enabled %d\n", ucLamponEnabled );
#endif

    return ucLamponEnabled ;
}
