#include <pnx8550_glb.h>
#include <asm-mips/addrspace.h>
#define int32_t     long
#define u_int32_t   unsigned long
#define __u32       unsigned long

#define PNX8XXXFB_DFPTYPE_FILE				0
#define PNX8XXXFB_DFPTYPE_PHILIPS_1080P		1
#define PNX8XXXFB_DFPTYPE_PHILIPS_768P		2
#define PNX8XXXFB_DFPTYPE_PHILIPS_1080P120	3

#define PNX8XXXFB_MMIO_BASE					0x1BE00000
#define PNX8XXXFB_MMIO_SZ					( 2 << 20 )

#define PNX8XXXFB_TM0_PC_OFFSET				0x14004C

#define PNX8XXXFB_SDRAM_BASE				( 0x00000000 + (64 << 20) )
#define PNX8XXXFB_SDRAM_SZ					( 8 << 20 )
#define PNX8XXXFB_SDRAM_POOL_SZ				( 24 << 20 )

#define PNX8XXXFB_MMIO_READ( a ) 			*((volatile unsigned int *)((a))) //readl( (void __iomem*)(a) )
#define PNX8XXXFB_MMIO_WRITE( a, w )		*((volatile unsigned int *)((a))) = (unsigned long)(w)//writel( (u_int32_t)(w), (void __iomem *)(a) )

#define PNX8XXXFB_PALETTE_CNT		16


#define DMA_ARB1_OFFSET							0x00052000
#define DMA_ARB1_ENTRIESA_OFFSET				0x00052800
#define DMA_ARB1_ENTRIESB_OFFSET				0x00052804
#define DMA_ARB1_CTRL_OFFSET					0x00052900
#define DMA_ARB1_STATUS_OFFSET					0x00052904
#define DMA_ARB2_OFFSET							0x00053000
#define DMA_ARB2_ENTRIESA_OFFSET				0x00053800
#define DMA_ARB2_ENTRIESB_OFFSET				0x00053804
#define DMA_ARB2_CTRL_OFFSET					0x00053900
#define DMA_ARB2_STATUS_OFFSET					0x00053904
#define DMA_ARB_BOOTMODE						0x00000000
#define DMA_ARB_MODEA							0x00000001
#define DMA_ARB_MODEB							0x00000002

#define LVDSTX_SRESRET_OFFSET					0x00177ff0
#define LVDSTX2_SRESRET_OFFSET					0x00114ff0

#define CPIPE_GFX_DECOMP1_CTRL_OFFSET			0x00063B80
#define CPIPE_GFX_DECOMP2_CTRL_OFFSET			0x00063B84
#define CPIPE_GFX_DECOMP3_CTRL_OFFSET			0x00063B88
#define CPIPE_GFX_DECOMP_CTRL_RESET				0x00001000

#define LAYER_STATUS_CTRL_GFX2_OFFSET			0x00147400
#define LAYER_STATUS_CTRL_DISABLE				0x00000000
#define LAYER_STATUS_CTRL_ENABLE				0x00000001

#define LAYER_INITIAL_SIZE_GFX2_OFFSET			0x00147404
#define LAYER_FINAL_SIZE_GFX2_OFFSET			0x00147408

#define RIF_LINE_WIDTH_BAMODE_PK_GFX2_OFFSET	0x0014745C
#define RIF_ADDR_A_PK_GFX2_OFFSET				0x00147464

#define RIF_FORMAT_GFX2_OFFSET					0x00147444
#define RIF_FORMAT_ARGB32						0xa0000018
#define RIF_FORMAT_ARGB4444						0x50000019 
#define RIF_FORMAT_RGB16						0x5000001B
#define RIF_FORMAT_YUY2							0x50000010
#define RIF_FORMAT_UYVY							0x50000011
#define RIF_FORMAT_CLUT8						0x00000003

#define RIF_PITCH_A_PK_GFX2_OFFSET				0x0014746C

#define CLUT_DATA_GFX2_OFFSET					0x00147520
#define CLUT_ADDR_GFX2_OFFSET					0x00147524

#define GS2D_FRAME_GEOMETRY_OUTPUT_GFX2_OFFSET	0x00147768

#define PROGIF_INTERRUPT_CLR_OFFSET				0x00146FE8
#define PROGIF_INTERRUPT_STS_OFFSET				0x00146FE0
#define PROGIF_INTERRUPT_STS_L4_DONE			0x00080000

struct fb_bitfield {
        __u32 offset;                   /* beginning of bitfield        */
        __u32 length;                   /* length of bitfield           */
        __u32 msb_right;                /* != 0 : Most significant bit is */
                                        /* right */
};

struct fb_var_screeninfo {
        __u32 xres;                     /* visible resolution           */
        __u32 yres;
        __u32 bits_per_pixel;           /* guess what                   */
        struct fb_bitfield red;         /* bitfield in fb mem if true color, */
        struct fb_bitfield green;       /* else only length is significant */
        struct fb_bitfield blue;
        struct fb_bitfield transp;      /* transparency                 */
        __u32 nonstd;                   /* != 0 Non standard pixel format */
};

typedef struct
{
	int32_t		offset;
	u_int32_t	value;

} pnx8xxx_reg_t, *ppnx8xxx_reg_t;

typedef const pnx8xxx_reg_t *pcpnx8xxx_reg_t;

typedef struct pnx8xxx_ovlsetup
{
	int32_t		pmem;
	u_int32_t	mode;
	u_int32_t	w;
	u_int32_t	h;

} pnx8xxx_ovlsetup_t, *ppnx8xxx_ovlsetup_t;

typedef const pnx8xxx_ovlsetup_t *pcpnx8xxx_ovlsetup_t;

typedef struct pnx8xxx_par
{
	u_int32_t					vmmio;
	u_int32_t					vmem;
	u_int32_t					pmem;
	u_int32_t					stridemul;
	u_int32_t					pseudo_palette[PNX8XXXFB_PALETTE_CNT];
	int32_t						dfp_type;
	ppnx8xxx_reg_t				dfp_regs;
	ppnx8xxx_ovlsetup_t			ovl;
	struct fb_var_screeninfo	*varsinfo;

} pnx8xxx_par_t, *ppnx8xxx_par_t;

/*-----------------------------------------------------------------------------
// Global data:
//-----------------------------------------------------------------------------
*/

static const struct fb_var_screeninfo gtmvipLmFb_ScreenInf = 
{
    1920,
    1080,
    16,//32,
    { 24, 8, 0 },
    { 16, 8, 0 },
    {  8, 8, 0 },
    {  0, 8, 0 },
};

static const pnx8xxx_reg_t	clocks[] =
{
	{ 0x00047440, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_CPIPE_L2K8_PIX_CTL
	{ 0x00047444, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_CPIPE_L2VO_OUT_CTL
	{ 0x00047448, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_CPIPE_L2VO_PIX_CTL
	{ 0x00047484, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_CPIPE_L2VO_PROC_CTL
	
	{ 0x00047470, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_CPIPE_L2K8_PROC1_CTL
	{ 0x00047474, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_CPIPE_L2K8_PROC2_CTL
	{ 0x00047478, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_CPIPE_L2K8_PROC3_CTL
	{ 0x0004747c, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_CPIPE_L2K8_PROC4_CTL
	{ 0x00047480, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_CPIPE_L2K8_PROC5_CTL

	{ 0x000474c0, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_LVDS_TX_PIX_CTL
	{ 0x000474c4, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_LVDS_TX_PLLIN_CTL
	{ 0x000474cc, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_LVDS_TX20_1_CTL
	{ 0x000474d0, 0x00000003 }, // TV550/PNX85500/CLOCKS/Other Registers/CLK_LVDS_TX20_2_CTL

	{ 0x00047A40, 0x00000003 },

	{ -1, 		  0x00000000 }
};


static const pnx8xxx_reg_t	cpipetvpix_pll_297[] =
{
	{ 0x000470ac, 0x0d34199d }, // TV550/PNX85500/CLOCKS/Other Registers/PLL_CPIPETVPIX_CON1_CTL
	{ 0x000470b0, 0x10e8c408 }, // TV550/PNX85500/CLOCKS/Other Registers/PLL_CPIPETVPIX_CON2_CTL
	{ 0x000470b8, 0x4018c888 }, // TV550/PNX85500/CLOCKS/Other Registers/CPIPETVPIX_PLLFRAC_CTL
	{ 0x000470b4, 0x00000002 }, // TV550/PNX85500/CLOCKS/Other Registers/PLL_CPIPETVPIX_STA_CTL
};

static const pnx8xxx_reg_t	cpipetvpix_pll_148[] =
{
	{ 0x000470ac, 0x0c301999 }, // TV550/PNX85500/CLOCKS/Other Registers/PLL_CPIPETVPIX_CON1_CTL
	{ 0x000470b0, 0x10e8c400 }, // TV550/PNX85500/CLOCKS/Other Registers/PLL_CPIPETVPIX_CON2_CTL
	{ 0x000470b8, 0x4018c888 }, // TV550/PNX85500/CLOCKS/Other Registers/CPIPETVPIX_PLLFRAC_CTL
	{ 0x000470b4, 0x00000002 }, // TV550/PNX85500/CLOCKS/Other Registers/PLL_CPIPETVPIX_STA_CTL
};

static const pnx8xxx_reg_t	cpipetvproc_pll_300[] =
{
	{ 0x000470bc, 0x0d34199d }, // TV550/PNX85500/CLOCKS/Other Registers/PLL_CPIPETVPROC_CON1_CTL
	{ 0x000470c0, 0x10e8c408 }, // TV550/PNX85500/CLOCKS/Other Registers/PLL_CPIPETVPROC_CON2_CTL
	{ 0x000470c8, 0x40190000 }, // TV550/PNX85500/CLOCKS/Other Registers/CPIPETVPROC_PLLFRAC_CTL
	{ 0x000470c4, 0x00000002 }, // TV550/PNX85500/CLOCKS/Other Registers/PLL_CPIPETVPROC_STA_CTL
};

static const pnx8xxx_reg_t	lvdsbuf[] =
{
	{ 0x00178004, 0x00000010 }, // TV550/PNX85500/LVDS_BUF/Other Registers/INTRP_ZONE
	{ 0x00178008, 0x00000100 }, // TV550/PNX85500/LVDS_BUF/Other Registers/FILL_LEVEL
	{ 0x0017800c, 0x004e2402 }, // TV550/PNX85500/LVDS_BUF/Other Registers/CNTRL_REG
	{ 0x00178010, 0x00000018 }, // TV550/PNX85500/LVDS_BUF/Other Registers/VID_DFLTS
	{ 0x00178014, 0x00000001 }, // TV550/PNX85500/LVDS_BUF/Other Registers/DELTA_ADDR
	{ 0x00178018, 0x00000000 }, // TV550/PNX85500/LVDS_BUF/Other Registers/AMBI_SUBS
	{ 0x0017801c, 0x04040004 }, // TV550/PNX85500/LVDS_BUF/Other Registers/VPG_CTRL
	{ 0x00178020, 0x04650898 }, // TV550/PNX85500/LVDS_BUF/Other Registers/VPG_WINDOW
	{ 0x00178024, 0x043a0781 }, // TV550/PNX85500/LVDS_BUF/Other Registers/VPG_ACTIVE
	{ 0x00178028, 0x002a0117 }, // TV550/PNX85500/LVDS_BUF/Other Registers/VPG_OFFSET
	{ 0x0017802c, 0x0000003e }, // TV550/PNX85500/LVDS_BUF/Other Registers/VPG_HSYNC
	{ 0x00178030, 0x00010004 }, // TV550/PNX85500/LVDS_BUF/Other Registers/VPG_VSYNC
	{ 0x00178034, 0x01ad0000 }, // TV550/PNX85500/LVDS_BUF/Other Registers/VPG_VFIELD
	{ 0x00178038, 0x00400040 }, // TV550/PNX85500/LVDS_BUF/Other Registers/VPG_BARS
	{ 0x0017803c, 0x000000ff }, // TV550/PNX85500/LVDS_BUF/Other Registers/VPG_COL1
	{ 0x00178040, 0x00ff0000 }, // TV550/PNX85500/LVDS_BUF/Other Registers/VPG_COL2
	{ 0x00178044, 0x00ffffff }, // TV550/PNX85500/LVDS_BUF/Other Registers/VPG_COL3

	{ -1, 		  0x00000000 }
};

static const pnx8xxx_reg_t	lvdstx_1080p[] =
{
	{ 0x00177040, 0x00011e80 }, // TV550/PNX85500/LVDS_TX/Other Registers/PPLL_SETUP
	{ 0x00177000, 0x0080a414 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_IFC_SETUP
	{ 0x00177004, 0x00000000 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_ELECTR_SETUP0
	{ 0x00177008, 0x00000000 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_ELECTR_SETUP1
	{ 0x0017700c, 0x00000000 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_BLANK_COLOR
	{ 0x00177010, 0x0b0a0908 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PB0_3_A
	{ 0x00177014, 0x00000d0c }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PB4_5_A
	{ 0x00177018, 0x08080808 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PBC0_3_A
	{ 0x0017701c, 0x00000808 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PBC4_5_A
	{ 0x00177020, 0x0b0a0908 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PB0_3_B
	{ 0x00177024, 0x00000d0c }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PB4_5_B
	{ 0x00177028, 0x08080808 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PBC0_3_B
	{ 0x0017702c, 0x00000808 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PBC4_5_B
	{ 0x00177030, 0x07070707 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PB0_3_C
	{ 0x00177034, 0x00000007 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PB4_C
	{ 0x00177038, 0x08080808 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PBC0_3_C
	{ 0x0017703c, 0x00000008 }, // TV550/PNX85500/LVDS_TX/Other Registers/OI_PBC4_C
	{ 0x00177044, 0xaf000018 }, // TV550/PNX85500/LVDS_TX/Other Registers/PPLL_FSEL
	{ 0x00177048, 0x11667c61 }, // TV550/PNX85500/LVDS_TX/Other Registers/PPLL_DEBUG
	{ 0x0017704c, 0x00000004 }, // TV550/PNX85500/LVDS_TX/Other Registers/CFG_LD_PULSE
	{ 0x00177050, 0x00000003 }, // TV550/PNX85500/LVDS_TX/Other Registers/LVDS_EN
	{ 0x00177ff0, 0x00040000 }, // TV550/PNX85500/LVDS_TX/Other Registers/SRESET
	{ 0x00177ff4, 0x00000000 }, // TV550/PNX85500/LVDS_TX/Other Registers/POWER_DWN
	{ 0x00177040, 0x00011e81 }, // TV550/PNX85500/LVDS_TX/Other Registers/PPLL_SETUP

	{ 0x00114040, 0x00011e00 }, // TV550/PNX85500/LVDS_TX2/Other Registers/PPLL_SETUP
	{ 0x00114000, 0x0080a414 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_IFC_SETUP
	{ 0x00114004, 0x00000000 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_ELECTR_SETUP0
	{ 0x00114008, 0x00000000 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_ELECTR_SETUP1
	{ 0x0011400c, 0x00000000 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_BLANK_COLOR
	{ 0x00114010, 0x03020100 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PB0_3_A
	{ 0x00114014, 0x00000504 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PB4_5_A
	{ 0x00114018, 0x08080808 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PBC0_3_A
	{ 0x0011401c, 0x00000808 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PBC4_5_A
	{ 0x00114020, 0x03020100 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PB0_3_B
	{ 0x00114024, 0x00000504 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PB4_5_B
	{ 0x00114028, 0x08080808 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PBC0_3_B
	{ 0x0011402c, 0x00000808 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PBC4_5_B
	{ 0x00114030, 0x07070707 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PB0_3_C
	{ 0x00114034, 0x00000007 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PB4_C
	{ 0x00114038, 0x08080808 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PBC0_3_C
	{ 0x0011403c, 0x00000008 }, // TV550/PNX85500/LVDS_TX2/Other Registers/OI_PBC4_C
	{ 0x00114044, 0x8c0000a7 }, // TV550/PNX85500/LVDS_TX2/Other Registers/PPLL_FSEL
	{ 0x00114048, 0x11667c61 }, // TV550/PNX85500/LVDS_TX2/Other Registers/PPLL_DEBUG
	{ 0x0011404c, 0x00000004 }, // TV550/PNX85500/LVDS_TX2/Other Registers/CFG_LD_PULSE
	{ 0x00114050, 0x00000003 }, // TV550/PNX85500/LVDS_TX2/Other Registers/LVDS_EN
	{ 0x00114ff0, 0x00040000 }, // TV550/PNX85500/LVDS_TX2/Other Registers/SRESET
	{ 0x00114ff4, 0x00000000 }, // TV550/PNX85500/LVDS_TX2/Other Registers/POWER_DWN
	{ 0x00114040, 0x00011e01 }, // TV550/PNX85500/LVDS_TX2/Other Registers/PPLL_SETUP

	{ -1, 		  0x00000000 }
};

static const pnx8xxx_reg_t	cpipel2qtv_stg_1080p120[] =
{
	{ 0x00146000, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GLB_CTRL_GLB_1
	{ 0x00146004, 0x2a },		// TV550/PNX85500/CPIPE_L2K8/Other Registers/GLB_SHADOW_RELOAD_GLB_1
	{ 0x00146008, 0x00043210 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GLB_LAYER_ASSIGN_GLB_1
	{ 0x0014600c, 0x20080200 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GLB_BACKGROUND_COLOR_GLB_1
	{ 0x00146f00, 0x06111200 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GLB_RTL_FREEZE_DATE_GLB_1
	{ 0x00146040, 0x00000031 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_CTRL_GLB_1
	{ 0x00146044, 0x089b0465 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_TOTAL_GLB_1
	{ 0x00146048, 0x089b011a }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_H_BLANK_GLB_1
	{ 0x0014604c, 0x0465002c }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_V_BLANK_O_GLB_1
	{ 0x00146050, 0x003c0068 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_H_SYNC_GLB_1
	{ 0x00146054, 0x00060012 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_V_SYNC_O_GLB_1
	{ 0x00146058, 0x00020002 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_INTL_CTRL_1_GLB_1
	{ 0x0014605c, 0x00020002 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_INTL_CTRL_2_GLB_1
	{ 0x00146060, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_V_BLANK_E_GLB_1
	{ 0x00146064, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_V_SYNC_E_GLB_1
	{ 0x00146068, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_EXT_H_V_TRIGGER_GLB_1
	{ 0x0014606c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_EXT_TRIGGER_STATUS_SELECT_GLB_1
	{ 0x00146070, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_EXT_TRIGGER_STATUS_GLB_1
	{ 0x00146074, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_EXT_TRIGGER_ALIGN_STATUS_GLB_1
	{ 0x00146078, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_ADJUST_CTRL_1_GLB_1
	{ 0x0014607c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_ADJUST_CTRL_2_GLB_1
	{ 0x00146080, 0x0465015e }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_LINE_INTERRUPT_GLB_1
	{ 0x00146084, 0x80000007 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_SHADOW_RELOAD_GLB_1
	{ 0x00146090, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/STG_LINE_INTERRUPT2_GLB_1

	{ 0x00147ce0, 0x04070002 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/OUTC_CTRL_OL_1
	{ 0x00147c00, 0x00000001 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/OUTIF_STATUS_CTRL_OL_1
};

static const pnx8xxx_reg_t	cpipel2k8[] =
{
	{ 0x00147410, 0x011b002c }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/LAYER_START_GFX2_1
	{ 0x00147420, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CROP_CTRL_GFX2_1
	{ 0x00147424, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CROP_WIN_START_GFX2_1
	{ 0x00147428, 0x02d00238 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CROP_WIN_SIZE_GFX2_1
	{ 0x00147430, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/LCU_BOUNDARY_GFX2_1
	{ 0x00147434, 0x00000006 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/LCU_CTRL_GFX2_1
	{ 0x00147438, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/LCU_FIRST_PIXEL_GFX2_1
	{ 0x00147440, 0x0868002c }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_FIRST_PIXEL_GFX2_1
	{ 0x00147448, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_VARIABLE_FORMAT_GFX2_1
	{ 0x0014744c, 0x00000028 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_DUMMY_CNT_GFX2_1
	{ 0x00147450, 0xff000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_PKEY_CTRL_GFX2_1
	{ 0x00147454, 0x8050002b }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_START_FETCH_GFX2_1
	{ 0x00147458, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_INS_GFX2_1
	{ 0x00147460, 0x0000ffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_LINE_INC_PK_GFX2_1
	{ 0x00147468, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_ADDR_B_PK_GFX2_1
	{ 0x00147470, 0x00001e00 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_PITCH_B_PK_GFX2_1
	{ 0x00147474, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_LINE_WIDTH_BAMODE_SP_GFX2_1
	{ 0x00147478, 0x0000ffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_LINE_INC_SP_GFX2_1
	{ 0x0014747c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_ADDR_A_SP_GFX2_1
	{ 0x00147480, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_ADDR_B_SP_GFX2_1
	{ 0x00147484, 0x00001e00 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/RIF_PITCH_SP_GFX2_1
	{ 0x00147488, 0x00000008 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/UDTH_CTRL_GFX2_1
	{ 0x00147520, 0x9503c428 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CLUT_DATA_GFX2_1
	{ 0x00147540, 0x00ffffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_MASK_1_GFX2_1
	{ 0x00147544, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_1_UPP_GFX2_1
	{ 0x00147548, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_1_LOW_GFX2_1
	{ 0x0014754c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_REPLACE_1_GFX2_1
	{ 0x00147550, 0x00ffffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_MASK_2_GFX2_1
	{ 0x00147554, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_2_UPP_GFX2_1
	{ 0x00147558, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_2_LOW_GFX2_1
	{ 0x0014755c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_REPLACE_2_GFX2_1
	{ 0x00147560, 0x00ffffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_MASK_3_GFX2_1
	{ 0x00147564, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_3_UPP_GFX2_1
	{ 0x00147568, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_3_LOW_GFX2_1
	{ 0x0014756c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_REPLACE_3_GFX2_1
	{ 0x00147570, 0x00ffffff }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_MASK_4_GFX2_1
	{ 0x00147574, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_4_UPP_GFX2_1
	{ 0x00147578, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_KEY_4_LOW_GFX2_1
	{ 0x0014757c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_REPLACE_4_GFX2_1
	{ 0x00147580, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_ROPS_1_GFX2_1
	{ 0x00147584, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/CKEY_ROPS_2_GFX2_1
	{ 0x00147690, 0x00000016 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_CTRL_GFX2_1
	{ 0x00147694, 0x08000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_MATRIX_COEFFS_1_GFX2_1
	{ 0x00147698, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_MATRIX_COEFFS_2_GFX2_1
	{ 0x0014769c, 0x08000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_MATRIX_COEFFS_3_GFX2_1
	{ 0x001476a0, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_MATRIX_COEFFS_4_GFX2_1
	{ 0x001476a4, 0x08000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_MATRIX_COEFFS_5_GFX2_1
	{ 0x001476a8, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_OFFSET_UPP_GFX2_1
	{ 0x001476ac, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_OFFSET_MID_GFX2_1
	{ 0x001476b0, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/VCBM_OFFSET_LOW_GFX2_1
	{ 0x001476c0, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_BACKGROUND_COLOR_GFX2_1
	{ 0x001476c4, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_SOLID_COLOR_GFX2_1
	{ 0x001476c8, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_CKEY_MASK_ROP_GFX2_1
	{ 0x001476cc, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_PIXEL_CTRL_ROP_GFX2_1
	{ 0x001476d0, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_ALPHA_BLEND_PASS_GFX2_1
	{ 0x001476d4, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_ALPHA_PASS_GFX2_1
	{ 0x001476d8, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_ALPHA_CTRL_GFX2_1
	{ 0x001476dc, 0x00236058 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_BORDER_START_GFX2_1
	{ 0x001476e0, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_BORDER_SIZE_GFX2_1
	{ 0x001476e4, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_HEIGHT_WIDTH_GFX2_1
	{ 0x001476e8, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_BORDER_COLOR_GFX2_1
	{ 0x001476ec, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/MIX_CURTAIN_COLOR_GFX2_1
	{ 0x00147760, 0x00200001 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_GLB_CTRL_0_GFX2_1
	{ 0x00147764, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_FILTER_KERNEL_GFX2_1
	{ 0x0014776c, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_FRAME_GEOMETRY_INPUT_GFX2_1
	{ 0x00147770, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_H_INITIAL_SET_GFX2_1
	{ 0x00147774, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_V_INITIAL_SET_GFX2_1
	{ 0x00147778, 0x00010000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_H_ZONE_0_SCALE_GFX2_1
	{ 0x0014777c, 0x00010000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GS2D_V_ZONE_0_SCALE_GFX2_1

	{ 0x00147cac, 0x00000000 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GNSH_GAMMA_CTRL_OL_1
	{ 0x00147cb0, 0x00000004 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GNSH_NSH_CTRL_OL_1
	{ 0x00147cb4, 0x00000007 }, // TV550/PNX85500/CPIPE_L2K8/Other Registers/GNSH_UNSIGN_ENABLE_OL_1

	{ -1, 		  0x00000000 }
};

static const pnx8xxx_reg_t	gClockLvdsCpipe[] = 
{
    /* Clocks, size=14*/
	{0x00047440, 0x00000003}, /*0*/
	{0x00047444, 0x00000003}, /*1*/
	{0x00047448, 0x00000003}, /*2*/
	{0x00047484, 0x00000003}, /*3*/
	{0x00047470, 0x00000003}, /*4*/
	{0x00047474, 0x00000003}, /*5*/
	{0x00047478, 0x00000003}, /*6*/
	{0x0004747c, 0x00000003}, /*7*/
	{0x00047480, 0x00000003}, /*8*/
	{0x000474c0, 0x00000003}, /*9*/
	{0x000474c4, 0x00000003}, /*10*/
	{0x000474cc, 0x00000003}, /*11*/
	{0x000474d0, 0x00000003}, /*12*/
	{0x00047A40, 0x00000003}, /*13*/

	/* cpipetvpix_pll, size=4 */
	{0x000470ac, 0x0d34199d}, /*14*/
	{0x000470b0, 0x10e8c408}, /*15*/
	{0x000470b8, 0x4018c888}, /*16*/
	{0x000470b4, 0x00000002}, /*17*/
	
	/* lvdsbuf, size=17*/
	{0x00178004, 0x00000010}, /*18*/
	{0x00178008, 0x00000100}, /*19*/
	{0x0017800c, 0x004e2402}, /*20*/
	{0x00178010, 0x00000018}, /*21*/
	{0x00178014, 0x00000001}, /*22*/
	{0x00178018, 0x00000000}, /*23*/
	{0x0017801c, 0x04040004}, /*24*/
	{0x00178020, 0x04650898}, /*25*/
	{0x00178024, 0x043a0781}, /*26*/
	{0x00178028, 0x002a0117}, /*27*/
	{0x0017802c, 0x0000003e}, /*28*/
	{0x00178030, 0x00010004}, /*29*/
	{0x00178034, 0x01ad0000}, /*30*/
	{0x00178038, 0x00400040}, /*31*/
	{0x0017803c, 0x000000ff}, /*32*/
	{0x00178040, 0x00ff0000}, /*33*/
	{0x00178044, 0x00ffffff}, /*34*/
	
	/* lvdstx1, size=23 */
    {0x00177040, 0x00011e80}, /*35*/	
	{0x00177000, 0x0080a414}, /*36*/
	{0x00177004, 0x00000000}, /*37*/
	{0x00177008, 0x00000000}, /*38*/
	{0x0017700c, 0x00000000}, /*39*/
	{0x00177010, 0x0b0a0908}, /*40*/
	{0x00177014, 0x00000d0c}, /*41*/
	{0x00177018, 0x08080808}, /*42*/
	{0x0017701c, 0x00000808}, /*43*/
	{0x00177020, 0x0b0a0908}, /*44*/
	{0x00177024, 0x00000d0c}, /*45*/
	{0x00177028, 0x08080808}, /*46*/
	{0x0017702c, 0x00000808}, /*47*/
	{0x00177030, 0x07070707}, /*48*/
	{0x00177034, 0x00000007}, /*49*/
	{0x00177038, 0x08080808}, /*50*/
	{0x0017703c, 0x00000008}, /*51*/
	{0x00177044, 0xaf000018}, /*52*/
	{0x00177048, 0x11667c61}, /*53*/
	{0x0017704c, 0x00000004}, /*54*/
	{0x00177050, 0x00000003}, /*55*/
	{0x00177ff0, 0x00040000}, /*56*/
	{0x00177ff4, 0x00000000}, /*57*/

	/* lvdstx2,size=23 */
	{0x00114040, 0x00011e00}, /*58*/
	{0x00114000, 0x0080a414}, /*59*/
	{0x00114004, 0x00000000}, /*60*/
	{0x00114008, 0x00000000}, /*61*/
	{0x0011400c, 0x00000000}, /*62*/
	{0x00114010, 0x03020100}, /*63*/
	{0x00114014, 0x00000504}, /*64*/
	{0x00114018, 0x08080808}, /*65*/
	{0x0011401c, 0x00000808}, /*66*/
	{0x00114020, 0x03020100}, /*67*/
	{0x00114024, 0x00000504}, /*68*/
	{0x00114028, 0x08080808}, /*69*/
	{0x0011402c, 0x00000808}, /*70*/
	{0x00114030, 0x07070707}, /*71*/
	{0x00114034, 0x00000007}, /*72*/
	{0x00114038, 0x08080808}, /*73*/
	{0x0011403c, 0x00000008}, /*74*/
	{0x00114044, 0x8c0000a7}, /*75*/
	{0x00114048, 0x11667c61}, /*76*/
	{0x0011404c, 0x00000004}, /*77*/
	{0x00114050, 0x00000003}, /*78*/
	{0x00114ff0, 0x00040000}, /*79*/
	{0x00114ff4, 0x00000000}, /*80*/
	
	/*cpipel2qtv_stg, size=26*/
	{0x00146000, 0x00000000}, /*81*/
	{0x00146004, 0x2a},       /*82*/
	{0x00146008, 0x00043210}, /*83*/
	{0x0014600c, 0x20080200}, /*84*/
	{0x00146f00, 0x06111200}, /*85*/
	{0x00146040, 0x00000031}, /*86*/
	{0x00146044, 0x089b0465}, /*87*/
	{0x00146048, 0x089b011a}, /*88*/
	{0x0014604c, 0x0465002c}, /*89*/
	{0x00146050, 0x003c0068}, /*90*/
	{0x00146054, 0x00060012}, /*91*/
	{0x00146058, 0x00020002}, /*92*/
	{0x0014605c, 0x00020002}, /*93*/
	{0x00146060, 0x00000000}, /*94*/
	{0x00146064, 0x00000000}, /*95*/
	{0x00146068, 0x00000000}, /*96*/
	{0x0014606c, 0x00000000}, /*97*/
	{0x00146070, 0x00000000}, /*98*/
	{0x00146074, 0x00000000}, /*99*/
	{0x00146078, 0x00000000}, /*100*/
	{0x0014607c, 0x00000000}, /*101*/
	{0x00146080, 0x0465015e}, /*102*/
	{0x00146084, 0x80000007}, /*103*/
	{0x00146090, 0x00000000}, /*104*/
	{0x00147ce0, 0x04070002}, /*105*/
	{0x00147c00, 0x00000001}, /*106*/
	
	/* cpipel2k8,size=72 */
	{0x00147410, 0x011b002c}, /*107*/
	{0x00147420, 0x00000000}, /*108*/
	{0x00147424, 0x00000000}, /*109*/
	{0x00147428, 0x02d00238}, /*110*/
	{0x00147430, 0x00000000}, /*111*/
	{0x00147434, 0x00000006}, /*112*/
	{0x00147438, 0x00000000}, /*113*/
	{0x00147440, 0x0868002c}, /*114*/
	{0x00147448, 0x00000000}, /*115*/
	{0x0014744c, 0x00000028}, /*116*/
	{0x00147450, 0xff000000}, /*117*/
	{0x00147454, 0x8050002b}, /*118*/
	{0x00147458, 0x00000000}, /*119*/
	{0x00147460, 0x0000ffff}, /*120*/
	{0x00147468, 0x00000000}, /*121*/
	{0x00147470, 0x00001e00}, /*122*/
	{0x00147474, 0x00000000}, /*123*/
	{0x00147478, 0x0000ffff}, /*124*/
	{0x0014747c, 0x00000000}, /*125*/
	{0x00147480, 0x00000000}, /*126*/
	{0x00147484, 0x00001e00}, /*127*/
	{0x00147488, 0x00000008}, /*128*/
	{0x00147520, 0x9503c428}, /*129*/
	{0x00147540, 0x00ffffff}, /*130*/
	{0x00147544, 0x00000000}, /*131*/
	{0x00147548, 0x00000000}, /*132*/
	{0x0014754c, 0x00000000}, /*133*/
	{0x00147550, 0x00ffffff}, /*134*/
	{0x00147554, 0x00000000}, /*135*/
	{0x00147558, 0x00000000}, /*136*/
	{0x0014755c, 0x00000000}, /*137*/
	{0x00147560, 0x00ffffff}, /*138*/
	{0x00147564, 0x00000000}, /*139*/
	{0x00147568, 0x00000000}, /*140*/
	{0x0014756c, 0x00000000}, /*141*/
	{0x00147570, 0x00ffffff}, /*142*/
	{0x00147574, 0x00000000}, /*143*/
	{0x00147578, 0x00000000}, /*144*/
	{0x0014757c, 0x00000000}, /*145*/
	{0x00147580, 0x00000000}, /*146*/
	{0x00147584, 0x00000000}, /*147*/
	{0x00147690, 0x00000016}, /*148*/
	{0x00147694, 0x08000000}, /*149*/
	{0x00147698, 0x00000000}, /*150*/
	{0x0014769c, 0x08000000}, /*151*/
	{0x001476a0, 0x00000000}, /*152*/
	{0x001476a4, 0x08000000}, /*153*/
	{0x001476a8, 0x00000000}, /*154*/
	{0x001476ac, 0x00000000}, /*155*/
	{0x001476b0, 0x00000000}, /*156*/
	{0x001476c0, 0x00000000}, /*157*/
	{0x001476c4, 0x00000000}, /*158*/
	{0x001476c8, 0x00000000}, /*159*/
	{0x001476cc, 0x00000000}, /*160*/
	{0x001476d0, 0x00000000}, /*161*/
	{0x001476d4, 0x00000000}, /*162*/
	{0x001476d8, 0x00000000}, /*163*/
	{0x001476dc, 0x00236058}, /*164*/
	{0x001476e0, 0x00000000}, /*165*/
	{0x001476e4, 0x00000000}, /*166*/
	{0x001476e8, 0x00000000}, /*167*/
	{0x001476ec, 0x00000000}, /*168*/
	{0x00147760, 0x00200001}, /*169*/
	{0x00147764, 0x00000000}, /*170*/
	{0x0014776c, 0x00000000}, /*171*/
	{0x00147770, 0x00000000}, /*172*/
	{0x00147774, 0x00000000}, /*173*/
	{0x00147778, 0x00010000}, /*174*/
	{0x0014777c, 0x00010000}, /*175*/
	{0x00147cac, 0x00000000}, /*176*/
	{0x00147cb0, 0x00000004}, /*177*/
	{0x00147cb4, 0x00000007}, /*178*/

	/* cpipetvproc_pll, size=4 */
	{ 0x000470bc, 0x0d34199d },/*179*/
	{ 0x000470c0, 0x10e8c408 },/*180*/
	{ 0x000470c8, 0x40190000 },/*181*/
	{ 0x000470c4, 0x00000002 },/*182*/
	
};

static int pnx85500fb_poll_mask_set( struct pnx8xxx_par *par, u_int32_t offset, u_int32_t mask );
static int pnx85500fb_poll_mask_unset( struct pnx8xxx_par *par, u_int32_t offset, u_int32_t mask );

static void my_sleep( int sleep)
{

   while( sleep--);

}
static inline void pnx8xxx_write_regs( u_int32_t base, pcpnx8xxx_reg_t pregs )
{
	u_int32_t	i;
	
	for ( i=0; pregs[i].offset != -1; i++ )
	{
		PNX8XXXFB_MMIO_WRITE( base+pregs[i].offset, pregs[i].value );
	}
}

static inline void pnx8xxx_write_regs_1( u_int32_t base, pcpnx8xxx_reg_t pregs, unsigned int size )
{
	u_int32_t	i;
	
	for ( i=0; i<size; i++ )
	{
		PNX8XXXFB_MMIO_WRITE( base+pregs[i].offset, pregs[i].value );
	}
}

/*-----------------------------------------------------------------------------
// FUNCTION:	pnx85500fb_init_pll
//-----------------------------------------------------------------------------
*/
static int
pnx85500fb_init_pll( struct pnx8xxx_par *par, const pnx8xxx_reg_t *pReg )
{
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[0].offset, pReg[0].value );
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[1].offset, pReg[1].value | 0x3 );
	pnx85500fb_poll_mask_unset( par, pReg[3].offset, pReg[3].value );
    
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[1].offset, pReg[1].value | 0x2 );
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[2].offset, 0x80000000 );
	pnx85500fb_poll_mask_set( par, pReg[3].offset, pReg[3].value );
	
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[2].offset, pReg[2].value );
	PNX8XXXFB_MMIO_WRITE( par->vmmio + pReg[1].offset, pReg[1].value & ~0x2 );
	pnx85500fb_poll_mask_set( par, pReg[3].offset, pReg[3].value );

	return 0;
}


/*-----------------------------------------------------------------------------
// FUNCTION:	pnx85500fb_init_layer
//-----------------------------------------------------------------------------
*/
static int
pnx85500fb_init_layer( struct pnx8xxx_par *par, struct fb_var_screeninfo *var )
{	
	u_int32_t 			xy, ckeyMask;


	PNX8XXXFB_MMIO_WRITE( par->vmmio + RIF_ADDR_A_PK_GFX2_OFFSET, par->pmem );

	xy = ( ((var->yres & 0xFFF) << 16) | (var->xres & 0xFFF) );
	PNX8XXXFB_MMIO_WRITE( par->vmmio+LAYER_INITIAL_SIZE_GFX2_OFFSET, xy );
	PNX8XXXFB_MMIO_WRITE( par->vmmio+LAYER_FINAL_SIZE_GFX2_OFFSET, xy );
	PNX8XXXFB_MMIO_WRITE( par->vmmio+GS2D_FRAME_GEOMETRY_OUTPUT_GFX2_OFFSET, xy );

	switch( var->bits_per_pixel )
	{
		case 8:
			par->stridemul 	= 1;
			ckeyMask		= 0x000000FF;

			PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_FORMAT_GFX2_OFFSET, RIF_FORMAT_CLUT8 );
			PNX8XXXFB_MMIO_WRITE( par->vmmio+CLUT_ADDR_GFX2_OFFSET, 0x2 );
			break;

		case 16:
			par->stridemul 	= 2;
		
			if ( var->green.length == 6 )
			{
				ckeyMask		= 0x0000FFFF;
				PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_FORMAT_GFX2_OFFSET, RIF_FORMAT_RGB16 );
			}
			else
			{
				ckeyMask		= 0x00000FFF;
				PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_FORMAT_GFX2_OFFSET, RIF_FORMAT_ARGB4444 );
			}
			PNX8XXXFB_MMIO_WRITE( par->vmmio+CLUT_ADDR_GFX2_OFFSET, 0x0 );
			break;

		case 32:
		default:
			par->stridemul	= 4;
			ckeyMask		= 0x00FFFFFF;
		
			PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_FORMAT_GFX2_OFFSET, RIF_FORMAT_ARGB32 );
			PNX8XXXFB_MMIO_WRITE( par->vmmio+CLUT_ADDR_GFX2_OFFSET, 0x0 );
			break;
	}
	
	PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_LINE_WIDTH_BAMODE_PK_GFX2_OFFSET, par->stridemul * (var->xres-1) );
	PNX8XXXFB_MMIO_WRITE( par->vmmio+RIF_PITCH_A_PK_GFX2_OFFSET, par->stridemul * var->xres );

	return 0;
}


/*-----------------------------------------------------------------------------
// FUNCTION:	pnx85500fb_poll_mask_set
//-----------------------------------------------------------------------------
*/
static int pnx85500fb_poll_mask_set( struct pnx8xxx_par *par, u_int32_t offset, u_int32_t mask )
{
	u_int32_t 		tmp, count = 9999;

        do{
           tmp = PNX8XXXFB_MMIO_READ( par->vmmio + offset );
        }while( ((tmp & mask) != mask) && (--count != 0));
	return 0;
}

/*-----------------------------------------------------------------------------
// FUNCTION:    pnx85500fb_poll_mask_unset
//-----------------------------------------------------------------------------
*/
static int pnx85500fb_poll_mask_unset( struct pnx8xxx_par *par, u_int32_t offset, u_int32_t mask )
{
        u_int32_t               tmp, count = 9999;

        do{
        tmp = PNX8XXXFB_MMIO_READ( par->vmmio + offset );
        }while( ((tmp & mask) == mask) && (--count !=0));
        return 0;
}


/*-----------------------------------------------------------------------------
// FUNCTION:	pnx85500fb_init
//-----------------------------------------------------------------------------
*/
int
pnx85500fb_init( struct pnx8xxx_par *par )
{	

	pnx8xxx_write_regs( par->vmmio, &clocks[0] );

	switch( par->dfp_type )
	{
		case PNX8XXXFB_DFPTYPE_PHILIPS_1080P120:
			pnx85500fb_init_pll( par, &cpipetvpix_pll_297[0] );
			break;
		case PNX8XXXFB_DFPTYPE_PHILIPS_1080P:
		default:
			pnx85500fb_init_pll( par, &cpipetvpix_pll_148[0] );
			break;
	}
	
	pnx85500fb_init_pll( par, &cpipetvproc_pll_300[0] );
	//pnx85500fb_init_arbiter( par );

	pnx8xxx_write_regs( par->vmmio, &cpipel2qtv_stg_1080p120[0] );
	
	PNX8XXXFB_MMIO_WRITE( par->vmmio + LAYER_STATUS_CTRL_GFX2_OFFSET, LAYER_STATUS_CTRL_DISABLE );
	pnx8xxx_write_regs( par->vmmio, &cpipel2k8[0] );
	pnx85500fb_init_layer( par, par->varsinfo );

	PNX8XXXFB_MMIO_WRITE( par->vmmio + LVDSTX_SRESRET_OFFSET, 0x00040001 );
	pnx85500fb_poll_mask_set( par, LVDSTX_SRESRET_OFFSET, 0x1 );
	PNX8XXXFB_MMIO_WRITE( par->vmmio + LVDSTX2_SRESRET_OFFSET, 0x00040001 );
	pnx85500fb_poll_mask_set( par, LVDSTX2_SRESRET_OFFSET, 0x1 );

	pnx8xxx_write_regs( par->vmmio, &lvdstx_1080p[0] );
	pnx8xxx_write_regs( par->vmmio, &lvdsbuf[0] );
	
	return 0;
}

/*-----------------------------------------------------------------------------
// FUNCTION:	pnx85500fb_init_1
//-----------------------------------------------------------------------------
*/
int
pnx85500fb_init_1( struct pnx8xxx_par *par )
{	
    unsigned int size = 0;
	size = 14;
	// pnx8xxx_write_regs( par->vmmio, &clocks[0] );
	pnx8xxx_write_regs_1( par->vmmio, &gClockLvdsCpipe[0], size );
	printf("CLOCKS DONE\n");
#if 0
	switch( par->dfp_type )
	{
		case PNX8XXXFB_DFPTYPE_PHILIPS_1080P120:
			pnx85500fb_init_pll( par, &cpipetvpix_pll_297[0] );
			break;
		case PNX8XXXFB_DFPTYPE_PHILIPS_1080P:
		default:
			pnx85500fb_init_pll( par, &cpipetvpix_pll_148[0] );
			break;
	}
#endif
	//pnx85500fb_init_pll( par, &cpipetvpix_pll_297[0] );
	pnx85500fb_init_pll( par, &gClockLvdsCpipe[14] );
    printf("CPIPE TVPIX PLL DONE\n");

	pnx85500fb_init_pll( par, &gClockLvdsCpipe[179] );
	//pnx85500fb_init_pll( par, &cpipetvproc_pll_300[0] );
    printf("CPIPE TVPROC PLL DONE\n");

	//pnx85500fb_init_arbiter( par );
    size = 26;
	pnx8xxx_write_regs_1( par->vmmio, &gClockLvdsCpipe[81], size );
	//pnx8xxx_write_regs( par->vmmio, &cpipel2qtv_stg_1080p120[0] );
    printf("CPIPE L2QTV STG DONE\n");
	
	PNX8XXXFB_MMIO_WRITE( par->vmmio + LAYER_STATUS_CTRL_GFX2_OFFSET, LAYER_STATUS_CTRL_DISABLE );

	size = 72;
	pnx8xxx_write_regs_1( par->vmmio, &gClockLvdsCpipe[107], size );
	//pnx8xxx_write_regs( par->vmmio, &cpipel2k8[0] );
    printf("CPIPE L2K8 DONE\n");
	
	pnx85500fb_init_layer( par, par->varsinfo );

	PNX8XXXFB_MMIO_WRITE( par->vmmio + LVDSTX_SRESRET_OFFSET, 0x00040001 );
	pnx85500fb_poll_mask_set( par, LVDSTX_SRESRET_OFFSET, 0x1 );
	PNX8XXXFB_MMIO_WRITE( par->vmmio + LVDSTX2_SRESRET_OFFSET, 0x00040001 );
	pnx85500fb_poll_mask_set( par, LVDSTX2_SRESRET_OFFSET, 0x1 );

    /* LVDS TX1 */
	PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[35].offset, gClockLvdsCpipe[35].value & 0xfffffff0);
	printf("gClockLvdsCpipe[35].offset: 0x%8x, gClockLvdsCpipe[35].value: 0x%8x\n", gClockLvdsCpipe[35].offset, gClockLvdsCpipe[35].value & 0xfffffff0);
	size = 23;	
	pnx8xxx_write_regs_1( par->vmmio, &gClockLvdsCpipe[36], size );
	PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[35].offset, gClockLvdsCpipe[35].value | 0x1);
	printf("gClockLvdsCpipe[35].offset: 0x%8x, gClockLvdsCpipe[35].value: 0x%8x\n", gClockLvdsCpipe[35].offset, gClockLvdsCpipe[35].value | 0x1);	
    printf("LVDS TX1 DONE\n");

    /* LVDS TX2 */
	PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[58].offset, gClockLvdsCpipe[58].value & 0xfffffff0);
	printf("gClockLvdsCpipe[58].offset: 0x%8x, gClockLvdsCpipe[58].value: 0x%8x\n", gClockLvdsCpipe[58].offset, gClockLvdsCpipe[58].value & 0xfffffff0);
	size = 23;	
	pnx8xxx_write_regs_1( par->vmmio, &gClockLvdsCpipe[59], size );
	PNX8XXXFB_MMIO_WRITE( par->vmmio+ gClockLvdsCpipe[58].offset, gClockLvdsCpipe[58].value | 0x1);
	printf("gClockLvdsCpipe[58].offset: 0x%8x, gClockLvdsCpipe[58].value: 0x%8x\n", gClockLvdsCpipe[58].offset, gClockLvdsCpipe[58].value | 0x1);
	//pnx8xxx_write_regs( par->vmmio, &lvdstx_1080p[0] );
    printf("LVDS TX2 DONE\n");
	
	
	size = 17;
	pnx8xxx_write_regs_1( par->vmmio, &gClockLvdsCpipe[18], size );
	//pnx8xxx_write_regs( par->vmmio, &lvdsbuf[0] );
    printf("LVDS BUF DONE\n");

	return 0;
}

/*-----------------------------------------------------------------------------
// FUNCTION:	pnx85500fb_enable_panel
//-----------------------------------------------------------------------------
*/
int
pnx85500fb_enable_panel( struct pnx8xxx_par *par )
{
	u_int32_t 			tmp;


	tmp = PNX8XXXFB_MMIO_READ( par->vmmio + 0x14c010 );
	tmp |=  0x00020000;
	tmp &= ~0x00000002;
	PNX8XXXFB_MMIO_WRITE( par->vmmio + 0x14c010, tmp );

	return 0;
}


/*-----------------------------------------------------------------------------
// FUNCTION:	pnx85500fb_pan
//-----------------------------------------------------------------------------
*/
int
pnx85500fb_pan( struct pnx8xxx_par *par, const struct fb_var_screeninfo *var )
{
	u_int32_t 		offset = 0;


	PNX8XXXFB_MMIO_WRITE( par->vmmio + PROGIF_INTERRUPT_CLR_OFFSET, 0xFFFFFFFF );
	pnx85500fb_poll_mask_set( par, PROGIF_INTERRUPT_STS_OFFSET, PROGIF_INTERRUPT_STS_L4_DONE );

#if 0
	if ( (var->xoffset == 0) & (var->yoffset == 0) )
	{
		offset = 0;
	}
	else
	{
		offset = (var->yoffset*var->xres_virtual + var->xoffset) * par->stridemul;
	}
#endif
	PNX8XXXFB_MMIO_WRITE( par->vmmio + RIF_ADDR_A_PK_GFX2_OFFSET, par->pmem + offset );
	PNX8XXXFB_MMIO_WRITE( par->vmmio + LAYER_STATUS_CTRL_GFX2_OFFSET, 0x00000000 );

	PNX8XXXFB_MMIO_WRITE( par->vmmio + CPIPE_GFX_DECOMP2_CTRL_OFFSET, CPIPE_GFX_DECOMP_CTRL_RESET );
	PNX8XXXFB_MMIO_WRITE( par->vmmio + CPIPE_GFX_DECOMP2_CTRL_OFFSET, 0x0 );

	PNX8XXXFB_MMIO_WRITE( par->vmmio + PROGIF_INTERRUPT_CLR_OFFSET, 0xFFFFFFFF );
	PNX8XXXFB_MMIO_WRITE( par->vmmio + LAYER_STATUS_CTRL_GFX2_OFFSET, LAYER_STATUS_CTRL_ENABLE );

	pnx85500fb_poll_mask_set( par, PROGIF_INTERRUPT_STS_OFFSET, PROGIF_INTERRUPT_STS_L4_DONE );

	return 0;
}


void SetDisplay( void )
{

	struct pnx8xxx_par par;
	unsigned char		   *pBuf = 0x0F500000;
	// FILE *fp = NULL;

	par.dfp_type = PNX8XXXFB_DFPTYPE_PHILIPS_1080P120;//PNX8XXXFB_DFPTYPE_PHILIPS_1080P;
	par.dfp_regs = 0;
	par.varsinfo = &gtmvipLmFb_ScreenInf;

	par.vmmio = (KSEG1ADDR(MMIO_BASE));
	par.pmem  = 0x0F500000;


	printf("SetDisplay: vmmio: %x, pmem: %x\n", par.vmmio, par.pmem);
	/*fp = fopen("/tmp/mtdparts3/splash1.bmp", "rb+");
	if( fp == NULL )
	{
	   printf("Splash File open Fails..!!");
	   return;
	}*/
	// ReadRegs( &par );
	//memset( pBuf, 0xff, sizeof(gTestPict));
	//memcpy( pBuf, gTestPict, sizeof(gTestPict));

	pnx85500fb_init_1(&par);

	pnx85500fb_enable_panel(&par);

	pnx85500fb_pan(&par, par.varsinfo);


}

void SetDisplay_OLD( void )
{
    struct pnx8xxx_par par;
    unsigned char          *pBuf = 0x0F500000;
	// FILE *fp = NULL;

    par.dfp_type = PNX8XXXFB_DFPTYPE_PHILIPS_1080P120;//PNX8XXXFB_DFPTYPE_PHILIPS_1080P;
    par.dfp_regs = 0;
    par.varsinfo = &gtmvipLmFb_ScreenInf;

    par.vmmio = (KSEG1ADDR(MMIO_BASE));
    par.pmem  = 0x0F500000;


    printf("SetDisplay: vmmio: %x, pmem: %x\n", par.vmmio, par.pmem);
    /*fp = fopen("/tmp/mtdparts3/splash1.bmp", "rb+");
	if( fp == NULL )
	{
	   printf("Splash File open Fails..!!");
	   return;
	}*/
	// ReadRegs( &par );
    //memset( pBuf, 0xff, sizeof(gTestPict));
    //memcpy( pBuf, gTestPict, sizeof(gTestPict));

	pnx85500fb_init(&par);

    pnx85500fb_enable_panel(&par);

    pnx85500fb_pan(&par, par.varsinfo);
}


