/* Copyright (C) 2007 NXP B.V.
 *
 * BRIEF MODULE DESCRIPTION
 *   PNX8XXX global definitions
 *
 * Author: source@mvista.com
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 */

#ifndef __PNX8XXX_GLB_H
#define __PNX8XXX_GLB_H

/* MMIO base in virtual in KSEG1 and physical */
#define PNX8XXX_MMIO_BASE_PHYS		0x1BE00000
#define PNX8XXX_MMIO_BASE_VIRT		0x1BE00000

/* Global register block and reset block base addresses */
#define PNX8XXX_GLB_BASE		(PNX8XXX_MMIO_BASE_VIRT + 0x63000)
#define PNX8XXX_RESET_BASE		(PNX8XXX_MMIO_BASE_VIRT + 0x60000)

/* Global register block */
#define PNX8XXX_GLB_IO_CTRL		*(volatile unsigned long *)(PNX8XXX_GLB_BASE + 0x400)
/* PCI ctrl contains PCI inta output enable bit */
#define PNX8XXX_GLB_PCI_CTRL		*(volatile unsigned long *)(PNX8XXX_GLB_BASE + 0x404)
#define PNX8XXX_GLB_SYS_ENDIAN		*(volatile unsigned long *)(PNX8XXX_GLB_BASE + 0x014)
#define PNX8XXX_GLB_MIPS_RESET_VEC	*(volatile unsigned long *)(PNX8XXX_GLB_BASE + 0x010)

#define PNX8XXX_GLB_MIPS_RESET_VEC_MTL_BSHIFT   (4)
#define PNX8XXX_GLB_MIPS_RESET_VEC_MTL_MASK     (0xFF0)

#define PNX8XXX_GLB_PCI_CTRL_INTA_OUTPUT_MASK	(0x00000002)

#define PNX8XXX_SCRATCH_0		*(volatile unsigned long *)(PNX8XXX_GLB_BASE+0x500)
#define PNX8XXX_SCRATCH_1		*(volatile unsigned long *)(PNX8XXX_GLB_BASE+0x504)
#define PNX8XXX_SCRATCH_2		*(volatile unsigned long *)(PNX8XXX_GLB_BASE+0x508)
#define PNX8XXX_SCRATCH_3		*(volatile unsigned long *)(PNX8XXX_GLB_BASE+0x50C)
#define PNX8XXX_SCRATCH_4		*(volatile unsigned long *)(PNX8XXX_GLB_BASE+0x510)
#define PNX8XXX_SCRATCH_5		*(volatile unsigned long *)(PNX8XXX_GLB_BASE+0x514)
#define PNX8XXX_SCRATCH_6		*(volatile unsigned long *)(PNX8XXX_GLB_BASE+0x518)
#define PNX8XXX_SCRATCH_7		*(volatile unsigned long *)(PNX8XXX_GLB_BASE+0x51C)
#define PNX8XXX_SCRATCH_31		*(volatile unsigned long *)(PNX8XXX_GLB_BASE+0x57C)

/* Reset register block */
#define PNX8XXX_RST_STATUS0		(PNX8XXX_RESET_BASE + 0x0110)
#define PNX8XXX_RST_STATUS1		(PNX8XXX_RESET_BASE + 0x0114)
#define PNX8XXX_RST_CTL0		(PNX8XXX_RESET_BASE + 0x0100)
#define PNX8XXX_RST_CTL1		(PNX8XXX_RESET_BASE + 0x0104)

/* Peripheral MMIO base addresses */
#define PNX8XXX_GIC_BASE		(PNX8XXX_MMIO_BASE_VIRT + 0x03E000)	/* GIC implementation expects virtual addresses */
#define PNX8XXX_TMGIC_BASE		(PNX8XXX_MMIO_BASE_VIRT + 0x102000)	/* GIC implementation expects virtual addresses */
#define PNX8XXX_PCI_BASE		(PNX8XXX_MMIO_BASE_PHYS + 0x040000)
#define PNX8XXX_PCI_BASE_VIRT		(PNX8XXX_MMIO_BASE_VIRT + 0x040000)
#define PNX8XXX_DDRCTRL_BASE		(PNX8XXX_MMIO_BASE_VIRT + 0x065000)	/* DDR ctrl driver expects virtual addresses */
#define PNX8XXX_CLOCK_BASE		(PNX8XXX_MMIO_BASE_VIRT + 0x047000)	/* Clock Module implementation expects virtual addresses */
#define PNX8XXX_XIO_BASE_PHYS		(PNX8XXX_MMIO_BASE_PHYS + 0x040000)
#define PNX8XXX_XIO_BASE_VIRT           (PNX8XXX_MMIO_BASE_VIRT + 0x040000)
#define PNX8XXX_UDMA_BASE_PHYS		(PNX8XXX_MMIO_BASE_PHYS + 0x040000)
#define PNX8XXX_I2C0_BASE_PHYS		(PNX8XXX_MMIO_BASE_PHYS + 0x045000)
#define PNX8XXX_I2C1_BASE_PHYS		(PNX8XXX_MMIO_BASE_PHYS + 0x046000)
#define PNX8XXX_I2C0_BASE_VIRT		(PNX8XXX_MMIO_BASE_VIRT + 0x045000)
#define PNX8XXX_I2C1_BASE_VIRT		(PNX8XXX_MMIO_BASE_VIRT + 0x046000)
#define PNX8XXX_GPIO_BASE_VIRT		(PNX8XXX_MMIO_BASE_VIRT + 0x14C000)	/* GPIO in board boot code expects virtual addresses */
#define PNX8XXX_GPIO_BASE_PHYS		(PNX8XXX_MMIO_BASE_PHYS + 0x14C000)
#define PNX8XXX_MDCS_CFG_BASE_PHYS	(PNX8XXX_MMIO_BASE_PHYS + 0x103000)
#define PNX8XXX_MDCS_SEC_BASE_PHYS	(PNX8XXX_MMIO_BASE_PHYS + 0x115000)
#define PNX8XXX_TDCS_CFG_BASE_PHYS	(PNX8XXX_MMIO_BASE_PHYS + 0x04E000)
#define PNX8XXX_TDCS_SEC_BASE_PHYS	(PNX8XXX_MMIO_BASE_PHYS + 0x068000)

/* PCI Direct Mappings */

#define PNX8XXX_PCI_BASE1_LO_VALUE	0x20000000
#define PNX8XXX_PCI_BASE1_HI_VALUE	0x30000000
#define PNX8XXX_PCI_BASE2_LO_VALUE	0x30000000
#define PNX8XXX_PCI_BASE2_HI_VALUE	0x30100000

#define PNX8XXX_PCIMEM			0x20000000
#define PNX8XXX_PCIMEM_SIZE		0x10000000

#define PNX8XXX_PCIIO			0x30000000
#define PNX8XXX_PCIIO_SIZE		0x00100000

/* Revision ID */
#define PNX8XXX_REVISION		(*(volatile unsigned long *)(PNX8XXX_PCI_BASE_VIRT + 0x48) & 0xFF)

/* Uncached base */
#define PNX8XXX_PORT_BASE		KSEG1

/* GPIO registers */
#define GPIO_0_15_MODE_CTL0		*(volatile unsigned long *)(PNX8XXX_GPIO_BASE_VIRT + 0x000)

/* NAND base address (from nand.h)  */
#define PNX8XXX_NAND_BASE_ADDR		0x10000000

#endif
