/*
 *  Copyright (C) 2007 NXP B.V.
 *
 *  Philips PNX8XXX i2c_ip3203.c
 *
 *  Copyright (C) 2006 Koninklijke Philips Electronics N.V.
 *  Niels Sterrenburg, niels.sterrenburg@philips.com
 *
 *  This program is free software; you can redistribute	 it and/or modify it
 *  under  the terms of	 the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the	License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED	  ``AS	IS'' AND   ANY	EXPRESS OR IMPLIED
 *  WARRANTIES,	  INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO	EVENT  SHALL   THE AUTHOR  BE	 LIABLE FOR ANY	  DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED	  TO, PROCUREMENT OF  SUBSTITUTE GOODS	OR SERVICES; LOSS OF
 *  USE, DATA,	OR PROFITS; OR	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN	 CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

//#include <linux/init.h>
//#include <linux/kernel.h>
//#include <linux/ctype.h>

#include "i2c_ip3203.h"

void pnx8xxx_ip3203_init( void )
{
	/* Make sure IIC is not in the power down mode */
	*IP3203_POWERDOWN = 0;

	/* Disable IIC module and make sure Ack and Start are off */
	*IP3203_CONTROL &= ~IP3203_EN;
	*IP3203_CONTROL &= ~IP3203_AA;
	*IP3203_CONTROL &= ~IP3203_STA;

	/* Set the speed to 100KHz */
	*IP3203_FSBIR = 0x18;

	/* Disable IIC interrupt line */
	*IP3203_INT_EN = 0;

	/* Clear any pending interrupts */
	*IP3203_INT_CLR = IP3203_INTBIT;

	/* Enable IIC module */
	*IP3203_CONTROL |= IP3203_EN;

}

int pnx8xxx_ip3203_write(char* i2c_message, int message_len)
{
	int counter;
	char *messagePointer;
	int result = 1;

	/* Generate start condition */
	*IP3203_CONTROL |= IP3203_STA;

	/* Wait till start condition is generated */
	WAIT_IP3203INT();

	if( !(*IP3203_STATUS == 0x08) )
	{
		result = 0; /* Wrong state  */
	}
	else
	{
		/* Clear start request bit */
		*IP3203_CONTROL &= ~IP3203_STA;

		/* Set SlaveAddress of the Standby processor */
		*IP3203_DAT = IP3203_SLAVE_ADDR;

		/* Clear interrupt */
		*IP3203_INT_CLR = IP3203_INTBIT;

		/* Wait till address is transmitted */
		WAIT_IP3203INT();

		if( !(*IP3203_STATUS == 0x18) )
		{
			result = 0; /* Wrong state  */
		}
		else
		{
			messagePointer = i2c_message;
			/* Transmit the I2c Rpc message */
			for(counter = 0; counter < message_len; counter++)
			{
				/* Set databyte */
				*IP3203_DAT = *messagePointer++;

				/* Clear interrupt */
				*IP3203_INT_CLR = IP3203_INTBIT;

				/* Wait till databyte is transmitted */
				WAIT_IP3203INT();

				if( !(*IP3203_STATUS == 0x28) )
				{
					result = 0; /* Wrong state  */
					break;
				}
			}
		}
	}

	/* Stop transmission by sending stop condition */
	*IP3203_CONTROL |= IP3203_STO;

	/* Clear interrupt */
	*IP3203_INT_CLR = IP3203_INTBIT;

	return result;
}

