/* Include files for ethernet driver */

/* lipp_6300eth_common.h includes config.h from uboot code,MAC base address,
** Speed, mode & autonegotiation 
*/

#include "lipp_6300eth_common.h" 
#include "lipp_6300eth.h"
#include "tmhwLIPP6100Eth_Vhip.h"
#include "tmhwLIPP6100Eth_Cfg.h"
#include "tmhwLIPP6100Eth.h"
#include "tmbslPhy.h"

#include <linux/types.h>
#include <common.h> /* Needed for datatypes for ethernet driver */
#include <asm/io.h>
#include <net.h>

/*----------------------------------------------------------------------------*/
/* Global data:                                                               */
/*----------------------------------------------------------------------------*/

/* Global pointer to get the PHY function pointers */
tmbslPhyConfig_t * gpPhyInterface[TMHWLIPP6100ETH_NUM_UNITS] = {NULL};

/*Array of dma tx & rx descriptor pointers */
dma_descs_t gDma_desc[NUMBER_OF_INTERFACES] __attribute__((__aligned__(4)));

/* Transmit descriptor list, for each interface */
TX_DESCR_t gTxDescList[NUMBER_OF_INTERFACES][HW_DESCR_QUEUE_LEN_TX]__attribute__((__aligned__(4)));

/* Receive descriptor list, for each interface */
RX_DESCR_t gRxDescList[NUMBER_OF_INTERFACES][HW_DESCR_QUEUE_LEN_RX]__attribute__((__aligned__(4)));

/* Allocate buffers, to be used by DMA */
typedef struct txRxBuffs
{
    volatile UInt8 rxBuffer[HW_DESCR_QUEUE_LEN_RX][MAX_ETH_FRAME_SIZE];
    volatile UInt8 rxCopyBuffer[HW_DESCR_QUEUE_LEN_RX][MAX_ETH_FRAME_SIZE];
} txRxBuffs_t,*ptxRxBuffs_t;

/* DMA buffers for receive */
txRxBuffs_t gDmaBuffers[NUMBER_OF_INTERFACES];

UInt8 dev_addr[6] = {0xAA,0xBB,0xCC,0xDD,0xEE,0xFF};

/* Ethernet device structure for uboot */
struct eth_device *pEthDevice[MAX_LIPP_6300ETH_UNITS] = {NULL};

static UInt32 gInitialized = 0;
/*----------------------------------------------------------------------------*/
/* Function prototypes                                                        */
/*----------------------------------------------------------------------------*/

void lipp_6300eth_initialize(void);

static int lipp_6300eth_init(struct eth_device *pEth, bd_t * bis);

static int lipp_6300Eth_recv(struct eth_device *pEth);

static int lipp_6300eth_transmit(struct eth_device *pEth, volatile void *packet, int length);

static void lipp_6300Eth_halt(struct eth_device *pEth);

Int32 setup_phy(plipp_6300eth_priv_t pPriv);

tmErrorCode_t setup_mac(plipp_6300eth_priv_t pPriv);

void setup_dma_descriptors(pdma_descs_t pDesc, UInt32 interfaceNum);


/*----------------------------------------------------------------------------*/
/* Function definitions                                                       */
/*----------------------------------------------------------------------------*/

void lipp_6300eth_initialize(void)
{

    UInt32 unitNum,i;
    plipp_6300eth_priv_t pPriv = NULL;

    GMAC_DBG("Initialize:Start\n");

    gtmhwLIPP6100Eth_Base[0].baseAddress = MAC_BASE_ADDRESS;

    for(unitNum=0; unitNum < MAX_LIPP_6300ETH_UNITS; unitNum++)
    {

        pEthDevice[unitNum] = (struct eth_device *) malloc(sizeof (struct eth_device));

        GMAC_DBG("pEthDevice :%08x\n",pEthDevice[unitNum]);

        pEthDevice[unitNum]->priv = NULL;
            
        if(pEthDevice[unitNum] == NULL)
        {
            GMAC_DBG("Mem alloc failed for ethdevice: lip%d ... exiting\n",unitNum);
            goto __free_mem;
        }

        pPriv = (plipp_6300eth_priv_t) malloc(sizeof (lipp_6300eth_priv_t));

        if(pPriv == NULL)
        {
            GMAC_DBG("Mem alloc failed for priv for lip%d ... exiting\n",unitNum);
            goto __free_mem;
        }

        /* Used in tx,rx routines */        
        pEthDevice[unitNum]->priv = pPriv;

        /* Fill the info for future use in init & other functions */
        pPriv->hwUnitNo = unitNum; 

 //       pEthDevice[unitNum]->iobase = (int)gtmhwLIPP6100Eth_Base[unitNum];

        /* Fill the ethernet interface info */
        sprintf(pEthDevice[unitNum]->name, "lip%d",unitNum);
 
        memcpy(pEthDevice[unitNum]->enetaddr,dev_addr,6);
            
        pEthDevice[unitNum]->init = lipp_6300eth_init;
        pEthDevice[unitNum]->send = lipp_6300eth_transmit;
        pEthDevice[unitNum]->recv = lipp_6300Eth_recv;
        pEthDevice[unitNum]->halt = lipp_6300Eth_halt;

        /* Store the descriptor start addresses in the data structure */
        pPriv->p_tx_descr = &gTxDescList[unitNum][0]; 
        pPriv->p_rx_descr = &gRxDescList[unitNum][0];
        pPriv->dmaEnabled = 0;

		/* Buffers for these descriptors are assigned statically */
        GMAC_DBG("p_tx_descr list :%08x\n",pPriv->p_tx_descr);
        GMAC_DBG("p_rx_descr list :%08x\n",pPriv->p_rx_descr);

        /* This used in descriptor initialization only */
        gDma_desc[unitNum].pTx_desc = &gTxDescList[unitNum][0]; 
        gDma_desc[unitNum].pRx_desc = &gRxDescList[unitNum][0];
		
        setup_dma_descriptors(&gDma_desc[unitNum],unitNum);

        eth_register(pEthDevice[unitNum]);

    }

    GMAC_DBG("lipp_6300eth_initialize:End\n");

    return;

__free_mem:
    for(i=0;i<unitNum;i++)
    {
        if(pEthDevice[unitNum] != NULL)
        {
            if(pEthDevice[unitNum]->priv != NULL)
            {
                free(pEthDevice[unitNum]->priv);
            }

            free(pEthDevice[unitNum]);
        }
        
    }

}


/* Called from n/w interface for h/w initialization */
static int lipp_6300eth_init(struct eth_device *pEth, bd_t * bis)
{
    int ret_val = 0;
    
    plipp_6300eth_priv_t pPriv = pEth->priv;
    tmhwLIPP6100Eth_EnTxfr_t Txfer;
    UInt32 hwVersion;
    UInt32 i;
    
    if(gInitialized == 1U) 
    {
        Txfer.dirFlag = tmhwLIPP6100Eth_Dir_TxRx;

        Txfer.enFlag = tmhwLIPP6100Eth_Enable;

        tmhwLIPP6100Eth_GmacEnableDisable(pPriv->hwUnitNo,&Txfer);

        tmhwLIPP6100Eth_DmaEnableDisable(pPriv->hwUnitNo,&Txfer);    

        pPriv->dmaEnabled = 1;

        return 1;
    }

    memcpy(dev_addr,bis->bi_enetaddr,6);
    memcpy(pEthDevice[0]->enetaddr,dev_addr,6);

    /* Fill in the private structure members */
    pPriv->rx_consume_index = 0;
    pPriv->tx_produce_index = 0;
    pPriv->u_autoneg = ETH_AUTO_NEGOTIATION;
    pPriv->u_speed = ETH_LINK_SPEED;
    pPriv->u_mode = ETH_LINK_MODE; 

    for(i=0;i< HW_DESCR_QUEUE_LEN_RX;i++)
    {
        pPriv->bufferFlip[i] = 0;
    }

    pPriv->dmaEnabled = 0;

    setup_dma_descriptors(&gDma_desc[pPriv->hwUnitNo],pPriv->hwUnitNo);

    /* Get the PHY interface function pointers */
    tmbslPhyGetInterface(pPriv->hwUnitNo,&gpPhyInterface[pPriv->hwUnitNo]);

    tmhwLIPP6100Eth_GetHWVersion(pPriv->hwUnitNo,&hwVersion);

    GMAC_DBG("HW Version:%08x\n",hwVersion);    

    if(hwVersion != 0x2334U)
    {
        GMAC_DBG("Wrong Module ID\n");        
        return 0;
    }

    ret_val = tmhwLIPP6100Eth_Init(pPriv->hwUnitNo);

    if(TM_OK !=  ret_val)
    {
        GMAC_DBG("MAC init failed\n");
    
        return (ret_val);
    }

    ret_val = gpPhyInterface[pPriv->hwUnitNo]->initFunc(pPriv->hwUnitNo);    

    if(TM_OK !=  ret_val)
    {
        GMAC_DBG("Phy init failed\n");
    
        return (ret_val);
    }

    /* Set up the physical layer */
    ret_val = setup_phy(pPriv);
    
    if(TM_OK !=  ret_val)
    {
        GMAC_DBG("Auto neg failed\n");
        return (ret_val);
    }    

    ret_val = setup_mac(pPriv);

    if(TM_OK !=  ret_val)
    {
        GMAC_DBG("MAC setup failed\n");
        return (ret_val);
    }        

    /* Enable the GMAC and DMA for both tx & rx directions */
    Txfer.dirFlag = tmhwLIPP6100Eth_Dir_TxRx;
    Txfer.enFlag = tmhwLIPP6100Eth_Enable;
    pPriv->dmaEnabled = 1;

   /* Reads the register and sets the corresponding bit */
    tmhwLIPP6100Eth_GmacEnableDisable(pPriv->hwUnitNo,&Txfer);

    tmhwLIPP6100Eth_DmaEnableDisable(pPriv->hwUnitNo,&Txfer);

    gInitialized = 1U;

    GMAC_DBG("MAC-PHY init complete,Rx DMA enabled\n");    

    return 1; 

}

static int lipp_6300Eth_recv(struct eth_device *pEth)
{
//    UInt32 intr_status;
    plipp_6300eth_priv_t pPriv = pEth->priv;
    
    Int32 ret_val = 0;
    UInt32 frameSize;
    pUInt8 pEmptyBuf, pFullBuf;
    tmhwLIPP6100Eth_Int_t   macStatus;
    UInt32 intr_status;
    
//    tmhwLIPP6100Eth_Int_t   IntDis;    
    
//    GMAC_DBG("rx recv : Start");

//    while(1) 
//    {

        /* Read the interrupt status */
//        tmhwLIPP6100Eth_IntGetStatus( pPriv->hwUnitNo, &IntDis);

#if ENABLE_CACHE
        invalidate_dcache_range(&pPriv->p_rx_descr[pPriv->rx_consume_index],
                                ((UInt32)&pPriv->p_rx_descr[pPriv->rx_consume_index])+
                                 sizeof(RX_DESCR_t));
#endif

        /* If the descriptor is not processed by DMA then break */
        if((pPriv->p_rx_descr[pPriv->rx_consume_index].RDES0 & RXDESC_RDES0_OWN_VAL) != 0) 
        {

            tmhwLIPP6100Eth_IntGetStatus(pPriv->hwUnitNo,&macStatus);

            intr_status = macStatus.dmaIntVal;

            if(((intr_status & 0xe0000) >> 17) == 0x4)
            {
                tmhwLIPP6100Eth_DmaPollDesc(pPriv->hwUnitNo, tmhwLIPP6100Eth_Dir_Rx);
            }

            goto __no_pkts_received;                

        }

        /* If length Error bit is set */
        if(pPriv->p_rx_descr[pPriv->rx_consume_index].RDES0 & RXDESC_RDES0_LEN_ERR_VAL )
        {
            GMAC_DBG("\nhandle_receive_packets: Length Errors");        
            goto _err_drop_packet ;
        }

        if(pPriv->p_rx_descr[pPriv->rx_consume_index].RDES0 & RXDESC_RDES0_DRIBBLE_VAL)
        {
            GMAC_DBG("\nhandle_receive_packets: Dribble Error");        
            goto _err_drop_packet ;        
        }

        if((pPriv->p_rx_descr[pPriv->rx_consume_index].RDES0 & RXDESC_RDES0_FIRST_DESC_VAL) &&
            (pPriv->p_rx_descr[pPriv->rx_consume_index].RDES0 & RXDESC_RDES0_LAST_DESC_VAL))
        {

            /* If the error summary bit is set, check for overflow and CRC errors 
            ** This is valid when last descriptor bit is set
            */            
            if(pPriv->p_rx_descr[pPriv->rx_consume_index].RDES0 & RXDESC_RDES0_ERR_SUM_VAL)
            {
                if(pPriv->p_rx_descr[pPriv->rx_consume_index].RDES0 & RXDESC_RDES0_OVERFLOW_ERR_VAL)
                {
                    GMAC_DBG("\nhandle_receive_packets: OverFlow Error: Index %d",pPriv->rx_consume_index);        
                }
                if(pPriv->p_rx_descr[pPriv->rx_consume_index].RDES0 & RXDESC_RDES0_CRC_ERR_VAL)
                {
                    GMAC_DBG("\nhandle_receive_packets: CRC Error");        
                }

                goto _err_drop_packet ;

            }
            
            /* Submit the frame to the Kernel */
            frameSize = (pPriv->p_rx_descr[pPriv->rx_consume_index].RDES0 &
                        RXDESC_RDES0_FRM_LEN_MSK) >> RXDESC_RDES0_FRM_LEN_POS;

			#if ENABLE_VIRT_TO_PHYS
            pFullBuf = phys_to_virt((pUInt8)pPriv->p_rx_descr[pPriv->rx_consume_index].RDES2);
			#else
            pFullBuf = (pUInt8)pPriv->p_rx_descr[pPriv->rx_consume_index].RDES2;
			#endif

			#if ENABLE_CACHE
			//           flush_cache(pFullBuf,frameSize);
            invalidate_dcache_range(pFullBuf, pFullBuf+frameSize);
			#endif

//            GMAC_DBG("Rx %u\n",++rxPktCount);

            /* If the frame received is valid, pass it to the upper layer */
            NetReceive(pFullBuf,le32_to_cpu(frameSize));

            if( pPriv->bufferFlip[pPriv->rx_consume_index] == 0)
            {
                pEmptyBuf = &gDmaBuffers[pPriv->hwUnitNo].rxCopyBuffer[pPriv->rx_consume_index][0];
                pPriv->bufferFlip[pPriv->rx_consume_index] = 1;
            }
            else
            {
                pEmptyBuf = &gDmaBuffers[pPriv->hwUnitNo].rxBuffer[pPriv->rx_consume_index][0];
                pPriv->bufferFlip[pPriv->rx_consume_index] =0;                
            }

			#if ENABLE_VIRT_TO_PHYS
            pPriv->p_rx_descr[pPriv->rx_consume_index].RDES2 = virt_to_phys(pEmptyBuf);
			#else
            pPriv->p_rx_descr[pPriv->rx_consume_index].RDES2 = (UInt32)pEmptyBuf;
			#endif

			/* When bufferflip =0, rx buf is full & copybuf is empty. Next time again use 
            ** rx buf as empty buf & copy buf as full buff. Invert the same.
            */                        

//            GMAC_DBG("Next Rx DMA desc :%08x",*(UInt32*)(TMHW_LIPP6100ETH_PHY_MMIO_ADDRESS0+0x104C));   

//          flush_cache(pPriv->p_rx_descr,HW_DESCR_QUEUE_LEN_RX*sizeof(RX_DESCR_t));
            ret_val = 1;

        }
        else
        {
            tmhwLIPP6100Eth_Int_t intStat;
            GMAC_DBG("handle_receive_packets: Dropped Pkt..EOF not set");        
            GMAC_DBG("Current RDES0:%08x\n",pPriv->p_rx_descr[pPriv->rx_consume_index].RDES0);                    
            tmhwLIPP6100Eth_IntGetStatus(0,&intStat);
            GMAC_DBG("Int Stat:%08x\n",intStat.dmaIntVal);

            GMAC_DBG("Current Rx DMA desc :%08x",*(UInt32*)(MAC_BASE_ADDRESS+0x104C));
            GMAC_DBG("Current Rx Buf:%08x",*(UInt32*)(MAC_BASE_ADDRESS+0x1054));

            goto _err_drop_packet;
            
        }

        _err_drop_packet :

//		 GMAC_DBG("Current Rx DMA desc :%08x\n",*(UInt32*)(TMHW_LIPP6100ETH_PHY_MMIO_ADDRESS0+0x104C));

		 /* Set back the own bit for this descriptor, use the same buffer */
        pPriv->p_rx_descr[pPriv->rx_consume_index].RDES0 = RXDESC_RDES0_OWN_VAL;

#if ENABLE_CACHE
        /* After setting & upating the buffer, flush cache */
        flush_cache((UInt32)(&pPriv->p_rx_descr[pPriv->rx_consume_index]),sizeof(RX_DESCR_t));        
#endif

        if(pPriv->rx_consume_index >= (HW_DESCR_QUEUE_LEN_RX-1))
        {
            pPriv->rx_consume_index = 0;
        }
        else
        {
            pPriv->rx_consume_index++;
        }

__no_pkts_received:

//        GMAC_DBG("rx recv : End\n");
        return (ret_val);

//    }

}


static int
lipp_6300eth_transmit(struct eth_device *pEth, volatile void *packet, int length)
{

    plipp_6300eth_priv_t pPriv = (plipp_6300eth_priv_t)pEth->priv;

    UInt32 ret_val = 0;
    UInt32 intr_status;
    tmhwLIPP6100Eth_Int_t   macStatus;
    tmhwLIPP6100Eth_EnTxfr_t Txfer;

#if 0
    int i;
    char*p = (char*)packet;

    GMAC_DBG("Tx: Start\n");

    GMAC_DBG("Virt bufaddr:%08x\n",p);
    
    if (*(unsigned long *)p == *(unsigned long *) ((unsigned long)p & 0x0FFFFFFFUL))
        {
        printf (" Mirror check successful\r\n");
        }else
        printf (" Mirror check failed\r\n");

    for(i=0;i< length;i++)
    {
        GMAC_DBG("%1x",*(p++));
    }
#endif


		/* Check if the own bit is cleared for the current transmit index.
    ** Transmit index loops back after reaching the max descriptor length
    ** For transmit descriptor, only end of ring is set in setup_descriptors()
    */
//    pPriv->p_tx_descr = (struct TX_DESCR_t *)0x500000;

 /*   invalidate_dcache_range(&pPriv->p_tx_descr[pPriv->tx_produce_index],
                            ((UInt32)&pPriv->p_tx_descr[pPriv->tx_produce_index])+
                             sizeof(TX_DESCR_t));
*/                             

    if(0 == (pPriv->p_tx_descr[pPriv->tx_produce_index].TDES0 & TXDESC_TDES0_OWN_VAL)) 
    {

		#if ENABLE_VIRT_TO_PHYS
        pPriv->p_tx_descr[pPriv->tx_produce_index].TDES2 = (UInt32)virt_to_phys(packet);
		#else
        pPriv->p_tx_descr[pPriv->tx_produce_index].TDES2 = (UInt32)packet;
		#endif

//        pPriv->p_tx_descr[pPriv->tx_produce_index].TDES2 = (UInt32)CPHYSADDR(packet);

		pPriv->p_tx_descr[pPriv->tx_produce_index].TDES1 &= TXDESC_TDES1_TX_BUF1_SIZE_CLR; 
        pPriv->p_tx_descr[pPriv->tx_produce_index].TDES0 |=
                                                        TXDESC_TDES0_LASTSEG_VAL |
                                                        TXDESC_TDES0_FIRSTSEG_VAL;

		pPriv->p_tx_descr[pPriv->tx_produce_index].TDES1 = length;

        /* Set the own bit value as the last statement. Otherwise, there could be a race condition */
        pPriv->p_tx_descr[pPriv->tx_produce_index].TDES0 |= TXDESC_TDES0_OWN_VAL;

#if ENABLE_CACHE
        flush_cache((UInt32)(&pPriv->p_tx_descr[pPriv->tx_produce_index]),sizeof(TX_DESCR_t));

        flush_cache(packet,length);
#endif        

        if( 1 == pPriv->dmaEnabled)
        {
            /* If DMA is in suspended state, write to Transmit poll demand register 
            ** Otherwise, enable GMAC and DMA
            */
            tmhwLIPP6100Eth_IntGetStatus(pPriv->hwUnitNo,&macStatus);

            intr_status = macStatus.dmaIntVal;

            if(((intr_status & 0x700000) >> 20) == 0x6)
            {
                tmhwLIPP6100Eth_DmaPollDesc(pPriv->hwUnitNo, tmhwLIPP6100Eth_Dir_Tx);
            }

        }
        else
        {
            /* Enable the GMAC and DMA for both tx direction */
            Txfer.dirFlag = tmhwLIPP6100Eth_Dir_Tx;
            Txfer.enFlag = tmhwLIPP6100Eth_Enable;

            /* Reads the register and sets the corresponding bit */
            tmhwLIPP6100Eth_GmacEnableDisable(pPriv->hwUnitNo,&Txfer);

            tmhwLIPP6100Eth_DmaEnableDisable(pPriv->hwUnitNo,&Txfer);

            pPriv->dmaEnabled =1;
        }

       /* Get the next produce index to set to. For 1 desc, this executes always */
        if( pPriv->tx_produce_index >= ( HW_DESCR_QUEUE_LEN_TX - 1 ))
        {
            pPriv->tx_produce_index = 0 ;
        }
        else
        {
            pPriv->tx_produce_index++;
        }   

//       mdelay(2);

#if 0        
        GMAC_DBG("Buff Len:%d",length);

        GMAC_DBG("Current Tx Desc:%08x",*(UInt32*)(TMHW_LIPP6100ETH_PHY_MMIO_ADDRESS0+0x1048));
        GMAC_DBG("Current Tx Buf:%08x",*(UInt32*)(TMHW_LIPP6100ETH_PHY_MMIO_ADDRESS0+0x1050));

        GMAC_DBG("Virtual Addr:%08x",&pPriv->p_tx_descr[pPriv->tx_produce_index]);
        GMAC_DBG("TDES0:%08x",pPriv->p_tx_descr[pPriv->tx_produce_index].TDES0);
        GMAC_DBG("TDES1:%08x",pPriv->p_tx_descr[pPriv->tx_produce_index].TDES1);
        GMAC_DBG("TDES2:%08x",pPriv->p_tx_descr[pPriv->tx_produce_index].TDES2);
        GMAC_DBG("TDES3:%08x",pPriv->p_tx_descr[pPriv->tx_produce_index].TDES3);        
        GMAC_DBG("Pkt txtd");
#endif                
        /* Wait for the transmission to complete & own bit to get cleared  */
        ret_val = 1;
    }
    else
    {
        #if 0                
        GMAC_DBG("W$$W%WOWN not clred%%#$#\n\n");
        GMAC_DBG("Buff Len:%d",length);

        GMAC_DBG("Current Tx Desc:%08x",*(UInt32*)(TMHW_LIPP6100ETH_PHY_MMIO_ADDRESS0+0x1048));
        GMAC_DBG("Current Tx Buf:%08x",*(UInt32*)(TMHW_LIPP6100ETH_PHY_MMIO_ADDRESS0+0x1050));

        GMAC_DBG("Virtual Addr:%08x",&pPriv->p_tx_descr[pPriv->tx_produce_index]);
        GMAC_DBG("TDES0:%08x",pPriv->p_tx_descr[pPriv->tx_produce_index].TDES0);
        GMAC_DBG("TDES1:%08x",pPriv->p_tx_descr[pPriv->tx_produce_index].TDES1);
        GMAC_DBG("TDES2:%08x",pPriv->p_tx_descr[pPriv->tx_produce_index].TDES2);
        GMAC_DBG("TDES3:%08x",pPriv->p_tx_descr[pPriv->tx_produce_index].TDES3);        
        #endif        
        
    }

//    GMAC_DBG("Tx: End\n\n");

    return ret_val;

}

static void lipp_6300Eth_halt(struct eth_device *pEth)
{

    plipp_6300eth_priv_t pPriv = pEth->priv;

    tmhwLIPP6100Eth_EnTxfr_t txfer;

    GMAC_DBG("Halt:Start\n");
    
    txfer.dirFlag = tmhwLIPP6100Eth_Dir_TxRx;

    txfer.enFlag = tmhwLIPP6100Eth_Disable;

    tmhwLIPP6100Eth_GmacEnableDisable(pPriv->hwUnitNo,&txfer);

    tmhwLIPP6100Eth_DmaEnableDisable(pPriv->hwUnitNo,&txfer);    

    pPriv->dmaEnabled = 0;

    /* Reset all the own bits in receive descriptors , so that no pkts are received */
    mdelay(1);

    GMAC_DBG("Halt:End\n");

}

Int32 setup_phy(plipp_6300eth_priv_t pPriv)
{
    Int32 i = 0 ;
    tmbslPhyBasicModeStatus_t  bms ;
    tmbslPhyBasicModeControl_t bmc ;
    tmbslPhyAutoNegotiationMask_t auto_neg_mask ;
    tmErrorCode_t ret_val;

    memset(&auto_neg_mask,0,sizeof(tmbslPhyAutoNegotiationMask_t));    

    /* 
    * Now check the parameters that are stored in private structure and 
    * accordingly configure the Phy and Mac
    */

    /* Common parameters. Enabling the mask disables the feature */
    auto_neg_mask.mask100BaseT4 = tmbslPhyEnable;
    auto_neg_mask.masknextPageDesired = tmbslPhyEnable;
    auto_neg_mask.protocolSel = tmbslPhyIEEE8023;
    auto_neg_mask.maskRemoteFault = tmbslPhyEnable;

    if( pPriv->u_autoneg == LX_AUTONEG_ENABLE ) 
    {

        if(LX_SPEED_10 == ETH_LINK_SPEED)
        {
            auto_neg_mask.mask100BaseTxFullDuplexSupport = tmbslPhyEnable;
            auto_neg_mask.mask100BaseTxSupport = tmbslPhyEnable;
        }

        /* autonegotiate for three times. If every time it fails, then set fixed values */
        for( i = 0 ; i < AUTO_NEG_RETRY_COUNT ; i++ )
        {
            ret_val =  gpPhyInterface[pPriv->hwUnitNo]->autoNegotiateFunc( pPriv->hwUnitNo, &auto_neg_mask);

            if(TM_OK ==  ret_val)                
            {
                break;
            }

        }

        if(TM_OK != ret_val)
        {
            GMAC_DBG("Auto Negotiation Failed.Disabling auto negotiation\n");                            
        }

    }

    if( ( pPriv->u_autoneg == LX_AUTONEG_DISABLE ) || ( i == AUTO_NEG_RETRY_COUNT) ) 
    {
        /* auto negotiation is disabled or auto negotiation is failed, then set the parameters  
        ** into phy register 
        */

        switch(pPriv->u_speed)
        {
        case LX_SPEED_100:        
            bmc.speed = tmbslPhySpeed100Mbps;                                                        
            break;
        case LX_SPEED_10:                    
            bmc.speed = tmbslPhySpeed10Mbps;                                                                    
            break;            
        default:
            bmc.speed = tmbslPhySpeed10Mbps;                                                                                
            break;
        }

        bmc.duplexMode = ( pPriv->u_mode == LX_MODE_FULL_DUPLEX )? tmbslPhyFullDuplex : tmbslPhyHalfDuplex ;

        bmc.enableCollisionTest = tmbslPhyDisable ;

        /* Write into basic mode control register, the speed and mode values. This function
        ** disables auto negotiation
        */        
        if( gpPhyInterface[pPriv->hwUnitNo]->setBasicModeControlFunc(pPriv->hwUnitNo,&bmc ) != TM_OK ) 
        {
            GMAC_DBG("PHY link setup failed\n");
            goto _err_setup_phy ;
        }

    }

    /* read the status register to get the speed/duplex mode */
    if( gpPhyInterface[pPriv->hwUnitNo]->getBasicModeStatusFunc( pPriv->hwUnitNo, &bms) != TM_OK )
    {
        GMAC_DBG("Get Basic Mode status failed\n");
        goto _err_setup_phy ;
    }

    /* store the updated results into the priv structure */
    pPriv->u_mode = bms.duplexMode ;

    if(tmbslPhySpeed100Mbps == bms.speed)
    {
        pPriv->u_speed = LX_SPEED_100;        
    }
    else if(tmbslPhySpeed10Mbps == bms.speed)
    {
        pPriv->u_speed = LX_SPEED_10;                
    }

    return 0 ;

_err_setup_phy:

    return -1 ;

}

tmErrorCode_t setup_mac(plipp_6300eth_priv_t pPriv)
{

    tmhwLIPP6100Eth_DevConfig_t	eth_cfg ;
    tmhwLIPP6100Eth_DmaCfg_t dmaCfg;
    tmhwLIPP6100Eth_Int_t IntDis;
    
    UInt32 unitNum = pPriv->hwUnitNo;    

    GMAC_DBG("setup_mac: Start\n");

    /* Clear the structure */
    memset(&eth_cfg,0,sizeof(tmhwLIPP6100Eth_DevConfig_t));
    memset(&dmaCfg,0,sizeof(tmhwLIPP6100Eth_DmaCfg_t));

    /* Do the ethernet MAC configuration */
    eth_cfg.autoPadCRC = True;
    eth_cfg.backOffLim = tmhwLIPP6100Eth_BackoffVal0;
    eth_cfg.clockSelect = (tmhwLIPP6100Eth_ClkDiv_t)TMFL_LIPP6100ETH_GMII_ADDRESS_CSR_VAL;
    eth_cfg.ifg = tmhwLIPP6100Eth_IFG96bits;
    eth_cfg.phyAddress = TMFL_LIPP6100ETH_GMII_PHY_ADDRESS_VAL;

    if(LX_SPEED_1000 != pPriv->u_speed)     
    {
        eth_cfg.miiSelect = True; /* 10/100Mbps mode */
    }
    else
    {
        eth_cfg.miiSelect = False; 
    }

    if(LX_SPEED_100 == pPriv->u_speed) 
    {
        eth_cfg.speed100Mbps = True;
    }

    if( LX_MODE_FULL_DUPLEX == pPriv->u_mode) 
    {
        eth_cfg.duplexMode = True;
    }

     /* set the MAC address & correct endianness */
    eth_cfg.station.adrHigh = (__u32) le16_to_cpu(*((__u16 *)&dev_addr[4]));

    eth_cfg.station.adrLow = le32_to_cpu(*((__u32 *)dev_addr));

    tmhwLIPP6100Eth_SetConfig( unitNum, &eth_cfg); 

    /* DMA transmits packets in store and forward mode */
    dmaCfg.storeNforwardEn = (Bool)ETH_STORE_FWD_ENABLE;
    dmaCfg.rxThreshold = (tmhwLIPP6100Eth_RTC_t)ETH_RX_THRESHOLD;
    dmaCfg.txThreshold = (tmhwLIPP6100Eth_TTC_t)ETH_TX_THRESHOLD;

    dmaCfg.disableFrameFlush  = (Bool)ETH_DISABLE_FRAME_FLUSH;
    dmaCfg.fixedBurstEn = (Bool)ETH_FIXED_BURST_ENABLE;

    dmaCfg.differentPBL = (Bool)ETH_DIFF_PBL_ENABLE;    
    dmaCfg.pBL4xmode = (Bool)ETH_4XPBL_ENABLE;
    dmaCfg.burstLen = (tmhwLIPP6100Eth_PBL_t)ETH_TX_PBL_VAL;
    dmaCfg.rxPBL = (tmhwLIPP6100Eth_PBL_t)ETH_RX_PBL_VAL;    

    dmaCfg.txSecondFrameEn = (Bool)ETH_ENABLE_OSF;

    dmaCfg.dmaArbitration = (Bool)ETH_DMA_ARBITRATION;
    
    dmaCfg.priority = (tmhwLIPP6100Eth_DmaPriority_t)ETH_DMA_PRIORITY;

    /* Set the base addresses in the DMA registers */
#if ENABLE_VIRT_TO_PHYS
    dmaCfg.txDescListBaseAdr = (UInt32)virt_to_phys(pPriv->p_tx_descr);
    dmaCfg.rxDescListBaseAdr = (UInt32)virt_to_phys(pPriv->p_rx_descr);
#else
    dmaCfg.txDescListBaseAdr = (UInt32)(pPriv->p_tx_descr);
    dmaCfg.rxDescListBaseAdr = (UInt32)(pPriv->p_rx_descr);
#endif

//    dmaCfg.txDescListBaseAdr = (UInt32)CPHYSADDR(pPriv->p_tx_descr);
//    dmaCfg.rxDescListBaseAdr = (UInt32)CPHYSADDR(pPriv->p_rx_descr);

	tmhwLIPP6100Eth_DmaConfig(unitNum,&dmaCfg);

	/* Disable all interrupts */
    IntDis.dmaIntVal = DMA_MASK_ALL_INTS;
    IntDis.gmacIntVal = 0 ;    

    tmhwLIPP6100Eth_IntDisable(unitNum,&IntDis);

    GMAC_DBG("setup_mac: End\n");

    return 0 ;

}

/* Initializes one Tx & Rx descriptor chain, and the buffers for Tx and Rx direction */
void setup_dma_descriptors(pdma_descs_t pDesc, UInt32 interfaceNum)
{

    UInt32 num_descs;

    memset(pDesc->pTx_desc,0, (sizeof(TX_DESCR_t)*HW_DESCR_QUEUE_LEN_TX));

    /* Set the Transmit End of Ring bit */
    pDesc->pTx_desc[HW_DESCR_QUEUE_LEN_TX-1].TDES0 |= TXDESC_TDES0_END_OF_RING_VAL;

    /* Transmit gets buffer from n/w stack. So no need to allocate */
    #if 0
    for(num_descs=0; num_descs < HW_DESCR_QUEUE_LEN_TX; num_descs++)
    {
        /* Initialize the buffers */    
        pDesc->pTx_desc[num_descs].TDES2= &gDmaBuffers[interfaceNum].txBuffer[interfaceNum][num_descs];
    }
    #endif 
    
    /* Initialize receive descriptors with buffer pointers and set the own bit */
    for(num_descs=0; num_descs < HW_DESCR_QUEUE_LEN_RX; num_descs++)
    {
        /* Set the own bit. DMA can process the descriptors only with own bit set */
        pDesc->pRx_desc[num_descs].RDES0 = RXDESC_RDES0_OWN_VAL;
        pDesc->pRx_desc[num_descs].RDES1 = MAX_ETH_FRAME_SIZE;        

		#if ENABLE_VIRT_TO_PHYS
        pDesc->pRx_desc[num_descs].RDES2 = (UInt32)virt_to_phys( &gDmaBuffers[interfaceNum].rxBuffer[num_descs][0]);
		#else
        pDesc->pRx_desc[num_descs].RDES2 = (UInt32)&gDmaBuffers[interfaceNum].rxBuffer[num_descs][0];
		#endif

//        pDesc->pRx_desc[num_descs].RDES2 = (UInt32)CPHYSADDR(&gDmaBuffers[interfaceNum].rxBuffer[num_descs][0]);
        pDesc->pRx_desc[num_descs].RDES3 = 0;
    }
    
    /*End of ring bit is set for receive direction */
    pDesc->pRx_desc[num_descs-1].RDES1 |= RXDESC_RDES1_END_OF_RING_VAL;

	#if ENABLE_CACHE
    flush_cache(pDesc->pRx_desc,sizeof(RX_DESCR_t)*HW_DESCR_QUEUE_LEN_RX);
	#endif

}


