/* lipp_6300eth.h */
#ifndef _LIPP_6300ETH_H_
#define _LIPP_6300ETH_H_

#include "tmNxTypes.h"

/* Macros for MAC driver */

/* Device speed macros */
#define DEVICE_SPEED_10MBPS (10)
#define DEVICE_SPEED_100MBPS (100)
#define DEVICE_SPEED_1G (1000)

/* Macros to define speed of the link */
#define LX_SPEED_1000  (1000)
#define LX_SPEED_100 (100)
#define LX_SPEED_10 (10)

#define LX_MODE_FULL_DUPLEX (1)
#define LX_MODE_HALF_DUPLEX (0)

/* Autonegotiation enable/disable macros */
#define LX_AUTONEG_ENABLE (1)
#define LX_AUTONEG_DISABLE (0)

#define LX_FLOW_CONTROL_ENABLED (1)
#define LX_FLOW_CONTROL_DISABLED (0)

#define LX_RX_FLOW_CONTROL (0x02)
#define LX_TX_FLOW_CONTROL (0x04)

#define LX_FILTER_TYPE_SW (0)
#define LX_FILTER_TYPE_HW (1)

#define LX_PROMISC_ENABLED (1)
#define LX_PROMISC_DISABLED (0)

#define LX_4SLOT_TIMES (0)
#define LX_28SLOT_TIMES (1)
#define LX_144SLOT_TIMES (2)
#define LX_256SLOT_TIMES (3)

/* Fill level of receive FIFO for activating/deactivating
** hardware flow control. Used when the macro ENABLE_HW_FLOW_CONTROL
** is set to 1.
*/
#define FIFO_FILL_LEVEL_1K (0)
#define FIFO_FILL_LEVEL_2K (1)
#define FIFO_FILL_LEVEL_3K (2)
#define FIFO_FILL_LEVEL_4K (3)
#define FIFO_FILL_LEVEL_5K (4)
#define FIFO_FILL_LEVEL_6K (5)
#define FIFO_FILL_LEVEL_7K (6)

/* Programmable burst length values */
#define BURST_LENGTH_1 (1)
#define BURST_LENGTH_2 (2)
#define BURST_LENGTH_4 (4)
#define BURST_LENGTH_8 (8)
#define BURST_LENGTH_16 (16)
#define BURST_LENGTH_32 (32)

/* DMA transmit threshold values */
#define TX_DMA_THRESHOLD_VAL_64 (0)
#define TX_DMA_THRESHOLD_VAL_128 (1)
#define TX_DMA_THRESHOLD_VAL_192 (2)
#define TX_DMA_THRESHOLD_VAL_256 (3)
#define TX_DMA_THRESHOLD_VAL_40 (4)
#define TX_DMA_THRESHOLD_VAL_32 (5)
#define TX_DMA_THRESHOLD_VAL_24 (6)
#define TX_DMA_THRESHOLD_VAL_16 (7)

/* DMA receive threshold values */
#define RX_DMA_THRESHOLD_VAL_64 (0)
#define RX_DMA_THRESHOLD_VAL_32 (1)
#define RX_DMA_THRESHOLD_VAL_96 (2)
#define RX_DMA_THRESHOLD_VAL_128 (3)

/* DMA priorities in Rx:Tx ratio */
#define DMA_RX1_TX1 (0)
#define DMA_RX2_TX1 (1)
#define DMA_RX3_TX1 (2)
#define DMA_RX4_TX1 (3)


/*----------------------------------------------------------------------------*/
/*********************** configuration options for MAC    *********************/
/*----------------------------------------------------------------------------*/

/* Rx Frame size should be multiple of 4/8/16 depending on bus width. 
 * The frame size should be at least (MTU+14) bytes after meeting the above
 * condition
 */
#define MAX_ETH_FRAME_SIZE (1536)

/* Number of descriptors for transmit side */
#define HW_DESCR_QUEUE_LEN_TX  (1)

/* Number of descriptors for receive side */
#define HW_DESCR_QUEUE_LEN_RX  (10)

/* Interfaces macros */
#define NUMBER_OF_INTERFACES (1)

/* HW or SW filtering */
#define ETH_FILTER_TYPE (LX_FILTER_TYPE_HW)

/* Software based flow control -Enable/Disable */
#define ETH_FLOW_CTRL (LX_FLOW_CONTROL_DISABLED)

/* Macro to enable hardware flow control if the receive FIFO size
 * is greater than 4K
 */    
#define ENABLE_HW_FLOW_CONTROL (0)

/* Activate flow control when the empty space falls below this value */
#define RFA_THRESHOLD (FIFO_FILL_LEVEL_5K)

/* Deactivate flow control when FIFO fill level is less than this value */
#define RFD_THRESHOLD (FIFO_FILL_LEVEL_4K)

#define ETH_DISABLE_FRAME_FLUSH (1)

/* Enable Operate on second frame. 1-Enable, 0-Disable */
#define ETH_ENABLE_OSF (0)

#define ETH_STORE_FWD_ENABLE (1)

#define ETH_TX_THRESHOLD (TX_DMA_THRESHOLD_VAL_256)

#define ETH_RX_THRESHOLD (RX_DMA_THRESHOLD_VAL_128)

/* 4*X PBL mode enable/disable */
#define ETH_4XPBL_ENABLE (0)

/* Separate PBL for Tx & Rx */
#define ETH_DIFF_PBL_ENABLE (0)

#define ETH_FIXED_BURST_ENABLE (1)

/* Programmable burst length value */
#define ETH_TX_PBL_VAL (BURST_LENGTH_32)

#define ETH_RX_PBL_VAL (BURST_LENGTH_32)

/* Enable/Disable DMA arbitration scheme */
#define ETH_DMA_ARBITRATION (0)

/* When DA bit is reset, the values are valid */
#define ETH_DMA_PRIORITY (DMA_RX1_TX1)

/* Flow control direction Tx/Rx or Both */
#define ETH_FLOW_CTRL_DIR (LX_RX_FLOW_CONTROL | LX_TX_FLOW_CONTROL)

/* Promiscuous mode enable/disable */
#define ETH_PROMISC_MODE (LX_PROMISC_DISABLED)

/* Time sent in a pause frame in slot times. Max value is 0xFFFF slot time
** Each slot time is 512 bit times in GMII/MII mode
*/    
#define LX_PAUSE_TIMER_VALUE (256)

/* Pause low threshold value  */
#define ETH_PLT_VALUE (LX_4SLOT_TIMES)

/* To find if there are enough descriptors are available to receive frames */
#define LX_DESC_GAP (10)

#undef  CONTROL_INTR_FREQ

/* Frequency at which the transmit side is interrupted */
#define ETH_TX_INTR_FREQ (1)

/* Frequency at which the receive side is interrupted */
#define ETH_RX_INTR_FREQ (1)

/* Autonegotiation retry count */
#define AUTO_NEG_RETRY_COUNT (3)

/* Number of perfect address filters available on the hardware
** Perfect Filter register 0 is used for MAC address
** Remaining Perfect Filter registers (1-31) are used for programming multicast addresses 
*/
#define ETH_NUM_OF_PER_ADR_FILTERS (32)

/*----------------------------------------------------------------------------*/
/**********************      Descriptor values     ****************************/
/*----------------------------------------------------------------------------*/

/* Transmit descriptor macros */
#define TXDESC_TDES0_OWN_VAL (0x80000000)

/* Status bits 16:0 */
#define TXDESC_TDES0_IHE_VAL (0x10000)
#define TXDESC_TDES0_ES_VAL (0x8000)
#define TXDESC_TDES0_JABTIMEOUT_VAL (0x4000)
#define TXDESC_TDES0_FRMFLUSH_VAL (0x2000)
#define TXDESC_TDES0_LOSSOFCAR_VAL (0x800)
#define TXDESC_TDES0_NOCAR_VAL (0x400)
#define TXDESC_TDES0_LATECOL_VAL (0x200)
#define TXDESC_TDES0_EXCOL_VAL (0x100)
#define TXDESC_TDES0_VLAN_VAL (0x80)
#define TXDESC_TDES0_COLCNT_MSK (0x78)
#define TXDESC_TDES0_COLCNT_POS (3)
#define TXDESC_TDES0_EXDEF_VAL (0x4)
#define TXDESC_TDES0_UNDERFLOW_VAL (0x2)
#define TXDESC_TDES0_DEF_BIT_VAL (0x1)

/* Control  Bits 30:26 */
#define TXDESC_TDES0_INT_VAL (0x40000000)
#define TXDESC_TDES0_LASTSEG_VAL (0x20000000)
#define TXDESC_TDES0_FIRSTSEG_VAL (0x10000000)
#define TXDESC_TDES0_CRC_DISABLE_VAL (0x8000000)
#define TXDESC_TDES0_PAD_DISABLE_VAL (0x4000000)

/* Control  Bits  Bits 23:20 */
#define TXDESC_TDES0_CIC_CLR (0xC00000)
#define TXDESC_TDES0_CIC_POS (22)
#define TXDESC_TDES0_END_OF_RING_VAL (0x200000)
#define TXDESC_TDES0_SEC_ADR_CHAIN_VAL (0x100000)

#define TXDESC_TDES1_TX_BUF2_SIZE_CLR (0xE000FFFF)
#define TXDESC_TDES1_TX_BUF2_SIZE_POS (16)
#define TXDESC_TDES1_TX_BUF1_SIZE_CLR (0xFFFFE000)
#define TXDESC_TDES1_TX_BUF1_SIZE_MSK (0x1FFF)

/* Receive descriptor macros */
#define RXDESC_RDES0_OWN_VAL (0x80000000)
#define RXDESC_RDES0_DST_ADR_FAIL_VAL (0x40000000)

#define RXDESC_RDES0_FRM_LEN_MSK (0x3fff0000)
#define RXDESC_RDES0_FRM_LEN_POS (16)

#define RXDESC_RDES0_ERR_SUM_VAL (0x8000)
#define RXDESC_RDES0_DESC_ERR_VAL (0x4000)
#define RXDESC_RDES0_SRC_ADR_FAIL_VAL (0x2000)
#define RXDESC_RDES0_LEN_ERR_VAL (0x1000)
#define RXDESC_RDES0_OVERFLOW_ERR_VAL (0x800)
#define RXDESC_RDES0_VLAN_TAG_VAL (0x400)
#define RXDESC_RDES0_FIRST_DESC_VAL (0x200)
#define RXDESC_RDES0_LAST_DESC_VAL (0x100)
#define RXDESC_RDES0_IPC_GIANT_VAL (0x80)
#define RXDESC_RDES0_LATE_COL_VAL (0x40)
#define RXDESC_RDES0_FRM_TYP_VAL (0x20)
#define RXDESC_RDES0_WDOG_VAL (0x10)
#define RXDESC_RDES0_RX_ERR_VAL (0x8)
#define RXDESC_RDES0_DRIBBLE_VAL (0x4)
#define RXDESC_RDES0_CRC_ERR_VAL (0x2)
#define RXDESC_RDES0_ADR_MATCH_VAL (0x1)

/* RDES1 */
#define RXDESC_RDES1_DIS_IOC_VAL (0x80000000)
#define RXDESC_RDES1_DIS_IOC_CLR (0x7FFFFFFF)

#define RXDESC_RDES1_END_OF_RING_VAL (0x8000)
#define RXDESC_RDES1_SEC_ADR_CHN_VAL (0x4000)
#define RXDESC_RDES1_BUF2_LEN_CLR (0xE000FFFF)
#define RXDESC_RDES1_BUF2_LEN_POS (16)
#define RXDESC_RDES1_BUF1_LEN_MSK (0x1FFF)
#define RXDESC_RDES1_BUF1_LEN_CLR (0xFFFFE000)

/*----------------------------------------------------------------------------*/
/**********************      Interrupt masks       ****************************/
/*----------------------------------------------------------------------------*/
#define DMA_MASK_ALL_INTS (0xFFFF)

#define GMAC_MASK_ALL_INTS (0xF)

/* Macro to clear the status bits. Bits are clear on write */
#define DMA_CLR_ALL_INTS (0xE7FF)

/* Macro for clearing receive status */
#define RX_STAT_MSK (TMHW_LIPP6100ETH_DMA_STATUS_RI_VAL | \
                                  TMHW_LIPP6100ETH_DMA_STATUS_RU_VAL | \
                                  TMHW_LIPP6100ETH_DMA_STATUS_OVF_VAL | \
                                  TMHW_LIPP6100ETH_DMA_STATUS_NIS_VAL | \
                                  TMHW_LIPP6100ETH_DMA_STATUS_AIS_VAL)

/* Receive interrupts macro for disabling interrupts for NAPI */
#define RX_INT_MSK (TMHW_LIPP6100ETH_DMA_INT_RIE_EN_VAL |  \
                                TMHW_LIPP6100ETH_DMA_INT_RUE_EN_VAL | \
                                TMHW_LIPP6100ETH_DMA_INT_OVE_EN_VAL )

/* Desired transmit interrupts */
/* Fatal bus error interrupt, Normal Interrupt summary,Abnormal Interrupt summary
** Underflow interrupt enable, Transmit interrupt enable 
*/
#define TX_INTR_VAL (TMHW_LIPP6100ETH_DMA_INT_FBE_EN_VAL | \
                     TMHW_LIPP6100ETH_DMA_INT_NIE_EN_VAL  | \
                     TMHW_LIPP6100ETH_DMA_INT_AIE_EN_VAL  | \
                     TMHW_LIPP6100ETH_DMA_INT_UNE_EN_VAL | \
                     TMHW_LIPP6100ETH_DMA_INT_TIE_EN_VAL )

/* Fatal Bus Error Interrupt, Over run error interrupt, Normal Interrupt Summary, 
** Abnormal Interrupt Summary, Receive Interrupt Enable 
*/
#define RX_INTR_VAL (TMHW_LIPP6100ETH_DMA_INT_FBE_EN_VAL | \
                     TMHW_LIPP6100ETH_DMA_INT_OVE_EN_VAL | \
                     TMHW_LIPP6100ETH_DMA_INT_NIE_EN_VAL | \
                     TMHW_LIPP6100ETH_DMA_INT_AIE_EN_VAL | \
                     TMHW_LIPP6100ETH_DMA_INT_RIE_EN_VAL )

/* Early Transmit and Early Receive Interrupts */
#define ERE_ETE_INT_VAL ( TMHW_LIPP6100ETH_DMA_INT_ERE_EN_VAL | \
                          TMHW_LIPP6100ETH_DMA_INT_ETE_EN_VAL )

#define MAX_LIPP_6300ETH_UNITS (1)

#define NULL 0

/*----------------------------------------------------------------------------*/
/**********************      Structures  definitions     **********************/
/*----------------------------------------------------------------------------*/

/* structure for TX descriptors */
typedef struct TX_DESCR 
{
    volatile UInt32 TDES0;
    volatile UInt32 TDES1;
    volatile UInt32 TDES2;
    volatile UInt32 TDES3;
} TX_DESCR_t ;

typedef struct RX_DESCR
{
    volatile UInt32 RDES0;
    volatile UInt32 RDES1;
    volatile UInt32 RDES2;
    volatile UInt32 RDES3;
} RX_DESCR_t ;


typedef struct dma_descs
{
    TX_DESCR_t* pTx_desc;
    RX_DESCR_t* pRx_desc;

} dma_descs_t,*pdma_descs_t;

/* Structure for storing the tx & rx transactions */
typedef struct lipp_6300eth_priv 
{

    struct eth_addr *ethaddr;

    /* Add whatever per-interface state that is needed here. */
    TX_DESCR_t *p_tx_descr;  /* Transmit descriptor ring pointer */ 
    RX_DESCR_t *p_rx_descr;  /* Receive descriptor ring pointer */   
    UInt32 tx_produce_index; /* Counter to keep track of transmit descriptor index */
    UInt32 rx_consume_index; /* Pointer to keep track of receive descriptor index */    
    UInt32 u_speed; /* speed setting 10/100/1000 */
    UInt32 u_mode; /* mode setting Full Duplex, Half Duplex */
    UInt32 u_autoneg; /* auto negotiation enable/disable */
    tmUnitSelect_t hwUnitNo; /* Hardware unit  < Combination of GMAC & PHY >*/
    UInt32 bufferFlip[HW_DESCR_QUEUE_LEN_RX]; /* Used to swap buffers & avoid memcpy */
    UInt32 dmaEnabled;

} lipp_6300eth_priv_t,*plipp_6300eth_priv_t ;

#endif /* _LIPP_6300ETH_H_ */


