#include "lipp_6300eth_common.h"

/* config.h, included in lipp_6300eth_common.h has defines for 
** CONFIG_LIPP_6300ETH & one of the PHY to be compiled
** as CONFIG_USING_<phy type>_PHY. 
**
** PHY source files are included as part of this file, so as to 
** keep the make file constant, even if a different PHY is used.
*/

/* pnx85500 on board ethernet */

#ifdef CONFIG_LIPP_6300ETH

    /* For national dp83848 phy */
    #ifdef CONFIG_USING_DP83848_PHY
    #include "tmbslPhyDP83848.h"
    #include "tmbslPhyDP83848.c"
    #endif

    /* For smsc 8700 ethernet phy */
    #ifdef CONFIG_USING_SMSC8700_PHY
    #include "tmbslPhySMSC8700.h"        
    #include "tmbslPhySMSC8700.c"    
    #endif

    /* For smsc 8700 ethernet phy */
    #ifdef CONFIG_USING_SMSC8710_PHY
    #include "tmbslPhySMSC8710.h"        
    #include "tmbslPhySMSC8710.c"    
    #endif

    /* Files which are must for ethernet driver, utilizing 
    ** macros in config.h, tv55x.h
    */

    #include "tmbslPhyAccess.c"
    #include "tmhwLIPP6100Eth_Cfg.c"
    #include "tmhwLIPP6100Eth.c"

#endif /* CONFIG_LIPP_6300ETH */







